/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.lqpt.service;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Date;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.dto.allele.AllEleCreditQuotaResponseDTO;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.bdm.lqpt.model.LqEpConfig;
import kd.imc.bdm.lqpt.model.request.base.sxed.SxedDownLoadRequest;
import kd.imc.bdm.lqpt.model.request.base.sxed.SxedQueryRequest;
import kd.imc.bdm.lqpt.model.request.base.sxed.SxedUpdateRequest;
import kd.imc.bdm.lqpt.model.response.LqptResponse;
import kd.imc.bdm.lqpt.model.response.base.sxed.SxedDownLoadResponse;
import kd.imc.bdm.lqpt.model.response.base.sxed.SxedQueryResponse;
import kd.imc.bdm.lqpt.model.response.base.sxed.SxedUpdateResponse;
import kd.imc.bdm.lqpt.service.LqptService;
import org.apache.commons.lang3.StringUtils;

public class SxedService {
    private static Log logger = LogFactory.getLog(SxedService.class);
    public static final String SXED_ENTITY = "bdm_lqpt_sxed";
    private static String SXED_LOG_ENTITY = "bdm_lqpt_sxed_log";
    private static final BigDecimal APPLY_MAX_SXED = new BigDecimal("999999999999999");

    public AllEleCreditQuotaResponseDTO querySxed(String taxNo) {
        DynamicObject sxedObject = this.getDynamicObject(taxNo);
        AllEleCreditQuotaResponseDTO dto = new AllEleCreditQuotaResponseDTO();
        if (sxedObject == null) {
            dto.setAvailableVolume("0");
            dto.setTotalVolume("0");
        } else {
            dto.setAvailableVolume(sxedObject.getBigDecimal("yxzwsyed").toString());
            dto.setTotalVolume(sxedObject.getBigDecimal("yxzed").toString());
        }
        return dto;
    }

    public boolean downLoadSxedFromLqpt(String taxNo) {
        DynamicObject sxedObject = this.getDynamicObject(taxNo);
        return this.downLoadSxedFromLqpt(taxNo, sxedObject, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean downLoadSxedFromLqpt(String taxNo, DynamicObject sxedObject, BigDecimal minSqed) {
        block18: {
            Throwable throwable = null;
            try (DLock lock = DLock.create((String)("lqpt_sxed" + taxNo), (String)"lqpt_sxed_lock");){
                boolean bl;
                if (!lock.tryLock()) break block18;
                try {
                    if (sxedObject == null) {
                        sxedObject = this.newDynamicObject(taxNo);
                    }
                    this.querySxed(taxNo, sxedObject);
                    boolean applyResult = this.applySxed(taxNo, sxedObject, minSqed);
                    this.afterQuerySxed(taxNo, sxedObject);
                    bl = true;
                }
                catch (Throwable throwable2) {
                    try {
                        lock.unlock();
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        throw throwable4;
                    }
                }
                lock.unlock();
                return bl;
            }
        }
        return false;
    }

    public void querySxed(String taxNo, DynamicObject sxedObject) {
        LqptService service = new LqptService();
        SxedQueryRequest queryRequest = new SxedQueryRequest();
        queryRequest.setNsrsbh(taxNo);
        LqptResponse queryResponse = service.send(queryRequest);
        if (!queryResponse.success()) {
            throw new KDBizException(new ErrorCode(queryResponse.getErrcode(), queryResponse.getDescription()), new Object[0]);
        }
        SxedQueryResponse sxedQueryResponse = (SxedQueryResponse)queryResponse.getData();
        sxedObject.set("ztsxbz", (Object)sxedQueryResponse.getZtsxbz());
        sxedObject.set("bysxed", (Object)sxedQueryResponse.getBysxed());
        sxedObject.set("kysyed", (Object)sxedQueryResponse.getKysyed());
        sxedObject.set("yxzed", (Object)sxedQueryResponse.getYxzed());
        sxedObject.set("yxzwsyed", (Object)sxedQueryResponse.getYxzwsyed());
        sxedObject.set("sq", (Object)DateUtils.format((Date)DateUtils.handleDate((String)sxedQueryResponse.getSq()), (String)"yyyyMM"));
        sxedObject.set("update_time", (Object)new Date());
        String cacheKey = "lqpt_sxed_query" + taxNo;
        CacheHelper.put((String)cacheKey, (String)cacheKey, (int)3600);
    }

    public void afterQuerySxed(String taxNo, DynamicObject sxedObject) {
        long oldVersion = sxedObject.getLong("version");
        sxedObject.set("version", (Object)(oldVersion + 1L));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{sxedObject});
        QFilter filter1 = new QFilter("nsrsbh", "=", (Object)taxNo);
        QFilter filter2 = new QFilter("version", "<=", (Object)oldVersion);
        DeleteServiceHelper.delete((String)SXED_LOG_ENTITY, (QFilter[])new QFilter[]{filter1, filter2});
        CacheHelper.remove((String)("creditQuota_" + taxNo));
        CacheHelper.remove((String)("totalCreditQuota_" + taxNo));
    }

    public String updateSxedTime(String taxNo, boolean isSchedule) {
        Date syqjz;
        DynamicObject sxedObject = this.getDynamicObject(taxNo);
        if (sxedObject == null) {
            logger.info("\u6388\u4fe1\u989d\u5ea6\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u4e0d\u9700\u8981\u66f4\u65b0\u6709\u6548\u671f{}", (Object)taxNo);
            return ResManager.loadKDString((String)"\u6388\u4fe1\u989d\u5ea6\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u4e0d\u9700\u8981\u66f4\u65b0\u6709\u6548\u671f", (String)"SxedService_0", (String)"imc-bdm-lqpt", (Object[])new Object[0]);
        }
        Date today = new Date();
        if (isSchedule && ((syqjz = sxedObject.getDate("syqjz")) == null || syqjz.after(today))) {
            logger.info("\u6388\u4fe1\u989d\u5ea6\u672a\u5931\u6548\uff0c\u4e0d\u9700\u8981\u66f4\u65b0\u6709\u6548\u671f{}", (Object)taxNo);
            return ResManager.loadKDString((String)"\u6388\u4fe1\u989d\u5ea6\u672a\u5931\u6548\uff0c\u4e0d\u9700\u8981\u66f4\u65b0\u6709\u6548\u671f", (String)"SxedService_1", (String)"imc-bdm-lqpt", (Object[])new Object[0]);
        }
        SxedUpdateRequest request = new SxedUpdateRequest();
        request.setNsrsbh(taxNo);
        request.setXsfnsrsbh(taxNo);
        request.setSxedsq(DateUtils.format((Date)today, (String)"yyyy-MM"));
        LqptService service = new LqptService();
        LqptResponse queryResponse = service.send(request);
        if (queryResponse.success()) {
            SxedUpdateResponse sxedResonse = (SxedUpdateResponse)queryResponse.getData();
            if (sxedResonse != null && sxedResonse.getSyqjq() != null) {
                sxedObject.set("syqjq", (Object)DateUtils.handleDate((String)sxedResonse.getSyqjq()));
                sxedObject.set("syqjz", (Object)DateUtils.handleDate((String)sxedResonse.getSyqjz()));
                sxedObject.set("sq", (Object)DateUtils.format((Date)DateUtils.handleDate((String)sxedResonse.getSxedsq()), (String)"yyyyMM"));
            }
            sxedObject.set("update_time", (Object)new Date());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{sxedObject});
            return "";
        }
        return queryResponse.getDescription();
    }

    public boolean downLoadSxed(String taxNo, BigDecimal minSqed) {
        DynamicObject sxedObject = this.getDynamicObject(taxNo);
        if (sxedObject == null) {
            return this.downLoadSxedFromLqpt(taxNo, sxedObject, minSqed);
        }
        this.querySxed(taxNo, sxedObject);
        if (this.applySxed(taxNo, sxedObject, minSqed)) {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{sxedObject});
            return true;
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{sxedObject});
        return false;
    }

    public boolean subtract(String taxNo, String invoiceNo, BigDecimal invoiceAmount) {
        boolean downFlag;
        DynamicObject sxedObject = this.getDynamicObject(taxNo);
        BigDecimal yxzwsyed = BigDecimal.ZERO;
        BigDecimal unCommitSxed = BigDecimal.ZERO;
        if (sxedObject != null) {
            yxzwsyed = sxedObject.getBigDecimal("yxzwsyed");
            unCommitSxed = this.getUnCommitSxed(taxNo, sxedObject.getLong("version"));
        }
        boolean bl = downFlag = sxedObject == null || yxzwsyed.subtract(unCommitSxed).compareTo(invoiceAmount) <= 0;
        if (downFlag) {
            boolean result = this.downLoadSxed(taxNo, invoiceAmount);
            sxedObject = this.getDynamicObject(taxNo);
            if (sxedObject != null) {
                yxzwsyed = sxedObject.getBigDecimal("yxzwsyed");
            }
        }
        logger.info("\u6388\u4fe1\u989d\u5ea6{},\u5df2\u4e0b\u8f7d\u672a\u4f7f\u7528{},\u5df2\u5360\u7528{}", new Object[]{taxNo, yxzwsyed, unCommitSxed});
        if (sxedObject != null && yxzwsyed.subtract(unCommitSxed).compareTo(invoiceAmount) >= 0) {
            QFilter filter1 = new QFilter("invoice_no", "=", (Object)invoiceNo);
            QFilter filter2 = new QFilter("version", "=", (Object)sxedObject.getLong("version"));
            DynamicObject logObject = BusinessDataServiceHelper.loadSingle((String)SXED_LOG_ENTITY, (QFilter[])new QFilter[]{filter1, filter2});
            if (logObject == null) {
                logObject = BusinessDataServiceHelper.newDynamicObject((String)SXED_LOG_ENTITY);
            }
            logObject.set("create_time", (Object)new Date());
            logObject.set("nsrsbh", (Object)taxNo);
            logObject.set("org", TaxUtils.getOrgDynamicObjectByTaxNo((String)taxNo).getPkValue());
            logObject.set("invoice_no", (Object)invoiceNo);
            logObject.set("invoice_amount", (Object)invoiceAmount);
            logObject.set("version", (Object)sxedObject.getLong("version"));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{logObject});
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BigDecimal getUnCommitSxed(String taxNo, Long version) {
        QFilter filter2 = new QFilter("version", "=", (Object)version);
        QFilter filter1 = new QFilter("nsrsbh", "=", (Object)taxNo);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)SXED_LOG_ENTITY, (String)"invoice_amount", (QFilter[])new QFilter[]{filter1, filter2}, null).groupBy().sum("invoice_amount").finish();){
            ORM orm = ORM.create();
            DynamicObjectCollection dynamicObjects = orm.toPlainDynamicObjectCollection(dataSet);
            if (dynamicObjects == null || dynamicObjects.isEmpty()) {
                BigDecimal bigDecimal2 = BigDecimal.ZERO;
                return bigDecimal2;
            }
            BigDecimal bigDecimal = ((DynamicObject)dynamicObjects.get(0)).getBigDecimal("invoice_amount");
            return bigDecimal;
        }
        catch (Exception e) {
            logger.info("\u6388\u4fe1\u989d\u5ea6\u67e5\u8be2\u5931\u8d25", (Object)e);
            return BigDecimal.ZERO;
        }
    }

    public void updateSxed(String taxNo, String invoiceNo, boolean invoiceSuccess) {
        if (!invoiceSuccess) {
            logger.info("\u6388\u4fe1\u989d\u5ea6\u6263\u51cf{},\u5f00\u7968\u5931\u8d25", (Object)invoiceNo);
            QFilter filter1 = new QFilter("invoice_no", "=", (Object)invoiceNo);
            DeleteServiceHelper.delete((String)SXED_LOG_ENTITY, (QFilter[])new QFilter[]{filter1});
            return;
        }
        DynamicObject sxedObject = this.getDynamicObject(taxNo);
        if (sxedObject != null) {
            QFilter filter1 = new QFilter("invoice_no", "=", (Object)invoiceNo);
            QFilter filter2 = new QFilter("version", "=", (Object)sxedObject.getLong("version"));
            DynamicObject logObject = QueryServiceHelper.queryOne((String)SXED_LOG_ENTITY, (String)"id,invoice_amount", (QFilter[])new QFilter[]{filter1, filter2});
            if (logObject != null) {
                BigDecimal yxzwsyed = sxedObject.getBigDecimal("yxzwsyed");
                BigDecimal afteryxzwsyed = yxzwsyed.subtract(logObject.getBigDecimal("invoice_amount"));
                sxedObject.set("yxzwsyed", (Object)afteryxzwsyed);
                logger.info("\u6388\u4fe1\u989d\u5ea6\u6263\u51cf{},\u6263\u51cf\u524d\u53ef\u7528\u5269\u4f59\u989d\u5ea6{}\u6263\u51cf\u540e{}", new Object[]{invoiceNo, yxzwsyed, afteryxzwsyed});
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{sxedObject});
                DeleteServiceHelper.delete((String)SXED_LOG_ENTITY, (QFilter[])new QFilter[]{new QFilter("id", "=", logObject.get("id"))});
            }
        }
    }

    public DynamicObject getDynamicObject(String taxNo) {
        QFilter filter1 = new QFilter("nsrsbh", "=", (Object)taxNo);
        String sq = DateUtils.format((Date)new Date(), (String)"yyyyMM");
        QFilter filter2 = new QFilter("sq", "=", (Object)sq);
        DynamicObject obj = QueryServiceHelper.queryOne((String)SXED_ENTITY, (String)"id", (QFilter[])new QFilter[]{filter1, filter2});
        DynamicObject sxedObject = null;
        if (obj != null) {
            sxedObject = BusinessDataServiceHelper.loadSingle((Object)obj.get("id"), (String)SXED_ENTITY);
        }
        return sxedObject;
    }

    private DynamicObject newDynamicObject(String taxNo) {
        DynamicObject sxedObject = BusinessDataServiceHelper.newDynamicObject((String)SXED_ENTITY);
        sxedObject.set("create_time", (Object)new Date());
        sxedObject.set("update_time", (Object)new Date());
        sxedObject.set("nsrsbh", (Object)taxNo);
        sxedObject.set("org", TaxUtils.getOrgDynamicObjectByTaxNo((String)taxNo).getPkValue());
        sxedObject.set("version", (Object)System.currentTimeMillis());
        return sxedObject;
    }

    private boolean applySxed(String taxNo, DynamicObject sxedObject, BigDecimal minSqed) {
        BigDecimal yxzwsyed = sxedObject.getBigDecimal("yxzwsyed");
        BigDecimal kysyed = sxedObject.getBigDecimal("kysyed");
        BigDecimal bysxed = sxedObject.getBigDecimal("bysxed");
        BigDecimal yxzed = sxedObject.getBigDecimal("yxzed");
        BigDecimal sqEd = this.calculateSqed(yxzwsyed, kysyed, bysxed, yxzed, minSqed);
        logger.info("\u6388\u4fe1\u989d\u5ea6-\u4e0b\u8f7d\u989d\u5ea6\u8ba1\u7b97:{},yxzwsyed:{},kysyed:{},bysxed:{},yxzed:{},minSqed:{},sqEd{}", new Object[]{taxNo, yxzwsyed, kysyed, bysxed, yxzed, minSqed, sqEd});
        if (sqEd == null) {
            logger.info("\u6388\u4fe1\u989d\u5ea6-\u65e0\u9700\u4e0b\u8f7d\u6388\u4fe1\u989d\u5ea6:{}", (Object)taxNo);
        } else if (sqEd.compareTo(BigDecimal.ZERO) <= 0) {
            logger.info("\u6388\u4fe1\u989d\u5ea6-\u6ca1\u6709\u5269\u4f59\u53ef\u7528\u989d\u5ea6:{}", (Object)taxNo);
        } else {
            logger.info("\u6388\u4fe1\u989d\u5ea6-\u4e0b\u8f7d\u6388\u4fe1\u989d\u5ea6:{}-{}", (Object)taxNo, (Object)sqEd);
            return this.requestApplySxed(taxNo, sxedObject, sqEd, "0");
        }
        return false;
    }

    public boolean requestApplySxed(String taxNo, DynamicObject sxedObject, BigDecimal sqEd, String sqlx) {
        LqptService service = new LqptService();
        SxedDownLoadRequest request = new SxedDownLoadRequest();
        LqEpConfig lqEpConfig = service.getLqEpConfig(taxNo);
        request.setNsrsbh(taxNo);
        request.setPtbh(lqEpConfig.getSydwptbh());
        request.setSqed(sqEd);
        request.setSqlx(sqlx);
        boolean isDown = "0".equals(sqlx);
        LqptResponse response = service.send(request);
        if (response.success()) {
            SxedDownLoadResponse sxedResonse = (SxedDownLoadResponse)response.getData();
            if (sxedResonse != null && StringUtils.isNotEmpty((CharSequence)sxedResonse.getSyqjq())) {
                JSONObject dateJson = new JSONObject();
                dateJson.put("syqjq", (Object)sxedResonse.getSyqjq());
                dateJson.put("syqjz", (Object)sxedResonse.getSyqjz());
                sxedObject.set("syqjq", (Object)dateJson.getDate("syqjq"));
                sxedObject.set("syqjz", (Object)dateJson.getDate("syqjz"));
            }
            BigDecimal yxzwsyed = sxedObject.getBigDecimal("yxzwsyed");
            BigDecimal kysyed = sxedObject.getBigDecimal("kysyed");
            BigDecimal yxzed = sxedObject.getBigDecimal("yxzed");
            if (!isDown) {
                sqEd = sqEd.negate();
            }
            kysyed = kysyed.subtract(sqEd);
            yxzed = yxzed.add(sqEd);
            yxzwsyed = yxzwsyed.add(sqEd);
            sxedObject.set("yxzed", (Object)yxzed);
            sxedObject.set("kysyed", (Object)kysyed);
            sxedObject.set("yxzwsyed", (Object)yxzwsyed);
            return true;
        }
        logger.info("\u6388\u4fe1\u989d\u5ea6-\u4e0b\u8f7d\u6388\u4fe1\u989d\u5ea6\u5931\u8d25:{}", (Object)taxNo);
        return false;
    }

    public BigDecimal calculateSqed(BigDecimal yxzwsyed, BigDecimal kysyed, BigDecimal bysxed, BigDecimal yxzed, BigDecimal minSqed) {
        if (kysyed.compareTo(BigDecimal.ZERO) <= 0) {
            return BigDecimal.ZERO;
        }
        if (yxzed.compareTo(BigDecimal.ZERO) <= 0) {
            BigDecimal sqed = kysyed.multiply(new BigDecimal("0.8"));
            if (sqed.compareTo(APPLY_MAX_SXED) > 0) {
                return APPLY_MAX_SXED;
            }
            return sqed;
        }
        BigDecimal sqed = null;
        if (yxzwsyed.divide(yxzed, 4, 4).compareTo(new BigDecimal("0.2")) < 0) {
            sqed = kysyed.divide(bysxed, 4, 4).compareTo(new BigDecimal("0.05")) <= 0 ? kysyed : kysyed.multiply(new BigDecimal("0.8"));
        }
        if (minSqed != null && yxzwsyed.compareTo(minSqed) < 0) {
            sqed = sqed == null ? kysyed.min(minSqed) : minSqed.max(sqed).min(kysyed);
        }
        if (sqed == null) {
            return null;
        }
        return sqed.compareTo(APPLY_MAX_SXED) > 0 ? APPLY_MAX_SXED : sqed;
    }
}

