/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.lqpt.utils;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Provider;
import java.security.Security;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class SM4Util {
    private static final Charset ENCODING;

    public static String encryptEcb(String hexKey, String paramStr) throws Exception {
        byte[] keyData = SM4Util.fromHexString(hexKey);
        byte[] srcData = paramStr.getBytes(ENCODING);
        byte[] cipherArray = SM4Util.encrypt_Ecb_Padding(keyData, srcData);
        return Base64.getEncoder().encodeToString(cipherArray);
    }

    public static byte[] fromHexString(String s) {
        char[] rawChars = s.toUpperCase().toCharArray();
        int hexChars = 0;
        for (int i = 0; i < rawChars.length; ++i) {
            if ((rawChars[i] < '0' || rawChars[i] > '9') && (rawChars[i] < 'A' || rawChars[i] > 'F')) continue;
            ++hexChars;
        }
        byte[] byteString = new byte[hexChars + 1 >> 1];
        int pos = hexChars & 1;
        for (int i = 0; i < rawChars.length; ++i) {
            if (rawChars[i] >= '0' && rawChars[i] <= '9') {
                int n = pos >> 1;
                byteString[n] = (byte)(byteString[n] << 4);
                int n2 = pos >> 1;
                byteString[n2] = (byte)(byteString[n2] | rawChars[i] - 48);
            } else {
                if (rawChars[i] < 'A' || rawChars[i] > 'F') continue;
                int n = pos >> 1;
                byteString[n] = (byte)(byteString[n] << 4);
                int n3 = pos >> 1;
                byteString[n3] = (byte)(byteString[n3] | rawChars[i] - 65 + 10);
            }
            ++pos;
        }
        return byteString;
    }

    public static String decryptEcb(String hexKey, String cipherText) throws Exception {
        byte[] keyData = SM4Util.fromHexString(hexKey);
        byte[] cipherData = Base64.getDecoder().decode(cipherText);
        byte[] srcData = SM4Util.decrypt_Ecb_Padding(keyData, cipherData);
        return new String(srcData, ENCODING);
    }

    private static byte[] encrypt_Ecb_Padding(byte[] key, byte[] data) throws Exception {
        Cipher cipher = SM4Util.generateEcbCipher(1, key);
        return cipher.doFinal(data);
    }

    private static byte[] decrypt_Ecb_Padding(byte[] key, byte[] cipherText) throws Exception {
        Cipher cipher = SM4Util.generateEcbCipher(2, key);
        return cipher.doFinal(cipherText);
    }

    private static Cipher generateEcbCipher(int mode, byte[] key) throws Exception {
        Cipher cipher = Cipher.getInstance(SM4Util.getFinal(), "BC");
        SecretKeySpec sm4Key = new SecretKeySpec(key, "SM4");
        cipher.init(mode, sm4Key);
        return cipher;
    }

    private static String getFinal() {
        return "SM4/E&&C&&B/PK&&CS5&&Padding".replace("&&", "");
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
        ENCODING = StandardCharsets.UTF_8;
    }
}

