/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.split.service;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.imc.sim.split.dto.BillDealResultDto;
import kd.imc.sim.split.dto.BillDetailDto;
import kd.imc.sim.split.dto.BillSubjectDto;
import kd.imc.sim.split.dto.SmruleConfigDto;
import kd.imc.sim.split.enums.EnumType;
import kd.imc.sim.split.methods.BackCalcUtilMethods;
import kd.imc.sim.split.methods.BillCheckMethods;

public class BillsCheckService {
    private static BackCalcUtilMethods backCalcUtilMethods = new BackCalcUtilMethods();
    private static BillCheckMethods billCheckMethods = new BillCheckMethods();

    public static void billItemsCheck(BillSubjectDto billSubjectDto, SmruleConfigDto configDto) {
        List<BillDetailDto> billDetailDtoList = billSubjectDto.getBillDList();
        for (int i = 0; i < billDetailDtoList.size(); ++i) {
            BillDetailDto detailDto = billDetailDtoList.get(i);
            Integer lineProperty = detailDto.getLineProperty();
            String billDetailNO = detailDto.getBillDetailNO();
            BigDecimal taxRate = detailDto.getTaxRate();
            BigDecimal amount = detailDto.getAmounts();
            BigDecimal price = detailDto.getPrice();
            BigDecimal dec = detailDto.getTaxDeduction();
            if (price == null || price.compareTo(BigDecimal.ZERO) < 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5355\u4ef7\u4e0d\u5141\u8bb8\u5c0f\u4e8e0", (String)"BillsCheckService_0", (String)"imc-sim-split", (Object[])new Object[0]));
            }
            if (taxRate == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a", (String)"BillsCheckService_1", (String)"imc-sim-split", (Object[])new Object[0]));
            }
            billCheckMethods.checkNull(billDetailNO, detailDto, i + 1, ResManager.loadKDString((String)"\u5355\u636e\u660e\u7ec6\u7f16\u53f7\u672a\u4f20\u5165", (String)"BillsCheckService_2", (String)"imc-sim-split", (Object[])new Object[0]));
            billCheckMethods.specilNo0TaxRate(taxRate, billSubjectDto.getInvKind(), detailDto, i + 1, ResManager.loadKDString((String)"\u7a0e\u7387\u4e3a0\u4e0d\u5141\u8bb8\u5f00\u4e13\u7968", (String)"BillsCheckService_3", (String)"imc-sim-split", (Object[])new Object[0]));
            billCheckMethods.verfTaxRateNew(taxRate, detailDto, i + 1, ResManager.loadKDString((String)"\u7a0e\u7387\u4e0d\u5408\u6cd5", (String)"BillsCheckService_4", (String)"imc-sim-split", (Object[])new Object[0]));
            billCheckMethods.taxRate15NotMultiTax(billDetailDtoList, taxRate, detailDto, i + 1, ResManager.loadKDString((String)"\u51cf\u514d1.5\u8ba1\u7a0e\u65f6\u4e0d\u5141\u8bb8\u5f00\u5177\u591a\u7a0e\u7387", (String)"BillsCheckService_5", (String)"imc-sim-split", (Object[])new Object[0]));
            billCheckMethods.decNottaxRate15(dec, taxRate, detailDto, i + 1, ResManager.loadKDString((String)"\u5dee\u989d\u53d1\u7968\u4e0d\u80fd\u5f00\u51771.5\u7a0e\u7387", (String)"BillsCheckService_6", (String)"imc-sim-split", (Object[])new Object[0]));
            billCheckMethods.disLineMoneyNotGt0(amount, lineProperty, detailDto, i + 1, ResManager.loadKDString((String)"\u6298\u6263\u884c\u91d1\u989d\u4e0d\u5141\u8bb8\u5927\u4e8e0", (String)"BillsCheckService_7", (String)"imc-sim-split", (Object[])new Object[0]));
            billCheckMethods.discount1LineNotExist(billDetailDtoList, detailDto, i + 1);
            billCheckMethods.discountNLineNotExist(billDetailDtoList, detailDto, i + 1);
            billCheckMethods.checkDisRows(detailDto, i + 1, ResManager.loadKDString((String)"\u6298\u6263\u884c\u6570\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e-1", (String)"BillsCheckService_8", (String)"imc-sim-split", (Object[])new Object[0]));
            billCheckMethods.checkNDline(detailDto, i + 1);
            BillsCheckService.checkPriceNumsAmt(detailDto, configDto);
        }
        billCheckMethods.checkBillTotal(billSubjectDto);
    }

    private static BigDecimal getBigDecimalVal(BigDecimal val) {
        if (val == null) {
            return BigDecimal.ZERO;
        }
        return val;
    }

    private static void checkPriceNumsAmt(BillDetailDto detailDto, SmruleConfigDto configDto) {
        BigDecimal amount = BillsCheckService.getBigDecimalVal(detailDto.getAmounts());
        BigDecimal price = BillsCheckService.getBigDecimalVal(detailDto.getPrice());
        BigDecimal amts = BillsCheckService.getBigDecimalVal(detailDto.getAmts());
        BigDecimal taxAmt = BillsCheckService.getBigDecimalVal(detailDto.getTaxAmt());
        if (amount.compareTo(BigDecimal.ZERO) == 0 && price.compareTo(BigDecimal.ZERO) > 0 && amts.compareTo(BigDecimal.ZERO) > 0) {
            amount = backCalcUtilMethods.recursionAmounts(amts, price, 2);
        } else if (price.compareTo(BigDecimal.ZERO) == 0 && amount.compareTo(BigDecimal.ZERO) > 0 && amts.compareTo(BigDecimal.ZERO) > 0) {
            price = backCalcUtilMethods.recursionPrice(amount, amts, 2, configDto);
        } else if (amts.compareTo(BigDecimal.ZERO) == 0 && amount.compareTo(BigDecimal.ZERO) > 0 && price.compareTo(BigDecimal.ZERO) > 0) {
            amts = backCalcUtilMethods.recursionAmtsCut(amount, price, 2, configDto);
        }
        BigDecimal amountInc = amount;
        BigDecimal priceInc = price;
        BigDecimal dec = detailDto.getTaxDeduction();
        BigDecimal taxRate = detailDto.getTaxRate();
        BigDecimal taxAmt15 = taxAmt;
        if (EnumType.TaxFlag.YES.getVal().equals(detailDto.getIncludeTax())) {
            if (taxAmt.compareTo(BigDecimal.ZERO) == 0) {
                taxAmt = backCalcUtilMethods.calcTaxAmtByTaxMoneyDec(amount, dec, taxRate, 2);
                taxAmt15 = backCalcUtilMethods.calcTaxAmtByTaxMoneyDec(amount, dec, taxRate, 15);
            }
            amount = amount.subtract(taxAmt15);
            price = backCalcUtilMethods.recursionPrice(amount, amts, 2, configDto);
            amount = amountInc.subtract(taxAmt);
        } else {
            if (taxAmt.compareTo(BigDecimal.ZERO) == 0) {
                taxAmt = backCalcUtilMethods.calcTaxAmtByNoTaxMoneyDec(amount, dec, taxRate, 2);
                taxAmt15 = backCalcUtilMethods.calcTaxAmtByNoTaxMoneyDec(amount, dec, taxRate, 15);
            }
            amountInc = taxAmt15.add(amount);
            priceInc = backCalcUtilMethods.recursionPrice(amountInc, amts, 2, configDto);
            amountInc = taxAmt.add(amount);
        }
        detailDto.setAmounts(amount);
        detailDto.setAmountsIncTax(amountInc);
        detailDto.setPrice(price);
        detailDto.setTaxAmt(taxAmt);
        detailDto.setPriceIncTax(priceInc);
        detailDto.setAmts(amts);
    }

    public static BillDealResultDto getBDR(String billNO, boolean success, String errorMsg) {
        BillDealResultDto bdr = new BillDealResultDto();
        bdr.setBillNO(billNO);
        bdr.setSuccess(success);
        bdr.setErrorMsg(errorMsg);
        return bdr;
    }
}

