/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.split.service;

import java.math.BigDecimal;
import java.util.List;
import java.util.Set;
import kd.bos.exception.KDBizException;
import kd.imc.sim.split.dto.BillDetailDto;
import kd.imc.sim.split.dto.BillDetailIdDto;
import kd.imc.sim.split.enums.EnumType;

public class GoodsDiscountService {
    private static boolean isDisCountRow(BillDetailDto billDetailDto) {
        return billDetailDto.getLineProperty() != null && billDetailDto.getLineProperty() == 4;
    }

    public static List<BillDetailDto> doDisLine(List<BillDetailDto> detailList) throws KDBizException {
        for (int i = 0; i < detailList.size(); ++i) {
            BillDetailDto billDetailDto = detailList.get(i);
            if (!GoodsDiscountService.isDisCountRow(billDetailDto) || i == 0) continue;
            BillDetailDto preDetail = detailList.get(i - 1);
            preDetail.setLineProperty(3);
            BigDecimal lineDisRate = billDetailDto.getAmountsByTax().abs().divide(preDetail.getAmountsByTax(), 5, 4).multiply(new BigDecimal("100"));
            preDetail.setDisRate(lineDisRate);
            billDetailDto.setPrice(null);
            billDetailDto.setPriceIncTax(null);
            billDetailDto.setAmts(null);
            billDetailDto.setBy1(null);
            billDetailDto.setGoodsModel(null);
            billDetailDto.setGoodsUnit(null);
            Set<BillDetailIdDto> detailIdSet = billDetailDto.getDetailIdSet();
            BillDetailIdDto next = detailIdSet.iterator().next();
            next.setAmts(null);
            next.setPrice(null);
            if (!EnumType.TaxFlag.YES.getVal().equals(billDetailDto.getIncludeTax())) continue;
            next.setAmounts(billDetailDto.getAmountsIncTax());
        }
        return detailList;
    }
}

