/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.split.service;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.sim.split.dto.BillDetailDto;
import kd.imc.sim.split.dto.BillDetailIdDto;
import kd.imc.sim.split.dto.BillSubjectDto;
import kd.imc.sim.split.dto.InvoiceDetailDto;
import kd.imc.sim.split.dto.InvoiceSubjectDto;
import kd.imc.sim.split.dto.SmruleConfigDto;
import kd.imc.sim.split.dto.SmsResultDto;
import kd.imc.sim.split.enums.EnumType;
import kd.imc.sim.split.methods.BackCalcUtilMethods;
import kd.imc.sim.split.service.InvoiceSplitCoreService;
import kd.imc.sim.split.utils.ComUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class InvoiceCoreService {
    private static Log LOG = LogFactory.getLog(InvoiceCoreService.class);
    private static BackCalcUtilMethods calcUtilMethods = new BackCalcUtilMethods();

    public static void openInvoice(BillSubjectDto billSubjectDto, SmruleConfigDto configDto, SmsResultDto smsResultDto) {
        String billSubjectNo = billSubjectDto.getBillNO();
        LOG.debug("\u5355\u636e\u7f16\u53f7[{}]\u751f\u6210\u53d1\u7968\u8bf7\u6c42\u62a5\u6587 \u5355\u636e:{}\uff0c\u89c4\u5219\u914d\u7f6e:{}", new Object[]{billSubjectNo, JSONObject.toJSONString((Object)billSubjectDto), JSONObject.toJSONString((Object)configDto)});
        BigDecimal amountIncTax = billSubjectDto.getSumAmtJE().add(billSubjectDto.getSumAmtSE());
        if (amountIncTax.divide(configDto.getFinalLimitAmt(), 0, 2).compareTo(new BigDecimal("1000")) > 0) {
            LOG.info("\u5355\u636e\u7f16\u53f7[{}]\u751f\u6210\u53d1\u7968\u8bf7\u6c42\u62a5\u6587 \u5355\u636e:{}\uff0c\u89c4\u5219\u914d\u7f6e:{}", new Object[]{billSubjectNo, JSONObject.toJSONString((Object)billSubjectDto), JSONObject.toJSONString((Object)configDto)});
            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u91d1\u989d\u8d85\u8fc7\u53d1\u7968\u9650\u989d\u76841000\u500d\uff0c\u8bf7\u8c03\u6574\u5355\u636e\u91d1\u989d", (String)"InvoiceCoreService_0", (String)"imc-sim-split", (Object[])new Object[0]));
        }
        try {
            InvoiceCoreService.openInvoiceDetail(billSubjectDto, configDto, smsResultDto);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u62c6\u5206\u5931\u8d25", (String)"InvoiceCoreService_1", (String)"imc-sim-split", (Object[])new Object[0]));
        }
    }

    private static void openInvoiceDetail(BillSubjectDto billSubjectDto, SmruleConfigDto configDto, SmsResultDto smsResultDto) throws Exception {
        InvoiceSplitCoreService invoiceSplitCoreService = new InvoiceSplitCoreService();
        LOG.debug("\u5355\u636e\u7f16\u53f7[{}]\u751f\u6210\u53d1\u7968\u8bf7\u6c42\u62a5\u6587 \u5355\u636e:{}\uff0c\u89c4\u5219\u914d\u7f6e:{}", new Object[]{billSubjectDto.getBillNO(), JSONObject.toJSONString((Object)billSubjectDto), JSONObject.toJSONString((Object)configDto)});
        BigDecimal invLimitAmt = configDto.getFinalLimitAmt();
        List<BillDetailDto> detailDtos = billSubjectDto.getBillDList();
        BigDecimal allAmount = billSubjectDto.getSumAmtJE();
        BigDecimal amountSum = BigDecimal.ZERO;
        BigDecimal taxAmtErrSum = BigDecimal.ZERO;
        int lastIndex = -1;
        int size = detailDtos.size();
        for (int detailIndex = 0; detailIndex < size; ++detailIndex) {
            BillDetailDto detailDto = detailDtos.get(detailIndex);
            int nextDetailIndex = detailIndex + 1;
            BillDetailDto disDto = null;
            if (nextDetailIndex < size && ComUtil.isDisLine(detailDtos.get(nextDetailIndex))) {
                disDto = detailDtos.get(nextDetailIndex);
            }
            String billNo = detailDto.getBillNO();
            BigDecimal lineAmount = detailDto.getAmounts();
            BigDecimal disLineAmount = lineAmount.add(disDto != null ? disDto.getAmounts() : BigDecimal.ZERO);
            if (disLineAmount.compareTo(invLimitAmt) > 0) {
                int currentIndex = detailIndex++;
                ArrayList<BillDetailDto> toSplitDetails = new ArrayList<BillDetailDto>();
                toSplitDetails.add(detailDtos.get(currentIndex));
                if (disDto != null) {
                    toSplitDetails.add(disDto);
                    detailDtos.remove(nextDetailIndex);
                }
                detailDtos.remove(currentIndex);
                List<BillDetailDto> splitGoods = invoiceSplitCoreService.goodsLineSplit(toSplitDetails, configDto, amountSum, toSplitDetails.size() > 1, allAmount);
                detailDtos.addAll(currentIndex, splitGoods);
                size = detailDtos.size();
                LOG.debug("\u5355\u636e\u7f16\u53f7[{}] \u8d85\u8fc7\u6700\u5927\u884c\u6570 \u884c\u53f7[{}]\u5f00\u7968,\u91d1\u989d\u7d2f\u8ba1\uff1a{},\u7a0e\u989d\u8bef\u5dee\u7d2f\u8ba1:{}", new Object[]{billNo, detailIndex + 1, amountSum, taxAmtErrSum});
                lastIndex = InvoiceCoreService.saveInvoince(smsResultDto, configDto, billSubjectDto, lastIndex, detailIndex, "\u91d1\u989d\u7d2f\u8ba1\u8d85\u9650\u5f00\u7968", detailDtos.get(0).getLineNote());
                allAmount = allAmount.subtract(smsResultDto.getInvoiceSList().get(smsResultDto.getInvoiceSList().size() - 1).getAmounts());
                amountSum = BigDecimal.ZERO;
                taxAmtErrSum = BigDecimal.ZERO;
                continue;
            }
            if (InvoiceCoreService.isLastLine(billSubjectDto, detailIndex).booleanValue()) {
                LOG.debug("\u5355\u636e\u7f16\u53f7[{}] \u6700\u540e\u4e00\u884c[{}]\u5f00\u7968,\u91d1\u989d\u7d2f\u8ba1\uff1a{},\u7a0e\u989d\u8bef\u5dee\u7d2f\u8ba1:{}", new Object[]{billNo, detailIndex + 1, amountSum, taxAmtErrSum});
                InvoiceCoreService.saveInvoince(smsResultDto, configDto, billSubjectDto, lastIndex, detailIndex, "\u6700\u540e\u4e00\u884c\u5f00\u7968", detailDtos.get(0).getLineNote());
                break;
            }
            boolean openInvIndex = InvoiceCoreService.isOpenInvIndex(billSubjectDto, detailIndex, lastIndex);
            if (openInvIndex) {
                LOG.debug("\u5355\u636e\u7f16\u53f7[{}] {} \u884c\u53f7[{}]\u5f00\u7968,\u91d1\u989d\u7d2f\u8ba1\uff1a{},\u7a0e\u989d\u8bef\u5dee\u7d2f\u8ba1:{}", new Object[]{billNo, "\u8d85\u8fc7\u6700\u5927\u884c\u6570", detailIndex + 1, amountSum, taxAmtErrSum});
                lastIndex = InvoiceCoreService.saveInvoince(smsResultDto, configDto, billSubjectDto, lastIndex, detailIndex, "\u8d85\u8fc7\u6700\u5927\u884c\u6570\u5f00\u7968", detailDtos.get(0).getLineNote());
                allAmount = allAmount.subtract(smsResultDto.getInvoiceSList().get(smsResultDto.getInvoiceSList().size() - 1).getAmounts());
                amountSum = BigDecimal.ZERO;
                taxAmtErrSum = BigDecimal.ZERO;
                continue;
            }
            if (ComUtil.isDisLine(detailDto)) continue;
            amountSum = amountSum.add(lineAmount);
            if (disDto != null && ComUtil.isDisLine(disDto)) {
                amountSum = amountSum.add(disDto.getAmounts());
                BigDecimal taxAmtErr = disDto.getAmounts().multiply(disDto.getTaxRate()).subtract(disDto.getTaxAmt()).setScale(2, 4);
                taxAmtErrSum = taxAmtErrSum.add(taxAmtErr);
            }
            if (amountSum.compareTo(invLimitAmt) < 0 && InvoiceCoreService.addNextProLineIsExpeed(detailDtos, detailIndex, amountSum, invLimitAmt).booleanValue()) {
                int nextIndex = disDto != null ? detailIndex + 2 : detailIndex + 1;
                BillDetailDto nextDetails = detailDtos.get(nextIndex);
                BigDecimal nextLineAmount = nextDetails.getAmounts();
                BillDetailDto nextDisDto = null;
                if (nextIndex + 1 < size && detailDtos.get(nextIndex + 1) != null && ComUtil.isDisLine(detailDtos.get(nextIndex + 1))) {
                    nextDisDto = detailDtos.get(nextIndex + 1);
                    nextLineAmount = nextDisDto.getAmounts();
                }
                if ((configDto.getSplitGoodsLine() != 0 || nextLineAmount.compareTo(invLimitAmt) >= 0) && 1 != nextDetails.getSplitSign()) {
                    if (disDto != null) {
                        ++detailIndex;
                    }
                    ArrayList<BillDetailDto> toSplitDetails = new ArrayList<BillDetailDto>();
                    toSplitDetails.add(nextDetails);
                    if (nextDisDto != null) {
                        toSplitDetails.add(nextDisDto);
                        detailDtos.remove(nextIndex + 1);
                        ++detailIndex;
                    }
                    detailDtos.remove(nextIndex);
                    ++detailIndex;
                    int toSplitNum = toSplitDetails.size();
                    List<BillDetailDto> splitGoods = invoiceSplitCoreService.goodsLineSplit(toSplitDetails, configDto, amountSum, toSplitDetails.size() > 1, allAmount);
                    detailDtos.addAll(nextIndex, splitGoods);
                    size = detailDtos.size();
                    if (splitGoods.size() > toSplitNum) {
                        if (nextDisDto != null && !ComUtil.isDisLine(splitGoods.get(1))) {
                            --detailIndex;
                        }
                        LOG.debug("\u5355\u636e\u7f16\u53f7[{}] \u8d85\u8fc7\u6700\u5927\u884c\u6570 \u884c\u53f7[{}]\u5f00\u7968,\u91d1\u989d\u7d2f\u8ba1\uff1a{},\u7a0e\u989d\u8bef\u5dee\u7d2f\u8ba1:{}", new Object[]{billNo, detailIndex + 1, amountSum, taxAmtErrSum});
                        lastIndex = InvoiceCoreService.saveInvoince(smsResultDto, configDto, billSubjectDto, lastIndex, detailIndex, "\u91d1\u989d\u7d2f\u8ba1\u8d85\u9650\u5f00\u7968", detailDtos.get(0).getLineNote());
                        allAmount = allAmount.subtract(smsResultDto.getInvoiceSList().get(smsResultDto.getInvoiceSList().size() - 1).getAmounts());
                        amountSum = BigDecimal.ZERO;
                        taxAmtErrSum = BigDecimal.ZERO;
                        continue;
                    }
                    if (disDto != null) {
                        --detailIndex;
                    }
                    --detailIndex;
                }
            }
            if (amountSum.compareTo(invLimitAmt) != 0 && !InvoiceCoreService.addNextProLineIsExpeed(detailDtos, detailIndex, amountSum, invLimitAmt).booleanValue()) {
                BigDecimal nextLineAmount = lineAmount.subtract(detailDto.getTaxDeduction()).multiply(detailDto.getTaxRate());
                BigDecimal taxAmtErr = nextLineAmount.subtract(detailDto.getTaxAmt()).setScale(2, 4);
                taxAmtErrSum = taxAmtErrSum.add(taxAmtErr);
                continue;
            }
            LOG.debug("\u5355\u636e\u7f16\u53f7[{}] \u91d1\u989d\u7d2f\u8ba1\u8d85\u9650 \u884c\u53f7[{}]\u5f00\u7968,\u91d1\u989d\u7d2f\u8ba1\uff1a{},\u7a0e\u989d\u8bef\u5dee\u7d2f\u8ba1:{}", new Object[]{billNo, detailIndex + 1, amountSum, taxAmtErrSum});
            lastIndex = InvoiceCoreService.saveInvoince(smsResultDto, configDto, billSubjectDto, lastIndex, detailIndex, "\u91d1\u989d\u7d2f\u8ba1\u8d85\u9650\u5f00\u7968", detailDtos.get(0).getLineNote());
            allAmount = allAmount.subtract(smsResultDto.getInvoiceSList().get(smsResultDto.getInvoiceSList().size() - 1).getAmounts());
            amountSum = BigDecimal.ZERO;
            taxAmtErrSum = BigDecimal.ZERO;
        }
    }

    private static Boolean addNextProLineIsExpeed(List<BillDetailDto> detailDtos, int curIndex, BigDecimal amountSum, BigDecimal invLimitAmt) {
        BigDecimal countNextAmount = BigDecimal.ZERO.add(amountSum);
        int j = curIndex + 1;
        if (j < detailDtos.size()) {
            BillDetailDto disLineDto = detailDtos.get(j);
            if (ComUtil.isDisLine(disLineDto)) {
                BillDetailDto nextDisDto;
                int m;
                int k = j + 1;
                if (k < detailDtos.size()) {
                    BillDetailDto nextProDto = detailDtos.get(k);
                    countNextAmount = countNextAmount.add(nextProDto.getAmounts());
                }
                if ((m = k + 1) < detailDtos.size() && ComUtil.isDisLine(nextDisDto = detailDtos.get(m))) {
                    countNextAmount = countNextAmount.add(nextDisDto.getAmounts());
                }
            } else {
                BillDetailDto nextDisDto;
                BillDetailDto nextProDto = detailDtos.get(j);
                BigDecimal nextProAmt = nextProDto.getAmounts();
                countNextAmount = countNextAmount.add(nextProAmt);
                int k = j + 1;
                if (k < detailDtos.size() && ComUtil.isDisLine(nextDisDto = detailDtos.get(k))) {
                    countNextAmount = countNextAmount.add(nextDisDto.getAmounts());
                }
            }
        }
        return countNextAmount.compareTo(invLimitAmt) > 0;
    }

    private static boolean isOpenInvIndex(BillSubjectDto billSubjectDto, int i, int lastIndx) {
        BillDetailDto isDisDto;
        List<BillDetailDto> detailDtos = billSubjectDto.getBillDList();
        int size = detailDtos.size();
        int limitLine = billSubjectDto.getLimitLine();
        int nextInvMaxIndex = lastIndx + limitLine;
        if (nextInvMaxIndex >= size) {
            return i == size - 1;
        }
        BillDetailDto lastInvDto = detailDtos.get(nextInvMaxIndex);
        if (ComUtil.isDisLine(lastInvDto)) {
            return nextInvMaxIndex == i;
        }
        int j = nextInvMaxIndex + 1;
        if (j < size && ComUtil.isDisLine(isDisDto = detailDtos.get(j))) {
            return nextInvMaxIndex - 1 == i;
        }
        return nextInvMaxIndex == i;
    }

    private static Boolean isLastLine(BillSubjectDto billSubjectDto, int index) {
        int lastIndex;
        List<BillDetailDto> billDetailDtos = billSubjectDto.getBillDList();
        BillDetailDto lastDto = billDetailDtos.get(lastIndex = billDetailDtos.size() - 1);
        if (ComUtil.isDisLine(lastDto)) {
            return lastIndex - 1 == index;
        }
        return lastIndex == index;
    }

    private static int saveInvoince(SmsResultDto smsResultDto, SmruleConfigDto configDto, BillSubjectDto billSubjectDto, Integer lastIndex, Integer index, String remark, String fristLineNote) {
        List<InvoiceSubjectDto> invoiceSList = smsResultDto.getInvoiceSList();
        if (CollectionUtils.isEmpty(invoiceSList)) {
            invoiceSList = new ArrayList<InvoiceSubjectDto>();
        }
        InvoiceSubjectDto invoiceSubjectDto = InvoiceCoreService.saveOneInvoice(configDto, billSubjectDto, lastIndex, index, fristLineNote);
        invoiceSubjectDto.setRemark(remark);
        invoiceSList.add(invoiceSubjectDto);
        smsResultDto.setInvoiceSList(invoiceSList);
        return invoiceSubjectDto.getPageIndex();
    }

    private static InvoiceSubjectDto saveOneInvoice(SmruleConfigDto configDto, BillSubjectDto billSubjectDto, Integer lastIndex, Integer index, String firstLineNote) {
        int i;
        InvoiceSubjectDto invoiceSubjectDto = new InvoiceSubjectDto();
        List<BillDetailDto> detailDtos = billSubjectDto.getBillDList();
        String invSN = InvoiceCoreService.getInvSN();
        int useLineNote = configDto.getInvNoteUseLineNote();
        Boolean mccDistinct = configDto.isMccRepeat();
        invoiceSubjectDto.setInvoiceNO(invSN);
        invoiceSubjectDto.setBillNO(billSubjectDto.getBillNO());
        invoiceSubjectDto.setInvoiceKind(billSubjectDto.getInvKind());
        invoiceSubjectDto.setInvoiceNote(billSubjectDto.getNotes());
        int curInvIndex = index;
        int j = index + 1;
        if (j < detailDtos.size() && ComUtil.isDisLine(detailDtos.get(j))) {
            ++curInvIndex;
        }
        ArrayList<InvoiceDetailDto> invoiceDetailList = new ArrayList<InvoiceDetailDto>(10);
        int lineNum = 0;
        ArrayList<String> billNOList = new ArrayList<String>();
        int n = i = lastIndex == -1 ? 0 : lastIndex + 1;
        while (i <= curInvIndex) {
            BillDetailDto billDetailDto = detailDtos.get(i);
            InvoiceDetailDto invoiceDetailDto = InvoiceCoreService.setInvDetailDto(billSubjectDto, invoiceSubjectDto, billDetailDto, invSN, useLineNote, firstLineNote, mccDistinct, lineNum);
            invoiceDetailList.add(invoiceDetailDto);
            Set<BillDetailIdDto> detailIdSet = billDetailDto.getDetailIdSet();
            for (BillDetailIdDto detailIdDto : detailIdSet) {
                if (billNOList.contains(detailIdDto.getBillNO())) continue;
                billNOList.add(detailIdDto.getBillNO());
            }
            ++lineNum;
            invoiceSubjectDto.setOneUnchange(invoiceSubjectDto.isOneUnchange() || billDetailDto.isOneUnchange());
            ++i;
        }
        List<String> lineNotes = invoiceSubjectDto.getLineNotes();
        ArrayList splitLineNotes = new ArrayList();
        if (configDto.isMccRepeat()) {
            invoiceSubjectDto.setInvoiceNote(StringUtils.join((Object[])lineNotes.toArray(), (String)configDto.getMccNoteStr()));
        } else {
            lineNotes.forEach(t -> {
                List<String> mergeList = Arrays.asList(t.split("\\".equals(configDto.getMccNoteStr()) ? "\\\\" : configDto.getMccNoteStr()));
                if (mergeList.size() > 0) {
                    for (String note : mergeList) {
                        if (splitLineNotes.contains(note)) continue;
                        splitLineNotes.add(note);
                    }
                }
            });
            invoiceSubjectDto.setInvoiceNote(StringUtils.join((Object[])splitLineNotes.toArray(), (String)configDto.getMccNoteStr()));
        }
        invoiceSubjectDto.setInvoiceDetailList(invoiceDetailList);
        invoiceSubjectDto.setBillNOList(billNOList);
        int listType = configDto.getListType();
        if (listType == 1) {
            invoiceSubjectDto.setListFlag(1);
        } else if (listType == 2) {
            invoiceSubjectDto.setListFlag(0);
        } else {
            if (invoiceDetailList.size() > 8) {
                invoiceSubjectDto.setListFlag(1);
            } else {
                invoiceSubjectDto.setListFlag(0);
            }
            if (EnumType.InvKindEnum.ROLL.getValue().equals(billSubjectDto.getInvKind())) {
                invoiceSubjectDto.setListFlag(0);
            }
        }
        invoiceSubjectDto.setPageIndex(curInvIndex);
        return invoiceSubjectDto;
    }

    private static InvoiceDetailDto setInvDetailDto(BillSubjectDto billSubjectDto, InvoiceSubjectDto invoiceSubjectDto, BillDetailDto billDetailDto, String invSN, int useLineNote, String fristLineNote, boolean mccDistinct, int lineNum) {
        List<Object> lineNotes;
        BigDecimal tmpTaxAmt;
        BigDecimal origTaxAmt = billDetailDto.getTaxAmt();
        billDetailDto.setTaxAmt(origTaxAmt.setScale(2, 4));
        InvoiceDetailDto invoiceDetail = new InvoiceDetailDto();
        invoiceDetail.setInvoiceNO(invSN);
        invoiceDetail.setInvoiceDetailNO(InvoiceCoreService.getInvSN());
        invoiceDetail.setGoodsCode(billDetailDto.getGoodsCode());
        invoiceDetail.setGoodsName(billDetailDto.getGoodsName());
        invoiceDetail.setGoodsModel(billDetailDto.getGoodsModel());
        invoiceDetail.setGoodsUnit(billDetailDto.getGoodsUnit());
        invoiceDetail.setAmts(billDetailDto.getAmts());
        invoiceDetail.setPrice(billDetailDto.getPrice());
        invoiceDetail.setAmounts(billDetailDto.getAmounts());
        invoiceDetail.setTaxRate(billDetailDto.getTaxRate());
        invoiceDetail.setTaxAmt(billDetailDto.getTaxAmt());
        invoiceDetail.setTaxPre(billDetailDto.getTaxPre());
        invoiceDetail.setTaxPreCon(billDetailDto.getTaxPreCon());
        invoiceDetail.setZeroTax(billDetailDto.getZeroTax());
        invoiceDetail.setLineProperty(billDetailDto.getLineProperty());
        invoiceDetail.setLineNum(lineNum);
        invoiceDetail.setIncludeTax(0);
        invoiceDetail.setAmountsIncTax(billDetailDto.getAmountsIncTax());
        invoiceDetail.setBillDetailNO(billDetailDto.getBillDetailNO());
        invoiceDetail.setBillNO(billDetailDto.getBillNO());
        invoiceDetail.setPriceIncTax(billDetailDto.getPriceIncTax());
        invoiceDetail.setBy1(billDetailDto.getBy1());
        invoiceDetail.setSplitSign(billDetailDto.getSplitSign());
        BigDecimal taxDeduction = billDetailDto.getTaxDeduction();
        BigDecimal taxRate = invoiceDetail.getTaxRate();
        BigDecimal invTaxAmt = invoiceDetail.getTaxAmt();
        if (taxDeduction != null && taxDeduction.compareTo(BigDecimal.ZERO) != 0) {
            tmpTaxAmt = calcUtilMethods.calcTaxAmtByNoTaxMoneyDec(billDetailDto.getAmounts(), taxDeduction, taxRate, 4);
            invoiceSubjectDto.setIsTaxDe(1);
            invoiceSubjectDto.setTaxDeduction(String.valueOf(billDetailDto.getTaxDeduction()));
        } else {
            tmpTaxAmt = billSubjectDto.getAllEReducedTax() != false ? billDetailDto.getAmounts().multiply(taxRate).setScale(2, RoundingMode.HALF_UP) : calcUtilMethods.calcTaxAmtByNoTaxMoneyDec(billDetailDto.getAmounts(), null, taxRate, 4);
        }
        invoiceDetail.setInvDetailErr(tmpTaxAmt.subtract(invTaxAmt));
        invoiceSubjectDto.setInvErr(invoiceSubjectDto.getInvErr().add(invoiceDetail.getInvDetailErr()));
        invoiceSubjectDto.setAmounts(invoiceSubjectDto.getAmounts().add(invoiceDetail.getAmounts()));
        invoiceSubjectDto.setTaxAmt(invoiceSubjectDto.getTaxAmt().add(invoiceDetail.getTaxAmt()));
        boolean existsInvTaxRate = false;
        List<BigDecimal> invTaxRate = invoiceSubjectDto.getInvTaxRate();
        for (BigDecimal bigDecimal : invTaxRate) {
            if (billDetailDto.getTaxRate().compareTo(bigDecimal) != 0) continue;
            existsInvTaxRate = true;
            break;
        }
        if (!existsInvTaxRate) {
            invTaxRate.add(billDetailDto.getTaxRate());
        }
        if (useLineNote == 1) {
            if (StringUtils.isNotEmpty((CharSequence)billDetailDto.getLineNote())) {
                lineNotes = invoiceSubjectDto.getLineNotes();
                if (mccDistinct || !lineNotes.contains(billDetailDto.getLineNote())) {
                    lineNotes.add(billDetailDto.getLineNote());
                }
                invoiceSubjectDto.setLineNotes(lineNotes);
            }
        } else if (fristLineNote != null) {
            lineNotes = new ArrayList();
            lineNotes.add(fristLineNote);
            invoiceSubjectDto.setLineNotes(lineNotes);
        }
        invoiceDetail.setDetailIdSet(billDetailDto.getDetailIdSet());
        if (invoiceDetail.getTaxAmt().compareTo(BigDecimal.ZERO) < 0 && invoiceDetail.getLineProperty() != 4) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7a0e\u989d\u4e0d\u80fd\u5c0f\u4e8e0", (String)"InvoiceCoreService_2", (String)"imc-sim-split", (Object[])new Object[0]));
        }
        return invoiceDetail;
    }

    public static void taxAmtCheck(SmsResultDto smsResultDto) {
        List<InvoiceSubjectDto> invoiceList = smsResultDto.getInvoiceSList();
        for (int invoiceIndex = 0; invoiceIndex < invoiceList.size(); ++invoiceIndex) {
            InvoiceSubjectDto invoice = invoiceList.get(invoiceIndex);
            BigDecimal invDetailErrs = invoice.getInvoiceDetailList().stream().map(InvoiceDetailDto::getInvDetailErr).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (invDetailErrs.abs().compareTo(EnumType.DiffErrorEnum.TOTAL_TAX.getDiff()) <= 0) continue;
            invDetailErrs = BigDecimal.ZERO;
            for (int detailIndex = 0; detailIndex < invoice.getInvoiceDetailList().size(); ++detailIndex) {
                InvoiceDetailDto disDto;
                InvoiceDetailDto invoiceDetailDto = invoice.getInvoiceDetailList().get(detailIndex);
                if (EnumType.LinePropertyEnum.FOUR.getValue().compareTo(invoiceDetailDto.getLineProperty()) == 0 && invoiceDetailDto.getAmounts().compareTo(BigDecimal.ZERO) < 0) continue;
                invDetailErrs = invDetailErrs.add(invoiceDetailDto.getInvDetailErr());
                int nextDetailIndex = detailIndex + 1;
                if (nextDetailIndex >= invoice.getInvoiceDetailList().size() || !ComUtil.isInvoiceDisLine(disDto = invoice.getInvoiceDetailList().get(nextDetailIndex))) continue;
                invDetailErrs = invDetailErrs.add(disDto.getInvDetailErr());
            }
            if (invDetailErrs.abs().compareTo(EnumType.DiffErrorEnum.TOTAL_TAX.getDiff()) <= 0) continue;
            invoiceIndex += InvoiceCoreService.splitInvoice127(invDetailErrs, smsResultDto, invoiceIndex);
        }
    }

    private static int splitInvoice127(BigDecimal invDetailErrs, SmsResultDto smsResultDto, int invoiceIndex) {
        List<InvoiceSubjectDto> orignInvoiceList = smsResultDto.getInvoiceSList();
        InvoiceSubjectDto invoiceSubjectDto = orignInvoiceList.get(invoiceIndex);
        InvoiceSubjectDto originDetailDtos = (InvoiceSubjectDto)ComUtil.cloneObj(invoiceSubjectDto);
        originDetailDtos.getInvoiceDetailList().clear();
        ArrayList<List<InvoiceDetailDto>> detailsList = new ArrayList<List<InvoiceDetailDto>>();
        detailsList.add(invoiceSubjectDto.getInvoiceDetailList());
        InvoiceCoreService.splitInvoiceDetail127(detailsList, invDetailErrs);
        ArrayList<InvoiceSubjectDto> splitInvoiceList = new ArrayList<InvoiceSubjectDto>(detailsList.size());
        for (int i = 1; i < detailsList.size(); ++i) {
            InvoiceSubjectDto invoice = (InvoiceSubjectDto)ComUtil.cloneObj(originDetailDtos);
            invoice.setInvoiceNO(InvoiceCoreService.getInvSN());
            List detailList = (List)detailsList.get(i);
            for (InvoiceDetailDto invoiceDetailDto : detailList) {
                invoiceDetailDto.setBillNO(invoice.getBillNO());
                invoiceDetailDto.setBillDetailNO(InvoiceCoreService.getInvSN());
            }
            invoice.setInvoiceDetailList((List)detailsList.get(i));
            splitInvoiceList.add(invoice);
        }
        orignInvoiceList.addAll(invoiceIndex + 1, splitInvoiceList);
        return splitInvoiceList.size();
    }

    private static void splitInvoiceDetail127(List<List<InvoiceDetailDto>> detailsList, BigDecimal sumInvDetailErrs) {
        if (sumInvDetailErrs.abs().compareTo(EnumType.DiffErrorEnum.TOTAL_TAX.getDiff()) <= 0) {
            return;
        }
        List<InvoiceDetailDto> listInvoice = detailsList.get(detailsList.size() - 1);
        ArrayList<InvoiceDetailDto> remainDetailList = new ArrayList<InvoiceDetailDto>();
        BigDecimal remainDetailErrs = BigDecimal.ZERO;
        for (int i = listInvoice.size() - 1; i >= 0; --i) {
            InvoiceDetailDto lastDetail = listInvoice.get(i);
            remainDetailErrs = InvoiceCoreService.removeDetail(listInvoice, lastDetail, remainDetailList, remainDetailErrs);
            if (ComUtil.isInvoiceDisLine(lastDetail)) {
                if (listInvoice.size() == 1) break;
                InvoiceDetailDto preLastDetail = listInvoice.get(listInvoice.size() - 1);
                remainDetailErrs = InvoiceCoreService.removeDetail(listInvoice, preLastDetail, remainDetailList, remainDetailErrs);
                --i;
            }
            if (sumInvDetailErrs.subtract(remainDetailErrs).abs().compareTo(EnumType.DiffErrorEnum.TOTAL_TAX.getDiff()) > 0) continue;
            detailsList.add(remainDetailList);
            InvoiceCoreService.splitInvoiceDetail127(detailsList, remainDetailErrs);
            break;
        }
    }

    private static BigDecimal removeDetail(List<InvoiceDetailDto> detailsList, InvoiceDetailDto detail, List<InvoiceDetailDto> remainDetailList, BigDecimal remainTaxErr) {
        remainDetailList.add(0, detail);
        detailsList.remove(detail);
        return remainTaxErr.add(detail.getInvDetailErr());
    }

    private static String getInvSN() {
        return UUID.randomUUID().toString();
    }
}

