/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.split.service;

import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kd.imc.sim.split.dto.BillDetailDto;
import kd.imc.sim.split.dto.BillDetailIdDto;
import kd.imc.sim.split.dto.SmruleConfigDto;
import kd.imc.sim.split.enums.EnumType;
import kd.imc.sim.split.methods.BackCalcUtilMethods;
import kd.imc.sim.split.utils.ComUtil;
import org.apache.commons.beanutils.BeanUtils;

public class InvoiceSplitCoreService {
    private static BackCalcUtilMethods calcUtilMethods = new BackCalcUtilMethods();

    public List<BillDetailDto> goodsLineSplit(List<BillDetailDto> detailDtos, SmruleConfigDto configDto, BigDecimal aggrAmt, boolean hasDisLine, BigDecimal allAmount) throws IllegalAccessException, InvocationTargetException {
        BillDetailDto lastBillDteailDis;
        BigDecimal disErr;
        BigDecimal err;
        BigDecimal amounts;
        BillDetailDto originDto;
        BigDecimal billDetailAmount;
        int splitGoodsType = configDto.getSplitGoodsWithNumber();
        BigDecimal invLimitAmt = configDto.getFinalLimitAmt();
        List originDetailDtos = (List)ComUtil.cloneObj(detailDtos);
        BigDecimal originAggrAmt = aggrAmt;
        int index = 0;
        allAmount = allAmount.subtract(aggrAmt);
        while ((billDetailAmount = (originDto = detailDtos.get(index)).getAmounts().add(aggrAmt)).compareTo(invLimitAmt) > 0) {
            BillDetailDto productDto = new BillDetailDto();
            BillDetailDto newProductDto = new BillDetailDto();
            if (originDto.getOriginalAmts() == null) {
                originDto.setOriginalAmts(originDto.getAmts());
                productDto.setOriginalAmts(originDto.getAmts());
                newProductDto.setOriginalAmts(originDto.getAmts());
            }
            if (hasDisLine) {
                int disLineIndex = index + 1;
                BillDetailDto orginDisDto = detailDtos.get(disLineIndex);
                BillDetailDto disDto = new BillDetailDto();
                BillDetailDto newDisDto = new BillDetailDto();
                this.splitLineByDis(configDto, originDto, productDto, newProductDto, orginDisDto, disDto, newDisDto, aggrAmt);
                detailDtos.set(index, productDto);
                BigDecimal disAmount = disDto.getAmounts();
                if (disAmount.compareTo(BigDecimal.ZERO) == 0) {
                    if (newProductDto.getAmounts().compareTo(BigDecimal.ZERO) == 0) break;
                    detailDtos.set(index + 1, newProductDto);
                    ++index;
                    if (newDisDto.getAmounts().compareTo(BigDecimal.ZERO) != 0) {
                        detailDtos.add(index + 1, newDisDto);
                        ++index;
                    }
                } else {
                    detailDtos.set(index + 1, disDto);
                    ++index;
                    if (newProductDto.getAmounts().compareTo(BigDecimal.ZERO) == 0) break;
                    detailDtos.add(index + 1, newProductDto);
                    ++index;
                    if (newDisDto.getAmounts().compareTo(BigDecimal.ZERO) != 0) {
                        detailDtos.add(index + 1, newDisDto);
                    }
                }
                allAmount = allAmount.subtract(productDto.getAmounts());
                allAmount = allAmount.subtract(disDto.getAmounts());
            } else {
                this.splitLine(configDto, originDto, productDto, newProductDto, aggrAmt);
                detailDtos.set(index, productDto);
                if (newProductDto.getAmounts().compareTo(BigDecimal.ZERO) == 0) break;
                detailDtos.add(index + 1, newProductDto);
                ++index;
                allAmount = allAmount.subtract(productDto.getAmounts());
            }
            aggrAmt = BigDecimal.ZERO;
            if (InvoiceSplitCoreService.addNextProLineIsExpeed(detailDtos, index, invLimitAmt).booleanValue()) continue;
        }
        BillDetailDto lastBillDetail = detailDtos.get(detailDtos.size() - 1);
        if (hasDisLine) {
            lastBillDetail = detailDtos.get(detailDtos.size() - 2);
        }
        int amtNumber = configDto.getAmtNumber();
        int priceNumber = configDto.getPriceNumber();
        int includeTax = lastBillDetail.getIncludeTax();
        BigDecimal price = lastBillDetail.getPrice();
        BigDecimal amts = lastBillDetail.getAmts();
        BigDecimal priceInc = lastBillDetail.getPriceIncTax();
        BigDecimal amountsInc = lastBillDetail.getAmountsIncTax();
        if (price != null && price.compareTo(BigDecimal.ZERO) > 0) {
            if (EnumType.YOrNEnum.YES.getValue() == includeTax && priceInc.multiply(amts).subtract(amountsInc).abs().compareTo(EnumType.DiffErrorEnum.AMOUNT.getDiff()) > 0) {
                if (splitGoodsType == EnumType.SplitGoodsTypeEnum.TWO.getValue()) {
                    amts = calcUtilMethods.recursionAmtsCut(amountsInc, priceInc, amtNumber, configDto);
                    lastBillDetail.setAmts(amts);
                } else if (splitGoodsType == EnumType.SplitGoodsTypeEnum.THREE.getValue()) {
                    priceInc = calcUtilMethods.recursionPrice(amountsInc, amts, priceNumber, configDto);
                    lastBillDetail.setPriceIncTax(priceInc);
                }
            }
            price = lastBillDetail.getPrice();
            amts = lastBillDetail.getAmts();
            amounts = lastBillDetail.getAmounts();
            if (price.multiply(amts).subtract(amounts).abs().compareTo(EnumType.DiffErrorEnum.AMOUNT.getDiff()) > 0) {
                if (splitGoodsType == EnumType.SplitGoodsTypeEnum.TWO.getValue()) {
                    amts = calcUtilMethods.recursionAmtsCut(amounts, price, amtNumber, configDto);
                    lastBillDetail.setAmts(amts);
                } else if (splitGoodsType == EnumType.SplitGoodsTypeEnum.THREE.getValue()) {
                    price = calcUtilMethods.recursionPrice(amounts, amts, priceNumber, configDto);
                    lastBillDetail.setPrice(price);
                }
            }
        }
        if ((err = lastBillDetail.getAmounts().multiply(lastBillDetail.getTaxRate()).subtract(lastBillDetail.getTaxAmt())).abs().compareTo(EnumType.DiffErrorEnum.TAX.getDiff()) > 0) {
            BigDecimal adjustAmount = err.divide(new BigDecimal(String.valueOf(detailDtos.size())), 2, 0);
            for (BillDetailDto billDetailDto : detailDtos) {
                if (this.isDisLine(billDetailDto).booleanValue()) continue;
                if (err.abs().compareTo(EnumType.DiffErrorEnum.AMOUNT.getDiff()) <= 0) break;
                BigDecimal allowAdjust = billDetailDto.getAmounts().multiply(billDetailDto.getTaxRate()).subtract(billDetailDto.getTaxAmt()).abs().subtract(new BigDecimal("0.06")).abs().setScale(2, 1);
                allowAdjust = adjustAmount.compareTo(allowAdjust) > 0 ? allowAdjust : adjustAmount;
                billDetailDto.setTaxAmt(billDetailDto.getTaxAmt().subtract(allowAdjust));
                lastBillDetail.setTaxAmt(lastBillDetail.getTaxAmt().add(allowAdjust));
                err = err.subtract(allowAdjust);
            }
        }
        if (hasDisLine && (disErr = (lastBillDteailDis = detailDtos.get(detailDtos.size() - 1)).getAmounts().multiply(lastBillDteailDis.getTaxRate()).subtract(lastBillDteailDis.getTaxAmt())).abs().compareTo(EnumType.DiffErrorEnum.TAX.getDiff()) > 0) {
            BigDecimal adjustAmount2 = disErr.divide(new BigDecimal(String.valueOf(detailDtos.size())), 2, 0);
            for (BillDetailDto billDetailDto2 : detailDtos) {
                if (!this.isDisLine(billDetailDto2).booleanValue()) continue;
                if (disErr.abs().compareTo(EnumType.DiffErrorEnum.AMOUNT.getDiff()) <= 0) break;
                BigDecimal allowAdjust2 = billDetailDto2.getAmounts().multiply(billDetailDto2.getTaxRate()).subtract(billDetailDto2.getTaxAmt()).abs().subtract(EnumType.DiffErrorEnum.TAX.getDiff()).abs().setScale(2, 1);
                allowAdjust2 = adjustAmount2.compareTo(allowAdjust2) > 0 ? allowAdjust2 : adjustAmount2;
                billDetailDto2.setTaxAmt(billDetailDto2.getTaxAmt().subtract(allowAdjust2));
                lastBillDteailDis.setTaxAmt(lastBillDteailDis.getTaxAmt().add(allowAdjust2));
                disErr = disErr.subtract(allowAdjust2);
            }
        }
        price = lastBillDetail.getPrice();
        amts = lastBillDetail.getAmts();
        amounts = lastBillDetail.getAmounts();
        priceInc = lastBillDetail.getPriceIncTax();
        amountsInc = lastBillDetail.getAmountsIncTax();
        if (price != null && price.compareTo(BigDecimal.ZERO) > 0) {
            BigDecimal allAmounts = amounts;
            if (hasDisLine) {
                allAmounts = allAmounts.add(detailDtos.get(detailDtos.size() - 1).getAmounts());
            }
            if (priceNumber < 15 && allAmounts.compareTo(invLimitAmt) > 0) {
                configDto.setPriceNumber(priceNumber + 1);
                detailDtos = this.goodsLineSplit(originDetailDtos, configDto, originAggrAmt, hasDisLine, allAmount);
                configDto.setPriceNumber(priceNumber);
                return detailDtos;
            }
            if (priceNumber < 15 && priceInc.multiply(amts).subtract(amountsInc).abs().compareTo(EnumType.DiffErrorEnum.AMOUNT.getDiff()) > 0) {
                configDto.setPriceNumber(priceNumber + 1);
                detailDtos = this.goodsLineSplit(originDetailDtos, configDto, originAggrAmt, hasDisLine, allAmount);
                configDto.setPriceNumber(priceNumber);
                return detailDtos;
            }
            if (priceNumber < 15 && price.multiply(amts).subtract(amounts).abs().compareTo(EnumType.DiffErrorEnum.AMOUNT.getDiff()) > 0) {
                configDto.setPriceNumber(priceNumber + 1);
                detailDtos = this.goodsLineSplit(originDetailDtos, configDto, originAggrAmt, hasDisLine, allAmount);
                configDto.setPriceNumber(priceNumber);
                return detailDtos;
            }
        }
        return detailDtos;
    }

    private static Boolean addNextProLineIsExpeed(List<BillDetailDto> detailDtos, int curIndex, BigDecimal invLimitAmt) {
        BillDetailDto lineDto = detailDtos.get(curIndex);
        BigDecimal countNextAmount = BigDecimal.ZERO.add(lineDto.getAmounts());
        int j = curIndex + 1;
        if (j < detailDtos.size()) {
            BillDetailDto disLineDto = detailDtos.get(j);
            countNextAmount = countNextAmount.add(disLineDto.getAmounts());
        }
        return countNextAmount.compareTo(invLimitAmt) > 0;
    }

    private void splitLineByDis(SmruleConfigDto configDto, BillDetailDto orginDto, BillDetailDto productDto, BillDetailDto remainProductDto, BillDetailDto orginDisDto, BillDetailDto disDto, BillDetailDto remainDisDto, BigDecimal aggrAmt) throws IllegalAccessException, InvocationTargetException {
        BigDecimal taxAmt2;
        BigDecimal taxAmt;
        BigDecimal amountsInc2;
        BigDecimal amountsInc;
        BigDecimal amounts2;
        BigDecimal usedAmt;
        BigDecimal calDisAmt;
        BigDecimal invLimitAmt = configDto.getFinalLimitAmt();
        BigDecimal dec = orginDto.getTaxDeduction();
        BigDecimal oAmounts = orginDto.getAmounts();
        BigDecimal oDisAmounts = orginDisDto.getAmounts();
        BigDecimal lineAmtErr = EnumType.DiffErrorEnum.AMOUNT.getDiff();
        BigDecimal itemAmt = invLimitAmt.subtract(aggrAmt);
        if (itemAmt.compareTo(invLimitAmt) > 0) {
            calDisAmt = oDisAmounts.multiply(invLimitAmt).divide(oAmounts, 2, 4);
            usedAmt = invLimitAmt.subtract(calDisAmt);
        } else {
            BigDecimal itemAmtGroup = oAmounts.add(oDisAmounts);
            calDisAmt = oDisAmounts.multiply(itemAmt).divide(itemAmtGroup, 2, 4);
            usedAmt = itemAmt.subtract(calDisAmt);
        }
        int includeTax = orginDto.getIncludeTax();
        BeanUtils.copyProperties((Object)productDto, (Object)orginDto);
        productDto.setAmounts(usedAmt);
        BigDecimal taxRate = productDto.getTaxRate();
        BigDecimal amounts = productDto.getAmounts();
        BeanUtils.copyProperties((Object)remainProductDto, (Object)orginDto);
        if (productDto.getPrice() != null && productDto.getPrice().compareTo(BigDecimal.ZERO) > 0) {
            BigDecimal amts;
            int priceNumber = configDto.getPriceNumber();
            BigDecimal price = this.getPrice(productDto.getPrice(), priceNumber);
            BigDecimal priceInc = this.getPrice(productDto.getPriceIncTax(), priceNumber);
            if (configDto.isOneUnchange() && orginDto.getAmts().compareTo(BigDecimal.ONE) == 0) {
                amts = BigDecimal.ONE;
                price = productDto.getAmounts();
                priceInc = productDto.getAmounts().add(calcUtilMethods.calcTaxAmtByNoTaxMoneyDec(amounts, dec, taxRate, 2));
                productDto.setOneUnchange(true);
            } else {
                int amtNumber = configDto.getAmtNumber();
                amts = calcUtilMethods.recursionAmtsCut(amounts, price, amtNumber, configDto);
                if ((amts = amts.setScale(amtNumber, 3)).compareTo(BigDecimal.ZERO) == 0) {
                    amts = calcUtilMethods.recursionAmtsCut(amounts, price, amtNumber, configDto);
                }
                if (amts.compareTo(BigDecimal.ONE) <= 0 && price.compareTo(invLimitAmt) < 0 && amts.setScale(amtNumber, 3).compareTo(BigDecimal.ZERO) == 0) {
                    BeanUtils.copyProperties((Object)productDto, (Object)orginDto);
                    remainProductDto.setAmounts(BigDecimal.ZERO);
                    BeanUtils.copyProperties((Object)disDto, (Object)orginDisDto);
                    remainDisDto.setAmounts(BigDecimal.ZERO);
                    return;
                }
                if (orginDto.getAmts().subtract(amts).compareTo(BigDecimal.ZERO) < 0) {
                    configDto.setPriceNumber(priceNumber + 1);
                    if (configDto.getPriceNumber() > 15) {
                        BeanUtils.copyProperties((Object)productDto, (Object)orginDto);
                        remainProductDto.setAmounts(BigDecimal.ZERO);
                        BeanUtils.copyProperties((Object)disDto, (Object)orginDisDto);
                        remainDisDto.setAmounts(BigDecimal.ZERO);
                        return;
                    }
                    this.splitLineByDis(configDto, orginDto, productDto, remainProductDto, orginDisDto, disDto, remainDisDto, aggrAmt);
                    return;
                }
            }
            amounts = calcUtilMethods.recursionAmounts(amts, price, 2);
            amounts2 = orginDto.getAmounts().subtract(amounts);
            amountsInc = calcUtilMethods.recursionAmounts(amts, priceInc, 2);
            amountsInc2 = orginDto.getAmountsIncTax().subtract(amountsInc);
            taxAmt = amountsInc.subtract(amounts);
            taxAmt2 = orginDto.getTaxAmt().subtract(taxAmt);
            if (amounts.compareTo(BigDecimal.ZERO) <= 0 || amounts2.compareTo(BigDecimal.ZERO) < 0 || amountsInc.compareTo(BigDecimal.ZERO) <= 0 || amountsInc2.compareTo(BigDecimal.ZERO) < 0) {
                BeanUtils.copyProperties((Object)productDto, (Object)orginDto);
                remainProductDto.setAmounts(BigDecimal.ZERO);
                BeanUtils.copyProperties((Object)disDto, (Object)orginDisDto);
                remainDisDto.setAmounts(BigDecimal.ZERO);
                return;
            }
            if (amounts.multiply(taxRate).subtract(taxAmt).abs().compareTo(EnumType.DiffErrorEnum.TAX.getDiff()) > 0) {
                taxAmt = calcUtilMethods.calcTaxAmtByNoTaxMoneyDec(amounts, dec, taxRate, 2);
                taxAmt2 = orginDto.getTaxAmt().subtract(taxAmt);
            }
            if (taxRate.compareTo(BigDecimal.ZERO) == 0) {
                taxAmt = orginDto.getTaxAmt().multiply(amounts).divide(orginDto.getAmounts(), 2, 4);
                taxAmt2 = orginDto.getTaxAmt().subtract(taxAmt);
                amountsInc = amounts.add(taxAmt);
                amountsInc2 = orginDto.getAmountsIncTax().subtract(amountsInc);
                if (EnumType.YOrNEnum.YES.getValue() == includeTax && priceInc.multiply(amts).subtract(amountsInc).abs().compareTo(lineAmtErr) > 0) {
                    amountsInc = calcUtilMethods.recursionAmounts(amts, priceInc, 2);
                    amountsInc2 = orginDto.getAmountsIncTax().subtract(amountsInc);
                }
            }
            productDto.setAmts(amts);
            productDto.setPrice(price);
            productDto.setPriceIncTax(priceInc);
            if (configDto.isOneUnchange() && orginDto.getAmts().compareTo(BigDecimal.ONE) == 0) {
                remainProductDto.setAmts(BigDecimal.ONE);
                remainProductDto.setPrice(remainProductDto.getAmounts());
                remainProductDto.setPriceIncTax(remainProductDto.getAmountsIncTax());
                remainProductDto.setOneUnchange(true);
            } else {
                remainProductDto.setAmts(orginDto.getAmts().subtract(amts));
                remainProductDto.setPrice(price);
                remainProductDto.setPriceIncTax(priceInc);
            }
        } else {
            amounts = usedAmt.setScale(2, 4);
            amounts2 = oAmounts.subtract(amounts).setScale(2, 4);
            taxAmt = calcUtilMethods.calcTaxAmtByNoTaxMoneyDec(amounts, dec, taxRate, 2);
            taxAmt2 = orginDto.getTaxAmt().subtract(taxAmt);
            amountsInc = amounts.add(taxAmt);
            amountsInc2 = orginDto.getAmountsIncTax().subtract(amountsInc).setScale(2, 4);
        }
        productDto.setAmounts(amounts);
        productDto.setAmountsIncTax(amountsInc);
        productDto.setTaxAmt(taxAmt);
        productDto.setSplitSign(1);
        remainProductDto.setAmounts(amounts2);
        remainProductDto.setAmountsIncTax(amountsInc2);
        remainProductDto.setTaxAmt(taxAmt2);
        remainProductDto.setSplitSign(1);
        BeanUtils.copyProperties((Object)disDto, (Object)orginDisDto);
        BigDecimal disAmount = itemAmt.subtract(amounts);
        disAmount = disAmount.compareTo(BigDecimal.ZERO) >= 0 ? calDisAmt : disAmount;
        BigDecimal disTaxAmt = disAmount.multiply(disDto.getTaxRate()).setScale(2, 4);
        disDto.setAmounts(disAmount);
        disDto.setTaxAmt(disTaxAmt);
        BigDecimal disAmountInc = disAmount.add(disTaxAmt);
        disDto.setAmountsIncTax(disAmountInc);
        disDto.setSplitSign(1);
        BeanUtils.copyProperties((Object)remainDisDto, (Object)orginDisDto);
        remainDisDto.setAmounts(orginDisDto.getAmounts().subtract(disAmount).setScale(2, 4));
        remainDisDto.setTaxAmt(orginDisDto.getTaxAmt().subtract(disTaxAmt).setScale(2, 4));
        remainDisDto.setAmountsIncTax(orginDisDto.getAmountsIncTax().subtract(disAmountInc));
        remainDisDto.setSplitSign(1);
        this.BillDetailIdSplit(orginDto, productDto, remainProductDto, orginDisDto, disDto, remainDisDto, configDto);
    }

    private BigDecimal getPrice(BigDecimal price, int priceNumber) {
        BigDecimal price1 = price.setScale(priceNumber, 4);
        if (price1.compareTo(BigDecimal.ZERO) == 0) {
            return price;
        }
        return price1;
    }

    private void splitLine(SmruleConfigDto configDto, BillDetailDto orginDto, BillDetailDto productDto, BillDetailDto remainProductDto, BigDecimal aggrAmt) throws IllegalAccessException, InvocationTargetException {
        BigDecimal taxAmt2;
        BigDecimal taxAmt;
        BigDecimal amountsInc2;
        BigDecimal amountsInc;
        BigDecimal amounts2;
        BigDecimal invLimitAmt = configDto.getFinalLimitAmt();
        BigDecimal dec = orginDto.getTaxDeduction();
        int includeTax = orginDto.getIncludeTax();
        BigDecimal lineAmtErr = EnumType.DiffErrorEnum.AMOUNT.getDiff();
        int amtNumber = configDto.getAmtNumber();
        int priceNumber = configDto.getPriceNumber();
        BigDecimal usedAmt = invLimitAmt.subtract(aggrAmt);
        BeanUtils.copyProperties((Object)productDto, (Object)orginDto);
        productDto.setAmounts(usedAmt);
        BigDecimal taxRate = productDto.getTaxRate();
        BigDecimal amounts = productDto.getAmounts();
        BeanUtils.copyProperties((Object)remainProductDto, (Object)orginDto);
        BigDecimal tmpAmountsInc = orginDto.getAmountsIncTax();
        if (productDto.getPrice() != null && productDto.getPrice().compareTo(BigDecimal.ZERO) > 0) {
            BigDecimal amts;
            BigDecimal price = this.getPrice(productDto.getPrice(), priceNumber);
            BigDecimal priceInc = this.getPrice(productDto.getPriceIncTax(), priceNumber);
            if (orginDto.getAmts().compareTo(BigDecimal.ONE) == 0 && configDto.isOneUnchange()) {
                amts = BigDecimal.ONE;
                price = productDto.getAmounts();
                priceInc = productDto.getAmounts().add(calcUtilMethods.calcTaxAmtByNoTaxMoneyDec(amounts, dec, taxRate, 2));
                productDto.setOneUnchange(true);
            } else {
                amts = calcUtilMethods.recursionAmtsCut(amounts, price, amtNumber, configDto);
                if ((amts = amts.setScale(amtNumber, 3)).compareTo(BigDecimal.ZERO) == 0) {
                    amts = calcUtilMethods.recursionAmtsCut(amounts, price, amtNumber, configDto);
                }
                if (amts.compareTo(BigDecimal.ONE) <= 0 && price.compareTo(invLimitAmt) < 0 && amts.setScale(amtNumber, 3).compareTo(BigDecimal.ZERO) == 0) {
                    BeanUtils.copyProperties((Object)productDto, (Object)orginDto);
                    remainProductDto.setAmounts(BigDecimal.ZERO);
                    return;
                }
                if (orginDto.getAmts().subtract(amts).compareTo(BigDecimal.ZERO) < 0) {
                    configDto.setPriceNumber(priceNumber + 1);
                    if (configDto.getPriceNumber() > 15) {
                        BeanUtils.copyProperties((Object)productDto, (Object)orginDto);
                        remainProductDto.setAmounts(BigDecimal.ZERO);
                        return;
                    }
                    this.splitLine(configDto, orginDto, productDto, remainProductDto, aggrAmt);
                    return;
                }
            }
            amounts = calcUtilMethods.recursionAmounts(amts, price, 2);
            amounts2 = orginDto.getAmounts().subtract(amounts);
            amountsInc = calcUtilMethods.recursionAmounts(amts, priceInc, 2);
            amountsInc2 = orginDto.getAmountsIncTax().subtract(amountsInc);
            taxAmt = amountsInc.subtract(amounts);
            taxAmt2 = orginDto.getTaxAmt().subtract(taxAmt);
            if (amounts.compareTo(BigDecimal.ZERO) <= 0 || amounts2.compareTo(BigDecimal.ZERO) < 0 || amountsInc.compareTo(BigDecimal.ZERO) <= 0 || amountsInc2.compareTo(BigDecimal.ZERO) < 0) {
                BeanUtils.copyProperties((Object)productDto, (Object)orginDto);
                remainProductDto.setAmounts(BigDecimal.ZERO);
                return;
            }
            if (amounts.multiply(taxRate).subtract(taxAmt).abs().compareTo(EnumType.DiffErrorEnum.AMOUNT.getDiff()) > 0) {
                taxAmt = calcUtilMethods.calcTaxAmtByNoTaxMoneyDec(amounts, dec, taxRate, 2);
                taxAmt2 = orginDto.getTaxAmt().subtract(taxAmt);
            }
            if (taxRate.compareTo(BigDecimal.ZERO) == 0) {
                taxAmt = orginDto.getTaxAmt().multiply(amounts).divide(orginDto.getAmounts(), 2, 4);
                taxAmt2 = orginDto.getTaxAmt().subtract(taxAmt);
                amountsInc = amounts.add(taxAmt);
                amountsInc2 = orginDto.getAmountsIncTax().subtract(amountsInc);
                if (EnumType.YOrNEnum.YES.getValue() == includeTax && priceInc.multiply(amts).subtract(amountsInc).abs().compareTo(lineAmtErr) > 0) {
                    amountsInc = calcUtilMethods.recursionAmounts(amts, priceInc, 2);
                    amountsInc2 = orginDto.getAmountsIncTax().subtract(amountsInc);
                }
            }
            productDto.setAmts(amts);
            productDto.setPrice(price);
            productDto.setPriceIncTax(priceInc);
            if (orginDto.getAmts().compareTo(BigDecimal.ONE) == 0 && configDto.isOneUnchange()) {
                remainProductDto.setAmts(BigDecimal.ONE);
                remainProductDto.setPrice(remainProductDto.getAmounts());
                remainProductDto.setPriceIncTax(remainProductDto.getAmountsIncTax());
                remainProductDto.setOneUnchange(true);
            } else {
                remainProductDto.setAmts(orginDto.getAmts().subtract(amts));
                remainProductDto.setPrice(price);
                remainProductDto.setPriceIncTax(priceInc);
            }
        } else {
            BigDecimal oAmounts = orginDto.getAmounts();
            amounts = usedAmt.setScale(2, 3);
            amounts2 = oAmounts.subtract(amounts).setScale(2, 3);
            taxAmt = calcUtilMethods.calcTaxAmtByNoTaxMoneyDec(amounts, dec, taxRate, 2);
            taxAmt2 = orginDto.getTaxAmt().subtract(taxAmt);
            amountsInc = amounts.add(taxAmt);
            amountsInc2 = tmpAmountsInc.subtract(amountsInc).setScale(2, 4);
        }
        productDto.setAmounts(amounts);
        productDto.setAmountsIncTax(amountsInc);
        productDto.setTaxAmt(taxAmt);
        productDto.setSplitSign(1);
        remainProductDto.setAmounts(amounts2);
        remainProductDto.setAmountsIncTax(amountsInc2);
        remainProductDto.setTaxAmt(taxAmt2);
        remainProductDto.setSplitSign(1);
        this.BillDetailIdSplit(orginDto, productDto, remainProductDto, null, null, null, configDto);
    }

    private Boolean isDisLine(BillDetailDto detailDto) {
        Integer lineProperty = detailDto.getLineProperty();
        BigDecimal amounts = detailDto.getAmounts();
        boolean isDisline = false;
        if (EnumType.LinePropertyEnum.FOUR.getValue().compareTo(lineProperty) == 0 && amounts.compareTo(BigDecimal.ZERO) < 0) {
            isDisline = true;
        }
        return isDisline;
    }

    private void BillDetailIdSplit(BillDetailDto originDto, BillDetailDto productDto, BillDetailDto remainProductDto, BillDetailDto originDisDto, BillDetailDto disDto, BillDetailDto remainDisDto, SmruleConfigDto configDto) {
        Set<BillDetailIdDto> orginDetailIdSet = originDto.getDetailIdSet();
        Iterator<BillDetailIdDto> it = orginDetailIdSet.iterator();
        LinkedHashSet<BillDetailIdDto> productDetailIdSet = new LinkedHashSet<BillDetailIdDto>();
        BigDecimal sumAmount = BigDecimal.ZERO;
        while (it.hasNext()) {
            BillDetailIdDto billDetailIdDto = it.next();
            if ((sumAmount = sumAmount.add(billDetailIdDto.getAmounts())).compareTo(productDto.getAmountsByTax()) > 0) {
                BigDecimal splitAomunt2 = sumAmount.subtract(productDto.getAmountsByTax());
                BigDecimal splitAomunt3 = billDetailIdDto.getAmounts().subtract(splitAomunt2);
                BigDecimal amt2 = calcUtilMethods.recursionAmtsCut(splitAomunt2, billDetailIdDto.getPrice(), configDto.getAmtNumber(), configDto);
                BigDecimal amt3 = billDetailIdDto.getAmts().subtract(amt2);
                BillDetailIdDto splitBillDetailId1 = new BillDetailIdDto(billDetailIdDto.getBillNO(), billDetailIdDto.getBillDetailNO(), splitAomunt3, billDetailIdDto.getPrice(), amt3, productDto.getTaxAmt());
                BillDetailIdDto splitBillDetailId2 = new BillDetailIdDto(billDetailIdDto.getBillNO(), billDetailIdDto.getBillDetailNO(), splitAomunt2, billDetailIdDto.getPrice(), amt2, remainProductDto.getTaxAmt());
                productDetailIdSet.add(splitBillDetailId1);
                it.remove();
                orginDetailIdSet.add(splitBillDetailId2);
                break;
            }
            if (sumAmount.compareTo(productDto.getAmountsByTax()) == 0) {
                productDetailIdSet.add(billDetailIdDto);
                it.remove();
                break;
            }
            productDetailIdSet.add(billDetailIdDto);
            it.remove();
        }
        productDto.setDetailIdSet(productDetailIdSet);
        remainProductDto.setDetailIdSet(orginDetailIdSet);
        if (originDisDto != null) {
            Set<BillDetailIdDto> orginDisDetailIdSet = originDisDto.getDetailIdSet();
            Iterator<BillDetailIdDto> disIt = orginDisDetailIdSet.iterator();
            LinkedHashSet<BillDetailIdDto> disProductDetailIdSet = new LinkedHashSet<BillDetailIdDto>();
            BigDecimal sumDisAmount = BigDecimal.ZERO;
            while (disIt.hasNext()) {
                BillDetailIdDto billDetailIdDto2 = disIt.next();
                if ((sumDisAmount = sumDisAmount.add(billDetailIdDto2.getAmounts())).compareTo(disDto.getAmountsByTax()) < 0) {
                    BigDecimal splitAomunt4 = sumDisAmount.subtract(disDto.getAmountsByTax());
                    BigDecimal splitAomunt5 = billDetailIdDto2.getAmounts().subtract(splitAomunt4);
                    BillDetailIdDto splitBillDetailId3 = new BillDetailIdDto(billDetailIdDto2.getBillNO(), billDetailIdDto2.getBillDetailNO(), splitAomunt5, billDetailIdDto2.getPrice(), billDetailIdDto2.getAmts(), disDto.getTaxAmt());
                    BillDetailIdDto splitBillDetailId4 = new BillDetailIdDto(billDetailIdDto2.getBillNO(), billDetailIdDto2.getBillDetailNO(), splitAomunt4, billDetailIdDto2.getPrice(), billDetailIdDto2.getAmts(), remainDisDto.getTaxAmt());
                    disProductDetailIdSet.add(splitBillDetailId3);
                    disIt.remove();
                    orginDisDetailIdSet.add(splitBillDetailId4);
                    break;
                }
                if (sumDisAmount.compareTo(disDto.getAmountsByTax()) == 0) {
                    disProductDetailIdSet.add(billDetailIdDto2);
                    disIt.remove();
                    break;
                }
                disProductDetailIdSet.add(billDetailIdDto2);
                disIt.remove();
            }
            disDto.setDetailIdSet(disProductDetailIdSet);
            remainDisDto.setDetailIdSet(orginDisDetailIdSet);
        }
    }
}

