/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.approverissue.redprover;

import com.alibaba.fastjson.JSONArray;
import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ValueTextItem;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.F7SelectedList;
import kd.bos.list.events.F7SelectedListRemoveEvent;
import kd.bos.list.events.F7SelectedListRemoveListener;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.orm.query.QFilter;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.common.helper.RedInfoHelper;
import org.apache.commons.collections.CollectionUtils;

public class RedInfoCheckPlugin
extends AbstractFormPlugin
implements ListRowClickListener,
F7SelectedListRemoveListener,
SearchEnterListener {
    public void search(SearchEnterEvent event) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(4);
        filters.add(this.getCommonQFilter());
        List searchFields = event.getSearchFields();
        if (CollectionUtils.isNotEmpty((Collection)searchFields)) {
            for (Map search : searchFields) {
                List fieldNames = (List)search.get("fieldName");
                List values = (List)search.get("value");
                QFilter filter = null;
                for (String fieldName : fieldNames) {
                    for (String value : values) {
                        if (filter == null) {
                            filter = new QFilter(fieldName, "ftlike", (Object)("%" + value + "%"));
                            continue;
                        }
                        filter.or(fieldName, "ftlike", (Object)("%" + value + "%"));
                    }
                }
                filters.add(filter);
            }
        }
        BillList billList = (BillList)this.getControl("billlistap");
        FilterParameter fp = new FilterParameter();
        fp.setQFilters(filters);
        billList.setFilterParameter(fp);
        billList.refreshData();
    }

    public void afterCreateNewData(EventObject e) {
        BillList billList = (BillList)this.getControl("billlistap");
        FilterParameter fp = new FilterParameter();
        fp.setFilter(this.getCommonQFilter());
        billList.setFilterParameter(fp);
        billList.refreshData();
    }

    private QFilter getCommonQFilter() {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        Object applicant = params.get("applicant");
        Object buyerTaxNo = params.get("buyertaxno");
        Object billOrgId = params.get("orgPk");
        Object salerTaxNo = params.get("salertaxno");
        return RedInfoHelper.getRedInfoFromFilter(applicant, buyerTaxNo, billOrgId, salerTaxNo);
    }

    public void afterBindData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object pk = customParams.get("infoserialnos");
        if (null != pk) {
            JSONArray array = JSONArray.parseArray((String)pk.toString());
            F7SelectedList selectedList = (F7SelectedList)this.getControl("f7selectedlistap");
            ArrayList<ValueTextItem> items = new ArrayList<ValueTextItem>();
            HashSet<String> pkSet = new HashSet<String>();
            for (Object pks : array) {
                String pkStr = pks.toString();
                ValueTextItem item = new ValueTextItem(pkStr, null);
                items.add(item);
                pkSet.add(pkStr);
            }
            selectedList.addItems(items);
            this.getView().updateView("f7selectedlistap");
            BillList billList = (BillList)this.getControl("billlistap");
            DynamicObjectCollection collection = billList.getListModel().getQueryResult().getCollection();
            ArrayList<Integer> selectRowList = new ArrayList<Integer>();
            for (int i = 0; i < collection.size(); ++i) {
                DynamicObject obj = (DynamicObject)collection.get(i);
                if (!pkSet.contains(String.valueOf(obj.getString("infoserialno")))) continue;
                selectRowList.add(i);
            }
            if (selectRowList.size() != 0) {
                billList.selectRows(selectRowList.stream().mapToInt(Integer::valueOf).toArray());
            }
        }
    }

    public void registerListener(EventObject e) {
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addListRowClickListener((ListRowClickListener)this);
        F7SelectedList f7SelectedList = (F7SelectedList)this.getControl("f7selectedlistap");
        f7SelectedList.addF7SelectedListRemoveListener((F7SelectedListRemoveListener)this);
        f7SelectedList.addF7SelectedListRemoveAllListener((F7SelectedListRemoveListener)this);
        this.addClickListeners(new String[]{"btnok", "btndownload"});
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener((SearchEnterListener)this);
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("btnok".equals(key)) {
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            this.getView().returnDataToParent((Object)selectedRows);
            this.getView().close();
        }
        if ("btndownload".equals(key)) {
            ViewUtil.openDialog((AbstractFormPlugin)this, (String)ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u4e0b\u8f7d", (String)"RedInfoCheckPlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]), null, (String)"sim_red_info_download", (String)"sim_red_info_download");
        }
    }

    public void listRowClick(ListRowClickEvent evt) {
        F7SelectedList selectedList = (F7SelectedList)this.getControl("f7selectedlistap");
        ListSelectedRowCollection col = evt.getListSelectedRowCollection();
        ArrayList<ValueTextItem> items = new ArrayList<ValueTextItem>();
        for (ListSelectedRow row : col) {
            ValueTextItem item = new ValueTextItem(String.valueOf(row.getPrimaryKeyValue()), row.getBillNo());
            items.add(item);
        }
        selectedList.addItems(items);
        this.getView().updateView("f7selectedlistap");
    }

    public void RemoveClick(F7SelectedListRemoveEvent f7SelectedListRemoveEvent) {
        String param = (String)f7SelectedListRemoveEvent.getParam();
        BillList billList = (BillList)this.getControl("billlistap");
        if (StringUtils.isBlank((CharSequence)param)) {
            billList.clearSelection();
            return;
        }
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        selectedRows.removeIf(row -> Objects.equal((Object)row.getPrimaryKeyValue().toString(), (Object)param));
        if (selectedRows.size() == 0) {
            billList.clearSelection();
        } else {
            billList.restoreSelection(selectedRows);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if ("sim_red_info_download".equals(actionId)) {
            this.getView().invokeOperation("refresh");
        }
    }
}

