/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.botp.convert;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildQueryParemeterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeBuildRowConditionEventArgs;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.imc.bdm.common.helper.CurrencyHelper;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.sim.common.dto.OriginalBill2ArBillProcessDTO;

public class OriginalBill2ArBillPlugin
extends AbstractConvertPlugIn {
    private static final Log LOGGER = LogFactory.getLog(OriginalBill2ArBillPlugin.class);

    public void afterBuildQueryParemeter(AfterBuildQueryParemeterEventArgs e) {
        e.addSrcField("exrate");
        e.addSrcField("exchangedate");
        e.addSrcField("quotation");
        e.addSrcField("exratetable");
        e.addSrcField("fromcurr");
        e.addSrcField("tocurr");
        e.addSrcField("billdate");
        e.addSrcField("billno");
        e.addSrcField("closestatus");
        e.addSrcField("producttype");
        e.addSrcField("num");
        e.addSrcField("taxrate");
        e.addSrcField("unpushnum");
        e.addSrcField("foreigntotalamount");
        e.addSrcField("fromtaxamount");
        e.addSrcField("totalamount");
        e.addSrcField("invoiceamount");
        e.addSrcField("hsbz");
        e.addSrcField("buyerproperty");
        e.addSrcField("id");
        e.addSrcField("sim_original_bill_item.id");
    }

    public void beforeBuildRowCondition(BeforeBuildRowConditionEventArgs e) {
        super.beforeBuildRowCondition(e);
        List selectedRows = e.getSelectedRows();
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)"sim_original_bill", (String)"sim_original_bill_item.corebillno,closestatus,billno", (QFilter[])new QFilter("id", "in", (Object)selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).distinct().toArray()).toArray());
        HashSet<String> billNos = new HashSet<String>();
        for (DynamicObject bill : bills) {
            DynamicObjectCollection items = bill.getDynamicObjectCollection("sim_original_bill_item");
            for (DynamicObject item : items) {
                String coreBillNo = item.getString("corebillno");
                if (!StringUtils.isNotBlank((CharSequence)coreBillNo)) continue;
                billNos.add(coreBillNo);
            }
            if (!"1".equals(bill.getString("closestatus"))) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e%s\u5df2\u5173\u95ed\uff0c\u4e0d\u80fd\u786e\u8ba4\u5e94\u6536", (String)"OriginalBill2ArBillPlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]), bill.getString("billno")));
        }
        try {
            Map result;
            if (billNos.size() > 0 && null != (result = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"ar", (String)"Original2FinArCheckService", (String)"checkSameCoreNoSalOutBill", (Object[])new Object[]{billNos})) && !((Boolean)result.get("success")).booleanValue()) {
                throw new KDBizException(String.valueOf(result.get("errMsg")));
            }
        }
        catch (KDBizException ke) {
            throw ke;
        }
        catch (Exception ex) {
            LOGGER.info(String.format("Original2FinArCheckServiceException:%s", ex.getMessage()), (Object)ex);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e0b\u63a8\u5f02\u5e38%s", (String)"OriginalBill2ArBillPlugin_3", (String)"imc-sim-formplugin", (Object[])new Object[0]), ex.getMessage()));
        }
    }

    public void afterConvert(AfterConvertEventArgs e) {
        long startTime = System.currentTimeMillis();
        String tgtName = this.getTgtMainType().getName();
        ExtendedDataEntity[] extendedDataEntities = e.getTargetExtDataEntitySet().FindByEntityKey(tgtName);
        Map srcfldPro = e.getFldProperties();
        String srcBillName = this.getSrcMainType().getName();
        OriginalBill2ArBillProcessDTO process = this.fillSourceMap(extendedDataEntities, srcfldPro, srcBillName);
        Map billPkMap = process.getBillPkMap();
        ExtendedDataEntitySet targetExtDataEntitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] arBillItems = targetExtDataEntitySet.FindByEntityKey("entry");
        int itemEntitySeq = 0;
        DynamicObject[] taxRates = BusinessDataServiceHelper.load((String)"bd_taxrate", (String)"taxrate", null);
        HashMap<String, DynamicObject> taxRateMap = new HashMap<String, DynamicObject>();
        for (DynamicObject obj : taxRates) {
            BigDecimal taxRate = obj.getBigDecimal("taxrate");
            if (null == taxRate) continue;
            taxRateMap.put(obj.getBigDecimal("taxrate").stripTrailingZeros().toPlainString(), obj);
        }
        boolean isExcludeOne = !"1".equals(ImcConfigUtil.getValue((String)"OriginalBill2ArBillNumConfig", (String)"excludeNumOne"));
        for (ExtendedDataEntity entity : extendedDataEntities) {
            DynamicObject dataEntity = entity.getDataEntity();
            List sourceBillRows = (List)entity.getValue("ConvertSource");
            DynamicObject sourceRow = (DynamicObject)sourceBillRows.get(0);
            this.dealExrate(srcfldPro, dataEntity, sourceRow);
            if (null == dataEntity.get("bizdate")) {
                dataEntity.set("bizdate", (Object)DateUtils.getDayStart((Date)((Date)((DynamicProperty)srcfldPro.get("billdate")).getValue((Object)sourceRow))));
            }
            Object invoiceAmount = ((DynamicProperty)srcfldPro.get("invoiceamount")).getValue((Object)sourceRow);
            Object totalAmount = ((DynamicProperty)srcfldPro.get("totalamount")).getValue((Object)sourceRow);
            dataEntity.set("localamt", invoiceAmount);
            dataEntity.set("reclocalamt", totalAmount);
            Object hsbz = ((DynamicProperty)srcfldPro.get("hsbz")).getValue((Object)sourceRow);
            dataEntity.set("isincludetax", (Object)"1".equals(hsbz));
            Object foreignTotalAmount = ((DynamicProperty)srcfldPro.get("foreigntotalamount")).getValue((Object)sourceRow);
            dataEntity.set("invoicedamt", foreignTotalAmount);
            dataEntity.set("invoicedlocalamt", totalAmount);
            dataEntity.set("ispricetotal", (Object)Boolean.TRUE);
            DynamicObjectCollection items = (DynamicObjectCollection)dataEntity.get("entry");
            int arItemsLength = items.size();
            BigDecimal arBillTotalRecAmount = BigDecimal.ZERO;
            BigDecimal arBillTotalLocRecAmount = BigDecimal.ZERO;
            for (int i = 0; i < arItemsLength; ++i) {
                ExtendedDataEntity itemConstruct = arBillItems[itemEntitySeq];
                ++itemEntitySeq;
                DynamicObject tgtEntryRow = itemConstruct.getDataEntity();
                DynamicObject source = (DynamicObject)((List)itemConstruct.getValue("ConvertSource")).get(0);
                String taxRate = (String)((DynamicProperty)srcfldPro.get("taxrate")).getValue((Object)source);
                BigDecimal percentTaxRate = new BigDecimal(taxRate).multiply(new BigDecimal("100"));
                String key = percentTaxRate.stripTrailingZeros().toPlainString();
                DynamicObject dynamicObject = (DynamicObject)taxRateMap.get(key);
                if (null == dynamicObject) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u7a0e\u7387%s", (String)"OriginalBill2ArBillPlugin_4", (String)"imc-sim-formplugin", (Object[])new Object[0]), taxRate));
                }
                tgtEntryRow.set("taxrateid", (Object)dynamicObject);
                tgtEntryRow.set("e_taxrate", dynamicObject.get("taxrate"));
                this.dealDiscountData(srcfldPro, process, billPkMap, hsbz, tgtEntryRow, source, isExcludeOne);
                this.dealIssuedData(srcfldPro, process, billPkMap, hsbz, tgtEntryRow, source);
                process.setAmount(process.getAmount().add(tgtEntryRow.getBigDecimal("e_amount")));
                process.setTax(process.getTax().add(tgtEntryRow.getBigDecimal("e_tax")));
                process.setYsAmount(process.getYsAmount().add(tgtEntryRow.getBigDecimal("e_recamount")));
                process.setYsLocalAmount(process.getYsAmount().add(tgtEntryRow.getBigDecimal("e_uninvoicedlocalamt")));
                process.setLocalAmount(process.getLocalAmount().add(tgtEntryRow.getBigDecimal("e_localamt")));
                process.setLocalTax(process.getTax().add(tgtEntryRow.getBigDecimal("e_taxlocalamt")));
                arBillTotalRecAmount = arBillTotalRecAmount.add(tgtEntryRow.getBigDecimal("e_issueinvrecamt"));
                arBillTotalLocRecAmount = arBillTotalLocRecAmount.add(tgtEntryRow.getBigDecimal("e_issueinvreclocalamt"));
            }
            dataEntity.set("invoicedamt", (Object)process.getYsAmount());
            dataEntity.set("invoicedlocalamt", (Object)process.getCombineLocalAmount());
            dataEntity.set("amount", (Object)process.getAmount());
            dataEntity.set("tax", (Object)process.getTax());
            dataEntity.set("recamount", (Object)process.getYsAmount());
            dataEntity.set("reclocalamt", (Object)process.getYsLocalAmount());
            dataEntity.set("localamt", (Object)process.getLocalAmount());
            dataEntity.set("taxlocamt", (Object)process.getLocalTax());
            dataEntity.set("issueinvrecamt", (Object)arBillTotalRecAmount);
            dataEntity.set("issueinvreclocalamt", (Object)arBillTotalLocRecAmount);
            this.clearAmount(process);
            LOGGER.info("OriginalBill2ArBill:" + SerializationUtils.toJsonString((Object)dataEntity));
            long endTime = System.currentTimeMillis();
            LOGGER.info("ArBill2OriginalBillBotpTime:" + (endTime - startTime));
        }
    }

    private void dealIssuedData(Map<String, DynamicProperty> srcfldPro, OriginalBill2ArBillProcessDTO process, Map<Object, DynamicObject> billPkMap, Object hsbz, DynamicObject tgtEntryRow, DynamicObject source) {
        Object nextRowPk;
        Object sourceEntryId = srcfldPro.get("sim_original_bill_item.id").getValue((Object)source);
        Object sourceEntityId = srcfldPro.get("id").getValue((Object)source);
        DynamicObject bill = billPkMap.get(sourceEntityId);
        DynamicObject fromCurr = bill.getDynamicObject("fromcurr");
        boolean isFrom = CurrencyHelper.isFrom((Object)fromCurr);
        Map itemMap = process.getItemMap();
        Map deducateMap = process.getDeducateMap();
        DynamicObject sourceItem = (DynamicObject)itemMap.get(sourceEntryId);
        if (null == sourceItem) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f00\u7968\u7533\u8bf7\u5355\u660e\u7ec6id:%s\u672a\u67e5\u5230\u660e\u7ec6", (String)"OriginalBill2ArBillPlugin_1", (String)"imc-sim-formplugin", (Object[])new Object[0]), sourceEntryId));
        }
        this.addIssuedData(tgtEntryRow, sourceItem, isFrom);
        if (deducateMap.containsKey(sourceEntryId) && null != (nextRowPk = deducateMap.get(sourceEntryId))) {
            DynamicObject nextRow = (DynamicObject)itemMap.get(nextRowPk);
            if (null != nextRow) {
                this.addIssuedData(tgtEntryRow, nextRow, isFrom);
            } else {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f00\u7968\u7533\u8bf7\u5355\u6298\u6263\u884c\u660e\u7ec6id:%s\u672a\u67e5\u5230\u660e\u7ec6", (String)"OriginalBill2ArBillPlugin_2", (String)"imc-sim-formplugin", (Object[])new Object[0]), sourceEntryId));
            }
        }
    }

    private void addIssuedData(DynamicObject tgtEntryRow, DynamicObject oriItem, boolean isFrom) {
        if (isFrom) {
            tgtEntryRow.set("e_issueinvamt", (Object)tgtEntryRow.getBigDecimal("e_issueinvamt").add(oriItem.getBigDecimal("fromissuedamount")));
            tgtEntryRow.set("e_issueinvtax", (Object)tgtEntryRow.getBigDecimal("e_issueinvtax").add(oriItem.getBigDecimal("fromissuedtax")));
            tgtEntryRow.set("e_issueinvrecamt", (Object)tgtEntryRow.getBigDecimal("e_issueinvrecamt").add(oriItem.getBigDecimal("fromissuedtaxamount")));
        } else {
            tgtEntryRow.set("e_issueinvamt", (Object)tgtEntryRow.getBigDecimal("e_issueinvamt").add(oriItem.getBigDecimal("issuedamount")));
            tgtEntryRow.set("e_issueinvtax", (Object)tgtEntryRow.getBigDecimal("e_issueinvtax").add(oriItem.getBigDecimal("issuedtax")));
            tgtEntryRow.set("e_issueinvrecamt", (Object)tgtEntryRow.getBigDecimal("e_issueinvrecamt").add(oriItem.getBigDecimal("issuedtotaltaxamount")));
        }
        tgtEntryRow.set("e_issueinvqty", (Object)tgtEntryRow.getBigDecimal("e_quantity"));
        tgtEntryRow.set("e_issueinvlocalamt", (Object)tgtEntryRow.getBigDecimal("e_issueinvlocalamt").add(oriItem.getBigDecimal("issuedamount")));
        tgtEntryRow.set("e_issueinvlocaltax", (Object)tgtEntryRow.getBigDecimal("e_issueinvlocaltax").add(oriItem.getBigDecimal("issuedtax")));
        tgtEntryRow.set("e_issueinvreclocalamt", (Object)tgtEntryRow.getBigDecimal("e_issueinvreclocalamt").add(oriItem.getBigDecimal("issuedtotaltaxamount")));
    }

    private void clearAmount(OriginalBill2ArBillProcessDTO process) {
        process.setYsAmount(BigDecimal.ZERO);
        process.setAmount(BigDecimal.ZERO);
        process.setTax(BigDecimal.ZERO);
        process.setYsLocalAmount(BigDecimal.ZERO);
    }

    private void dealDiscountData(Map<String, DynamicProperty> srcfldPro, OriginalBill2ArBillProcessDTO process, Map<Object, DynamicObject> billPkMap, Object hsbz, DynamicObject tgtEntryRow, DynamicObject source, boolean isExcludeOne) {
        BigDecimal rmbAmount;
        BigDecimal arAmount;
        BigDecimal discountRMBAmount;
        BigDecimal discountArAmount;
        Object sourceEntityId = srcfldPro.get("id").getValue((Object)source);
        Object sourceEntryId = srcfldPro.get("sim_original_bill_item.id").getValue((Object)source);
        Object discountMode = tgtEntryRow.get("e_discountmode");
        DynamicObject firstRow = (DynamicObject)process.getItemMap().get(sourceEntryId);
        DynamicObject bill = billPkMap.get(sourceEntityId);
        DynamicObject fromCurr = bill.getDynamicObject("fromcurr");
        int amtPrecision = 2;
        int pricePrecision = 8;
        if (null != fromCurr) {
            amtPrecision = fromCurr.getInt("amtprecision");
            pricePrecision = fromCurr.getInt("priceprecision");
        }
        BigDecimal num = tgtEntryRow.getBigDecimal("e_quantity");
        BigDecimal srcNum = (BigDecimal)srcfldPro.get("unpushnum").getValue((Object)source);
        BigDecimal taxUnitPrice = tgtEntryRow.getBigDecimal("e_taxunitprice");
        boolean isNumEmpty = BigDecimalUtil.compareZero((BigDecimal)num);
        if (isExcludeOne) {
            isNumEmpty = isNumEmpty || BigDecimal.ONE.compareTo(num) == 0;
        }
        boolean isTaxPriceEmpty = BigDecimalUtil.compareZero((BigDecimal)taxUnitPrice);
        Object deducutedPk = process.getDeducateMap().get(sourceEntryId);
        DynamicObject nextRow = (DynamicObject)process.getItemMap().get(deducutedPk);
        boolean isFrom = CurrencyHelper.isFrom((Object)fromCurr);
        if (CurrencyHelper.isFrom((Object)fromCurr)) {
            tgtEntryRow.set("e_recamount", (Object)firstRow.getBigDecimal("fromtaxamount").setScale(amtPrecision, RoundingMode.HALF_UP));
            tgtEntryRow.set("e_invoicedamt", tgtEntryRow.get("e_recamount"));
            tgtEntryRow.set("e_invoicedlocalamt", (Object)firstRow.getBigDecimal("taxamount"));
            tgtEntryRow.set("e_reclocalamt", tgtEntryRow.get("e_invoicedlocalamt"));
            tgtEntryRow.set("e_amount", (Object)firstRow.getBigDecimal("fromamount").setScale(amtPrecision, RoundingMode.HALF_UP));
            tgtEntryRow.set("e_localamt", (Object)firstRow.getBigDecimal("amount"));
            tgtEntryRow.set("e_tax", (Object)tgtEntryRow.getBigDecimal("e_recamount").subtract(tgtEntryRow.getBigDecimal("e_amount")));
            tgtEntryRow.set("e_taxlocalamt", (Object)tgtEntryRow.getBigDecimal("e_reclocalamt").subtract(tgtEntryRow.getBigDecimal("e_localamt")));
            num = this.setQuantity(tgtEntryRow, srcNum, taxUnitPrice, isNumEmpty, isTaxPriceEmpty);
            taxUnitPrice = this.setPrice(tgtEntryRow, firstRow, pricePrecision, num, taxUnitPrice, isNumEmpty, isTaxPriceEmpty, isFrom);
        } else {
            tgtEntryRow.set("e_recamount", (Object)firstRow.getBigDecimal("taxamount"));
            tgtEntryRow.set("e_reclocalamt", tgtEntryRow.get("e_recamount"));
            tgtEntryRow.set("e_invoicedamt", tgtEntryRow.get("e_recamount"));
            tgtEntryRow.set("e_invoicedlocalamt", tgtEntryRow.get("e_recamount"));
            tgtEntryRow.set("e_amount", (Object)firstRow.getBigDecimal("amount"));
            tgtEntryRow.set("e_localamt", tgtEntryRow.get("e_amount"));
            tgtEntryRow.set("e_tax", (Object)tgtEntryRow.getBigDecimal("e_recamount").subtract(tgtEntryRow.getBigDecimal("e_amount")));
            tgtEntryRow.set("e_taxlocalamt", (Object)tgtEntryRow.getBigDecimal("e_reclocalamt").subtract(tgtEntryRow.getBigDecimal("e_localamt")));
            num = this.setQuantity(tgtEntryRow, srcNum, taxUnitPrice, isNumEmpty, isTaxPriceEmpty);
            taxUnitPrice = this.setPrice(tgtEntryRow, firstRow, pricePrecision, num, taxUnitPrice, isNumEmpty, isTaxPriceEmpty, isFrom);
        }
        if (null == nextRow || StringUtils.isBlank((Object)discountMode) && StringUtils.isBlank(process.getDeducateMap().get(sourceEntryId))) {
            tgtEntryRow.set("e_discountmode", (Object)"NULL");
            return;
        }
        if (CurrencyHelper.isFrom((Object)fromCurr)) {
            discountArAmount = nextRow.getBigDecimal("fromtaxamount").abs();
            discountRMBAmount = nextRow.getBigDecimal("taxamount").abs();
            arAmount = firstRow.getBigDecimal("fromtaxamount").abs();
            rmbAmount = firstRow.getBigDecimal("taxamount").abs();
            tgtEntryRow.set("e_discountamount", (Object)discountArAmount);
            tgtEntryRow.set("e_discountlocalamt", (Object)discountRMBAmount);
        } else {
            discountRMBAmount = discountArAmount = nextRow.getBigDecimal("taxamount").abs();
            rmbAmount = arAmount = firstRow.getBigDecimal("taxamount").abs();
            tgtEntryRow.set("e_discountamount", (Object)discountArAmount);
            tgtEntryRow.set("e_discountlocalamt", (Object)discountArAmount);
        }
        BigDecimal recAmount = arAmount.subtract(discountArAmount);
        tgtEntryRow.set("e_recamount", (Object)recAmount.setScale(amtPrecision, RoundingMode.HALF_UP));
        num = this.setQuantity(tgtEntryRow, num, taxUnitPrice, isNumEmpty, isTaxPriceEmpty);
        tgtEntryRow.set("e_invoicedamt", tgtEntryRow.get("e_recamount"));
        BigDecimal recRmbAmount = rmbAmount.subtract(discountRMBAmount);
        tgtEntryRow.set("e_reclocalamt", (Object)recRmbAmount);
        tgtEntryRow.set("e_invoicedlocalamt", (Object)recRmbAmount);
        String taxRateStr = firstRow.getString("taxrate");
        BigDecimal amount = firstRow.getBigDecimal("amount");
        BigDecimal tax = firstRow.getBigDecimal("tax");
        BigDecimal fromAmount = firstRow.getBigDecimal("fromamount");
        BigDecimal fromTax = firstRow.getBigDecimal("fromtax");
        BigDecimal nextAmount = nextRow.getBigDecimal("amount");
        BigDecimal nextTax = nextRow.getBigDecimal("tax");
        BigDecimal nextFromAmount = nextRow.getBigDecimal("fromamount");
        BigDecimal nextFromTax = nextRow.getBigDecimal("fromtax");
        BigDecimal rowAmount = amount.add(nextAmount);
        BigDecimal rowTax = tax.add(nextTax);
        tgtEntryRow.set("e_localamt", (Object)rowAmount);
        tgtEntryRow.set("e_taxlocalamt", (Object)rowTax);
        if (CurrencyHelper.isFrom((Object)fromCurr)) {
            rowAmount = fromAmount.add(nextFromAmount);
            rowTax = fromTax.add(nextFromTax);
        }
        tgtEntryRow.set("e_amount", (Object)rowAmount);
        tgtEntryRow.set("e_tax", (Object)rowTax);
        this.setPrice(tgtEntryRow, firstRow, pricePrecision, num, taxUnitPrice, isNumEmpty, isTaxPriceEmpty, isFrom);
        if (StringUtils.isBlank((Object)discountMode)) {
            tgtEntryRow.set("e_discountmode", (Object)"TOTAL");
            tgtEntryRow.set("e_discountamount", (Object)discountArAmount);
            this.dealRealPrice(tgtEntryRow, amtPrecision, pricePrecision, recAmount, num, taxRateStr);
            return;
        }
        this.dealDiscountMode(hsbz, tgtEntryRow, discountMode, firstRow, amtPrecision, nextRow, discountArAmount);
        this.dealRealPrice(tgtEntryRow, amtPrecision, pricePrecision, recAmount, num, taxRateStr);
    }

    private BigDecimal setPrice(DynamicObject tgtEntryRow, DynamicObject firstRow, int pricePrecision, BigDecimal num, BigDecimal taxUnitPrice, boolean isNumEmpty, boolean isTaxPriceEmpty, boolean isFrom) {
        if (isNumEmpty && isTaxPriceEmpty) {
            if (BigDecimalUtil.compareZero((BigDecimal)tgtEntryRow.getBigDecimal("e_unitprice"))) {
                BigDecimal price = firstRow.getBigDecimal("unitprice").setScale(pricePrecision, RoundingMode.HALF_UP);
                if (isFrom) {
                    price = firstRow.getBigDecimal("fromprice").setScale(pricePrecision, RoundingMode.HALF_UP);
                }
                tgtEntryRow.set("e_unitprice", (Object)price);
            }
            if (BigDecimalUtil.compareZero((BigDecimal)tgtEntryRow.getBigDecimal("e_taxunitprice"))) {
                BigDecimal taxPrice = firstRow.getBigDecimal("taxunitprice").setScale(pricePrecision, RoundingMode.HALF_UP);
                if (isFrom) {
                    taxPrice = firstRow.getBigDecimal("fromtaxprice").setScale(pricePrecision, RoundingMode.HALF_UP);
                }
                tgtEntryRow.set("e_taxunitprice", (Object)taxPrice);
            }
            tgtEntryRow.set("e_actunitprice", tgtEntryRow.get("e_unitprice"));
            tgtEntryRow.set("e_acttaxunitprice", tgtEntryRow.get("e_taxunitprice"));
        } else if (isTaxPriceEmpty && !isNumEmpty) {
            BigDecimal recAmount = tgtEntryRow.getBigDecimal("e_recamount").add(tgtEntryRow.getBigDecimal("e_discountamount"));
            taxUnitPrice = recAmount.divide(num, pricePrecision, RoundingMode.HALF_UP);
            BigDecimal amount = tgtEntryRow.getBigDecimal("e_amount");
            if (!BigDecimalUtil.compareZero((BigDecimal)tgtEntryRow.getBigDecimal("e_discountamount"))) {
                BigDecimal taxRate = tgtEntryRow.getBigDecimal("e_taxrate").divide(new BigDecimal("100"), 4, RoundingMode.HALF_UP);
                amount = recAmount.divide(taxRate.add(BigDecimal.ONE), 2, RoundingMode.HALF_UP);
            }
            BigDecimal price = amount.divide(num, pricePrecision, RoundingMode.HALF_UP);
            tgtEntryRow.set("e_unitprice", (Object)price);
            tgtEntryRow.set("e_taxunitprice", (Object)taxUnitPrice);
            tgtEntryRow.set("e_actunitprice", (Object)price);
            tgtEntryRow.set("e_acttaxunitprice", (Object)taxUnitPrice);
        }
        return taxUnitPrice;
    }

    private BigDecimal setQuantity(DynamicObject tgtEntryRow, BigDecimal srcNum, BigDecimal taxUnitPrice, boolean isNumEmpty, boolean isTaxPriceEmpty) {
        if (isNumEmpty && isTaxPriceEmpty) {
            tgtEntryRow.set("e_quantity", (Object)srcNum);
            tgtEntryRow.set("e_invoicedqty", (Object)srcNum);
        } else if (isNumEmpty && !isTaxPriceEmpty) {
            srcNum = tgtEntryRow.getBigDecimal("e_recamount").add(tgtEntryRow.getBigDecimal("e_discountamount")).divide(taxUnitPrice, 8, RoundingMode.HALF_UP);
            tgtEntryRow.set("e_quantity", (Object)srcNum);
            tgtEntryRow.set("e_invoicedqty", (Object)srcNum);
        } else {
            srcNum = tgtEntryRow.getBigDecimal("e_quantity");
        }
        return srcNum;
    }

    private void dealRealPrice(DynamicObject tgtEntryRow, int amtPrecision, int pricePrecision, BigDecimal recAmount, BigDecimal num, String taxRateStr) {
        BigDecimal realTaxPrice = recAmount.divide(num, pricePrecision, RoundingMode.HALF_UP);
        BigDecimal recAmountExcludTax = recAmount.divide(BigDecimal.ONE.add(new BigDecimal(taxRateStr)), amtPrecision, RoundingMode.HALF_UP);
        BigDecimal realPrice = recAmountExcludTax.divide(num, pricePrecision, RoundingMode.HALF_UP);
        tgtEntryRow.set("e_actunitprice", (Object)realPrice);
        tgtEntryRow.set("e_acttaxunitprice", (Object)realTaxPrice);
    }

    private void dealDiscountMode(Object hsbz, DynamicObject tgtEntryRow, Object discountMode, DynamicObject firstRow, int amtPrecision, DynamicObject nextRow, BigDecimal discountArAmount) {
        String taxRateStr = firstRow.getString("taxrate");
        BigDecimal taxAmount = nextRow.getBigDecimal("taxamount").abs();
        BigDecimal firstAmount = firstRow.getBigDecimal("taxamount").abs();
        if ("PERCENT".equals(discountMode)) {
            BigDecimal rate = taxAmount.divide(firstAmount, 4, RoundingMode.HALF_UP).multiply(new BigDecimal("100"));
            tgtEntryRow.set("e_discountrate", (Object)rate);
        }
        if ("PERUNIT".equals(discountMode)) {
            BigDecimal discountUnitRate;
            if ("1".equals(hsbz)) {
                discountUnitRate = discountArAmount.divide(tgtEntryRow.getBigDecimal("e_quantity"), amtPrecision, RoundingMode.HALF_UP);
            } else {
                discountUnitRate = discountArAmount.divide(tgtEntryRow.getBigDecimal("e_quantity"), 20, RoundingMode.HALF_UP);
                discountUnitRate = discountUnitRate.divide(BigDecimal.ONE.add(new BigDecimal(taxRateStr)), amtPrecision, RoundingMode.HALF_UP);
            }
            tgtEntryRow.set("e_discountrate", (Object)discountUnitRate);
        }
        if ("GIFT".equals(discountMode)) {
            tgtEntryRow.set("e_ispresent", (Object)Boolean.TRUE);
        }
        tgtEntryRow.set("e_discountamount", (Object)discountArAmount);
    }

    public OriginalBill2ArBillProcessDTO fillSourceMap(ExtendedDataEntity[] extendedDataEntities, Map<String, DynamicProperty> srcfldPro, String srcBillName) {
        OriginalBill2ArBillProcessDTO process = new OriginalBill2ArBillProcessDTO();
        HashSet<Object> sourceBillPks = new HashSet<Object>();
        for (ExtendedDataEntity entity : extendedDataEntities) {
            List sourceBillRows = (List)entity.getValue("ConvertSource");
            for (DynamicObject sourceBillRow : sourceBillRows) {
                sourceBillPks.add(srcfldPro.get("id").getValue((Object)sourceBillRow));
            }
        }
        DynamicObject[] sourceBills = BusinessDataServiceHelper.load((Object[])sourceBillPks.toArray(new Object[0]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)srcBillName));
        HashMap<Object, Object> deducateMap = new HashMap<Object, Object>();
        HashMap<Object, DynamicObject> itemMap = new HashMap<Object, DynamicObject>();
        HashMap<Object, DynamicObject> billPkMap = new HashMap<Object, DynamicObject>();
        for (DynamicObject sourceBill : sourceBills) {
            billPkMap.put(sourceBill.getPkValue(), sourceBill);
            DynamicObjectCollection entry = sourceBill.getDynamicObjectCollection("sim_original_bill_item");
            for (int i = 0; i < entry.size(); ++i) {
                DynamicObject item = (DynamicObject)entry.get(i);
                itemMap.put(item.getPkValue(), item);
                if (!"1".equals(item.getString("rowtype"))) continue;
                Object lastRowPk = ((DynamicObject)entry.get(i - 1)).getPkValue();
                deducateMap.put(lastRowPk, item.getPkValue());
            }
        }
        process.setBillPkMap(billPkMap);
        process.setDeducateMap(deducateMap);
        process.setItemMap(itemMap);
        return process;
    }

    private void dealExrate(Map<String, DynamicProperty> srcfldPro, DynamicObject dataEntity, DynamicObject sourceRow) {
        BigDecimal exChangeRate = (BigDecimal)dataEntity.get("exchangerate");
        if (!BigDecimalUtil.compareZero((BigDecimal)exChangeRate)) {
            return;
        }
        BigDecimal exRate = (BigDecimal)srcfldPro.get("exrate").getValue((Object)sourceRow);
        if (BigDecimalUtil.compareZero((BigDecimal)exRate)) {
            exRate = BigDecimal.ONE;
        }
        dataEntity.set("exchangerate", (Object)exRate);
    }
}

