/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.matchbill;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.SubEntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.InvoiceStatus;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.IssueType;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.RandomString;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.common.constant.table.MatchBillConstant;
import kd.imc.sim.common.dto.matchconfirm.CheckRedConfirmDTO;
import kd.imc.sim.common.dto.matchconfirm.MatchRedConfirmBillDTO;
import kd.imc.sim.common.dto.matchconfirm.MatchRedConfirmBillItemDTO;
import kd.imc.sim.common.dto.matchconfirm.MatchRedConfirmResultDTO;
import kd.imc.sim.common.helper.issueinvoice.UnitPriceHelper;
import kd.imc.sim.common.utils.MathUtils;
import kd.imc.sim.formplugin.bill.matchbill.control.NegativeBillMatchControl;
import kd.imc.sim.formplugin.issuing.control.CreateInvoiceViewCloseCallBackControl;
import kd.imc.sim.formplugin.match.RedConfirmMatchHelper;

public class BillMatchDetailPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"oriinvoiceno", "saleraddr", "buyeraddr", "confirminfocode"});
        this.addItemClickListeners(new String[]{"save", "chooseredconfirm", "advcontoolbarap11"});
    }

    public void afterBindData(EventObject e) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("sim_original_bill_item");
        entryGrid.selectRows(0);
        String source = (String)this.getView().getFormShowParameter().getCustomParam("source");
        if ("workbench".equals(source)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"fieldsetpanelap3"});
            this.setFlexCollapse("fs_baseinfo", "fieldsetpanelap2", "flexpanelap3");
        }
        this.reCalcPushAmount();
    }

    private void reCalcPushAmount() {
        try {
            DynamicObject matchBill = this.getModel().getDataEntity(true);
            String matchTarget = matchBill.getString("matchtarget");
            if (StringUtils.isNotBlank((CharSequence)matchTarget) && !"0".equals(matchTarget)) {
                return;
            }
            DynamicObjectCollection items = matchBill.getDynamicObjectCollection("sim_original_bill_item");
            BigDecimal pushAmount = BigDecimal.ZERO;
            BigDecimal pushTax = BigDecimal.ZERO;
            HashSet<String> pushInvoiceNum = new HashSet<String>(16);
            BigDecimal matchAmount = BigDecimal.ZERO;
            BigDecimal matchTax = BigDecimal.ZERO;
            HashSet<String> matchInvoiceNum = new HashSet<String>(16);
            for (DynamicObject item : items) {
                DynamicObjectCollection oriItems = item.getDynamicObjectCollection("subentryentity");
                for (DynamicObject oriItem : oriItems) {
                    if ("1".equals(oriItem.getString("pushstatus"))) {
                        pushAmount = pushAmount.add(oriItem.getBigDecimal("oriitemamount"));
                        pushTax = pushTax.add(oriItem.getBigDecimal("oriitemtax"));
                        pushInvoiceNum.add(oriItem.getString("oriinvoiceid"));
                    }
                    matchAmount = matchAmount.add(oriItem.getBigDecimal("oriitemamount"));
                    matchTax = matchTax.add(oriItem.getBigDecimal("oriitemtax"));
                    matchInvoiceNum.add(oriItem.getString("oriinvoiceid"));
                }
            }
            IDataModel model = this.getModel();
            model.setValue("pushdownamount", (Object)pushAmount.negate());
            model.setValue("pushdowntax", (Object)pushTax.negate());
            model.setValue("pushdowninvoicenum", (Object)pushInvoiceNum.size());
            model.setValue("matchamount", (Object)matchAmount);
            model.setValue("matchtax", (Object)matchTax);
            model.setValue("matchtotalamount", (Object)matchAmount.add(matchTax));
            model.setValue("matchinvoicenum", (Object)matchInvoiceNum.size());
            this.getModel().setDataChanged(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setFlexCollapse(String ... keys) {
        for (String key : keys) {
            Container flex = (Container)this.getView().getControl(key);
            if (flex == null) continue;
            flex.setCollapse(true);
        }
    }

    public static String createMatchBatch() {
        String matchBatchNum = "400_";
        LocalDate date = LocalDate.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");
        matchBatchNum = matchBatchNum + date.format(formatter);
        matchBatchNum = matchBatchNum + RandomString.getRandom((int)15);
        return matchBatchNum;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate oprate = (FormOperate)args.getSource();
        String operateKey = oprate.getOperateKey();
        if ("newsubentry".equals(operateKey) || "newsubentry2".equals(operateKey)) {
            int selectRow = this.getBillItemSelectRow();
            Object itemMatchStatus = this.getModel().getValue("itemmatchstatus", selectRow);
            if ("1".equals(itemMatchStatus)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5339\u914d\u6210\u529f\u7684\u660e\u7ec6\u4e0d\u80fd\u589e\u884c\u3002", (String)"BillMatchDetailPlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        } else if ("deletesubentry".equals(operateKey)) {
            SubEntryGrid subEntryGrid = (SubEntryGrid)this.getControl("subentryentity");
            int selectRow = subEntryGrid.getSelectRows()[0];
            Object pushStatus = this.getModel().getValue("pushstatus", selectRow);
            if ("1".equals(pushStatus)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u4e0b\u63a8\u7684\u4e0d\u5141\u8bb8\u5220\u884c \u3002", (String)"BillMatchDetailPlugin_1", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        } else if ("red".equals(operateKey)) {
            DynamicObject bill = this.getModel().getDataEntity(true);
            new NegativeBillMatchControl().red(this, args, new DynamicObject[]{bill});
        } else if ("deletesubentry1".equals(operateKey)) {
            SubEntryGrid subEntryGrid = (SubEntryGrid)this.getControl("confirmsubentryentity");
            int[] selectRows = subEntryGrid.getSelectRows();
            HashSet<Long> redConfirmPks = new HashSet<Long>();
            DynamicObjectCollection entity = this.getModel().getEntryEntity("confirmsubentryentity");
            for (int selectRow : selectRows) {
                Object issueStatus = this.getModel().getValue("confirmissuestatus", selectRow);
                if ("0".equals(issueStatus)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5f00\u7968\u7684\u4e0d\u5141\u8bb8\u5220\u884c \u3002", (String)"BillMatchDetailPlugin_20", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                Object redConfirmPk = ((DynamicObject)entity.get(selectRow)).get("redconfirmpk");
                if (null != redConfirmPk && redConfirmPk instanceof Long) {
                    redConfirmPks.add((Long)redConfirmPk);
                    continue;
                }
                if (!(redConfirmPk instanceof DynamicObject)) continue;
                redConfirmPks.add(((DynamicObject)redConfirmPk).getLong("id"));
            }
            this.getPageCache().put("deleteSubEntryConfirmPks", JSONObject.toJSONString(redConfirmPks));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if ("oriinvoiceno".equals(e.getProperty().getName())) {
            SubEntryGrid subEntryGrid = (SubEntryGrid)this.getControl("subentryentity");
            int selectRow = subEntryGrid.getSelectRows()[0];
            String newValue = (String)e.getChangeSet()[0].getNewValue();
            if (StringUtils.isBlank((CharSequence)newValue)) {
                this.getModel().setValue("oriinvoiceno", e.getChangeSet()[0].getOldValue(), selectRow);
            }
        }
        if ("matchstatus".equals(e.getProperty().getName())) {
            this.getModel().setValue("matchtime", (Object)new Date());
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("chooseredconfirm".equals(itemKey)) {
            this.clickRedConirmNumber();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String pksStr;
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        if ("deletesubentry".equals(operateKey)) {
            SubEntryGrid subEntryGrid = (SubEntryGrid)this.getControl("subentryentity");
            this.getModel().setValue("matchtime", (Object)new Date());
            if (subEntryGrid.getEntryData().getDataEntitys().length > 0) {
                this.getModel().setValue("itemmatchstatus", (Object)MatchBillConstant.MatchStatusEnum.MATCH_PART_SUCCESS.getCode(), this.getBillItemSelectRow());
                this.getModel().setValue("matchstatus", (Object)MatchBillConstant.MatchStatusEnum.MATCH_PART_SUCCESS.getCode());
            } else {
                this.getModel().setValue("itemmatchstatus", (Object)MatchBillConstant.MatchStatusEnum.MATCH_FAIL.getCode(), this.getBillItemSelectRow());
                DynamicObject matchBill = this.getModel().getDataEntity(true);
                DynamicObjectCollection matchItems = matchBill.getDynamicObjectCollection("sim_original_bill_item");
                if (matchItems.stream().allMatch(matchItem -> MatchBillConstant.MatchStatusEnum.MATCH_FAIL.getCode().equals(matchItem.getString("itemmatchstatus")))) {
                    this.getModel().setValue("matchstatus", (Object)MatchBillConstant.MatchStatusEnum.MATCH_FAIL.getCode());
                } else {
                    this.getModel().setValue("matchstatus", (Object)MatchBillConstant.MatchStatusEnum.MATCH_PART_SUCCESS.getCode());
                }
            }
        } else if ("deletesubentry1".equals(operateKey) && StringUtils.isNotBlank((CharSequence)(pksStr = this.getPageCache().get("deleteSubEntryConfirmPks")))) {
            HashSet<Long> redConfirmPks = new HashSet<Long>();
            JSONArray jsonArray = JSONObject.parseArray((String)pksStr);
            for (Object o : jsonArray) {
                redConfirmPks.add((Long)o);
            }
            this.deleteRedConfirmAndResetView(redConfirmPks);
            this.getPageCache().remove("deleteSubEntryConfirmPks");
        }
    }

    private void deleteRedConfirmAndResetView(Set<Long> redConfirmPks) {
        DynamicObject matchBillObj = this.getModel().getDataEntity(true);
        BigDecimal matchInvoiceAmount = BigDecimal.ZERO;
        BigDecimal matchTotalTax = BigDecimal.ZERO;
        DynamicObjectCollection parentRowObjs = matchBillObj.getDynamicObjectCollection("sim_original_bill_item");
        HashSet<String> redConfirmNumSet = new HashSet<String>();
        for (DynamicObject parentRow : parentRowObjs) {
            DynamicObjectCollection subItems = parentRow.getDynamicObjectCollection("confirmsubentryentity");
            Iterator subIterator = subItems.iterator();
            while (subIterator.hasNext()) {
                DynamicObject item = (DynamicObject)subIterator.next();
                Long redConfirmPk = item.getLong("redconfirmpk");
                if (!redConfirmPks.contains(redConfirmPk)) continue;
                subIterator.remove();
            }
            BigDecimal totalItemInvoiceAmount = BigDecimal.ZERO;
            BigDecimal totalItemTax = BigDecimal.ZERO;
            for (DynamicObject subItem : subItems) {
                totalItemInvoiceAmount = totalItemInvoiceAmount.add(subItem.getBigDecimal("confirmoriitemamount"));
                totalItemTax = totalItemTax.add(subItem.getBigDecimal("confirmoriitemtax"));
                String infoCode = subItem.getString("confirminfocode");
                if (!StringUtils.isNotBlank((CharSequence)infoCode)) continue;
                redConfirmNumSet.add(infoCode);
            }
            BigDecimal itemAmount = parentRow.getBigDecimal("amount");
            BigDecimal itemTax = parentRow.getBigDecimal("tax");
            matchInvoiceAmount = matchInvoiceAmount.add(totalItemInvoiceAmount);
            matchTotalTax = matchTotalTax.add(totalItemTax);
            if (itemAmount.compareTo(totalItemInvoiceAmount) == 0 && itemTax.compareTo(totalItemTax) == 0) {
                parentRow.set("itemmatchstatus", (Object)MatchBillConstant.MatchStatusEnum.MATCH_SUCCESS.getCode());
                continue;
            }
            if (BigDecimalUtil.lessZero((BigDecimal)totalItemInvoiceAmount)) {
                parentRow.set("itemmatchstatus", (Object)MatchBillConstant.MatchStatusEnum.MATCH_PART_SUCCESS.getCode());
                continue;
            }
            parentRow.set("itemmatchstatus", (Object)MatchBillConstant.MatchStatusEnum.MATCH_FAIL.getCode());
        }
        BigDecimal applyAmount = matchBillObj.getBigDecimal("applyamount");
        BigDecimal applyTax = matchBillObj.getBigDecimal("applytax");
        if (applyAmount.compareTo(matchInvoiceAmount) == 0 && applyTax.compareTo(matchTotalTax) == 0) {
            this.getModel().setValue("matchstatus", (Object)MatchBillConstant.MatchStatusEnum.MATCH_SUCCESS.getCode());
        } else if (BigDecimalUtil.lessZero((BigDecimal)matchInvoiceAmount)) {
            this.getModel().setValue("matchstatus", (Object)MatchBillConstant.MatchStatusEnum.MATCH_PART_SUCCESS.getCode());
        } else {
            this.getModel().setValue("matchstatus", (Object)MatchBillConstant.MatchStatusEnum.MATCH_FAIL.getCode());
        }
        this.getModel().setValue("matchamount", (Object)matchInvoiceAmount);
        this.getModel().setValue("matchtax", (Object)matchTotalTax);
        this.getModel().setValue("matchtotalamount", (Object)matchTotalTax.add(matchInvoiceAmount));
        this.getModel().setValue("matchinvoicenum", (Object)redConfirmNumSet.size());
        this.updateRedConfirmMatchFields();
    }

    private Object getOrgId() {
        Object orgId = this.getModel().getValue("org");
        orgId = orgId == null ? RequestContext.get().getOrgId() : DynamicObjectUtil.getDynamicObjectLongValue((Object)orgId);
        return orgId;
    }

    public void click(EventObject evt) {
        String key;
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "oriinvoiceno": {
                this.clickOriInvoiceNo();
                break;
            }
            case "saleraddr": {
                QFilter qFilter = new QFilter("taxno", "=", this.getModel().getValue("salertaxno"));
                ViewUtil.openListPage((AbstractFormPlugin)this, (QFilter)qFilter, (String)"sim_invoice_setting", (String)"close_call_back_seller_bank_addr");
                break;
            }
            case "buyeraddr": {
                Object orgId = this.getOrgId();
                HashMap<String, Object> customParams = new HashMap<String, Object>();
                customParams.put("orgId", orgId);
                customParams.put("name", this.getModel().getValue("buyername"));
                ViewUtil.openDialog((AbstractFormPlugin)this, (String)ResManager.loadKDString((String)"\u8d2d\u65b9\u62ac\u5934\u4fe1\u606f\u5217\u8868", (String)"BillMatchDetailPlugin_21", (String)"imc-sim-formplugin", (Object[])new Object[0]), customParams, (String)"bdm_invice_title_adr_ctr", (String)"close_call_back_buyer_bank_addr");
                break;
            }
            case "confirminfocode": {
                this.clickRedConirmNumber();
                break;
            }
        }
    }

    private void clickRedConirmNumber() {
        String buyerTaxNo;
        BigDecimal remainAmount = this.calculateRemainAmount();
        QFilter occupyFilter = new QFilter("occupystatus", "!=", (Object)"1");
        QFilter amountFilter = new QFilter("invoiceamount", ">=", (Object)remainAmount);
        ArrayList<QFilter> filters = new ArrayList<QFilter>(4);
        filters.add(amountFilter);
        String buyerName = (String)this.getModel().getValue("buyername");
        if (StringUtils.isNotBlank((CharSequence)buyerName)) {
            filters.add(new QFilter("buyername", "=", (Object)buyerName));
        }
        if (StringUtils.isNotBlank((CharSequence)(buyerTaxNo = (String)this.getModel().getValue("buyertaxno")))) {
            filters.add(new QFilter("buyertaxno", "=", (Object)buyerTaxNo));
        }
        Object salerTaxNo = this.getModel().getValue("salertaxno");
        filters.add(new QFilter("salertaxno", "=", salerTaxNo));
        String invoiceType = (String)this.getModel().getValue("invoicetype");
        if (InvoiceUtils.isNormalInvoice((String)invoiceType) || InvoiceType.ALL_E_NORMAL.getTypeCode().equals(invoiceType)) {
            filters.add(new QFilter("invoicetype", "=", (Object)InvoiceType.ALL_E_NORMAL.getTypeCode()));
        } else {
            filters.add(new QFilter("invoicetype", "=", (Object)InvoiceType.ALL_E_SPECIAL.getTypeCode()));
        }
        for (QFilter filter : filters) {
            occupyFilter.and(filter);
        }
        ViewUtil.openListPage((AbstractFormPlugin)this, (QFilter)occupyFilter, (String)"sim_choose_redconfirm", (String)"confirmsubentryentity");
    }

    private BigDecimal calculateRemainAmount() {
        DynamicObject billObj = this.getModel().getDataEntity(true);
        BigDecimal matchAmount = billObj.getBigDecimal("matchamount");
        DynamicObjectCollection parentRowObjs = billObj.getDynamicObjectCollection("sim_original_bill_item");
        BigDecimal invoiceAmount = BigDecimal.ZERO;
        BigDecimal totalTax = BigDecimal.ZERO;
        for (DynamicObject parentRowObj : parentRowObjs) {
            DynamicObjectCollection subCollection = parentRowObj.getDynamicObjectCollection("confirmsubentryentity");
            for (DynamicObject subRow : subCollection) {
                invoiceAmount = invoiceAmount.add(subRow.getBigDecimal("confirmoriitemamount"));
                totalTax = totalTax.add(subRow.getBigDecimal("confirmoriitemtax"));
            }
        }
        BigDecimal applyAmount = billObj.getBigDecimal("applyamount");
        BigDecimal applyTax = billObj.getBigDecimal("applytax");
        return applyAmount.subtract(matchAmount);
    }

    private void clickOriInvoiceNo() {
        DynamicObject matchRule;
        SubEntryGrid subEntryGrid = (SubEntryGrid)this.getControl("subentryentity");
        Object pushStatus = this.getModel().getValue("pushstatus", subEntryGrid.getSelectRows()[0]);
        if ("1".equals(pushStatus)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u4e0b\u63a8\u7684\u4e0d\u5141\u8bb8\u7f16\u8f91 \u3002", (String)"BillMatchDetailPlugin_3", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            return;
        }
        int selectRow = this.getBillItemSelectRow();
        int index = selectRow + 1;
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        BigDecimal itemAmount = (BigDecimal)model.getValue("amount", selectRow);
        BigDecimal itemTax = (BigDecimal)model.getValue("tax", selectRow);
        if (StringUtils.isEmpty((CharSequence)(model.getValue("goodscode", selectRow) + ""))) {
            view.showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u8d1f\u6570\u5355\u636e\u660e\u7ec6\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (String)"BillMatchDetailPlugin_13", (String)"imc-sim-formplugin", (Object[])new Object[0]), index));
            return;
        }
        if (StringUtils.isEmpty((CharSequence)(model.getValue("goodsname", selectRow) + ""))) {
            view.showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u8d1f\u6570\u5355\u636e\u660e\u7ec6\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (String)"BillMatchDetailPlugin_13", (String)"imc-sim-formplugin", (Object[])new Object[0]), index));
            return;
        }
        if (StringUtils.isEmpty((CharSequence)(model.getValue("taxrate", selectRow) + ""))) {
            view.showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u8d1f\u6570\u5355\u636e\u660e\u7ec6\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a", (String)"BillMatchDetailPlugin_14", (String)"imc-sim-formplugin", (Object[])new Object[0]), index));
            return;
        }
        if (MathUtils.isZero((BigDecimal)itemAmount)) {
            view.showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u8d1f\u6570\u5355\u636e\u660e\u7ec6\u91d1\u989d\u4e0d\u80fd\u4e3a0", (String)"BillMatchDetailPlugin_15", (String)"imc-sim-formplugin", (Object[])new Object[0]), index));
            return;
        }
        if (!MathUtils.bigDecimalIsNegativeValue((BigDecimal)itemAmount)) {
            view.showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u8d1f\u6570\u5355\u636e\u660e\u7ec6\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e0", (String)"BillMatchDetailPlugin_16", (String)"imc-sim-formplugin", (Object[])new Object[0]), index));
            return;
        }
        if (!MathUtils.bigDecimalIsNegativeValue((BigDecimal)itemTax)) {
            view.showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u8d1f\u6570\u5355\u636e\u660e\u7ec6\u7a0e\u989d\u4e0d\u80fd\u5927\u4e8e0", (String)"BillMatchDetailPlugin_17", (String)"imc-sim-formplugin", (Object[])new Object[0]), index));
            return;
        }
        QFilter qFilter = new QFilter("salertaxno", "=", model.getValue("salertaxno"));
        String buyerTaxNo = (String)model.getValue("buyertaxno");
        if (StringUtils.isNotBlank((CharSequence)buyerTaxNo)) {
            qFilter.and("buyertaxno", "=", (Object)buyerTaxNo);
        } else {
            qFilter.and("buyername", "=", model.getValue("buyername"));
        }
        qFilter.and("invoicestatus", "in", (Object)InvoiceStatus.NormalStatusArray);
        qFilter.and("issuetype", "=", (Object)IssueType.BLUE_INVOICE.getTypeCode());
        String invoiceType = (String)this.getModel().getValue("invoicetype");
        ArrayList<String> invoiceTypes = new ArrayList<String>();
        invoiceTypes.add(invoiceType);
        if (InvoiceUtils.isAllEInvoice((Object)invoiceType) && (matchRule = (DynamicObject)model.getValue("matchrule")) != null && (matchRule = BusinessDataServiceHelper.loadSingle((String)"bdm_match_ori_inv_setting", (String)"canredtaxcontrol", (QFilter[])new QFilter("id", "=", matchRule.getPkValue()).toArray())) != null && matchRule.getBoolean("canredtaxcontrol")) {
            if (InvoiceType.ALL_E_NORMAL.getTypeCode().equals(invoiceType)) {
                invoiceTypes.addAll(InvoiceUtils.getNormalInvoiceType());
            } else {
                invoiceTypes.addAll(InvoiceUtils.getSpecialInvoiceType());
            }
        }
        qFilter.and("invoicetype", "in", invoiceTypes);
        qFilter.and("occupystatus", "!=", (Object)"1");
        qFilter.and("items.taxrate", "=", model.getValue("taxrate", selectRow));
        ViewUtil.openListPage((AbstractFormPlugin)this, (QFilter)qFilter, (String)"sim_choose_vatinvoice", (String)"oriinvoiceno");
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Object returnData = event.getReturnData();
        if (returnData == null) {
            return;
        }
        switch (event.getActionId()) {
            case "oriinvoiceno": {
                this.jumpChooseBlueItemPage((ListSelectedRowCollection)returnData);
                break;
            }
            case "sim_choose_invoice_item": {
                this.closeCallbackChooseBlueItem((JSONObject)returnData);
                break;
            }
            case "close_call_back_seller_bank_addr": {
                CreateInvoiceViewCloseCallBackControl.handleChooseSaleAddress((ClosedCallBackEvent)event, (IFormView)this.getView());
                break;
            }
            case "close_call_back_buyer_bank_addr": {
                this.closeCallBackBuyerAddr(event);
                break;
            }
            case "confirmsubentryentity": {
                this.checkRedConfirm((ListSelectedRowCollection)returnData);
                break;
            }
        }
    }

    private void checkRedConfirm(ListSelectedRowCollection returnData) {
        Object[] redConfirmPks = returnData.getPrimaryKeyValues();
        DynamicObject[] redConfirm = BusinessDataServiceHelper.load((String)"sim_red_confirm_bill", (String)"id,number,redreason,occupystatus,totalamount,invoiceamount,buyertaxno,totaltax,invoicetype,specialtype,originalinvoicecode,originalinvoiceno,originalinvoicetype,items.goodsname,items.simplegoodsname,items.specification,items.unit,items.num,items.unitprice,items.taxunitprice,items.amount,items.taxamount,items.taxrate,items.tax,items.goodscode,items.originseq,items.seq,items.zzstsgl", (QFilter[])new QFilter("id", "in", (Object)redConfirmPks).toArray());
        RedConfirmMatchHelper redConfirmMatchHelper = new RedConfirmMatchHelper();
        DynamicObject matchBill = this.getModel().getDataEntity(true);
        CheckRedConfirmDTO checkRedConfirmDTO = redConfirmMatchHelper.checkRedConfirmCanUsedByMatchBill(matchBill, redConfirm[0]);
        if (!checkRedConfirmDTO.isCanUsed()) {
            throw new KDBizException(checkRedConfirmDTO.getErrorMsg());
        }
        MatchRedConfirmBillDTO result = checkRedConfirmDTO.getResult();
        this.resetView(result);
    }

    private void resetView(MatchRedConfirmBillDTO result) {
        Map<Long, List> itemPkSubItemsMap = result.getItems().stream().collect(Collectors.toMap(o -> o.getMatchOrMergeItemId(), o -> o.getMatchResult()));
        DynamicObject matchBillObj = this.getModel().getDataEntity(true);
        BigDecimal matchInvoiceAmount = BigDecimal.ZERO;
        BigDecimal matchTotalTax = BigDecimal.ZERO;
        DynamicObjectCollection parentRowObjs = matchBillObj.getDynamicObjectCollection("sim_original_bill_item");
        for (int i = 0; i < parentRowObjs.size(); ++i) {
            DynamicObject parentRow = (DynamicObject)parentRowObjs.get(i);
            long parentRowPk = parentRow.getLong("id");
            List redConfirmInfos = itemPkSubItemsMap.get(parentRowPk);
            if (null == redConfirmInfos) continue;
            for (MatchRedConfirmResultDTO redConfirmInfo : redConfirmInfos) {
                if (!redConfirmInfo.isNewMatchInfo()) continue;
                this.createSubEntity(i, parentRow, redConfirmInfo);
            }
            DynamicObjectCollection subItems = parentRow.getDynamicObjectCollection("confirmsubentryentity");
            BigDecimal totalItemInvoiceAmount = BigDecimal.ZERO;
            BigDecimal totalItemTax = BigDecimal.ZERO;
            for (DynamicObject subItem : subItems) {
                totalItemInvoiceAmount = totalItemInvoiceAmount.add(subItem.getBigDecimal("confirmoriitemamount"));
                totalItemTax = totalItemTax.add(subItem.getBigDecimal("confirmoriitemtax"));
            }
            BigDecimal itemAmount = parentRow.getBigDecimal("amount");
            BigDecimal itemTax = parentRow.getBigDecimal("tax");
            matchInvoiceAmount = matchInvoiceAmount.add(totalItemInvoiceAmount);
            matchTotalTax = matchTotalTax.add(totalItemTax);
            if (itemAmount.compareTo(totalItemInvoiceAmount) == 0 && itemTax.compareTo(totalItemTax) == 0) {
                parentRow.set("itemmatchstatus", (Object)MatchBillConstant.MatchStatusEnum.MATCH_SUCCESS.getCode());
                continue;
            }
            if (BigDecimalUtil.lessZero((BigDecimal)totalItemInvoiceAmount)) {
                parentRow.set("itemmatchstatus", (Object)MatchBillConstant.MatchStatusEnum.MATCH_PART_SUCCESS.getCode());
                continue;
            }
            parentRow.set("itemmatchstatus", (Object)MatchBillConstant.MatchStatusEnum.MATCH_FAIL.getCode());
        }
        BigDecimal applyAmount = matchBillObj.getBigDecimal("applyamount");
        BigDecimal applyTax = matchBillObj.getBigDecimal("applytax");
        if (applyAmount.compareTo(matchInvoiceAmount) == 0 && applyTax.compareTo(matchTotalTax) == 0) {
            this.getModel().setValue("matchstatus", (Object)MatchBillConstant.MatchStatusEnum.MATCH_SUCCESS.getCode());
        } else if (BigDecimalUtil.lessZero((BigDecimal)matchInvoiceAmount)) {
            this.getModel().setValue("matchstatus", (Object)MatchBillConstant.MatchStatusEnum.MATCH_PART_SUCCESS.getCode());
        } else {
            this.getModel().setValue("matchstatus", (Object)MatchBillConstant.MatchStatusEnum.MATCH_FAIL.getCode());
        }
        HashSet<String> redConfirmNumSet = new HashSet<String>();
        for (MatchRedConfirmBillItemDTO item : result.getItems()) {
            List matchResult = item.getMatchResult();
            if (null == matchResult) continue;
            for (MatchRedConfirmResultDTO resultDTO : matchResult) {
                redConfirmNumSet.add(resultDTO.getInfocode());
            }
        }
        this.getModel().setValue("matchamount", (Object)matchInvoiceAmount);
        this.getModel().setValue("matchtax", (Object)matchTotalTax);
        this.getModel().setValue("matchtotalamount", (Object)matchTotalTax.add(matchInvoiceAmount));
        this.getModel().setValue("matchinvoicenum", (Object)redConfirmNumSet.size());
        this.getModel().setValue("matchtype", (Object)"0");
        this.getModel().setValue("matchtime", (Object)new Date());
        this.updateRedConfirmMatchFields();
    }

    private void updateRedConfirmMatchFields() {
        this.getView().updateView("confirmsubentryentity");
        this.getView().updateView("sim_original_bill_item");
        this.getView().updateView("matchstatus");
        this.getView().updateView("matchtype");
        this.getView().updateView("matchamount");
        this.getView().updateView("matchtax");
        this.getView().updateView("matchtotalamount");
        this.getView().updateView("matchtype");
        this.getView().updateView("matchinvoicenum");
    }

    private void createSubEntity(int parentRowIndex, DynamicObject parentDyn, MatchRedConfirmResultDTO redConfirmInfo) {
        IDataModel entryOperate = this.getModel();
        entryOperate.setEntryCurrentRowIndex("sim_original_bill_item", parentRowIndex);
        int subRow = entryOperate.createNewEntryRow("confirmsubentryentity");
        this.getModel().setValue("confirminfocode", (Object)redConfirmInfo.getInfocode(), subRow, parentRowIndex);
        this.getModel().setValue("confirmoriinvoicecode", (Object)redConfirmInfo.getBlueInvoiceCode(), subRow, parentRowIndex);
        this.getModel().setValue("confirmoriinvoiceno", (Object)redConfirmInfo.getBlueInvoiceNo(), subRow, parentRowIndex);
        this.getModel().setValue("confirmoriitemseq", (Object)redConfirmInfo.getConfirmOriItemSeq(), subRow, parentRowIndex);
        this.getModel().setValue("confirmoriitemamount", (Object)redConfirmInfo.getOriItemAmount(), subRow, parentRowIndex);
        this.getModel().setValue("confirmoriitemtax", (Object)redConfirmInfo.getOriItemTax(), subRow, parentRowIndex);
        this.getModel().setValue("confirmoritaxrate", (Object)redConfirmInfo.getOriTaxRate(), subRow, parentRowIndex);
        this.getModel().setValue("confirmoriitemnum", (Object)redConfirmInfo.getOriItemNum(), subRow, parentRowIndex);
        this.getModel().setValue("confirmoriitemunitprice", (Object)redConfirmInfo.getOriItemUnitprice(), subRow, parentRowIndex);
        this.getModel().setValue("confiroriitemtaxunitprice", (Object)redConfirmInfo.getOriItemTaxUnitprice(), subRow, parentRowIndex);
        this.getModel().setValue("confirmoriitemgoodsname", (Object)redConfirmInfo.getOriitemGoodsName(), subRow, parentRowIndex);
        this.getModel().setValue("conforiitemspecification", (Object)redConfirmInfo.getOriItemSpecification(), subRow, parentRowIndex);
        this.getModel().setValue("confirmoriitemunit", (Object)redConfirmInfo.getOriItemUnit(), subRow, parentRowIndex);
        this.getModel().setValue("redconfirmpk", (Object)redConfirmInfo.getRedConfirmPk(), subRow, parentRowIndex);
        this.getModel().setValue("redconfirmitempk", (Object)redConfirmInfo.getRedConfirmItemPk(), subRow, parentRowIndex);
        this.getModel().setValue("confirmissuestatus", (Object)"2", subRow, parentRowIndex);
    }

    private void jumpChooseBlueItemPage(ListSelectedRowCollection returnData) {
        Long fid = (Long)returnData.getPrimaryKeyValues()[0];
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put("blueInvoiceFid", fid);
        customParams.put("taxRate", this.getModel().getValue("taxrate", this.getBillItemSelectRow()));
        ViewUtil.openDialog((AbstractFormPlugin)this, (String)ResManager.loadKDString((String)"\u9009\u62e9\u84dd\u7968\u660e\u7ec6", (String)"BillMatchDetailPlugin_22", (String)"imc-sim-formplugin", (Object[])new Object[0]), customParams, (String)"sim_choose_invoice_item", (String)"sim_choose_invoice_item");
    }

    private int getBillItemSelectRow() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("sim_original_bill_item");
        int selectRow = 0;
        if (entryGrid.getSelectRows().length > 0) {
            selectRow = entryGrid.getSelectRows()[0];
        }
        return selectRow;
    }

    private void closeCallbackChooseBlueItem(JSONObject json) {
        int billItemSelectRow = this.getBillItemSelectRow();
        BigDecimal itemAmount = (BigDecimal)this.getModel().getValue("amount", billItemSelectRow);
        BigDecimal itemTax = (BigDecimal)this.getModel().getValue("tax", billItemSelectRow);
        SubEntryGrid subEntryGrid = (SubEntryGrid)this.getControl("subentryentity");
        int selectRow = subEntryGrid.getSelectRows()[0];
        DynamicObject[] dataEntitys = subEntryGrid.getEntryData().getDataEntitys();
        BigDecimal totalOriItemAmount = BigDecimal.ZERO;
        BigDecimal totalOriItemTax = BigDecimal.ZERO;
        for (int i = 0; i < dataEntitys.length; ++i) {
            if (selectRow == i) continue;
            DynamicObject dataEntity = dataEntitys[i];
            totalOriItemAmount = totalOriItemAmount.add(dataEntity.getBigDecimal("oriitemamount"));
            totalOriItemTax = totalOriItemTax.add(dataEntity.getBigDecimal("oriitemtax"));
        }
        BigDecimal oriItemRemainAmount = itemAmount.abs().subtract(totalOriItemAmount);
        BigDecimal oriItemRemainTax = itemTax.abs().subtract(totalOriItemTax);
        BigDecimal totalMatchAmount = BigDecimal.ZERO;
        BigDecimal totalMatchTax = BigDecimal.ZERO;
        BigDecimal remainRedAmount = json.getBigDecimal("itemremainredamount");
        BigDecimal remainRedTax = json.getBigDecimal("itemremainredtax");
        DynamicObject matchBill = this.getModel().getDataEntity(true);
        DynamicObjectCollection mergeItems = matchBill.getDynamicObjectCollection("sim_original_bill_item");
        for (int i = 0; i < mergeItems.size(); ++i) {
            DynamicObject mergeItem = (DynamicObject)mergeItems.get(i);
            DynamicObjectCollection subItems = mergeItem.getDynamicObjectCollection("subentryentity");
            for (int j = 0; j < subItems.size(); ++j) {
                DynamicObject subItem = (DynamicObject)subItems.get(j);
                if (i == billItemSelectRow && j == selectRow || subItem.getLong("oriinvoiceid") != json.getLong("oriinvoiceid").longValue() || subItem.getLong("oriitemid") != json.getLong("oriitemid").longValue()) continue;
                remainRedAmount = remainRedAmount.subtract(subItem.getBigDecimal("oriitemamount"));
                remainRedTax = remainRedTax.subtract(subItem.getBigDecimal("oriitemtax"));
                totalMatchAmount = totalMatchAmount.add(subItem.getBigDecimal("oriitemamount"));
                totalMatchTax = totalMatchTax.add(subItem.getBigDecimal("oriitemtax"));
            }
        }
        if (remainRedAmount.compareTo(BigDecimal.ZERO) <= 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u53d1\u7968\u5df2\u5168\u90e8\u5339\u914d\u5b8c\uff0c\u65e0\u6cd5\u9009\u62e9", (String)"BillMatchDetailPlugin_12", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            return;
        }
        IDataModel model = this.getModel();
        model.setValue("oriinvoiceid", json.get((Object)"oriinvoiceid"), selectRow);
        model.setValue("oriitemid", json.get((Object)"oriitemid"), selectRow);
        model.setValue("oriitemseq", json.get((Object)"oriitemseq"), selectRow);
        model.setValue("oriinvoicecode", json.get((Object)"invoicecode"), selectRow);
        model.setValue("oriinvoiceno", json.get((Object)"invoiceno"), selectRow);
        model.setValue("oriitemunitprice", json.get((Object)"unitprice"), selectRow);
        model.setValue("oritaxrate", json.get((Object)"taxrate"), selectRow);
        model.setValue("oriitemtaxunitprice", json.get((Object)"taxunitprice"), selectRow);
        model.setValue("oriitemgoodsname", json.get((Object)"goodsname"), selectRow);
        model.setValue("oriitemspecification", json.get((Object)"specification"), selectRow);
        model.setValue("oriitemunit", json.get((Object)"unit"), selectRow);
        model.setValue("matchamount", (Object)totalMatchAmount.negate());
        model.setValue("matchtax", (Object)totalMatchTax.negate());
        model.setValue("matchtotalamount", (Object)totalMatchAmount.add(totalMatchTax).negate());
        model.setValue("matchtype", (Object)"0");
        boolean isAllMatch = false;
        BigDecimal amount = remainRedAmount;
        BigDecimal tax = remainRedTax;
        if (oriItemRemainAmount.compareTo(remainRedAmount) <= 0) {
            amount = oriItemRemainAmount.abs();
            tax = oriItemRemainTax.abs();
            isAllMatch = true;
        }
        model.setValue("oriitemamount", (Object)amount, selectRow);
        model.setValue("oriitemtax", (Object)tax, selectRow);
        BigDecimal num = json.getBigDecimal("itemremainrednum") == null ? BigDecimal.ZERO : json.getBigDecimal("itemremainrednum");
        BigDecimal unitPrice = json.getBigDecimal("unitprice");
        if (!MathUtils.isNullOrZero((BigDecimal)unitPrice) && num.abs().multiply(unitPrice).setScale(2, 4).compareTo(amount) != 0) {
            num = UnitPriceHelper.calcNum((BigDecimal)amount, (BigDecimal)unitPrice);
        }
        model.setValue("oriitemnum", (Object)num, selectRow);
        model.setValue("itemmatchstatus", (Object)(isAllMatch ? MatchBillConstant.MatchStatusEnum.MATCH_SUCCESS.getCode() : MatchBillConstant.MatchStatusEnum.MATCH_PART_SUCCESS.getCode()), billItemSelectRow);
        if (!isAllMatch) {
            model.setValue("matchstatus", (Object)MatchBillConstant.MatchStatusEnum.MATCH_PART_SUCCESS.getCode());
            return;
        }
        for (int i = 0; i < mergeItems.size(); ++i) {
            if (billItemSelectRow == i) continue;
            DynamicObject mergeItem = (DynamicObject)mergeItems.get(i);
            isAllMatch = isAllMatch && MatchBillConstant.MatchStatusEnum.MATCH_SUCCESS.getCode().equals(mergeItem.getString("itemmatchstatus"));
        }
        if (isAllMatch) {
            model.setValue("matchstatus", (Object)MatchBillConstant.MatchStatusEnum.MATCH_SUCCESS.getCode());
        } else {
            model.setValue("matchstatus", (Object)MatchBillConstant.MatchStatusEnum.MATCH_PART_SUCCESS.getCode());
        }
    }

    private void closeCallBackBuyerAddr(ClosedCallBackEvent event) {
        Map customParams = (Map)event.getReturnData();
        if (customParams != null) {
            this.getModel().setValue("buyeraddr", customParams.get("buyeraddr"));
            this.getModel().setValue("buyerbank", customParams.get("buyerbank"));
            String email = (String)this.getModel().getValue("buyeremail");
            String phone = (String)this.getModel().getValue("buyerphone");
            if (StringUtils.isEmpty((CharSequence)email) && StringUtils.isEmpty((CharSequence)phone)) {
                this.getModel().setValue("buyeremail", customParams.get("buyeremail"));
                this.getModel().setValue("buyerphone", customParams.get("buyerphone"));
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (MessageBoxResult.Cancel.equals((Object)messageBoxClosedEvent.getResult())) {
            return;
        }
        if ("red".equals(messageBoxClosedEvent.getCallBackId())) {
            new NegativeBillMatchControl().redConfirmCallBack(this, messageBoxClosedEvent, new Object[]{this.getModel().getDataEntity().getPkValue()});
        }
    }
}

