/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.matchbill;

import com.alibaba.fastjson.JSONArray;
import java.math.BigDecimal;
import java.util.EventObject;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.helper.ImcBaseDataHelper;
import kd.imc.bdm.common.util.DynamicObjectUtil;

public class NegativeBillMatchDialogPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        JSONArray jsonArray = (JSONArray)this.getView().getFormShowParameter().getCustomParam("pks");
        if (Objects.isNull(jsonArray)) {
            return;
        }
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)"sim_original_bill", (String)String.join((CharSequence)",", "orgid", "invoiceamount", "totaltax"), (QFilter[])new QFilter("id", "in", (Object)jsonArray.toArray()).toArray());
        BigDecimal amountSum = BigDecimal.ZERO;
        BigDecimal taxSum = BigDecimal.ZERO;
        for (DynamicObject bill : bills) {
            amountSum = amountSum.add(bill.getBigDecimal("invoiceamount"));
            taxSum = taxSum.add(bill.getBigDecimal("totaltax"));
        }
        QFilter filter = ImcBaseDataHelper.getBillMatchSettingFilter((Object)bills[0].get("orgid"));
        DynamicObject matchSetting = BusinessDataServiceHelper.loadSingle((String)"bdm_match_ori_inv_setting", (String)"", (QFilter[])filter.toArray());
        if (matchSetting != null) {
            this.getModel().setValue("matchrule", (Object)matchSetting);
        }
        Label tipLabel = (Label)this.getControl("tiplabel");
        tipLabel.setText(String.format(ResManager.loadKDString((String)"\u672c\u6b21\u5f85\u5904\u7406\u5355\u636e%1$s\u6761\uff0c\u4ef7\u7a0e\u5408\u8ba1%2$s\u5143\uff0c\u7a0e\u989d%3$s\u5143\u3002\u662f\u5426\u7ee7\u7eed\u5339\u914d\uff1f", (String)"NegativeBillMatchDialogPlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]), bills.length, amountSum.setScale(2, 4), taxSum.setScale(2, 4)));
        this.getModel().setValue("orgid", bills[0].get("orgid"));
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        if ("btnok".equals(control.getKey())) {
            DynamicObject matchrule = (DynamicObject)this.getModel().getValue("matchrule");
            DynamicObject matchRedConfirmRule = (DynamicObject)this.getModel().getValue("matchconfirmrule");
            if (matchrule == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5339\u914d\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a", (String)"NegativeBillMatchDialogPlugin_1", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                return;
            }
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            customParams.put("ismergebill", this.getModel().getValue("ismergebill"));
            if (null != this.getModel().getValue("matchconfirmrule")) {
                customParams.put("matchconfig", matchRedConfirmRule.getPkValue());
            }
            customParams.put("ismergebilldetail", this.getModel().getValue("ismergebilldetail"));
            customParams.put("redreason", this.getModel().getValue("redreason"));
            customParams.put("matchrule", matchrule.getPkValue());
            customParams.put("orgid", DynamicObjectUtil.getDynamicObjectLongValue((Object)this.getModel().getValue("orgid")));
            this.getView().returnDataToParent((Object)customParams);
            this.getView().close();
        }
    }
}

