/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.matchbill.op;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.OrgHelper;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.sim.formplugin.bill.matchbill.op.MatchBillRevokeOpPlugin;
import kd.imc.sim.formplugin.bill.originalbill.workbench.alleevent.AllEBillProcessNegativeTabCustomEvent;
import kd.imc.sim.formplugin.match.MinusBillMatchHelper;

public class BillMatchDetailSaveOpPlugin
extends AbstractOperationServicePlugIn {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] matchBills = e.getDataEntities();
        ArrayList<Long> matchRedConfirmPks = new ArrayList<Long>();
        for (DynamicObject matchBill : matchBills) {
            String matchTarget = matchBill.getString("matchtarget");
            if (!"1".equals(matchTarget) && !"2".equals(matchTarget)) continue;
            matchRedConfirmPks.add(matchBill.getLong("id"));
        }
        DynamicObject[] dbMatchBills = BusinessDataServiceHelper.load((Object[])matchRedConfirmPks.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_match_bill"));
        ArrayList<Long> dbRedConfirmPks = new ArrayList<Long>();
        for (DynamicObject dynamicObject : dbMatchBills) {
            DynamicObjectCollection items = dynamicObject.getDynamicObjectCollection("sim_original_bill_item");
            for (DynamicObject item : items) {
                DynamicObjectCollection redConfirms = item.getDynamicObjectCollection("confirmsubentryentity");
                for (DynamicObject redConfirm : redConfirms) {
                    dbRedConfirmPks.add(redConfirm.getLong("redconfirmpk"));
                }
            }
        }
        matchRedConfirmPks.stream().filter(o -> !dbRedConfirmPks.contains(o)).collect(Collectors.toSet());
        String salerTaxNo = matchBills[0].getString("salertaxno");
        String lockKey = salerTaxNo + "RedConfirmMatchHelperMatch";
        if (matchRedConfirmPks.size() > 0) {
            if (StringUtils.isNotBlank((CharSequence)CacheHelper.get((String)lockKey))) {
                e.setCancelOperation(true);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7a0e\u53f7:%s\u6709\u5176\u4ed6\u5339\u914d\u5355\u5728\u4fdd\u5b58\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"BillMatchDetailSaveOpPlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]), salerTaxNo));
            }
            Throwable throwable = null;
            try (DLock lock = DLock.create((String)lockKey);){
                if (!lock.tryLock(500L)) {
                    e.setCancelOperation(true);
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7a0e\u53f7:%s\u6709\u5176\u4ed6\u5339\u914d\u5355\u5728\u4fdd\u5b58\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"BillMatchDetailSaveOpPlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]), salerTaxNo));
                }
                DynamicObject[] redConfirms = BusinessDataServiceHelper.load((String)"sim_red_confirm_bill", (String)"occupystatus,number", (QFilter[])new QFilter("id", "in", matchRedConfirmPks).and("occupystatus", "=", (Object)"1").toArray());
                if (redConfirms.length > 0) {
                    e.setCancelOperation(true);
                    StringBuilder builder = new StringBuilder();
                    Arrays.stream(redConfirms).forEach(o -> builder.append('[').append(o.getString("number")).append(']'));
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u786e\u8ba4\u5355:%s\u5df2\u88ab\u5360\u7528\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u786e\u8ba4\u5355", (String)"BillMatchDetailSaveOpPlugin_1", (String)"imc-sim-formplugin", (Object[])new Object[0]), builder.toString()));
                }
                CacheHelper.put((String)lockKey, (String)lockKey, (int)60);
            }
            catch (Throwable redConfirms) {
                Throwable throwable2 = redConfirms;
                throw redConfirms;
            }
        }
        try {
            DynamicObject[] billRelations = BusinessDataServiceHelper.load((String)"sim_matchbill_relation", (String)String.join((CharSequence)",", "sbillid", "tbillid"), (QFilter[])OrgHelper.getIdFilter((Collection)Arrays.stream(matchBills).map(DataEntityBase::getPkValue).collect(Collectors.toSet()), (String)"tbillid").toArray());
            HashMap<Object, Set> hashMap = new HashMap<Object, Set>(billRelations.length);
            for (DynamicObject billRelation : billRelations) {
                Set sBillIdSet = hashMap.computeIfAbsent(billRelation.get("tbillid"), k -> new HashSet());
                sBillIdSet.add(billRelation.get("sbillid"));
            }
            DynamicObject[] bills = BusinessDataServiceHelper.load((String)"sim_original_bill", (String)String.join((CharSequence)",", "matchstatus", "comprehensivestatus"), (QFilter[])OrgHelper.getIdFilter((Collection)Arrays.stream(billRelations).map(relation -> relation.getLong("sbillid")).collect(Collectors.toSet())).toArray());
            HashMap<Object, DynamicObject> billMap = new HashMap<Object, DynamicObject>(bills.length);
            for (DynamicObject bill : bills) {
                billMap.put(bill.getPkValue(), bill);
            }
            AllEBillProcessNegativeTabCustomEvent negativeTabCustomEvent = new AllEBillProcessNegativeTabCustomEvent();
            for (DynamicObject matchBill : matchBills) {
                Set relations = (Set)hashMap.get(matchBill.getPkValue());
                for (Object e2 : relations) {
                    DynamicObject bill = (DynamicObject)billMap.get(e2);
                    bill.set("matchstatus", matchBill.get("matchstatus"));
                    negativeTabCustomEvent.setComprehensiveStatusByMatchStatus(bill, matchBill);
                }
            }
            ImcSaveServiceHelper.update((DynamicObject[])bills);
            DynamicObjectCollection beforeMatchBills = QueryServiceHelper.query((String)"sim_match_bill", (String)"matchtarget,sim_original_bill_item.subentryentity.oriinvoiceid,sim_original_bill_item.confirmsubentryentity.redconfirmpk", (QFilter[])new QFilter("id", "in", (Object)Arrays.stream(matchBills).map(DataEntityBase::getPkValue).toArray()).toArray());
            HashSet<Long> beforeOriInvoiceIdSet = new HashSet<Long>(beforeMatchBills.size());
            HashSet<Long> beforeRedConfirmIdSet = new HashSet<Long>(beforeMatchBills.size());
            for (DynamicObject beforeMatchBill : beforeMatchBills) {
                String matchTarget = beforeMatchBill.getString("matchtarget");
                if ("1".equals(matchTarget) || "2".equals(matchTarget)) {
                    beforeRedConfirmIdSet.add(beforeMatchBill.getLong("sim_original_bill_item.confirmsubentryentity.redconfirmpk"));
                    continue;
                }
                beforeOriInvoiceIdSet.add(beforeMatchBill.getLong("sim_original_bill_item.subentryentity.oriinvoiceid"));
            }
            HashSet<Long> afterOriInvoiceIdSet = new HashSet<Long>(beforeMatchBills.size());
            HashSet<Long> afterRedConfirmIdSet = new HashSet<Long>(beforeMatchBills.size());
            MatchBillRevokeOpPlugin matchBillRevokeOpPlugin = new MatchBillRevokeOpPlugin();
            for (DynamicObject dynamicObject : matchBills) {
                String matchTarget = dynamicObject.getString("matchtarget");
                if ("1".equals(matchTarget) || "2".equals(matchTarget)) {
                    matchBillRevokeOpPlugin.setInvoiceIdSetFormMatchBill(dynamicObject, afterRedConfirmIdSet);
                    continue;
                }
                matchBillRevokeOpPlugin.setInvoiceIdSetFormMatchBill(dynamicObject, afterOriInvoiceIdSet);
            }
            afterOriInvoiceIdSet.removeIf(afterInvoiceId -> !beforeOriInvoiceIdSet.contains(afterInvoiceId));
            MinusBillMatchHelper minusBillMatchHelper = new MinusBillMatchHelper();
            minusBillMatchHelper.updateInvoiceOccupyStatus((Collection)beforeOriInvoiceIdSet.stream().filter(id -> !afterOriInvoiceIdSet.contains(id)).collect(Collectors.toSet()), "0", "sim_vatinvoice");
            minusBillMatchHelper.updateInvoiceOccupyStatus(afterOriInvoiceIdSet, "1", "sim_vatinvoice");
            minusBillMatchHelper.updateInvoiceOccupyStatus((Collection)beforeRedConfirmIdSet.stream().filter(id -> !afterRedConfirmIdSet.contains(id)).collect(Collectors.toSet()), "0", "sim_red_confirm_bill");
            minusBillMatchHelper.updateInvoiceOccupyStatus(afterRedConfirmIdSet, "1", "sim_red_confirm_bill");
        }
        finally {
            CacheHelper.remove((String)lockKey);
        }
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("matchtarget");
    }
}

