/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.matchbill.op;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.sim.common.helper.issueinvoice.IssueInvoiceMqHelper;
import kd.imc.sim.formplugin.match.MatchBillRedHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class MatchBillRedOpPlugin
extends AbstractOperationServicePlugIn {
    private static final Log LOGGER = LogFactory.getLog(MatchBillRedOpPlugin.class);

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        OperateOption option;
        DynamicObject[] matchBills = BusinessDataServiceHelper.load((Object[])Arrays.stream(e.getDataEntities()).map(DataEntityBase::getPkValue).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_match_bill"));
        ArrayList redInvoiceLit = new ArrayList(matchBills.length);
        MatchBillRedHelper matchBillRedHelper = new MatchBillRedHelper();
        for (DynamicObject matchBill : matchBills) {
            matchBillRedHelper.matchBillRed(matchBill, redInvoiceLit, "", this.operationResult);
        }
        if (CollectionUtils.isNotEmpty(redInvoiceLit) && (option = this.getOption()).containsVariable("autoIssue") && "1".equals(option.getVariableValue("autoIssue"))) {
            option.setVariableValue("invoiceIds", redInvoiceLit.stream().map(DataEntityBase::getPkValue).map(Object::toString).collect(Collectors.joining(",")));
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        OperateOption option = this.getOption();
        if (!option.containsVariable("invoiceIds")) {
            return;
        }
        String invoiceIdsStr = option.getVariableValue("invoiceIds");
        if (StringUtils.isNotBlank((CharSequence)invoiceIdsStr)) {
            Object[] invoiceIds = Arrays.stream(invoiceIdsStr.split(",")).map(Long::parseLong).toArray();
            DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)String.join((CharSequence)",", "salertaxno", "jqbh", "orderno", "issuestatus", "result", "issuesource"), (QFilter[])new QFilter("id", "in", (Object)invoiceIds).toArray());
            IssueInvoiceMqHelper.submitInvoice2MQ((DynamicObject[])invoices);
        }
    }
}

