/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.matchbill.op;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.sim.common.constant.table.MatchBillConstant;
import kd.imc.sim.common.helper.NegativeBillMatchHelper;
import kd.imc.sim.formplugin.match.MinusBillMatchHelper;

public class MatchBillRevokeOpPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("pushdownstatus");
        e.getFieldKeys().add("id");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] matchBills = e.getDataEntities();
        DynamicObject[] matchBillArr = BusinessDataServiceHelper.load((Object[])Arrays.stream(matchBills).map(DataEntityBase::getPkValue).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_match_bill"));
        ArrayList<DynamicObject> unPushBills = new ArrayList<DynamicObject>(matchBillArr.length);
        ArrayList<DynamicObject> partPushBills = new ArrayList<DynamicObject>(matchBillArr.length);
        for (DynamicObject matchBill : matchBillArr) {
            DynamicObject[] matchTarget = matchBill.getString("matchtarget");
            String pushStatus = "1".equals(matchTarget) || "2".equals(matchTarget) ? this.getIssueStatus(matchBill) : matchBill.getString("pushdownstatus");
            if ("1".equals(pushStatus)) {
                partPushBills.add(matchBill);
                continue;
            }
            if (!"0".equals(pushStatus)) continue;
            unPushBills.add(matchBill);
        }
        HashSet<Long> oriInvoiceIdSet = new HashSet<Long>(matchBillArr.length);
        HashSet<Long> confirmIdSet = new HashSet<Long>(matchBillArr.length);
        if (unPushBills.size() > 0) {
            Object[] matchBillIdArr = unPushBills.stream().map(DataEntityBase::getPkValue).toArray();
            DynamicObject[] billRelations = BusinessDataServiceHelper.load((String)"sim_matchbill_relation", (String)"sbillid", (QFilter[])new QFilter("tbillid", "in", (Object)matchBillIdArr).toArray());
            if (billRelations.length == 0) {
                return;
            }
            DynamicObject[] bills = BusinessDataServiceHelper.load((String)"sim_original_bill", (String)String.join((CharSequence)",", "matchstatus", "confirmstate", "confirmamount", "hsbz", "comprehensivestatus", "operatebatch", "sim_original_bill_item.remainvalidamount", "sim_original_bill_item.remainvalidtax", "sim_original_bill_item.remainvalidnum", "sim_original_bill_item.amount", "sim_original_bill_item.taxamount", "sim_original_bill_item.tax", "sim_original_bill_item.num"), (QFilter[])new QFilter("id", "in", (Object)Arrays.stream(billRelations).map(relation -> relation.getLong("sbillid")).toArray()).toArray());
            for (DynamicObject bill : bills) {
                bill.set("matchstatus", (Object)"0");
                bill.set("confirmamount", (Object)BigDecimal.ZERO);
                bill.set("operatebatch", (Object)"");
                bill.set("comprehensivestatus", (Object)"01");
                bill.set("confirmstate", (Object)"0");
                DynamicObjectCollection items = bill.getDynamicObjectCollection("sim_original_bill_item");
                for (DynamicObject item : items) {
                    item.set("remainvalidamount", item.get("1".equals(bill.getString("hsbz")) ? "taxamount" : "amount"));
                    item.set("remainvalidtax", item.get("tax"));
                    item.set("remainvalidnum", item.get("num"));
                }
            }
            ImcSaveServiceHelper.update((DynamicObject[])bills);
            for (DynamicObject matchBill : unPushBills) {
                NegativeBillMatchHelper.changePushStatus((DynamicObject)matchBill);
                if ("1".equals(matchBill.getString("matchtarget")) || "2".equals(matchBill.getString("matchtarget"))) {
                    this.setInvoiceIdSetFormMatchBill(matchBill, confirmIdSet);
                    continue;
                }
                this.setInvoiceIdSetFormMatchBill(matchBill, oriInvoiceIdSet);
            }
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"sim_match_bill"), (Object[])matchBillIdArr);
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"sim_matchbill_relation"), (Object[])Arrays.stream(billRelations).map(DataEntityBase::getPkValue).toArray());
        }
        if (partPushBills.size() > 0) {
            for (DynamicObject matchBill : partPushBills) {
                DynamicObjectCollection matchItems = matchBill.getDynamicObjectCollection("sim_original_bill_item");
                String target = matchBill.getString("matchtarget");
                BigDecimal invoiceAmount = BigDecimal.ZERO;
                BigDecimal totalTax = BigDecimal.ZERO;
                HashSet<Long> partInvoiceIdSet = new HashSet<Long>(matchItems.size());
                HashSet<Long> partRedConfirmIdSet = new HashSet<Long>(matchItems.size());
                for (DynamicObject matchItem : matchItems) {
                    DynamicObject subItem;
                    DynamicObjectCollection subItems;
                    if ("1".equals(target) || "2".equals(target)) {
                        subItems = matchItem.getDynamicObjectCollection("confirmsubentryentity");
                        Iterator iterator = subItems.iterator();
                        BigDecimal totalSubAmount = BigDecimal.ZERO;
                        while (iterator.hasNext()) {
                            subItem = (DynamicObject)iterator.next();
                            if ("0".equals(subItem.getString("confirmissuestatus"))) {
                                invoiceAmount = invoiceAmount.add(subItem.getBigDecimal("confirmoriitemamount"));
                                totalSubAmount = totalSubAmount.add(subItem.getBigDecimal("confirmoriitemamount"));
                                totalTax = totalTax.add(subItem.getBigDecimal("confirmoriitemtax"));
                                partRedConfirmIdSet.add(subItem.getLong("redconfirmpk"));
                                continue;
                            }
                            long redConfirmPk = subItem.getLong("redconfirmpk");
                            if (0L != redConfirmPk) {
                                confirmIdSet.add(redConfirmPk);
                            }
                            iterator.remove();
                        }
                        matchBill.set("matchamount", (Object)invoiceAmount);
                        matchBill.set("matchtax", (Object)totalTax);
                        if (subItems.size() == 0) {
                            matchItem.set("itemmatchstatus", (Object)MatchBillConstant.MatchStatusEnum.MATCH_FAIL.getCode());
                            continue;
                        }
                        if (totalSubAmount.compareTo(matchItem.getBigDecimal("amount")) == 0) {
                            matchItem.set("itemmatchstatus", (Object)MatchBillConstant.MatchStatusEnum.MATCH_SUCCESS.getCode());
                            continue;
                        }
                        matchItem.set("itemmatchstatus", (Object)MatchBillConstant.MatchStatusEnum.MATCH_PART_SUCCESS.getCode());
                        continue;
                    }
                    subItems = matchItem.getDynamicObjectCollection("subentryentity");
                    int oriSize = subItems.size();
                    Iterator iterator = subItems.iterator();
                    while (iterator.hasNext()) {
                        subItem = (DynamicObject)iterator.next();
                        String pushStatus = subItem.getString("pushstatus");
                        if (!"-1".equals(pushStatus)) continue;
                        oriInvoiceIdSet.add(subItem.getLong("oriinvoiceid"));
                        partInvoiceIdSet.add(subItem.getLong("oriinvoiceid"));
                        iterator.remove();
                        matchBill.set("matchamount", (Object)matchBill.getBigDecimal("matchamount").add(subItem.getBigDecimal("oriitemamount")));
                        matchBill.set("matchtax", (Object)matchBill.getBigDecimal("matchtax").add(subItem.getBigDecimal("oriitemtax")));
                    }
                    if (subItems.size() == 0) {
                        matchItem.set("itemmatchstatus", (Object)MatchBillConstant.MatchStatusEnum.MATCH_FAIL.getCode());
                        continue;
                    }
                    if (subItems.size() >= oriSize) continue;
                    matchItem.set("itemmatchstatus", (Object)MatchBillConstant.MatchStatusEnum.MATCH_PART_SUCCESS.getCode());
                }
                matchBill.set("matchstatus", (Object)MatchBillConstant.MatchStatusEnum.MATCH_PART_SUCCESS.getCode());
                matchBill.set("matchinvoicenum", (Object)(matchBill.getInt("matchinvoicenum") - partInvoiceIdSet.size()));
                if ("1".equals(target) || "2".equals(target)) {
                    matchBill.set("matchinvoicenum", (Object)partRedConfirmIdSet.size());
                }
                matchBill.set("matchtotalamount", (Object)matchBill.getBigDecimal("matchamount").add(matchBill.getBigDecimal("matchtax")));
                NegativeBillMatchHelper.changePushStatus((DynamicObject)matchBill);
            }
            ImcSaveServiceHelper.save(partPushBills);
            DynamicObject[] billRelations = BusinessDataServiceHelper.load((String)"sim_matchbill_relation", (String)"sbillid", (QFilter[])new QFilter("tbillid", "in", (Object)partPushBills.stream().map(DataEntityBase::getPkValue).toArray()).toArray());
            if (billRelations.length != 0) {
                DynamicObject[] bills;
                for (DynamicObject bill : bills = BusinessDataServiceHelper.load((String)"sim_original_bill", (String)String.join((CharSequence)",", "matchstatus", "comprehensivestatus"), (QFilter[])new QFilter("id", "in", (Object)Arrays.stream(billRelations).map(relation -> relation.getLong("sbillid")).toArray()).toArray())) {
                    bill.set("matchstatus", (Object)MatchBillConstant.MatchStatusEnum.MATCH_PART_SUCCESS.getCode());
                    if (!"33".equals(bill.getString("comprehensivestatus"))) continue;
                    bill.set("comprehensivestatus", (Object)"32");
                }
                ImcSaveServiceHelper.update((DynamicObject[])bills);
            }
        }
        MinusBillMatchHelper matchHelper = new MinusBillMatchHelper();
        if (oriInvoiceIdSet.size() > 0) {
            matchHelper.updateInvoiceOccupyStatus(oriInvoiceIdSet, "0", "sim_vatinvoice");
        }
        if (confirmIdSet.size() > 0) {
            matchHelper.updateInvoiceOccupyStatus(confirmIdSet, "0", "sim_red_confirm_bill");
        }
    }

    private String getIssueStatus(DynamicObject matchBill) {
        DynamicObjectCollection items = matchBill.getDynamicObjectCollection("sim_original_bill_item");
        boolean isContainsIssued = false;
        boolean isContainsNotIssued = false;
        for (DynamicObject item : items) {
            DynamicObjectCollection subItems = item.getDynamicObjectCollection("confirmsubentryentity");
            for (DynamicObject subItem : subItems) {
                String issueStatus = subItem.getString("confirmissuestatus");
                if ("0".equals(issueStatus)) {
                    isContainsIssued = true;
                    continue;
                }
                isContainsNotIssued = true;
            }
        }
        if (isContainsIssued && !isContainsNotIssued) {
            return "2";
        }
        if (isContainsIssued && isContainsNotIssued) {
            return "1";
        }
        return "0";
    }

    public void setInvoiceIdSetFormMatchBill(DynamicObject matchBill, Set<Long> invoiceIdSet) {
        DynamicObjectCollection matchItems = matchBill.getDynamicObjectCollection("sim_original_bill_item");
        String target = matchBill.getString("matchtarget");
        boolean isMatchTarget = "1".equals(target) || "2".equals(target);
        for (DynamicObject matchItem : matchItems) {
            if (isMatchTarget) {
                DynamicObjectCollection subConfirmItems = matchItem.getDynamicObjectCollection("confirmsubentryentity");
                if (null == subConfirmItems) continue;
                for (DynamicObject subConfirmItem : subConfirmItems) {
                    Long redConfirmPk = subConfirmItem.getLong("redconfirmpk");
                    invoiceIdSet.add(redConfirmPk);
                }
                continue;
            }
            DynamicObjectCollection subItems = matchItem.getDynamicObjectCollection("subentryentity");
            for (DynamicObject subItem : subItems) {
                invoiceIdSet.add(subItem.getLong("oriinvoiceid"));
            }
        }
    }
}

