/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.matchbill.op;

import java.util.Arrays;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.imc.bdm.common.constant.OperationConstant;

public class NegativeBillRedOpPlugin
extends AbstractOperationServicePlugIn {
    private static final Log LOGGER = LogFactory.getLog(NegativeBillRedOpPlugin.class);

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        Object[] ids = this.getMatchBillIdArrByOriginalBill(e.getDataEntities());
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"red", (String)"sim_match_bill", (Object[])ids, (OperateOption)this.operateOption);
        if (!operationResult.isSuccess()) {
            LOGGER.info("\u8d1f\u6570\u5f00\u7968\u7533\u8bf7\u5355\u7ea2\u51b2" + OperationConstant.getErrorMsg((OperationResult)operationResult));
            throw new KDBizException(OperationConstant.getErrorMsg((OperationResult)operationResult));
        }
    }

    Object[] getMatchBillIdArrByOriginalBill(DynamicObject[] originalBill) {
        DynamicObject[] billRelations = BusinessDataServiceHelper.load((String)"sim_matchbill_relation", (String)"tbillid", (QFilter[])new QFilter("sbillid", "in", (Object)Arrays.stream(originalBill).map(DataEntityBase::getPkValue).toArray()).toArray());
        return Arrays.stream(billRelations).map(relation -> relation.getLong("tbillid")).distinct().toArray();
    }
}

