/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.originalbill;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.bdm.common.constant.InvItemSettingConstant;
import kd.imc.bdm.common.helper.ExcelHelper;
import kd.imc.bdm.common.helper.InvItemConfigHelper;
import kd.imc.bdm.common.model.FileField;
import kd.imc.bdm.common.plugin.AbstractImportPlugin;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public abstract class AbstractOriginalBillImportPlugin
extends AbstractImportPlugin {
    private static final Log LOGGER = LogFactory.getLog(AbstractOriginalBillImportPlugin.class);

    protected void fillInGoodsInfo(Map<String, Object> map, Map<String, DynamicObject> goodsNameMap, Map<String, DynamicObject> goodsCodeMap, boolean completion, boolean isCompletionPolicylogo) {
        boolean isNormal;
        DynamicObject obj;
        String goodsCode = (String)map.get("spbm");
        String goodsName = (String)map.get("goodsname");
        DynamicObject dynamicObject = obj = goodsCodeMap.get(goodsCode) == null ? goodsNameMap.get(goodsName) : goodsCodeMap.get(goodsCode);
        if (obj == null) {
            return;
        }
        this.fillInMapValue(map, "taxrate", obj.getString("taxrate"));
        String rowType = (String)map.get("rowtype");
        boolean bl = isNormal = "2".equals(rowType) || "3".equals(rowType);
        if (completion) {
            this.fillInMapValue(map, "goodsname", obj.getString("name"));
            if (isCompletionPolicylogo) {
                this.fillInMapValue(map, "policylogo", obj.getString("privilegeflag"));
                String policylogo = (String)map.get("policylogo");
                if ("1".equals(policylogo)) {
                    this.fillInMapValue(map, "policycontants", obj.getString("privilegetype"));
                }
            }
            this.fillInMapValue(map, "goodscode", obj.getString("taxcode.mergecode"));
            this.fillInMapValue(map, "goodsid", obj.get("id"));
            this.fillInMapValue(map, "spbm", obj.getString("number"));
            if (isNormal) {
                this.fillInMapValue(map, "specification", obj.getString("specifications"));
                this.fillInMapValue(map, "unit", obj.getString("unit"));
            }
            return;
        }
        map.put("goodsname", obj.getString("name"));
        map.put("spbm", obj.getString("number"));
        map.put("goodscode", obj.getString("taxcode.mergecode"));
        map.put("goodsid", obj.get("id"));
        map.put("policylogo", obj.getString("privilegeflag"));
        map.put("policycontants", obj.getString("privilegetype"));
        if (isNormal) {
            map.put("specification", obj.getString("specifications"));
            map.put("unit", obj.getString("unit"));
        }
    }

    protected boolean checkGoodsInfo(Map<String, Object> detail) {
        return !this.checkMapValueNull(detail, "number") && !this.checkMapValueNull(detail, "name") && !this.checkMapValueNull(detail, "taxcode") && !this.checkMapValueNull(detail, "taxrate");
    }

    protected boolean getGoodsInfoSwitch(long orgId) {
        Map invItemConfig = InvItemConfigHelper.getInvItemConfig((Long)orgId);
        return null != invItemConfig && Boolean.parseBoolean(String.valueOf(invItemConfig.get(InvItemSettingConstant.BusTypeEnum.ORIGINAL_BILL_IMPORT.getValue())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void downloadTemplate(String templateDir, String templateName, String templateJsonName) {
        try (InputStream inStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(templateDir + '/' + templateName);){
            if (inStream == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e0b\u8f7d\u5931\u8d25\uff1a%s", (String)"AbstractOriginalBillImportPlugin_4", (String)"imc-sim-formplugin", (Object[])new Object[0]), ""));
            }
            try (Workbook workbook = WorkbookFactory.create((InputStream)inStream);){
                Row titleRow = workbook.getSheetAt(0).getRow(1);
                List fileFieldList = ExcelHelper.readTemplate((String)templateDir, (String)templateJsonName);
                ExcelHelper.replaceFieldName((List)fileFieldList, (String)"sim_original_bill");
                Map<String, FileField> fieldMap = fileFieldList.stream().collect(Collectors.toMap(FileField::getFieldOrder, v -> v));
                for (int i = 0; i <= titleRow.getLastCellNum(); ++i) {
                    String colIndex = ExcelHelper.excelColIndexToStr((int)(i + 1));
                    FileField fileField = fieldMap.get(colIndex);
                    if (fileField == null || !fileField.getNeedReplaceName().booleanValue()) continue;
                    Cell cell = titleRow.getCell(i);
                    cell.setCellValue(fileField.getFieldName());
                }
                ByteArrayInputStream bais = null;
                try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                    workbook.write((OutputStream)byteArrayOutputStream);
                    bais = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                    String urls = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(templateName, (InputStream)bais, 5000);
                    this.getView().openUrl(urls);
                }
                finally {
                    if (bais != null) {
                        try {
                            bais.close();
                        }
                        catch (IOException e) {
                            LOGGER.error("\u5173\u95ed\u6587\u4ef6\u6d41\u5931\u8d25");
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("downloadTemplateFail:" + e.getMessage(), (Throwable)e);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e0b\u8f7d\u5931\u8d25\uff1a%s", (String)"AbstractOriginalBillImportPlugin_4", (String)"imc-sim-formplugin", (Object[])new Object[0]), e.getMessage()));
        }
    }
}

