/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.originalbill;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.formplugin.bill.originalbill.control.InvoiceOriginalFormControl;

public class InvoiceSpecifyWorkbenchPlugin
extends AbstractFormPlugin {
    private static final String MATCH_TYPE = "matchtype";

    public void registerListener(EventObject e) {
        InvoiceOriginalFormControl.addTextEditClickListener((AbstractFormPlugin)this, (String[])new String[]{"infocode", "blueinvoiceno"});
        this.addClickListeners(new String[]{"btn_ok"});
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        EntryGrid entryEntity = (EntryGrid)this.getView().getControl("entryentity");
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entryentity");
        switch (key) {
            case "infocode": {
                this.getPageCache().put("selectRow", String.valueOf(entryEntity.getSelectRows()[0]));
                this.openRedConfirmBillView();
                break;
            }
            case "blueinvoiceno": {
                this.getPageCache().put("selectRow", String.valueOf(entryEntity.getSelectRows()[0]));
                this.openVatInvoiceListView((DynamicObject)entrys.get(entryEntity.getSelectRows()[0]));
                break;
            }
            case "btn_ok": {
                this.specifyDataProcess();
            }
        }
    }

    private void specifyDataProcess() {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        String orgId = params.get("orgid").toString();
        try (DLock lock = DLock.create((String)("SpecifyMatch:" + orgId));){
            if (!lock.tryLock(1000L)) {
                return;
            }
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            HashSet blueInvoice = Sets.newHashSetWithExpectedSize((int)0);
            HashSet redConfirm = Sets.newHashSetWithExpectedSize((int)0);
            int blueNum = 0;
            int redNum = 0;
            HashMap specifyDataCollection = Maps.newHashMapWithExpectedSize((int)0);
            for (DynamicObject entry : entryEntity) {
                DynamicObjectCollection objects = new DynamicObjectCollection();
                if ("0".equals(entry.getString(MATCH_TYPE))) {
                    if (StringUtils.isEmpty((CharSequence)entry.getString("blueinvoiceno")) || StringUtils.isEmpty((CharSequence)entry.getString("redreason"))) {
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7b2c[%s]\u884c\uff0c\u6307\u5b9a\u84dd\u7968\u4e0e\u7ea2\u51b2\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceSpecifyWorkbenchPlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]), entry.getString("seq")));
                        return;
                    }
                    String invoiceNo = entry.getString("blueinvoiceno");
                    DynamicObject invoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice", (boolean)true), (QFilter[])new QFilter("invoiceno", "=", (Object)invoiceNo).toArray());
                    if (invoice == null) {
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7b2c[%s]\u884c\uff0c\u53d1\u7968\u53f7\u7801\u586b\u5199\u6709\u8bef", (String)"InvoiceSpecifyWorkbenchPlugin_4", (String)"imc-sim-formplugin", (Object[])new Object[0]), entry.getString("seq")));
                        return;
                    }
                    if ("1".equals(invoice.getString("occupystatus"))) {
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7b2c[%1$s]\u884c\uff0c\u53d1\u7968[%2%s]\u5df2\u88ab\u5360\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"InvoiceSpecifyWorkbenchPlugin_10", (String)"imc-sim-formplugin", (Object[])new Object[0]), entry.getString("seq"), invoiceNo));
                        return;
                    }
                    if (entry.getBigDecimal("amount").abs().compareTo(invoice.getBigDecimal("remainredamount").abs()) != 0) {
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7b2c[%s]\u884c\uff0c\u6307\u5b9a\u84dd\u7968\u91d1\u989d\u4e0e\u586b\u5199\u91d1\u989d\u4e0d\u5339\u914d", (String)"InvoiceSpecifyWorkbenchPlugin_5", (String)"imc-sim-formplugin", (Object[])new Object[0]), entry.getString("seq")));
                        return;
                    }
                    if (entry.getBigDecimal("tax").abs().compareTo(invoice.getBigDecimal("canredtaxamount").abs()) != 0) {
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7b2c[%s]\u884c\uff0c\u6307\u5b9a\u84dd\u7968\u7a0e\u989d\u4e0e\u586b\u5199\u7a0e\u989d\u4e0d\u5339\u914d", (String)"InvoiceSpecifyWorkbenchPlugin_8", (String)"imc-sim-formplugin", (Object[])new Object[0]), entry.getString("seq")));
                        return;
                    }
                    objects.add((Object)invoice);
                    blueInvoice.add(entry.getString("blueinvoiceno"));
                    ++blueNum;
                }
                if ("1".equals(entry.getString(MATCH_TYPE))) {
                    if (StringUtils.isEmpty((CharSequence)entry.getString("infocode"))) {
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7b2c[%s]\u884c\uff0c\u6307\u5b9a\u7ea2\u5b57\u786e\u8ba4\u5355\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceSpecifyWorkbenchPlugin_1", (String)"imc-sim-formplugin", (Object[])new Object[0]), entry.getString("seq")));
                        return;
                    }
                    String[] billNos = entry.getString("infocode").split(",");
                    for (int i = 0; i < billNos.length; ++i) {
                        billNos[i] = billNos[i].trim();
                        redConfirm.add(billNos[i]);
                        ++redNum;
                    }
                    DynamicObject[] redConfirmBills = BusinessDataServiceHelper.load((String)"sim_red_confirm_bill", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_red_confirm_bill", (boolean)true), (QFilter[])new QFilter("number", "in", (Object)billNos).toArray());
                    if (redConfirmBills == null) {
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7b2c[%s]\u884c\uff0c\u7ea2\u5b57\u786e\u8ba4\u5355\u586b\u5199\u6709\u8bef", (String)"InvoiceSpecifyWorkbenchPlugin_2", (String)"imc-sim-formplugin", (Object[])new Object[0]), entry.getString("seq")));
                        return;
                    }
                    BigDecimal amount = BigDecimal.ZERO;
                    BigDecimal tax = BigDecimal.ZERO;
                    BigDecimal needAmount = entry.getBigDecimal("amount");
                    for (DynamicObject redConfirmBill : redConfirmBills) {
                        if ("1".equals(redConfirmBill.getString("occupystatus"))) {
                            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7b2c[%1$s]\u884c\uff0c\u7ea2\u5b57\u786e\u8ba4\u5355[%2%s]\u5df2\u88ab\u5360\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"InvoiceSpecifyWorkbenchPlugin_11", (String)"imc-sim-formplugin", (Object[])new Object[0]), entry.getString("seq"), redConfirmBill.getString("number")));
                            return;
                        }
                        amount = amount.add(redConfirmBill.getBigDecimal("invoiceamount"));
                        tax = tax.add(redConfirmBill.getBigDecimal("totaltax"));
                        objects.add((Object)redConfirmBill);
                    }
                    if (amount.compareTo(needAmount) != 0) {
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7b2c[%s]\u884c\uff0c\u6307\u5b9a\u7ea2\u5b57\u786e\u8ba4\u5355\u91d1\u989d\u4e0e\u586b\u5199\u91d1\u989d\u4e0d\u5339\u914d", (String)"InvoiceSpecifyWorkbenchPlugin_3", (String)"imc-sim-formplugin", (Object[])new Object[0]), entry.getString("seq")));
                        return;
                    }
                    if (tax.compareTo(entry.getBigDecimal("tax")) != 0) {
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7b2c[%s]\u884c\uff0c\u6307\u5b9a\u7ea2\u5b57\u786e\u8ba4\u5355\u7a0e\u989d\u4e0e\u586b\u5199\u7a0e\u989d\u4e0d\u5339\u914d", (String)"InvoiceSpecifyWorkbenchPlugin_9", (String)"imc-sim-formplugin", (Object[])new Object[0]), entry.getString("seq")));
                        return;
                    }
                }
                specifyDataCollection.put(entry.getString("matchbillid"), objects);
            }
            if (blueInvoice.size() != blueNum) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u53ef\u91cd\u590d\u9009\u62e9\u540c\u4e00\u5f20\u84dd\u7968", (String)"InvoiceSpecifyWorkbenchPlugin_6", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                return;
            }
            if (redConfirm.size() != redNum) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u53ef\u91cd\u590d\u9009\u62e9\u540c\u4e00\u5f20\u7ea2\u5b57\u786e\u8ba4\u5355", (String)"InvoiceSpecifyWorkbenchPlugin_7", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                return;
            }
            this.saveSpecifyData(entryEntity, specifyDataCollection);
            this.getView().close();
        }
    }

    private void saveSpecifyData(DynamicObjectCollection entryEntity, Map<String, DynamicObjectCollection> specifyDataMap) {
        ArrayList matchBillList = Lists.newArrayListWithCapacity((int)0);
        HashSet redConfirmBillNo = Sets.newHashSetWithExpectedSize((int)0);
        DynamicObjectCollection redConfirmBillCollection = new DynamicObjectCollection();
        DynamicObjectCollection invoiceCollection = new DynamicObjectCollection();
        for (DynamicObject entry : entryEntity) {
            HashSet invoiceNo = Sets.newHashSetWithExpectedSize((int)0);
            Map params = this.getView().getFormShowParameter().getCustomParams();
            List jsonArray = (List)params.get("data");
            DynamicObject matchBill = BusinessDataServiceHelper.newDynamicObject((String)"sim_match_bill");
            for (JSONObject jsonObject : jsonArray) {
                if (!jsonObject.getString("id").equals(entry.getString("matchbillid"))) continue;
                DynamicObjectUtil.json2DynamicObjectContainItems((JSONObject)jsonObject, (DynamicObject)matchBill, (boolean)true);
                break;
            }
            if (null == matchBill.get("billno")) {
                return;
            }
            DynamicObjectCollection specifyDataCollection = specifyDataMap.get(entry.getString("matchbillid"));
            DynamicObjectCollection items = matchBill.getDynamicObjectCollection("sim_original_bill_item");
            if ("0".equals(entry.getString(MATCH_TYPE))) {
                matchBill.set("matchtarget", (Object)"3");
                DynamicObject invoice = (DynamicObject)specifyDataCollection.get(0);
                invoice.set("occupystatus", (Object)"1");
                invoiceCollection.add((Object)invoice);
                invoiceNo.add(invoice.getPkValue().toString());
                for (DynamicObject item : items) {
                    item.set("itemmatchstatus", (Object)"1");
                    DynamicObjectCollection subEntryEntity = item.getDynamicObjectCollection("subentryentity");
                    DynamicObject entryData = subEntryEntity.addNew();
                    entryData.set("oriinvoiceid", invoice.getPkValue());
                    entryData.set("oriitemseq", (Object)-1);
                    entryData.set("oriinvoicecode", (Object)invoice.getString("invoicecode"));
                    entryData.set("oriinvoiceno", (Object)invoice.getString("invoiceno"));
                    entryData.set("pushstatus", (Object)"-1");
                    entryData.set("oriitemamount", (Object)invoice.getBigDecimal("invoiceamount"));
                    entryData.set("oriitemtax", (Object)invoice.getBigDecimal("totaltax"));
                }
                matchBill.set("matchstatus", (Object)"1");
                matchBill.set("redreason", (Object)entry.getString("redreason"));
                matchBill.set(MATCH_TYPE, (Object)"0");
                matchBill.set("matchamount", (Object)entry.getBigDecimal("amount"));
                matchBill.set("matchtax", (Object)entry.getBigDecimal("tax"));
                matchBill.set("matchinvoicenum", (Object)invoiceNo.size());
                matchBill.set("matchtotalamount", (Object)entry.getBigDecimal("tax").add(entry.getBigDecimal("amount")));
            }
            if ("1".equals(entry.getString(MATCH_TYPE))) {
                matchBill.set("matchtarget", (Object)"2");
                for (DynamicObject item : items) {
                    item.set("itemmatchstatus", (Object)"1");
                    DynamicObjectCollection redConfirmEntryEntity = item.getDynamicObjectCollection("confirmsubentryentity");
                    for (DynamicObject redConfirmBill : specifyDataCollection) {
                        redConfirmBill.set("occupystatus", (Object)"1");
                        redConfirmBillCollection.add((Object)redConfirmBill);
                        redConfirmBillNo.add(redConfirmBill.getString("number"));
                        DynamicObject entryData = redConfirmEntryEntity.addNew();
                        entryData.set("confirminfocode", (Object)redConfirmBill.getString("number"));
                        entryData.set("redconfirmpk", redConfirmBill.getPkValue());
                        entryData.set("confirmoriinvoicecode", (Object)redConfirmBill.getString("originalinvoicecode"));
                        entryData.set("confirmoriinvoiceno", (Object)redConfirmBill.getString("originalinvoiceno"));
                    }
                }
                matchBill.set("matchstatus", (Object)"1");
                matchBill.set("matchamount", (Object)entry.getBigDecimal("amount"));
                matchBill.set(MATCH_TYPE, (Object)"0");
                matchBill.set("matchinvoicenum", (Object)redConfirmBillNo.size());
                matchBill.set("matchtax", (Object)entry.getBigDecimal("tax"));
                matchBill.set("matchtotalamount", (Object)entry.getBigDecimal("tax").add(entry.getBigDecimal("amount")));
            }
            matchBillList.add(matchBill);
        }
        SaveServiceHelper.save((DynamicObject[])((DynamicObject[])redConfirmBillCollection.toArray((Object[])new DynamicObject[redConfirmBillCollection.size()])));
        SaveServiceHelper.save((DynamicObject[])((DynamicObject[])invoiceCollection.toArray((Object[])new DynamicObject[invoiceCollection.size()])));
        this.getView().returnDataToParent((Object)matchBillList);
    }

    private void openRedConfirmBillView() {
        Map fatherParams = this.getView().getFormShowParameter().getCustomParams();
        Object org = fatherParams.get("orgid");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("buyername", this.getModel().getValue("buyername"));
        params.put("buyertaxno", this.getModel().getValue("buyertaxno"));
        params.put("salertaxno", this.getModel().getValue("salertaxno"));
        String[] split = this.getModel().getValue("infocode").toString().split(",");
        for (int i = 0; i < split.length; ++i) {
            split[i] = StringUtils.trim((String)split[i]);
        }
        params.put("infocode", split);
        params.put("org", Long.parseLong(String.valueOf(org)));
        ViewUtil.openDialog((AbstractFormPlugin)this, null, params, (String)"sim_redconfirmbill_choose", (String)"infocode", (boolean)true);
    }

    private void openVatInvoiceListView(DynamicObject dynamicObject) {
        QFilter buyerNameFilter = new QFilter("buyername", "=", (Object)dynamicObject.getString("buyername"));
        QFilter occupyStatusFilter = new QFilter("occupystatus", "!=", (Object)"1");
        QFilter statusFilter = new QFilter("invoicestatus", "in", (Object)new String[]{"0", "2"});
        QFilter blueFilter = new QFilter("issuetype", "=", (Object)"0");
        QFilter orgFilter = new QFilter("orgid", "=", (Object)RequestContext.get().getOrgId());
        QFilter amountFilter = new QFilter("remainredamount", "=", (Object)dynamicObject.getBigDecimal("amount").abs()).and("canredtaxamount", "=", (Object)dynamicObject.getBigDecimal("tax").abs());
        QFilter invoiceTypeFilter = null;
        if ("08xdp".equals(dynamicObject.getString("invoicetype"))) {
            invoiceTypeFilter = new QFilter("invoicetype", "in", (Object)new String[]{"028", "004", "08xdp"});
        }
        if ("10xdp".equals(dynamicObject.getString("invoicetype"))) {
            invoiceTypeFilter = new QFilter("invoicetype", "in", (Object)new String[]{"026", "007", "10xdp", "025"});
        }
        ViewUtil.openListPage((AbstractFormPlugin)this, (QFilter)buyerNameFilter.and(invoiceTypeFilter).and(statusFilter).and(occupyStatusFilter).and(blueFilter).and(orgFilter).and(amountFilter), (String)"sim_choose_vatinvoice", (String)"blueinvoiceno");
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId = event.getActionId();
        Object returnData = event.getReturnData();
        if (null == returnData) {
            return;
        }
        int selectRow = Integer.parseInt(this.getPageCache().get("selectRow"));
        switch (actionId) {
            case "infocode": {
                this.getModel().setValue("infocode", (Object)returnData.toString().substring(1, returnData.toString().length() - 1), selectRow);
                break;
            }
            case "blueinvoiceno": {
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)((ListSelectedRowCollection)returnData).get(0).getPrimaryKeyValue(), (String)"sim_vatinvoice");
                this.getModel().setValue("blueinvoiceno", (Object)dynamicObject.getString("invoiceno"), selectRow);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        List jsonArray = (List)params.get("data");
        for (JSONObject object : jsonArray) {
            int row = this.getModel().createNewEntryRow("entryentity");
            this.getModel().setValue("billno", (Object)object.getString("billno"), row);
            this.getModel().setValue("matchbillid", (Object)object.getString("id"), row);
            this.getModel().setValue("buyername", (Object)object.getString("buyername"), row);
            this.getModel().setValue("buyertaxno", (Object)object.getString("buyertaxno"), row);
            this.getModel().setValue("salertaxno", (Object)object.getString("salertaxno"), row);
            this.getModel().setValue("amount", (Object)object.getString("applyamount"), row);
            this.getModel().setValue("tax", (Object)object.getString("applytax"), row);
            this.getModel().setValue("invoicetype", (Object)object.getString("invoicetype"), row);
            this.getModel().setValue("oriredreason", (Object)object.getString("redreason"), row);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String eventName = e.getProperty().getName();
        EntryGrid entryEntity = (EntryGrid)this.getView().getControl("entryentity");
        if (MATCH_TYPE.equals(eventName)) {
            if ("0".equals(this.getModel().getValue(MATCH_TYPE))) {
                this.getModel().setValue("infocode", (Object)"", entryEntity.getSelectRows()[0]);
                if (StringUtils.isNotBlank((Object)this.getModel().getValue("oriredreason"))) {
                    this.getModel().setValue("redreason", this.getModel().getValue("oriredreason"), entryEntity.getSelectRows()[0]);
                    this.getView().setEnable(Boolean.valueOf(false), entryEntity.getSelectRows()[0], new String[]{"redreason"});
                }
            } else {
                this.getModel().setValue("blueinvoiceno", (Object)"", entryEntity.getSelectRows()[0]);
                this.getModel().setValue("redreason", (Object)"", entryEntity.getSelectRows()[0]);
            }
        }
    }
}

