/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.originalbill.callback;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.imc.bdm.common.annotation.CallBackAnnotation;
import kd.imc.bdm.common.constant.CallBackEnum;
import kd.imc.bdm.common.constant.ImcPermItemEnum;
import kd.imc.bdm.common.helper.EnterpriseHelper;
import kd.imc.bdm.common.helper.PermissionHelper;
import kd.imc.bdm.common.helper.SynchronizationQuotaHelper;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.common.helper.BillHelper;
import kd.imc.sim.formplugin.bill.originalbill.control.OriginalBillPluginIssueControl;
import kd.imc.sim.formplugin.bill.originalbill.control.OriginalBillPluginRowControl;
import kd.imc.sim.formplugin.bill.originalbill.control.OriginalBillPluginZSFSControl;

public class InvoiceOriginalFormCallBack {
    @CallBackAnnotation(value={"btn_clickopeninvoice"}, callback=CallBackEnum.CLOSED)
    public void issuepushClosedCallBack(AbstractFormPlugin that, ClosedCallBackEvent event) {
        Map returnData = (Map)event.getReturnData();
        if (Objects.isNull(returnData)) {
            return;
        }
        Object pkValue = that.getView().getModel().getDataEntity().getPkValue();
        OriginalBillPluginIssueControl.issuePush((AbstractFormPlugin)that, (Object[])new Object[]{pkValue}, (Map)returnData);
    }

    @CallBackAnnotation(value={"quick_issue"}, callback=CallBackEnum.CLOSED)
    public void quickIssue(AbstractFormPlugin that, ClosedCallBackEvent event) {
        that.getView().setStatus(OperationStatus.VIEW);
        that.getView().invokeOperation("refresh");
    }

    @CallBackAnnotation(value={"bill_issuepush_check_remark"}, callback=CallBackEnum.CONFIRM)
    public void billIssuePushCheckSpecialCodeRemarkConfirmCallBack(AbstractFormPlugin that, MessageBoxClosedEvent event) {
        if (event.getResult() == MessageBoxResult.Yes) {
            boolean isRedInfo;
            HashSet typeSet = Sets.newHashSet();
            BigDecimal totalAmount = (BigDecimal)that.getView().getModel().getValue("totalamount");
            String invoiceType = (String)that.getView().getModel().getValue("invoicetype");
            boolean bl = isRedInfo = totalAmount.compareTo(new BigDecimal(0)) < 0 && InvoiceUtils.isSpecialInvoice((String)invoiceType);
            if (isRedInfo) {
                typeSet.add("-1");
            } else {
                typeSet.add("1");
            }
            Object pkValue = that.getView().getModel().getDataEntity().getPkValue();
            BillHelper.issuePushBill((AbstractFormPlugin)that, (Object[])new Object[]{pkValue}, (HashSet)typeSet);
        }
    }

    @CallBackAnnotation(value={"CLEAR_BILL_ITEM"}, callback=CallBackEnum.CONFIRM)
    public void clearBillItemConfirmCallBack(AbstractFormPlugin that, MessageBoxClosedEvent event) {
        if (event.getResult() == MessageBoxResult.Yes) {
            IFormView view = that.getView();
            view.getModel().deleteEntryData("sim_original_bill_item");
        }
    }

    @CallBackAnnotation(value={"CLOSED_QUOTA_CONFIRM"}, callback=CallBackEnum.CONFIRM)
    public void closedQuotaConfirmCallBack(AbstractFormPlugin that, MessageBoxClosedEvent event) {
        SynchronizationQuotaHelper.closedCallBack((MessageBoxClosedEvent)event, (AbstractFormPlugin)that, (String)(that.getView().getModel().getValue("salertaxno") + ""), (String)(that.getView().getModel().getValue("jqbh") + ""));
    }

    @CallBackAnnotation(value={"ZSFS_REDUCED_LEVY"}, callback=CallBackEnum.CONFIRM)
    public void changeZSFS2ReducedLevyConfirmCallBack(AbstractFormPlugin that, MessageBoxClosedEvent event) {
        if (event.getResult() == MessageBoxResult.Yes) {
            IFormView view = that.getView();
            OriginalBillPluginZSFSControl.changeInvoiceRemarkByDeduction((IFormView)view);
            OriginalBillPluginZSFSControl.deleteBillOriginalItem((IFormView)view);
            EntryGrid grid = (EntryGrid)that.getControl("sim_original_bill_item");
            Object rowcount = grid.getEntryData().getData().get("rowcount");
            OriginalBillPluginRowControl.addRow((IFormView)that.getView(), (int)((Integer)rowcount));
        }
    }

    @CallBackAnnotation(value={"ZSFS_DIFFERENCE_LEVY"}, callback=CallBackEnum.CONFIRM)
    public void changeZSFS2DifferenceLevyConfirmCallBack(AbstractFormPlugin that, MessageBoxClosedEvent event) {
        if (event.getResult() == MessageBoxResult.Yes) {
            IFormView view = that.getView();
            OriginalBillPluginZSFSControl.deleteBillOriginalItem((IFormView)view);
            view.setEnable(Boolean.FALSE, new String[]{"taxadjust"});
        }
    }

    @CallBackAnnotation(value={"ZSFS_NORMAL"}, callback=CallBackEnum.CONFIRM)
    public void changeZSFS2NormalLevyConfirmCallBack(AbstractFormPlugin that, MessageBoxClosedEvent event) {
        if (event.getResult() == MessageBoxResult.Yes) {
            OriginalBillPluginZSFSControl.deleteBillOriginalItem((IFormView)that.getView());
            OriginalBillPluginZSFSControl.changeInvoiceRemarkByDeduction((IFormView)that.getView());
        }
    }

    @CallBackAnnotation(value={"ZSFS_REDUCED_TAX"}, callback=CallBackEnum.CONFIRM)
    public void changeZSFSREDUCEDTaxConfirmCallBack(AbstractFormPlugin that, MessageBoxClosedEvent event) {
        if (event.getResult() == MessageBoxResult.Yes) {
            OriginalBillPluginZSFSControl.deleteBillOriginalItem((IFormView)that.getView());
            if (!EnterpriseHelper.isLqptChannel((String)((String)that.getView().getModel().getValue("salertaxno")))) {
                that.getView().setVisible(Boolean.TRUE, new String[]{"reductiontaxtype"});
            }
            that.getView().getModel().setValue("specialtype", (Object)"00");
        }
    }

    @CallBackAnnotation(value={"bill_preview_check_remark"}, callback=CallBackEnum.CONFIRM)
    public void billPreviewCheckSpecialCodeRemarkConfirmCallBack(AbstractFormPlugin that, MessageBoxClosedEvent event) {
        if (event.getResult() == MessageBoxResult.Yes) {
            this.checkOrgPermission(that);
            HashMap<String, ArrayList> param = new HashMap<String, ArrayList>(2);
            ArrayList objects = Lists.newArrayList((Object[])new Object[]{that.getView().getModel().getDataEntity().getPkValue()});
            param.put("pks", objects);
            ViewUtil.openDialog((AbstractFormPlugin)that, param, (String)"sim_ori_preview", (String)"sim_ori_preview");
        }
    }

    @CallBackAnnotation(value={"sim_ori_preview"}, callback=CallBackEnum.CLOSED)
    public void billProcessPrevies(AbstractFormPlugin that, ClosedCallBackEvent event) {
        this.checkOrgPermission(that);
        Map returnData = (Map)event.getReturnData();
        if (Objects.isNull(returnData)) {
            return;
        }
        Object pkValue = that.getView().getModel().getDataEntity().getPkValue();
        returnData.put("pks", new Object[]{pkValue});
        returnData.put("step", "preview");
        ViewUtil.openDialog((AbstractFormPlugin)that, (Map)returnData, (String)"sim_bill_process", (String)"sim_bill_process");
    }

    @CallBackAnnotation(value={"sim_bill_process", "sim_alle_bill_process"}, callback=CallBackEnum.CLOSED)
    public void billProcessCallback(AbstractFormPlugin that, ClosedCallBackEvent event) {
        BillHelper.clearWorkbench((Object[])new Object[]{that.getView().getModel().getDataEntity().getPkValue()});
        that.getView().invokeOperation("refresh");
    }

    @CallBackAnnotation(value={"sim_split_process"}, callback=CallBackEnum.CLOSED)
    public void billSplitProcessCallback(AbstractFormPlugin that, ClosedCallBackEvent event) {
        that.getView().invokeOperation("refresh");
    }

    private void checkOrgPermission(AbstractFormPlugin that) {
        IDataModel model = that.getView().getModel();
        if (!PermissionHelper.checkOrgPermission((AbstractFormPlugin)that, (ImcPermItemEnum)ImcPermItemEnum.IMC_SIM_SHOW_INVOICE, (Long)DynamicObjectUtil.getDynamicObjectLongValue((Object)model.getValue("orgid")))) {
            DynamicObject org = (DynamicObject)model.getValue("orgid");
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709%1$s\u7ec4\u7ec7\u7684%2$s\u6743\u9650\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e", (String)"InvoiceOriginalFormCallBack_1", (String)"imc-sim-formplugin", (Object[])new Object[0]), org.getString("name"), ImcPermItemEnum.IMC_SIM_SHOW_INVOICE));
        }
    }
}

