/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.originalbill.op;

import java.math.BigDecimal;
import java.util.ArrayList;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.sim.formplugin.bill.originalbill.util.Dto.CheckResult;
import kd.imc.sim.formplugin.bill.originalbill.util.OriginalBillFormEditUtil;

public abstract class AbstractOriginalBillSavePlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().addAll(PropertieUtil.addFieldKey((String)"sim_original_bill", (boolean)true));
    }

    public static void checkNormalRedBlueInvoiceSurplusAmount(DynamicObject originBillDynamicObject) {
        String blueInvoiceNo = originBillDynamicObject.getString("blueinvoiceno");
        String invoiceType = originBillDynamicObject.getString("invoicetype");
        if (StringUtils.isBlank((CharSequence)blueInvoiceNo) || InvoiceUtils.isSpecialInvoice((String)invoiceType) || InvoiceUtils.isAllEInvoice((Object)invoiceType)) {
            return;
        }
        QFilter qFilter = new QFilter("invoiceno", "=", (Object)blueInvoiceNo);
        qFilter.and("orgid", "=", (Object)RequestContext.get().getOrgId());
        DynamicObject invoice = QueryServiceHelper.queryOne((String)"sim_vatinvoice", (String)"remainredamount,canredtaxamount", (QFilter[])qFilter.toArray());
        if (null == invoice) {
            return;
        }
        BigDecimal remainRedAmount = invoice.getBigDecimal("remainredamount");
        BigDecimal canRedTaxAmount = invoice.getBigDecimal("canredtaxamount");
        if (remainRedAmount.compareTo(BigDecimalUtil.abs((BigDecimal)originBillDynamicObject.getBigDecimal("surplusamount"))) < 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5269\u4f59\u53ef\u7ea2\u51b2\u91d1\u989d\u5fc5\u987b\u5927\u4e8e\u62df\u5f00\u7ea2\u7968\u91d1\u989d,\u5bf9\u5e94\u84dd\u7968\u5269\u4f59\u53ef\u7ea2\u51b2\u91d1\u989d\u4e3a\uff1a%s", (String)"AbstractOriginalBillSavePlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]), remainRedAmount.setScale(2, 4)));
        }
        if (canRedTaxAmount.compareTo(BigDecimalUtil.abs((BigDecimal)originBillDynamicObject.getBigDecimal("surplustax"))) < 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5269\u4f59\u53ef\u7ea2\u51b2\u7a0e\u989d\u5fc5\u987b\u5927\u4e8e\u62df\u5f00\u7ea2\u7968\u7a0e\u989d,\u5bf9\u5e94\u84dd\u7968\u5269\u4f59\u53ef\u7ea2\u51b2\u7a0e\u989d\u4e3a\uff1a%s", (String)"AbstractOriginalBillSavePlugin_1", (String)"imc-sim-formplugin", (Object[])new Object[0]), canRedTaxAmount.setScale(2, 4)));
        }
    }

    protected static void billSavePluginCheckRed(DynamicObject dynamicObject) {
        if (InvoiceUtils.isSpecialInvoice((String)dynamicObject.getString("invoicetype")) && !AllEleAuthHelper.isElePaper((Object)dynamicObject.get("iselepaper"))) {
            if ("-1".equals(dynamicObject.getString("billproperties")) && (StringUtils.isNotBlank((CharSequence)dynamicObject.getString("blueinvoicecode")) || StringUtils.isNotBlank((CharSequence)dynamicObject.getString("infocode"))) && StringUtils.isBlank((CharSequence)dynamicObject.getString("applicant"))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e:%s\u672a\u586b\u5199\u7533\u8bf7\u65b9", (String)"AbstractOriginalBillSavePlugin_2", (String)"imc-sim-formplugin", (Object[])new Object[0]), dynamicObject.getString("billno")));
            }
        } else {
            CheckResult result = OriginalBillFormEditUtil.checkNormalRedReasonInfo((DynamicObject[])new DynamicObject[]{dynamicObject}, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
            ArrayList errMsgList = result.getErrMsgList();
            if (!errMsgList.isEmpty()) {
                throw new KDBizException((String)errMsgList.get(0));
            }
        }
    }
}

