/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.originalbill.op.validator;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class BillReOpenSelectValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.dataEntities;
        DynamicObject[] billRelation = BusinessDataServiceHelper.load((String)"sim_bill_relation", (String)String.join((CharSequence)",", "tbillid", "sbillid"), (QFilter[])new QFilter("sbillid", "in", (Object)Stream.of(dataEntities).map(ExtendedDataEntity::getBillPkId).toArray()).and("relationtype", "=", (Object)"0").toArray());
        Map<Object, List<DynamicObject>> relationMap = Stream.of(billRelation).collect(Collectors.groupingBy(k -> k.get("sbillid")));
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject bill = dataEntity.getDataEntity();
            try {
                this.checkBill(bill, relationMap);
            }
            catch (KDBizException e) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)e.getMessage(), (String)"BillReOpenSelectValidator_0", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void checkBill(DynamicObject bill, Map<Object, List<DynamicObject>> relationMap) {
        if ("0".equals(bill.getString("confirmstate"))) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s:\u672a\u7533\u8bf7\u5355\u636e\u4e0d\u80fd\u91cd\u5f00", (String)"BillReOpenSelectValidator_1", (String)"imc-sim-formplugin", (Object[])new Object[0]), bill.getString("billno")));
        }
        if ("B".equals(bill.getString("billsourcetype"))) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s:\u7ea2\u51b2\u5355\u636e\u4e0d\u80fd\u91cd\u5f00", (String)"BillReOpenSelectValidator_2", (String)"imc-sim-formplugin", (Object[])new Object[0]), bill.getString("billno")));
        }
        if ("C".equals(bill.getString("billsourcetype"))) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s:\u4f5c\u5e9f\u5355\u636e\u4e0d\u80fd\u91cd\u5f00", (String)"BillReOpenSelectValidator_3", (String)"imc-sim-formplugin", (Object[])new Object[0]), bill.getString("billno")));
        }
        if ("1".equals(bill.getString("closestatus"))) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s:\u5df2\u5173\u95ed\u5355\u636e\u4e0d\u80fd\u91cd\u5f00", (String)"BillReOpenSelectValidator_4", (String)"imc-sim-formplugin", (Object[])new Object[0]), bill.getString("billno")));
        }
        if ("1".equals(bill.getString("validstate"))) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s:\u5df2\u6401\u7f6e\u5355\u636e\u4e0d\u80fd\u91cd\u5f00", (String)"BillReOpenSelectValidator_5", (String)"imc-sim-formplugin", (Object[])new Object[0]), bill.getString("billno")));
        }
        if (!relationMap.containsKey(bill.getPkValue())) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s:\u672a\u751f\u6210\u5bf9\u5e94\u7684\u7ea2\u51b2\u5355\u6216\u4f5c\u5e9f\u5355\uff0c\u65e0\u6cd5\u91cd\u5f00", (String)"BillReOpenSelectValidator_6", (String)"imc-sim-formplugin", (Object[])new Object[0]), bill.getString("billno")));
        }
    }
}

