/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.originalbill.workbench.formplugins;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.imc.bdm.common.util.RandomString;
import kd.imc.sim.common.utils.MathUtils;
import kd.imc.sim.formplugin.bill.originalbill.workbench.dto.SpecifiedDiscountRelationDTO;
import kd.imc.sim.formplugin.bill.splitMerge.helper.BillSplitWorkBenchMergeHelper;

public class BillSplitWorkbenchSpecifiedDiscountRowPlugin
extends AbstractFormPlugin {
    private static final String POSITIVE_RELATION = "positive_relation";

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        ((Label)this.getControl("allamountlabel")).setText((String)customParams.get("allAmount"));
        ((Label)this.getControl("alltaxlabel")).setText((String)customParams.get("allTax"));
        ((Label)this.getControl("alltaxamountlabel")).setText((String)customParams.get("allTaxAmount"));
        this.setPositiveAndNegativeEntry(customParams);
    }

    private void setPositiveAndNegativeEntry(Map<String, Object> customParams) {
        JSONObject billInvoiceJson = (JSONObject)customParams.get("treatmentInvoiceList");
        if (billInvoiceJson == null) {
            return;
        }
        JSONObject originBillInvoicceJson = (JSONObject)customParams.get("origin_treatmentInvoiceList");
        Set billIdSet = billInvoiceJson.keySet();
        for (String billId : billIdSet) {
            JSONArray invoiceArr = billInvoiceJson.getJSONArray(billId);
            JSONArray originInvoiceArr = originBillInvoicceJson.getJSONArray(billId);
            for (int invoiceIndex = 0; invoiceIndex < invoiceArr.size(); ++invoiceIndex) {
                JSONObject invoice = invoiceArr.getJSONObject(invoiceIndex);
                JSONArray originItems = originInvoiceArr.getJSONObject(invoiceIndex).getJSONArray("items");
                JSONArray items = invoice.getJSONArray("items");
                for (int itemIndex = 0; itemIndex < items.size(); ++itemIndex) {
                    int index;
                    JSONObject item = items.getJSONObject(itemIndex);
                    Set<String> billNo = this.getBillNo(originItems, item);
                    if ("2".equals(item.getString("rowtype"))) {
                        JSONObject discountItem = items.getJSONObject(itemIndex + 1);
                        BigDecimal remainTaxAmount = item.getBigDecimal("taxamount").add(discountItem.getBigDecimal("taxamount"));
                        billNo.addAll(this.getBillNo(originItems, discountItem));
                        if (remainTaxAmount.compareTo(BigDecimal.ZERO) < 0) {
                            item.put("taxamount", (Object)remainTaxAmount);
                            item.put("tax", (Object)item.getBigDecimal("tax").add(discountItem.getBigDecimal("tax")));
                            item.put("id", (Object)item.getString("id"));
                            item.put("negativediscountid", discountItem.get((Object)"id"));
                        } else {
                            item.put("discountamount", discountItem.get((Object)"taxamount"));
                            item.put("positivediscountid", discountItem.get((Object)"id"));
                        }
                        ++itemIndex;
                    }
                    if (item.getBigDecimal("taxamount").compareTo(BigDecimal.ZERO) < 0) {
                        index = this.getModel().createNewEntryRow("negativeentry");
                        this.getModel().setValue("negativeid", (Object)item.getString("id"), index);
                        this.getModel().setValue("negativediscountid", (Object)item.getString("negativediscountid"), index);
                        this.getModel().setValue("negative_billno", (Object)String.join((CharSequence)"\u3001", billNo), index);
                        this.getModel().setValue("negative_goodsname", (Object)item.getString("goodsname"), index);
                        this.getModel().setValue("negative_taxrate", (Object)item.getString("taxrate"), index);
                        this.getModel().setValue("negative_taxamount", (Object)item.getBigDecimal("taxamount"), index);
                        this.getModel().setValue("negative_tax", (Object)item.getBigDecimal("tax"), index);
                        this.getModel().setValue("negative_unspecified", (Object)item.getBigDecimal("taxamount"), index);
                        continue;
                    }
                    index = this.getModel().createNewEntryRow("positiveentry");
                    this.getModel().setValue("positiveid", (Object)item.getString("id"), index);
                    this.getModel().setValue("positivediscountid", (Object)item.getString("positivediscountid"), index);
                    this.getModel().setValue("positive_billno", (Object)String.join((CharSequence)"\u3001", billNo), index);
                    this.getModel().setValue("positive_goodsname", (Object)item.getString("goodsname"), index);
                    this.getModel().setValue("positive_taxrate", (Object)item.getString("taxrate"), index);
                    BigDecimal taxAmount = item.getBigDecimal("taxamount");
                    BigDecimal discountAmount = item.getBigDecimal("discountamount");
                    this.getModel().setValue("positive_taxamount", (Object)taxAmount, index);
                    this.getModel().setValue("positive_discountamount", (Object)discountAmount, index);
                    this.getModel().setValue("positive_unspecified", (Object)taxAmount.add(discountAmount), index);
                }
            }
        }
    }

    private Set<String> getBillNo(JSONArray originItems, JSONObject item) {
        String itemIds = item.getString("id");
        HashSet<String> billNoSet = new HashSet<String>(originItems.size());
        for (int i = 0; i < originItems.size(); ++i) {
            JSONObject originItem = originItems.getJSONObject(i);
            if (!itemIds.contains(originItem.getString("id"))) continue;
            billNoSet.add(originItem.getString("billNo"));
        }
        return billNoSet;
    }

    public void afterBindData(EventObject e) {
        EntryGrid grid = (EntryGrid)this.getControl("negativeentry");
        grid.selectRows(0);
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData changeData;
        BigDecimal newValue;
        if ("positive_specifi".equals(e.getProperty().getName()) && (newValue = (BigDecimal)(changeData = e.getChangeSet()[0]).getNewValue()).compareTo(BigDecimal.ZERO) > 0) {
            EntryGrid grid = (EntryGrid)this.getControl("positiveentry");
            DynamicObject[] positiveEntry = grid.getEntryData().getDataEntitys();
            for (int i = 0; i < positiveEntry.length; ++i) {
                BigDecimal specifi = (BigDecimal)this.getModel().getValue("positive_specifi", i);
                if (MathUtils.isNullOrZero((BigDecimal)specifi) || specifi.compareTo(BigDecimal.ZERO) <= 0) continue;
                this.getModel().setValue("positive_specifi", (Object)specifi.negate(), i);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        switch (operateKey = args.getOperateKey()) {
            case "ok": {
                this.specifiedDiscount();
                break;
            }
            case "cancel": {
                this.unSpecifiedDiscount();
            }
        }
    }

    private void specifiedDiscount() {
        BigDecimal specifyTax;
        EntryGrid negativeEntry = (EntryGrid)this.getControl("negativeentry");
        int negativeIndex = negativeEntry.getSelectRows()[0];
        EntryGrid positiveEntry = (EntryGrid)this.getControl("positiveentry");
        int positiveIndex = positiveEntry.getSelectRows()[0];
        BigDecimal specifi = (BigDecimal)this.getModel().getValue("positive_specifi", positiveIndex);
        if (specifi.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        if (specifi.compareTo(BigDecimal.ZERO) > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8d1f\u6570\u7684\u91d1\u989d", (String)"BillSplitWorkbenchSpecifiedDiscountRowPlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            return;
        }
        String taxRateStr = (String)this.getModel().getValue("positive_taxrate", positiveIndex);
        if (!taxRateStr.equals(this.getModel().getValue("negative_taxrate", negativeIndex))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u8d1f\u6570\u884c\u4e0e\u6307\u5b9a\u6b63\u6570\u884c\u7a0e\u7387\u4e0d\u540c\uff0c\u65e0\u6cd5\u6307\u5b9a", (String)"BillSplitWorkbenchSpecifiedDiscountRowPlugin_1", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            return;
        }
        BigDecimal negativeUnSpecified = (BigDecimal)this.getModel().getValue("negative_unspecified", negativeIndex);
        if (specifi.compareTo(negativeUnSpecified) < 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672c\u6b21\u6307\u5b9a\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u9009\u4e2d\u8d1f\u6570\u884c\u5f85\u6307\u5b9a\u542b\u7a0e\u91d1\u989d", (String)"BillSplitWorkbenchSpecifiedDiscountRowPlugin_2", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            return;
        }
        BigDecimal specifiedAmount = (BigDecimal)this.getModel().getValue("positive_specified", positiveIndex);
        BigDecimal unSpecifiedAmount = (BigDecimal)this.getModel().getValue("positive_unspecified", positiveIndex);
        if (specifi.abs().compareTo(unSpecifiedAmount) > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672c\u6b21\u6307\u5b9a\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u5f53\u524d\u6b63\u6570\u884c\u53ef\u88ab\u6307\u5b9a\u91d1\u989d", (String)"BillSplitWorkbenchSpecifiedDiscountRowPlugin_3", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().setValue("positive_specified", (Object)specifiedAmount.add(specifi.abs()));
        this.getModel().setValue("positive_unspecified", (Object)unSpecifiedAmount.subtract(specifi.abs()));
        BigDecimal negativeSpecified = (BigDecimal)this.getModel().getValue("negative_specified", negativeIndex);
        this.getModel().setValue("negative_specified", (Object)negativeSpecified.add(specifi), negativeIndex);
        BigDecimal negativeUnSpecifiedAmount = negativeUnSpecified.subtract(specifi);
        this.getModel().setValue("negative_unspecified", (Object)negativeUnSpecified.subtract(specifi), negativeIndex);
        if (negativeUnSpecifiedAmount.compareTo(BigDecimal.ZERO) == 0) {
            BigDecimal tax = (BigDecimal)this.getModel().getValue("negative_tax", negativeIndex);
            specifyTax = tax.subtract((BigDecimal)this.getModel().getValue("negative_specified_tax", negativeIndex));
        } else {
            BigDecimal taxRate = new BigDecimal(taxRateStr);
            specifyTax = specifi.multiply(taxRate).divide(BigDecimal.ONE.add(taxRate), 2, 4);
        }
        this.getModel().setValue("negative_unspecified", (Object)negativeUnSpecifiedAmount, negativeIndex);
        this.getModel().setValue("negative_specified_tax", (Object)((BigDecimal)this.getModel().getValue("negative_specified_tax", negativeIndex)).add(specifyTax), negativeIndex);
        String negativeId = (String)this.getModel().getValue("negativeid", negativeIndex);
        String positiveId = (String)this.getModel().getValue("positiveid", positiveIndex);
        String positiveRelation = this.getPageCache().get(POSITIVE_RELATION);
        List relationList = JSONObject.parseArray((String)positiveRelation, SpecifiedDiscountRelationDTO.class);
        relationList = relationList == null ? new ArrayList() : relationList;
        Optional<SpecifiedDiscountRelationDTO> first = relationList.stream().filter(relation -> relation.getsBillId().equals(negativeId) && relation.gettBillId().equals(positiveId)).findFirst();
        if (first.isPresent()) {
            SpecifiedDiscountRelationDTO relation2 = first.get();
            relation2.setSpecifiedAmount(relation2.getSpecifiedAmount().add(specifi));
            relation2.setSpecifiedTax(relation2.getSpecifiedTax().add(specifyTax));
        } else {
            relationList.add(new SpecifiedDiscountRelationDTO(negativeId, positiveId, Integer.valueOf(negativeIndex), specifi, specifyTax));
        }
        this.getPageCache().put(POSITIVE_RELATION, JSONObject.toJSONString((Object)relationList));
        this.getModel().setValue("positive_specifi", (Object)BigDecimal.ZERO, positiveIndex);
        this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u6307\u5b9a\u6210\u529f\uff0c\u672c\u6b21\u5df2\u6307\u5b9a%s", (String)"BillSplitWorkbenchSpecifiedDiscountRowPlugin_7", (String)"imc-sim-formplugin", (Object[])new Object[0]), specifi.setScale(2, 4)));
    }

    private void unSpecifiedDiscount() {
        EntryGrid grid = (EntryGrid)this.getControl("positiveentry");
        int selectIndex = grid.getSelectRows()[0];
        BigDecimal positiveSpecifiedAmount = (BigDecimal)this.getModel().getValue("positive_specified", selectIndex);
        if (positiveSpecifiedAmount.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        BigDecimal taxAmount = ((BigDecimal)this.getModel().getValue("positive_taxamount", selectIndex)).add((BigDecimal)this.getModel().getValue("positive_discountamount", selectIndex));
        this.getModel().setValue("positive_specified", (Object)BigDecimal.ZERO, selectIndex);
        this.getModel().setValue("positive_unspecified", (Object)taxAmount, selectIndex);
        String positiveId = (String)this.getModel().getValue("positiveid", selectIndex);
        List relationList = JSONObject.parseArray((String)this.getPageCache().get(POSITIVE_RELATION), SpecifiedDiscountRelationDTO.class);
        List relations = relationList.stream().filter(relation -> relation.gettBillId().equals(positiveId)).collect(Collectors.toList());
        for (SpecifiedDiscountRelationDTO relation2 : relations) {
            Integer index = relation2.getIndex();
            BigDecimal specifiedAmount = (BigDecimal)this.getModel().getValue("negative_specified", index.intValue());
            BigDecimal unSpecifiedAmount = (BigDecimal)this.getModel().getValue("negative_unspecified", index.intValue());
            BigDecimal specifiedTax = (BigDecimal)this.getModel().getValue("negative_specified_tax", index.intValue());
            this.getModel().setValue("negative_specified", (Object)specifiedAmount.subtract(relation2.getSpecifiedAmount()), index.intValue());
            this.getModel().setValue("negative_unspecified", (Object)unSpecifiedAmount.add(relation2.getSpecifiedAmount()), index.intValue());
            this.getModel().setValue("negative_specified_tax", (Object)specifiedTax.subtract(relation2.getSpecifiedTax()), index.intValue());
        }
        relationList.removeAll(relations);
        this.getPageCache().put(POSITIVE_RELATION, JSONObject.toJSONString((Object)relationList));
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u6307\u5b9a\u6210\u529f", (String)"BillSplitWorkbenchSpecifiedDiscountRowPlugin_5", (String)"imc-sim-formplugin", (Object[])new Object[0]));
    }

    public void click(EventObject evt) {
        EntryGrid negativeEntry = (EntryGrid)this.getControl("negativeentry");
        DynamicObject[] negativeObjs = negativeEntry.getEntryData().getDataEntitys();
        for (int i = 0; i < negativeObjs.length; ++i) {
            BigDecimal unspecifiedAmount = negativeObjs[i].getBigDecimal("negative_unspecified");
            if (unspecifiedAmount.compareTo(BigDecimal.ZERO) == 0) continue;
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5f85\u6307\u5b9a\u8d1f\u6570\u884c\u7684\u5f85\u6307\u5b9a\u542b\u7a0e\u91d1\u989d\u4e0d\u4e3a0", (String)"BillSplitWorkbenchSpecifiedDiscountRowPlugin_6", (String)"imc-sim-formplugin", (Object[])new Object[0]), i + 1));
            return;
        }
        this.createInvoiceItemsAndRelation();
    }

    private void createInvoiceItemsAndRelation() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        JSONObject billInvoiceJson = (JSONObject)customParams.get("treatmentInvoiceList");
        String mergeBillId = billInvoiceJson.keySet().toArray(new String[0])[0];
        JSONObject mergeInvoice = billInvoiceJson.getJSONArray(mergeBillId).getJSONObject(0);
        Map<String, JSONObject> idItemsMap = mergeInvoice.getJSONArray("items").stream().map(item -> (JSONObject)item).collect(Collectors.toMap(k -> k.getString("id"), v -> v, (v1, v2) -> v1));
        JSONObject invRelation = (JSONObject)customParams.get("invRealtion");
        List<JSONObject> relationList = invRelation.getJSONArray(mergeBillId).stream().map(relation -> (JSONObject)relation).collect(Collectors.toList());
        List specifiedDiscountRelationList = JSONObject.parseArray((String)this.getPageCache().get(POSITIVE_RELATION), SpecifiedDiscountRelationDTO.class);
        EntryGrid entry = (EntryGrid)this.getControl("positiveentry");
        DynamicObject[] positiveEntry = entry.getEntryData().getDataEntitys();
        JSONArray newItems = new JSONArray();
        JSONArray newRelations = new JSONArray();
        ArrayList<SpecifiedDiscountRelationDTO> relationArr = new ArrayList<SpecifiedDiscountRelationDTO>();
        for (DynamicObject positive : positiveEntry) {
            BigDecimal specifiedAmount;
            String positiveId = positive.getString("positiveid");
            JSONObject normalItem = idItemsMap.get(positiveId);
            newItems.add((Object)normalItem);
            newRelations.addAll((Collection)relationList.stream().filter(relation -> relation.getString("tdetailid").equals(normalItem.getString("id"))).collect(Collectors.toList()));
            String discountId = positive.getString("positivediscountid");
            if (StringUtils.isNotBlank((CharSequence)discountId)) {
                JSONObject originDiscountItem = idItemsMap.get(discountId);
                newItems.add((Object)originDiscountItem);
                newRelations.addAll((Collection)relationList.stream().filter(relation -> relation.getString("tdetailid").equals(originDiscountItem.getString("id"))).collect(Collectors.toList()));
            }
            if ((specifiedAmount = positive.getBigDecimal("positive_specified")).compareTo(BigDecimal.ZERO) == 0) continue;
            List<SpecifiedDiscountRelationDTO> specifiedDiscountRelations = specifiedDiscountRelationList.stream().filter(relation -> relation.gettBillId().equals(positiveId)).collect(Collectors.toList());
            relationArr.addAll(this.dealSpecifiedDiscountRow(newItems, normalItem, specifiedDiscountRelations));
        }
        newRelations.addAll((Collection)this.dealRelations(relationList, relationArr));
        mergeInvoice.put("mergelable", (Object)"1");
        mergeInvoice.put("items", (Object)newItems);
        invRelation.put(mergeBillId, (Object)newRelations);
        customParams.put("treatmentInvoiceList", billInvoiceJson);
        customParams.put("invRealtion", invRelation);
        this.getView().returnDataToParent((Object)customParams);
        this.getView().close();
    }

    private List<SpecifiedDiscountRelationDTO> dealSpecifiedDiscountRow(JSONArray newItems, JSONObject normalClone, List<SpecifiedDiscountRelationDTO> specifiedDiscountRelations) {
        ArrayList<SpecifiedDiscountRelationDTO> relationArr = new ArrayList<SpecifiedDiscountRelationDTO>(specifiedDiscountRelations.size());
        for (SpecifiedDiscountRelationDTO specifiedDiscountRelation : specifiedDiscountRelations) {
            JSONObject preItem = newItems.getJSONObject(newItems.size() - 1);
            boolean isExistDiscountRow = "1".equals(preItem.getString("rowtype"));
            SpecifiedDiscountRelationDTO relation = new SpecifiedDiscountRelationDTO(specifiedDiscountRelation.getsBillId(), specifiedDiscountRelation.getSpecifiedAmount(), specifiedDiscountRelation.getSpecifiedTax());
            if (isExistDiscountRow) {
                preItem.put("taxamount", (Object)preItem.getBigDecimal("taxamount").add(specifiedDiscountRelation.getSpecifiedAmount()));
                preItem.put("tax", (Object)preItem.getBigDecimal("tax").add(specifiedDiscountRelation.getSpecifiedTax()));
                preItem.put("amount", (Object)preItem.getBigDecimal("amount").add(specifiedDiscountRelation.getSpecifiedAmount().subtract(specifiedDiscountRelation.getSpecifiedTax())));
                relation.settBillId(preItem.getString("id"));
            } else {
                preItem.put("rowtype", (Object)"2");
                JSONObject negativeClone = BillSplitWorkBenchMergeHelper.cloneJSONObject((JSONObject)normalClone);
                negativeClone.put("id", (Object)("items" + RandomString.getRandom((int)32)));
                negativeClone.put("taxamount", (Object)specifiedDiscountRelation.getSpecifiedAmount());
                negativeClone.put("tax", (Object)specifiedDiscountRelation.getSpecifiedTax());
                negativeClone.put("amount", (Object)specifiedDiscountRelation.getSpecifiedAmount().subtract(specifiedDiscountRelation.getSpecifiedTax()));
                negativeClone.put("num", null);
                negativeClone.put("unitprice", null);
                negativeClone.put("taxunitprice", null);
                negativeClone.put("specification", (Object)"");
                negativeClone.put("unit", (Object)"");
                negativeClone.put("rowtype", (Object)"1");
                newItems.add((Object)negativeClone);
                relation.settBillId(negativeClone.getString("id"));
            }
            relationArr.add(relation);
        }
        return relationArr;
    }

    private JSONArray dealRelations(List<JSONObject> relationList, List<SpecifiedDiscountRelationDTO> specifiedDiscountRelationList) {
        JSONArray relationArr = new JSONArray();
        EntryGrid negativeEntry = (EntryGrid)this.getControl("negativeentry");
        DynamicObject[] negativeArr = negativeEntry.getEntryData().getDataEntitys();
        Map<String, String> negativeDiscountMap = Arrays.stream(negativeArr).collect(Collectors.toMap(k -> k.getString("negativeid"), v -> v.getString("negativediscountid"), (v1, v2) -> v1));
        Map<String, List<SpecifiedDiscountRelationDTO>> relationGroup = specifiedDiscountRelationList.stream().collect(Collectors.groupingBy(SpecifiedDiscountRelationDTO::getsBillId));
        Set<Map.Entry<String, List<SpecifiedDiscountRelationDTO>>> entries = relationGroup.entrySet();
        for (Map.Entry<String, List<SpecifiedDiscountRelationDTO>> entry : entries) {
            String negativeDiscountId = negativeDiscountMap.get(entry.getKey());
            List relations = relationList.stream().filter(relation -> relation.getString("tdetailid").equals(entry.getKey()) || relation.getString("tdetailid").equals(negativeDiscountId)).sorted(Comparator.comparing(relation -> relation.getBigDecimal("amount"))).collect(Collectors.toList());
            List<SpecifiedDiscountRelationDTO> specifiedDiscountRelations = entry.getValue();
            for (int i = 0; i < specifiedDiscountRelations.size(); ++i) {
                JSONObject newRelation;
                SpecifiedDiscountRelationDTO specifiedDiscountRelation = specifiedDiscountRelations.get(i);
                Iterator iterator = relations.iterator();
                while (iterator.hasNext()) {
                    JSONObject relation2 = (JSONObject)iterator.next();
                    BigDecimal amount = specifiedDiscountRelation.getSpecifiedAmount().subtract(specifiedDiscountRelation.getSpecifiedTax());
                    newRelation = BillSplitWorkBenchMergeHelper.cloneJSONObject((JSONObject)relation2);
                    if (amount.compareTo(relation2.getBigDecimal("amount")) <= 0) {
                        newRelation.put("tdetailid", (Object)specifiedDiscountRelation.gettBillId());
                        newRelation.put("price", null);
                        newRelation.put("num", null);
                        specifiedDiscountRelation.setSpecifiedAmount(specifiedDiscountRelation.getSpecifiedAmount().subtract(relation2.getBigDecimal("amount")).subtract(relation2.getBigDecimal("tax")));
                        specifiedDiscountRelation.setSpecifiedTax(specifiedDiscountRelation.getSpecifiedTax().subtract(relation2.getBigDecimal("tax")));
                        relationArr.add((Object)newRelation);
                        iterator.remove();
                        continue;
                    }
                    newRelation.put("amount", (Object)amount);
                    newRelation.put("tax", (Object)specifiedDiscountRelation.getSpecifiedTax());
                    newRelation.put("tdetailid", (Object)specifiedDiscountRelation.gettBillId());
                    newRelation.put("price", null);
                    newRelation.put("num", null);
                    relation2.put("amount", (Object)relation2.getBigDecimal("amount").subtract(amount));
                    relation2.put("tax", (Object)relation2.getBigDecimal("tax").subtract(specifiedDiscountRelation.getSpecifiedTax()));
                    relationArr.add((Object)newRelation);
                    break;
                }
                if (CollectionUtils.isEmpty(relations) || i != specifiedDiscountRelations.size() - 1) continue;
                for (JSONObject relation3 : relations) {
                    newRelation = BillSplitWorkBenchMergeHelper.cloneJSONObject((JSONObject)relation3);
                    newRelation.put("price", null);
                    newRelation.put("num", null);
                    newRelation.put("tdetailid", (Object)specifiedDiscountRelation.gettBillId());
                    relationArr.add((Object)newRelation);
                }
            }
        }
        return relationArr;
    }

    private static class PositiveEntry {
        private static final String ENTRY_NAME = "positiveentry";
        private static final String POSITIVEID = "positiveid";
        private static final String POSITIVEDISCOUNTID = "positivediscountid";
        private static final String POSITIVE_BILLNO = "positive_billno";
        private static final String POSITIVE_GOODSNAME = "positive_goodsname";
        private static final String POSITIVE_TAXRATE = "positive_taxrate";
        private static final String POSITIVE_TAXAMOUNT = "positive_taxamount";
        private static final String POSITIVE_DISCOUNTAMOUNT = "positive_discountamount";
        private static final String POSITIVE_SPECIFIED = "positive_specified";
        private static final String POSITIVE_UNSPECIFIED = "positive_unspecified";
        private static final String POSITIVE_SPECIFI = "positive_specifi";

        private PositiveEntry() {
        }
    }

    private static class NegativeEntry {
        private static final String ENTRY_NAME = "negativeentry";
        private static final String NEGATIVEID = "negativeid";
        private static final String NEGATIVEDISCOUNTID = "negativediscountid";
        private static final String NEGATIVE_BILLNO = "negative_billno";
        private static final String NEGATIVE_GOODSNAME = "negative_goodsname";
        private static final String NEGATIVE_TAXRATE = "negative_taxrate";
        private static final String NEGATIVE_TAX = "negative_tax";
        private static final String NEGATIVE_SPECIFIED_TAX = "negative_specified_tax";
        private static final String NEGATIVE_TAXAMOUNT = "negative_taxamount";
        private static final String NEGATIVE_SPECIFIED = "negative_specified";
        private static final String NEGATIVE_UNSPECIFIED = "negative_unspecified";

        private NegativeEntry() {
        }
    }
}

