/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.billpreview;

import com.alibaba.fastjson.JSON;
import java.util.EventObject;
import java.util.List;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.imc.bdm.common.dto.BillFreightItemVo;
import kd.imc.bdm.common.dto.allelespecial.BillCoBuyerItemVo;
import kd.imc.bdm.common.dto.allelespecial.BillEstateSaleItemVo;
import kd.imc.bdm.common.dto.allelespecial.BillTravlerInfoVo;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.sim.common.billpreview.BillPreviewData;
import kd.imc.sim.common.enums.TransportTypeEnum;
import kd.imc.sim.untrans.SimFormPluginConstellationUntrans;

public class InvoicePreviewElePlugin
extends AbstractFormPlugin
implements SimFormPluginConstellationUntrans {
    public void afterCreateNewData(EventObject e) {
        int currentRow = Integer.parseInt(this.getView().getParentView().getPageCache().get("CurrentRow"));
        List datasList = JSON.parseArray((String)this.getView().getParentView().getPageCache().get("Bill" + currentRow), BillPreviewData.class);
        int invoiceIndex = Integer.parseInt(this.getView().getParentView().getPageCache().get("invoiceIndex"));
        for (BillPreviewData billPreviewData : datasList) {
            if (billPreviewData.getBillSeq() != invoiceIndex) continue;
            switch (((BillPreviewData)datasList.get(0)).getInvoicetype()) {
                case "08xdp": {
                    this.writeEleData(billPreviewData, "\u6570\u7535\u7968\uff08\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\uff09", invoiceIndex, datasList.size());
                    break;
                }
                case "10xdp": {
                    this.writeEleData(billPreviewData, "\u6570\u7535\u7968\uff08\u666e\u901a\u53d1\u7968\uff09", invoiceIndex, datasList.size());
                }
            }
        }
    }

    private void writeEleData(BillPreviewData data, String title, int index, int num) {
        block25: {
            String specialtype;
            block24: {
                specialtype = data.getSpecialtype();
                this.getView().setVisible(Boolean.valueOf(!"E04".equals(specialtype)), new String[]{"flexpanelap13"});
                this.getView().setVisible(Boolean.valueOf("E04".equals(specialtype)), new String[]{"flexpanelap131", "flexpanelap132"});
                this.getView().setVisible(Boolean.valueOf("E09".equals(specialtype)), new String[]{"travelersflex"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"estateid", "areaunit", "address", "buildingname"});
                switch (specialtype) {
                    case "E01": {
                        title = title + " --\u6210\u54c1\u6cb9";
                        break;
                    }
                    case "E03": {
                        title = title + " --\u5efa\u7b51\u670d\u52a1";
                        this.getView().setVisible(Boolean.valueOf(true), new String[]{"address", "buildingname"});
                        this.getView().setVisible(Boolean.valueOf(false), new String[]{"specification", "unit", "num", "unitprice"});
                        break;
                    }
                    case "E04": {
                        title = title + "--\u8d27\u7269\u8fd0\u8f93\u670d\u52a1";
                        break;
                    }
                    case "E06": {
                        title = title + " --\u4e0d\u52a8\u4ea7\u79df\u8d41\u670d\u52a1";
                        this.getView().setVisible(Boolean.valueOf(true), new String[]{"estateid", "areaunit"});
                        this.getView().setVisible(Boolean.valueOf(false), new String[]{"num", "unitprice"});
                        break;
                    }
                    case "E05": {
                        title = title + " --\u4e0d\u52a8\u4ea7\u9500\u552e\u670d\u52a1";
                        this.getView().setVisible(Boolean.valueOf(true), new String[]{"estateid", "areaunit"});
                        this.getView().setVisible(Boolean.valueOf(false), new String[]{"num", "unitprice"});
                        break;
                    }
                    case "02": {
                        title = title + "\uff08\u6536\u8d2d\uff09";
                        break;
                    }
                    case "E09": {
                        title = title + " --\u65c5\u5ba2\u8fd0\u8f93\u670d\u52a1";
                    }
                }
                this.getView().getModel().setValue("title", (Object)title);
                this.getView().getModel().setValue("index", (Object)(index + 1));
                this.getView().getModel().setValue("indextotal", (Object)num);
                this.getView().getModel().setValue("buyername", (Object)data.getBuyername());
                this.getView().getModel().setValue("buyertaxno", (Object)data.getBuyertaxno());
                this.getView().getModel().setValue("totalamountpro", (Object)data.getTotalamountbig());
                this.getView().getModel().setValue("totalamount", (Object)data.getTotalamount());
                this.getView().getModel().setValue("salername", (Object)data.getSalername());
                this.getView().getModel().setValue("salertaxno", (Object)data.getSalertaxno());
                this.getView().getModel().setValue("drawer", (Object)data.getDrawer());
                this.getView().getModel().setValue("remark", (Object)data.getRemark());
                for (int i = 0; i < data.getItems().size(); ++i) {
                    block19: for (BillPreviewData.items item : data.getItems()) {
                        int itemIndex;
                        IDataModel modelDetail;
                        if (!String.valueOf(i).equals(item.getSeq())) continue;
                        if ("E04".equals(specialtype)) {
                            modelDetail = this.getView().getControl("entryentity1").getModel();
                            itemIndex = this.getView().getModel().createNewEntryRow("entryentity1");
                            modelDetail.setValue("goodsname1", (Object)item.getGoodsname(), itemIndex);
                            modelDetail.setValue("specification1", (Object)item.getSpecification(), itemIndex);
                            modelDetail.setValue("unit1", (Object)item.getUnit(), itemIndex);
                            modelDetail.setValue("num1", (Object)item.getNum(), itemIndex);
                            modelDetail.setValue("unitprice1", (Object)item.getUnitprice(), itemIndex);
                            modelDetail.setValue("amount1", (Object)item.getAmount(), itemIndex);
                            modelDetail.setValue("taxrate1", (Object)item.getTaxrate(), itemIndex);
                            modelDetail.setValue("tax1", (Object)item.getTax(), itemIndex);
                            continue;
                        }
                        modelDetail = this.getView().getControl("entryentity").getModel();
                        itemIndex = this.getView().getModel().createNewEntryRow("entryentity");
                        modelDetail.setValue("goodsname", (Object)item.getGoodsname(), itemIndex);
                        modelDetail.setValue("estateid", (Object)data.getEstateid(), itemIndex);
                        modelDetail.setValue("specification", (Object)item.getSpecification(), itemIndex);
                        modelDetail.setValue("areaunit", (Object)data.getAreaunit(), itemIndex);
                        modelDetail.setValue("unit", (Object)item.getUnit(), itemIndex);
                        modelDetail.setValue("num", (Object)item.getNum(), itemIndex);
                        modelDetail.setValue("unitprice", (Object)item.getUnitprice(), itemIndex);
                        modelDetail.setValue("buildingname", (Object)data.getBuildingname(), itemIndex);
                        modelDetail.setValue("address", (Object)(data.getSimpleaddress() + data.getDetailaddress()), itemIndex);
                        modelDetail.setValue("amount", (Object)item.getAmount(), itemIndex);
                        modelDetail.setValue("taxrate", (Object)item.getTaxrate(), itemIndex);
                        modelDetail.setValue("tax", (Object)item.getTax(), itemIndex);
                        if (!"E05".equals(specialtype)) continue;
                        for (int j = 0; j < data.getEstatesales().size(); ++j) {
                            if (i != j) continue;
                            modelDetail.setValue("areaunit", (Object)((BillEstateSaleItemVo)data.getEstatesales().get(j)).getAreaunit(), itemIndex);
                            modelDetail.setValue("estateid", (Object)((BillEstateSaleItemVo)data.getEstatesales().get(j)).getEstateId(), itemIndex);
                            continue block19;
                        }
                    }
                }
                if (!"E04".equals(specialtype)) break block24;
                IDataModel modelDetail = this.getView().getControl("entryentity2").getModel();
                for (BillFreightItemVo freight : data.getFreights()) {
                    int itemIndex = this.getView().getModel().createNewEntryRow("entryentity2");
                    modelDetail.setValue("transporttype", (Object)freight.getTransportType(), itemIndex);
                    modelDetail.setValue("licenseplate", (Object)freight.getLicensePlate(), itemIndex);
                    modelDetail.setValue("startplace", (Object)freight.getStartPlace(), itemIndex);
                    modelDetail.setValue("endplace", (Object)freight.getEndPlace(), itemIndex);
                    modelDetail.setValue("transportgoods", (Object)freight.getTransportGoods(), itemIndex);
                }
                break block25;
            }
            if (!"E09".equals(specialtype)) break block25;
            IDataModel modelDetail = this.getView().getControl("travelers").getModel();
            for (BillTravlerInfoVo traveler : data.getTravelers()) {
                int itemIndex = this.getView().getModel().createNewEntryRow("travelers");
                modelDetail.setValue("traveler", (Object)traveler.getTraveler(), itemIndex);
                modelDetail.setValue("travelercardtype", (Object)BillCoBuyerItemVo.CoBuyerTypeEnum.formatNameByCode((String)traveler.getCardType()), itemIndex);
                modelDetail.setValue("travelercardno", (Object)traveler.getCardNo(), itemIndex);
                modelDetail.setValue("traveldate", (Object)DateUtils.dateFormatStringToString((String)traveler.getTravelDate(), (String)"yyyy-MM-dd HH:mm:ss", (String)"yyyy-MM-dd"), itemIndex);
                modelDetail.setValue("travelerstartplace", (Object)traveler.getStartPlace(), itemIndex);
                modelDetail.setValue("travelerendplace", (Object)traveler.getEndPlace(), itemIndex);
                modelDetail.setValue("travelertransporttype", (Object)TransportTypeEnum.getDescByCode((String)traveler.getTransportType()), itemIndex);
                modelDetail.setValue("travelerseatclass", (Object)traveler.getSeatClass(), itemIndex);
            }
        }
    }
}

