/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.decalaration;

import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.EventObject;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.imc.bdm.common.constant.ImcPermItemEnum;
import kd.imc.bdm.common.constant.table.BgdBillConstant;
import kd.imc.bdm.common.helper.PermissionHelper;
import kd.imc.bdm.common.helper.UnitTestHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.sim.common.dto.bgd.response.BgdCollectResponse;
import kd.imc.sim.common.dto.bgd.service.BgdCollectDTO;
import kd.imc.sim.declarationbill.service.BgdCollectService;
import kd.imc.sim.declarationbill.service.BgdServiceFactory;

public class CollectDeclarationFormPlugin
extends AbstractFormPlugin {
    private static final String BTN_COLLECT = "btnok";

    public void afterCreateNewData(EventObject e) {
        String tip = String.format(ResManager.loadKDString((String)"1\u3001\u5f53\u524d\u91c7\u96c6\u9884\u5f55\u5165\u62a5\u5173\u5355\u6570\u636e\uff0c\u53ef\u83b7\u53d6\u6570\u636e\u4e3a\u7533\u62a5\u65e5\u671fT+1%1$s2\u3001\u672a\u7ed3\u5173\u6570\u636e\u53ef\u80fd\u65e0\u51fa\u53e3\u65e5\u671f\uff0c\u5982\u4f7f\u7528\u51fa\u53e3\u65e5\u671f\u4f5c\u4e3a\u57fa\u51c6\u6c47\u7387\uff0c\u8bf7\u624b\u52a8\u8865\u5145\u51fa\u53e3\u65e5\u671f%2$s3\u3001\u62a5\u5173\u5355\u5982\u5b58\u5728\u53d8\u66f4\uff0c\u8bf7\u91cd\u65b0\u91c7\u96c6\u3002\u91cd\u65b0\u91c7\u96c6\u540e\uff0c\u672a\u4e0b\u63a8\u5f00\u7968\u7533\u8bf7\u5355\u7684\u62a5\u5173\u5355\u5c06\u88ab\u66f4\u65b0\u4e3a\u6700\u65b0\u6570\u636e\u3002\u5728\u91c7\u96c6\u5b8c\u6210\u524d\uff0c\u8bf7\u4fdd\u6301\u7535\u5b50\u53e3\u5cb8\u5361\u5904\u4e8e\u767b\u5f55\u72b6\u6001\u3002", (String)"CollectDeclarationFormPlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]), System.lineSeparator(), System.lineSeparator());
        this.getModel().setValue("tips", (Object)tip);
        this.getModel().setValue("org", (Object)RequestContext.get().getOrgId());
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_COLLECT});
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (BTN_COLLECT.equals(key)) {
            this.checkParam();
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (!PermissionHelper.checkOrgPermission((AbstractFormPlugin)this, (ImcPermItemEnum)ImcPermItemEnum.IMC_BGD_COLLECT, (String)"sim_declaration_bill", (Long)org.getLong("id"))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u201c\u62a5\u5173\u5355\u201d\u7684\u201c\u62a5\u5173\u5355\u91c7\u96c6\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"CollectDeclarationFormPlugin_6", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            }
            BgdCollectDTO bgdCollectDTO = new BgdCollectDTO();
            Date startTime = (Date)this.getModel().getValue("starttime");
            Date endTime = (Date)this.getModel().getValue("endtime");
            String completeStatus = (String)this.getModel().getValue("completestatus");
            if (UnitTestHelper.isUnitTest()) {
                startTime = new Date();
                endTime = new Date();
            }
            String entryid = (String)this.getModel().getValue("entryid");
            bgdCollectDTO.setStart(startTime);
            bgdCollectDTO.setEnd(endTime);
            bgdCollectDTO.setOrg(org);
            bgdCollectDTO.setBgdSource(BgdBillConstant.BgdSource.XU_NUO);
            bgdCollectDTO.setCompleteStatusCode(completeStatus);
            bgdCollectDTO.setEntryid(entryid);
            BgdCollectService collectService = BgdServiceFactory.getCollectService((BgdCollectDTO)bgdCollectDTO);
            BgdCollectResponse response = collectService.collect(bgdCollectDTO);
            this.getModel().setValue("starttime", null);
            this.getModel().setValue("endtime", null);
            if (ErrorType.SUCCESS.getCode().equals(response.getErrorCode())) {
                this.getView().returnDataToParent((Object)JSONObject.toJSONString((Object)response));
                this.getView().close();
            } else {
                this.getView().showErrorNotification(response.getErrorMsg());
            }
        }
    }

    private void checkParam() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (null == org) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u5fc5\u586b", (String)"CollectDeclarationFormPlugin_7", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        Date startTime = (Date)this.getModel().getValue("starttime");
        Date endTime = (Date)this.getModel().getValue("endtime");
        if (UnitTestHelper.isUnitTest()) {
            return;
        }
        if (null == startTime || null == endTime) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7533\u62a5\u65e5\u671f\u8d77\u6b62\u5fc5\u586b", (String)"CollectDeclarationFormPlugin_8", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        int i = DateUtils.timeDifferenceDay((Date)startTime, (Date)endTime);
        if (i > 31) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7533\u62a5\u65e5\u671f\u8303\u56f4\u9700\u8981\u5c0f\u4e8e31\u5929", (String)"CollectDeclarationFormPlugin_9", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
    }
}

