/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.decalaration.convert;

import java.util.HashMap;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.table.InvIssueTitleConstant;
import kd.imc.bdm.common.enums.CacheKeyEnum;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;

public class FillDataConvertPlugin
extends AbstractConvertPlugIn {
    private static final String BOTH = "1";
    private static final String THREE = "0";
    private static final String FOUR = "2";

    public void afterConvert(AfterConvertEventArgs e) {
        String tgtName = this.getTgtMainType().getName();
        ExtendedDataEntity[] extendedDataEntities = e.getTargetExtDataEntitySet().FindByEntityKey(tgtName);
        HashSet<Long> orgPks = new HashSet<Long>();
        HashSet<String> buyerNameSet = new HashSet<String>();
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            DynamicObject bill = extendedDataEntity.getDataEntity();
            long orgPk = DynamicObjectUtil.getDynamicObjectLongValue((Object)bill.get("orgid"));
            orgPks.add(orgPk);
            buyerNameSet.add(bill.getString("buyername"));
        }
        DynamicObject[] buyerTitles = BusinessDataServiceHelper.load((String)"bdm_invice_title_strate", (String)"name,taxno,eleschedule", (QFilter[])new QFilter("name", "in", (Object)buyerNameSet.toArray()).toArray());
        HashMap<String, DynamicObject> nameTaxNoMap = new HashMap<String, DynamicObject>();
        HashMap<String, DynamicObject> nameMap = new HashMap<String, DynamicObject>();
        for (DynamicObject buyerTitle : buyerTitles) {
            nameTaxNoMap.put(buyerTitle.getString("name") + buyerTitle.getString("taxno"), buyerTitle);
            nameMap.put(buyerTitle.getString("name"), buyerTitle);
        }
        DynamicObject[] dynamicObjectArray = BusinessDataServiceHelper.load((String)"bdm_org", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_org"), (QFilter[])new QFilter("id", "in", (Object)orgPks.toArray()).toArray());
        HashMap<Long, DynamicObject> orgPkMap = new HashMap<Long, DynamicObject>();
        for (DynamicObject dynamicObject : dynamicObjectArray) {
            orgPkMap.put(dynamicObject.getLong("id"), dynamicObject);
        }
        for (DynamicObject dynamicObject : extendedDataEntities) {
            DynamicObject bill = dynamicObject.getDataEntity();
            String billProperties = bill.getString("billproperties");
            if (BOTH.equals(billProperties)) continue;
            long orgPk = DynamicObjectUtil.getDynamicObjectLongValue((Object)bill.get("orgid"));
            DynamicObject org = (DynamicObject)orgPkMap.get(orgPk);
            String salerEleSchedule = null;
            if (null != org) {
                salerEleSchedule = dynamicObjectArray[0].getString("epinfo.eleschedule");
            }
            String buyerName = bill.getString("buyername");
            String buyerTaxNo = bill.getString("buyertaxno");
            DynamicObject title = (DynamicObject)nameTaxNoMap.get(buyerName + buyerTaxNo);
            String value = ImcConfigUtil.getValue((CacheKeyEnum)CacheKeyEnum.ELE_SCHEDULE_USE_UNLY_NAME);
            if (null == title && CacheKeyEnum.ELE_SCHEDULE_USE_UNLY_NAME.getConfigKey().equals(value)) {
                title = (DynamicObject)nameMap.get(buyerName);
            }
            String buyerSchedule = null;
            if (null != title) {
                buyerSchedule = title.getString(InvIssueTitleConstant.ELE_SCHEDULE);
            }
            String caStatus = dynamicObjectArray[0].getString("epinfo.castatus");
            String invoiceType = bill.getString("invoicetype");
            boolean caApplied = BOTH.equalsIgnoreCase(caStatus);
            if (!BOTH.equals(salerEleSchedule) || !THREE.equals(buyerSchedule) && !BOTH.equals(buyerSchedule) || !InvoiceUtils.isAllEInvoice((Object)invoiceType)) continue;
            if (InvoiceType.ALL_E_NORMAL.getTypeCode().equals(invoiceType)) {
                String invoiceTypeCode = caApplied ? InvoiceType.ELECTRICAL_NORMAL_INVOICE.getTypeCode() : InvoiceType.PAPER_NOMAL_INVOICE.getTypeCode();
                bill.set("invoicetype", (Object)invoiceTypeCode);
            }
            if (!InvoiceType.ALL_E_SPECIAL.getTypeCode().equals(invoiceType)) continue;
            bill.set("invoicetype", (Object)InvoiceType.PAPER_SPECIAL_INVOICE.getTypeCode());
        }
    }
}

