/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.giftreceipt.op.validater;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.sim.common.utils.MathUtils;

public class GiftReceiptSaveValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.dataEntities) {
            DynamicObject giftReceipt = dataEntity.getDataEntity();
            try {
                DynamicObjectCollection items2 = giftReceipt.getDynamicObjectCollection("items");
                String source = giftReceipt.getString("source");
                if (!"billcenter".equals(source)) {
                    long orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)giftReceipt.get("org"));
                    DynamicObject giftSetting = BusinessDataServiceHelper.loadSingle((String)"bdm_st_qr_code_manage", (String)"limit", (QFilter[])new QFilter("orgid", "=", (Object)orgId).toArray());
                    if (giftSetting != null) {
                        BigDecimal limit = giftSetting.getBigDecimal("limit");
                        BigDecimal invoiceAmount = items2.stream().map(item -> item.getBigDecimal("taxamount").subtract(item.getBigDecimal("tax"))).reduce(BigDecimal.ZERO, BigDecimal::add);
                        if (invoiceAmount.compareTo(limit) > 0) {
                            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8d85\u8fc7\u5c0f\u7968\u7801\u9650\u989d\uff0c\u5c0f\u7968\u7801\u9650\u989d\u4e3a[%s]", (String)"GiftReceiptSaveValidator_0", (String)"imc-sim-formplugin", (Object[])new Object[0]), limit.setScale(2, 4)));
                        }
                    }
                } else {
                    String availableInvoiceType = giftReceipt.getString("availableinvoicetype");
                    if (StringUtils.isBlank((CharSequence)availableInvoiceType)) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53ef\u9009\u7968\u79cd\u4e0d\u80fd\u4e3a\u7a7a", (String)"GiftReceiptSaveValidator_8", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                    }
                }
                if (!InvoiceUtils.isAllEInvoice((Object)giftReceipt.getString("invoicetype")) && StringUtils.isBlank((CharSequence)giftReceipt.getString("jqbh"))) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53d1\u7968\u79cd\u7c7b\u975e\u6570\u7535\uff0c\u8bbe\u5907\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"GiftReceiptSaveValidator_1", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                }
                for (int i = 0; i < items2.size(); ++i) {
                    DynamicObject item2 = (DynamicObject)items2.get(i);
                    String rowType = item2.getString("rowtype");
                    BigDecimal taxAmount = item2.getBigDecimal("taxamount");
                    if ("1".equals(rowType)) {
                        if (i == 0) {
                            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u660e\u7ec6\u6298\u6263\u884c\u4e0a\u4e00\u884c\u4e0d\u80fd\u4e3a\u6298\u6263\u884c", (String)"GiftReceiptSaveValidator_2", (String)"imc-sim-formplugin", (Object[])new Object[0]), i + 1));
                            continue;
                        }
                        if (taxAmount.compareTo(BigDecimal.ZERO) >= 0) {
                            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u660e\u7ec6\u6298\u6263\u884c\u4e0d\u80fd\u5927\u4e8e\u7b49\u4e8e0", (String)"GiftReceiptSaveValidator_3", (String)"imc-sim-formplugin", (Object[])new Object[0]), i + 1));
                            continue;
                        }
                        DynamicObject preItem = (DynamicObject)items2.get(i - 1);
                        if ("1".equals(preItem.getString("rowtype"))) {
                            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u660e\u7ec6\u6298\u6263\u884c\u4e0a\u4e00\u884c\u4e0d\u80fd\u4e3a\u6298\u6263\u884c", (String)"GiftReceiptSaveValidator_2", (String)"imc-sim-formplugin", (Object[])new Object[0]), i + 1));
                            continue;
                        }
                        BigDecimal preAmount = ((DynamicObject)items2.get(i - 1)).getBigDecimal("taxamount");
                        if (preAmount.compareTo(taxAmount.abs()) >= 0) continue;
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u660e\u7ec6\u6298\u6263\u884c\u4e0d\u80fd\u5927\u4e8e\u5546\u54c1\u884c\u91d1\u989d", (String)"GiftReceiptSaveValidator_4", (String)"imc-sim-formplugin", (Object[])new Object[0]), i + 1));
                        continue;
                    }
                    if (taxAmount.compareTo(BigDecimal.ZERO) <= 0) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u660e\u7ec6\u6b63\u5e38\u884c\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0", (String)"GiftReceiptSaveValidator_5", (String)"imc-sim-formplugin", (Object[])new Object[0]), i + 1));
                        continue;
                    }
                    BigDecimal num = item2.getBigDecimal("num");
                    if (!MathUtils.isNullOrZero((BigDecimal)num) && num.compareTo(BigDecimal.ZERO) < 0) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u660e\u7ec6\u6b63\u5e38\u884c\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0", (String)"GiftReceiptSaveValidator_6", (String)"imc-sim-formplugin", (Object[])new Object[0]), i + 1));
                        continue;
                    }
                    BigDecimal taxUnitPrice = item2.getBigDecimal("taxunitprice");
                    if (MathUtils.isNullOrZero((BigDecimal)taxUnitPrice) || taxUnitPrice.compareTo(BigDecimal.ZERO) >= 0) continue;
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u660e\u7ec6\u6b63\u5e38\u884c\u5355\u4ef7\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0", (String)"GiftReceiptSaveValidator_7", (String)"imc-sim-formplugin", (Object[])new Object[0]), i + 1));
                }
            }
            catch (KDBizException e) {
                this.addErrorMessage(dataEntity, e.getMessage());
            }
        }
    }
}

