/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.home;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.imc.bdm.common.helper.EquipmentHelper;
import kd.imc.bdm.common.helper.OrgHelper;
import kd.imc.bdm.common.util.EquipmentUtil;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.sim.common.helper.QueryStockHelper;

public class EquipmentStockPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    private static final Log LOGGER = LogFactory.getLog(EquipmentStockPlugin.class);

    public void afterCreateNewData(EventObject e) {
        try {
            LOGGER.info("\u67e5\u8be2\u8bbe\u5907\u5e93\u5b58");
            QFilter qFilter = new QFilter("1", "=", (Object)1);
            HasPermOrgResult userHasPermOrgs = PermissionServiceHelper.getUserHasPermOrgs((long)Long.parseLong(RequestContext.get().getUserId()));
            if (!userHasPermOrgs.hasAllOrgPerm()) {
                List orgIds = OrgHelper.getAuthOrgs();
                orgIds.retainAll(userHasPermOrgs.getHasPermOrgs());
                qFilter = OrgHelper.getIdFilter((Collection)orgIds);
            }
            DynamicObject[] orgArray = BusinessDataServiceHelper.load((String)"bdm_org", (String)"equipmentno,devlist_tag", (QFilter[])qFilter.toArray());
            HashSet<String> equipNoSet = new HashSet<String>();
            for (DynamicObject org : orgArray) {
                DynamicObject[] dynamicObjectCollection;
                for (DynamicObject object : dynamicObjectCollection = EquipmentUtil.getEquipmentDynamicObjectsByOrg((DynamicObject)org)) {
                    equipNoSet.add(object.getString("equipmentno"));
                }
            }
            DynamicObject[] array = BusinessDataServiceHelper.load((String)"bdm_stock_manage", (String)"equipmentno,epname,equipmenttype,einvoicestock,especialinvoicestock,invoicestock,specialinvoicestock,modifytime", (QFilter[])OrgHelper.getIdFilter(equipNoSet, (String)"equipmentno").toArray());
            String entryName = "entryentity";
            for (DynamicObject object : array) {
                int rowIndex = this.getModel().createNewEntryRow(entryName);
                this.getModel().setValue("equipmentno", (Object)object.getString("equipmentno"), rowIndex);
                this.getModel().setValue("epname", (Object)object.getString("epname"), rowIndex);
                this.getModel().setValue("equipmenttype", (Object)object.getString("equipmenttype"), rowIndex);
                this.getModel().setValue("einvoicestock", (Object)object.getString("einvoicestock"), rowIndex);
                this.getModel().setValue("especialinvoicestock", (Object)object.getString("especialinvoicestock"), rowIndex);
                this.getModel().setValue("invoicestock", (Object)object.getString("invoicestock"), rowIndex);
                this.getModel().setValue("specialinvoicestock", (Object)object.getString("specialinvoicestock"), rowIndex);
                this.getModel().setValue("refreshtime", object.get("modifytime"), rowIndex);
            }
        }
        catch (Exception e1) {
            LOGGER.info("\u6ca1\u6709\u67e5\u8be2\u5230\u5f53\u524d\u7ec4\u7ec7\u5bf9\u5e94\u7684\u5e93\u5b58\u4fe1\u606f" + RequestContext.get().getOrgId(), (Object)e1);
        }
    }

    public void registerListener(EventObject e) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        this.addClickListeners(new String[]{"refreshall"});
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)"refreshall", (CharSequence)source.getKey())) {
            DynamicObject[] array;
            for (DynamicObject stock : array = BusinessDataServiceHelper.load((String)"bdm_stock_manage", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_stock_manage", (boolean)true), null)) {
                try {
                    QueryStockHelper.refreshStock((DynamicObject)stock);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.getView().invokeOperation("refresh");
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5237\u65b0\u6210\u529f", (String)"EquipmentStockPlugin_3", (String)"imc-sim-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        int rowIndex = hyperLinkClickEvent.getRowIndex();
        Object epName = this.getModel().getValue("epname", rowIndex);
        Object equipmentno = this.getModel().getValue("equipmentno", rowIndex);
        Object equipmenttype = this.getModel().getValue("equipmenttype", rowIndex);
        if (StringUtils.isNotBlank((Object)equipmentno)) {
            DynamicObject[] array;
            QFilter filter = new QFilter("equipmentno", "=", equipmentno).and("equipmenttype", "=", equipmenttype).and("epname", "=", epName);
            for (DynamicObject stock : array = BusinessDataServiceHelper.load((String)"bdm_stock_manage", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_stock_manage", (boolean)true), (QFilter[])filter.toArray())) {
                String equipmentNo;
                String taxNo = stock.getString("taxno");
                if (!EquipmentHelper.isDisableJQBH((Object)taxNo, (Object)(equipmentNo = stock.getString("equipmentno")))) continue;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bbe\u5907\uff1a%s\u5df2\u88ab\u7981\u7528", (String)"EquipmentStockPlugin_2", (String)"imc-sim-formplugin", (Object[])new Object[0]), equipmentNo));
            }
            if (array.length > 0) {
                LOGGER.info("QueryStockHelperRefreshStock");
                DynamicObject stock = array[0];
                try {
                    QueryStockHelper.refreshStock((DynamicObject)stock);
                    this.getView().invokeOperation("refresh");
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5237\u65b0\u6210\u529f", (String)"EquipmentStockPlugin_3", (String)"imc-sim-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                }
                catch (KDBizException e) {
                    throw e;
                }
                catch (Exception e) {
                    LOGGER.error("equipmentStockRefresh:" + e.getMessage(), (Throwable)e);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5237\u65b0\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (String)"EquipmentStockPlugin_4", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                }
            }
        }
    }
}

