/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.invoicebatch;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.ComponentInterfaceTypeEnum;
import kd.imc.bdm.common.constant.IssueType;
import kd.imc.bdm.common.constant.allele.AllEleInterfaceTypeEnum;
import kd.imc.bdm.common.dto.ComponentRequest;
import kd.imc.bdm.common.dto.ComponentResponse;
import kd.imc.bdm.common.dto.PaperInvoiceRollInfoDTO;
import kd.imc.bdm.common.dto.allele.AllEleTaxPlatformResponseDTO;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.AllEleServiceHelper;
import kd.imc.bdm.common.helper.BotpHelper;
import kd.imc.bdm.common.helper.ComponentServiceHelper;
import kd.imc.bdm.common.helper.DrawerStrategyHelper;
import kd.imc.bdm.common.helper.EquipmentHelper;
import kd.imc.bdm.common.helper.RedConfirmHelper;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.model.DrawerInfo;
import kd.imc.bdm.common.model.SaleInfo;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.EquipmentUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.common.helper.allele.CreditQuotaHelper;
import kd.imc.sim.common.utils.BeanUtil;
import kd.imc.sim.formplugin.bill.originalbill.util.SelectDeviceUtil;
import kd.imc.sim.formplugin.invoicebatch.AbstractBatchDialogPlugin;
import kd.imc.sim.formplugin.issuing.control.BatchInvoiceControl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InvoiceBatchDialogListPlugin
extends AbstractBatchDialogPlugin {
    private static final Log logger = LogFactory.getLog(InvoiceBatchDialogListPlugin.class);

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"issueinvoice", "imgvolumninfo"});
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        if (source.getKey().equals("issueinvoice")) {
            this.confirmBatch();
        } else if ("imgvolumninfo".equals(source.getKey())) {
            this.popPaperInvoiceRollInfoDialog();
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"customcontrolap"});
        Object[] issueIds = this.getIssueIds();
        DynamicObject waitDynamic = BusinessDataServiceHelper.loadSingle((Object)issueIds[0], (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_vatinvoice"));
        this.getPageCache().put("orgid", String.valueOf(DynamicObjectUtil.getDynamicObjectLongValue((Object)waitDynamic.get("orgid"))));
        this.getPageCache().put("salertaxno", waitDynamic.getString("salertaxno"));
        this.setTotalCount();
        this.setListFilter();
        this.setAllEleCreditQuota(Boolean.FALSE);
        if (InvoiceUtils.isAllEInvoice((Object)waitDynamic.getString("invoicetype")) || AllEleAuthHelper.isElePaper((Object)waitDynamic.getString("iselepaper"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexdev"});
            this.setAllEleCreditQuota(Boolean.TRUE);
            this.getView().setVisible(Boolean.TRUE, new String[]{"accountflex"});
            SelectDeviceUtil.setAccount((AbstractFormPlugin)this, (String)waitDynamic.getString("salertaxno"));
            String account = waitDynamic.getString("account");
            if (StringUtils.isNotEmpty((CharSequence)account)) {
                this.getView().getModel().setValue("account", (Object)account);
            }
            return;
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"accountflex"});
        this.setJqbh(waitDynamic);
        try {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexvolumninfo"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"textvolumninfo"});
            DynamicObject equipment = EquipmentUtil.getEquipmentDynamicObjectByDevNo((String)waitDynamic.getString("jqbh"), (String)waitDynamic.getString("salertaxno"));
            if (equipment != null && !"8".equals(equipment.getString("equipmenttype"))) {
                logger.info((Object)"\u6279\u91cf\u5f00\u7968\u9884\u89c8\u521d\u59cb\u5316\u663e\u793a\u53d1\u7968\u5377");
                this.changeDevice(waitDynamic.getString("jqbh"), equipment.getString("equipmenttype"));
            }
        }
        catch (Exception ex) {
            this.getView().showErrorNotification(ex.getMessage());
        }
    }

    private void setAllEleCreditQuota(Boolean aTrue) {
        this.getView().setVisible(aTrue, new String[]{"alleleflex"});
        if (aTrue.booleanValue()) {
            String creditQuotaStr = CreditQuotaHelper.getCreditQuota((AbstractFormPlugin)this, (String)this.getPageCache().get("salertaxno"));
            this.getModel().setValue("creditquota", (Object)creditQuotaStr);
            BigDecimal invoiceAmount = new BigDecimal(this.getPageCache().get("invoiceAmount"));
            this.getModel().setValue("remaincreditquota", (Object)CreditQuotaHelper.getNumberFormat((BigDecimal)new BigDecimal(creditQuotaStr.replaceAll(",", "")).subtract(invoiceAmount)));
        }
    }

    @Override
    public String getOrderBy() {
        DynamicObject issueInvSetting = BusinessDataServiceHelper.loadSingleFromCache((String)"bdm_issue_inv_setting", (QFilter[])new QFilter("org", "=", (Object)Long.parseLong(this.getPageCache().get("orgid"))).toArray());
        String orderBy = "billno";
        if (null != issueInvSetting) {
            orderBy = issueInvSetting.getString("issueinvoiceorder");
        }
        if (!"billno".equals(orderBy)) {
            orderBy = "splitorder".equals(orderBy) ? String.format("%s,%s", "billno", orderBy) : String.format("%s,%s", orderBy, "billno");
        }
        return orderBy;
    }

    private void setJqbh(DynamicObject waitDynamic) {
        String jqbh = waitDynamic.getString("jqbh");
        String sellerTaxNo = waitDynamic.getString("salertaxno");
        if (EquipmentHelper.isEnable((Object)sellerTaxNo, (Object)jqbh)) {
            this.getModel().setValue("jqbh", (Object)jqbh);
        }
        InvoiceBatchDialogListPlugin.setEquipmentAndTerminaNo(this, DynamicObjectUtil.getDynamicObjectLongValue((Object)waitDynamic.get("orgid")));
        if (StringUtils.isNotBlank((Object)this.getModel().getValue("jqbh"))) {
            this.getModel().setValue("terminalno", (Object)waitDynamic.getString("terminalno"));
        }
    }

    public static void setEquipmentAndTerminaNo(AbstractFormPlugin that, long orgId) {
        orgId = orgId == 0L ? RequestContext.get().getOrgId() : orgId;
        SaleInfo saleInfo = TaxUtils.getSaleInfoByOrg((Long)orgId);
        EquipmentUtil.initEquipmentAndTerminal((AbstractFormPlugin)that, (long)orgId, (String)saleInfo.getSaleTaxNo(), (String)"jqbh", (String)"terminalno", (boolean)true);
    }

    private void setTotalCount() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        JSONArray jsonArray = (JSONArray)customParams.get("ids");
        this.getPageCache().put("ids", jsonArray.toJSONString());
        String invoiceType = (String)customParams.get("invoiceType");
        this.getPageCache().put("invoicetype", invoiceType);
        Map<String, Object> amtMap = this.getAmt(jsonArray.toArray());
        this.getModel().setValue("countfw", amtMap.get("count"));
        this.getModel().setValue("totalamounttext", (Object)CreditQuotaHelper.getNumberFormat((BigDecimal)((BigDecimal)amtMap.get("totalAmount"))));
        this.getModel().setValue("labelap", (Object)CreditQuotaHelper.getNumberFormat((BigDecimal)((BigDecimal)amtMap.get("taxAmount"))));
        BigDecimal invoiceAmount = new BigDecimal(this.getPageCache().get("invoiceAmount"));
        this.getModel().setValue("invoiceamounttext", (Object)CreditQuotaHelper.getNumberFormat((BigDecimal)invoiceAmount));
    }

    private Map<String, Object> getAmt(Object[] ids) {
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT count(1) as count,SUM(t.FTOTALTAX) as taxTotal,SUM(t.FTOTALAMOUNT) as totalAmount, SUM(T.FINVOICEAMOUNT) as invoiceAmount");
        sql.append(" FROM t_sim_vatinvoice t ");
        sql.append(" WHERE t.fid in (");
        for (int i = 0; i < ids.length; ++i) {
            sql.append('?');
            if (i == ids.length - 1) continue;
            sql.append(',');
        }
        sql.append(')');
        HashMap<String, Object> map = new HashMap<String, Object>();
        try (DataSet ds = DB.queryDataSet((String)"getInvoiceBatchAmt", (DBRoute)new DBRoute("taxc"), (String)sql.toString(), (Object[])ids);){
            if (ds != null) {
                for (Row data : ds) {
                    BigDecimal taxAmount = data.getBigDecimal("taxTotal") != null ? data.getBigDecimal("taxTotal") : BigDecimal.ZERO;
                    BigDecimal totalAmount = data.getBigDecimal("totalAmount") != null ? data.getBigDecimal("totalAmount") : BigDecimal.ZERO;
                    BigDecimal invoiceAmount = data.getBigDecimal("invoiceAmount") != null ? data.getBigDecimal("invoiceAmount") : BigDecimal.ZERO;
                    map.put("count", data.get("count"));
                    map.put("taxAmount", taxAmount.setScale(2, 4));
                    map.put("totalAmount", totalAmount.setScale(2, 4));
                    this.getPageCache().put("invoiceAmount", invoiceAmount.setScale(2, 4).toString());
                }
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void confirmBatch() {
        try {
            String devNo = (String)this.getModel().getValue("jqbh");
            String terminalNo = (String)this.getModel().getValue("terminalno");
            String allEAccount = (String)this.getModel().getValue("account");
            DynamicObject[] batchList = this.getDynamicObjects("sim_vatinvoice");
            boolean allEleFlag = false;
            if (!InvoiceUtils.isAllEInvoice((Object)batchList[0].getString("invoicetype")) && !AllEleAuthHelper.isElePaper((Object)batchList[0].getString("iselepaper"))) {
                if (StringUtils.isBlank((CharSequence)devNo)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u4e2a\u8bbe\u5907", (String)"InvoiceBatchDialogListPlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                    return;
                }
                long orgId = RequestContext.get().getOrgId();
                if (batchList[0] != null) {
                    orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)batchList[0].get("orgid"));
                }
                this.warpDrawer(devNo, batchList, orgId);
                SaleInfo saleInfo = TaxUtils.getSaleInfoByOrg((Long)orgId);
                EquipmentHelper.checkTerminalNo((String)devNo, (String)saleInfo.getSaleTaxNo(), (String)terminalNo);
            } else {
                HashMap param = Maps.newHashMap();
                param.put("salertaxno", batchList[0].getString("salertaxno"));
                param.put("account", allEAccount);
                if (AllEleServiceHelper.isNeedLogin((AbstractFormPlugin)this, (Map)param)) {
                    return;
                }
                allEleFlag = true;
            }
            boolean isShowTip = false;
            for (DynamicObject invoice : batchList) {
                DynamicObject[] reds = null;
                if (isShowTip) break;
                if (InvoiceUtils.isRedInfo((DynamicObject)invoice)) {
                    QFilter filter = new QFilter("infocode", "=", (Object)invoice.getString("infocode")).and("org", "=", (Object)DynamicObjectUtil.getDynamicObjectLongValue((Object)invoice.getDynamicObject("orgid")));
                    reds = BusinessDataServiceHelper.load((String)"sim_red_info", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_red_info"), (QFilter[])filter.toArray());
                }
                if (IssueType.RED_INVOICE.getTypeCode().equals(invoice.get("issuetype")) && InvoiceUtils.isAllEInvoice((Object)invoice.getString("invoicetype"))) {
                    QFilter filter = RedConfirmHelper.getFilter((String)invoice.getString("infocode"), (Long)DynamicObjectUtil.getDynamicObjectLongValue((Object)invoice.getDynamicObject("orgid")));
                    reds = BusinessDataServiceHelper.load((String)"sim_red_confirm_bill", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_red_info"), (QFilter[])filter.toArray());
                }
                if (reds != null && reds.length > 0) {
                    isShowTip = BotpHelper.isRedConfirmOrInfoNeedShowArTips(reds);
                }
                if (reds == null && IssueType.RED_INVOICE.getTypeCode().equals(invoice.get("issuetype"))) {
                    isShowTip = BotpHelper.isRedNeedShowArTip((DynamicObject)invoice);
                }
                if (!allEleFlag) continue;
                invoice.set("account", (Object)allEAccount);
            }
            if (isShowTip) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5f85\u5f00\u53d1\u7968\u4e2d%s", (String)"InvoiceBatchDialogListPlugin_7", (String)"imc-sim-formplugin", (Object[])new Object[0]), BotpHelper.getRedFiTip()), Integer.valueOf(8000));
            }
            this.batchOpenInvoice(devNo, terminalNo, batchList);
        }
        catch (KDBizException exception) {
            this.getView().showErrorNotification(exception.getMessage());
        }
        catch (MsgException exception) {
            this.getView().showErrorNotification(exception.getErrorMsg());
        }
        catch (Exception exception) {
            this.getView().showErrorNotification(exception.toString());
        }
        finally {
            this.getView().hideLoading();
        }
    }

    private void batchOpenInvoice(String devNo, String terminalNo, DynamicObject[] batchList) {
        this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5728\u5f00\u7968\u4e2d", (String)"InvoiceBatchDialogListPlugin_2", (String)"imc-sim-formplugin", (Object[])new Object[0])));
        long user = Long.parseLong(RequestContext.get().getUserId());
        for (DynamicObject invoice : batchList) {
            invoice.set("invoicingoperator", (Object)user);
        }
        BatchInvoiceControl.doBatchInvoice((Object)devNo, (Object)terminalNo, (DynamicObject[])batchList);
        this.getView().returnDataToParent((Object)"success");
        this.getView().close();
    }

    private void warpDrawer(String devNo, DynamicObject[] batchList, long orgId) {
        for (DynamicObject waitInvoice : batchList) {
            DrawerInfo drawerInfo = DrawerStrategyHelper.getDrawerInfoNonOriginalBill((String)waitInvoice.getString("drawer"), (String)waitInvoice.getString("payee"), (String)waitInvoice.getString("reviewer"), (Long)orgId, (Object)devNo);
            if (StringUtils.isEmpty((CharSequence)drawerInfo.getDrawer())) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bbe\u5907%s\u5f00\u7968\u4eba\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5f00\u7968", (String)"InvoiceBatchDialogListPlugin_3", (String)"imc-sim-formplugin", (Object[])new Object[0]), devNo));
            }
            waitInvoice.set("drawer", (Object)drawerInfo.getDrawer());
            waitInvoice.set("payee", (Object)drawerInfo.getPayee());
            waitInvoice.set("reviewer", (Object)drawerInfo.getReviewer());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if ("jqbh".equals(e.getProperty().getName())) {
            String equipmentNo = (String)e.getChangeSet()[0].getNewValue();
            if (StringUtils.isBlank((CharSequence)equipmentNo)) {
                return;
            }
            SaleInfo saleInfoByOrg = TaxUtils.getSaleInfoByOrg((Long)this.getBillOrgId());
            EquipmentUtil.showTerminalNo((AbstractFormPlugin)this, (String)equipmentNo, (String)saleInfoByOrg.getSaleTaxNo(), (String)"terminalno", (boolean)false);
            DynamicObject equipment = EquipmentUtil.getEquipmentDynamicObjectByDevNo((String)equipmentNo, (String)saleInfoByOrg.getSaleTaxNo());
            if (!"8".equals(equipment.getString("equipmenttype"))) {
                try {
                    this.changeDevice(String.valueOf(e.getChangeSet()[0].getNewValue()), equipment.getString("equipmenttype"));
                }
                catch (KDBizException ex) {
                    this.getView().showErrorNotification(ex.getMessage());
                }
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId = event.getActionId();
        if (actionId == null) {
            return;
        }
        if ("callback_sim_invoice_volumn_info_dialog".equals(actionId)) {
            this.handleSelectInvoiceVolumn(event);
        }
        if ("bdm_tax_login".equals(actionId)) {
            AllEleTaxPlatformResponseDTO response = (AllEleTaxPlatformResponseDTO)event.getReturnData();
            if (null != response) {
                if (AllEleInterfaceTypeEnum.QUERY_CREDIT_QUOTA.getRequestPath().equals(response.getCustomParams().get("request_path"))) {
                    this.setAllEleCreditQuota(Boolean.TRUE);
                    return;
                }
                DynamicObject[] invoices = this.getDynamicObjects("sim_vatinvoice");
                if (invoices != null && invoices.length > 0) {
                    String allEAccount = (String)this.getModel().getValue("account");
                    for (DynamicObject invoiceObj : invoices) {
                        invoiceObj.set("account", (Object)allEAccount);
                    }
                }
                this.batchOpenInvoice("", "", invoices);
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u767b\u5f55\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6570\u7535\u8d26\u53f7", (String)"InvoiceBatchDialogListPlugin_4", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void handleSelectInvoiceVolumn(ClosedCallBackEvent event) {
        Map map = (Map)event.getReturnData();
        if (MapUtils.isNotEmpty((Map)map)) {
            String invoiceCode = ObjectUtils.defaultIfNull(map.get("invoice_code"), (Object)"").toString();
            String invoiceNum = ObjectUtils.defaultIfNull(map.get("invoice_num"), (Object)"").toString();
            HashMap<String, String> sjdMap = new HashMap<String, String>();
            sjdMap.put("fpdm", invoiceCode);
            sjdMap.put("fphm", ObjectUtils.defaultIfNull(map.get("invoice_num"), (Object)"").toString());
            sjdMap.put("kpzl", "2");
            String deviceId = ObjectUtils.defaultIfNull((Object)this.getModel().getValue("jqbh"), (Object)"").toString();
            if (StringUtils.isEmpty((CharSequence)deviceId)) {
                return;
            }
            SaleInfo saleInfo = TaxUtils.getSaleInfoByOrg((Long)this.getBillOrgId());
            ComponentResponse componentResponse = ComponentServiceHelper.doPost((String)ComponentServiceHelper.getComponentRequestUrl((String)deviceId), (String)JSON.toJSONString((Object)new ComponentRequest(ComponentInterfaceTypeEnum.SETINVOICEVOLUME.getCzlx(), sjdMap, null, saleInfo.getDefaultTerminal())), Map.class);
            if (!"0".equals(componentResponse.getErrcode())) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u9009\u62e9\u53d1\u7968\u5377\u5f02\u5e38(%s)", (String)"InvoiceBatchDialogListPlugin_8", (String)"imc-sim-formplugin", (Object[])new Object[0]), componentResponse.getDescription()));
            }
            String lc = InvoiceUtils.getInvoiceFormsType((String)invoiceCode).getDesc();
            String volumnInfoStr = String.format(ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801: %1$s \u8d77\u59cb\u53f7\u7801: %2$s %3$s", (String)"InvoiceBatchDialogListPlugin_9", (String)"imc-sim-formplugin", (Object[])new Object[0]), invoiceCode, invoiceNum, lc);
            this.getModel().setValue("textvolumninfo", (Object)volumnInfoStr);
        }
    }

    private void changeDevice(String equipmentNo, String equipmentType) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexvolumninfo"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"textvolumninfo"});
        this.getPageCache().put("textvolumninfo", null);
        String invoiceType = this.getPageCache().get("invoicetype");
        if (!EquipmentHelper.checkIsSupportSelectInvoiceRoll((String)invoiceType, (String)equipmentType)) {
            return;
        }
        PaperInvoiceRollInfoDTO paperInvoiceRollInfoDTO = EquipmentHelper.queryPaperInvoiceRollInfo((String)invoiceType, (String)equipmentNo);
        if (paperInvoiceRollInfoDTO == null || CollectionUtils.isEmpty((Collection)paperInvoiceRollInfoDTO.getVolumn())) {
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"flexvolumninfo"});
        for (PaperInvoiceRollInfoDTO.RollInfo volumn : paperInvoiceRollInfoDTO.getVolumn()) {
            if (!paperInvoiceRollInfoDTO.getInfo().getInvoice_code().equals(volumn.getInvoice_code()) || Long.parseLong(paperInvoiceRollInfoDTO.getInfo().getInvoice_num()) < Long.parseLong(volumn.getInvoice_num()) || Long.parseLong(paperInvoiceRollInfoDTO.getInfo().getInvoice_num()) > Long.parseLong(volumn.getInvoice_num()) + Long.parseLong(volumn.getAmount())) continue;
            String lc = InvoiceUtils.getInvoiceFormsType((String)volumn.getInvoice_code()).getDesc();
            String volumnInfoStr = String.format(ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801: %1$s \u8d77\u59cb\u53f7\u7801: %2$s %3$s", (String)"InvoiceBatchDialogListPlugin_9", (String)"imc-sim-formplugin", (Object[])new Object[0]), volumn.getInvoice_code(), volumn.getInvoice_num(), lc);
            this.getModel().setValue("textvolumninfo", (Object)volumnInfoStr);
            break;
        }
    }

    private void popPaperInvoiceRollInfoDialog() {
        String equipmentNo = ObjectUtils.defaultIfNull((Object)this.getModel().getValue("jqbh"), (Object)"").toString();
        PaperInvoiceRollInfoDTO paperInvoiceRollInfoDTO = EquipmentHelper.queryPaperInvoiceRollInfo((String)this.getPageCache().get("invoicetype"), (String)equipmentNo);
        if (paperInvoiceRollInfoDTO != null) {
            ViewUtil.openDialog((AbstractFormPlugin)this, (Map)BeanUtil.objectToMap((Object)paperInvoiceRollInfoDTO), (String)"sim_invoice_volumn_info", (String)"callback_sim_invoice_volumn_info_dialog");
        }
    }

    private Long getBillOrgId() {
        Long orgId;
        try {
            orgId = Long.valueOf(this.getPageCache().get("orgid"));
        }
        catch (Exception ignore) {
            orgId = RequestContext.get().getOrgId();
        }
        return orgId;
    }
}

