/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.issuing;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.constant.ImcPermItemEnum;
import kd.imc.bdm.common.helper.PermissionHelper;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.sim.formplugin.editorg.EditOrgController;
import kd.imc.sim.formplugin.issuing.AbstractVatInvoiceListPlugin;

public class InvoiceQueryListEditOrgPlugin
extends AbstractVatInvoiceListPlugin {
    private static final String KEY_EDIT_ORG = "editorg";
    private Set<String> editTypeSet = Sets.newHashSet((Object[])new String[]{"2", "9"});

    @Override
    public void itemClick(ItemClickEvent evt) {
        if (KEY_EDIT_ORG.equals(evt.getItemKey())) {
            Object[] primaryKeyValues = ((IListView)this.getView()).getSelectedRows().getPrimaryKeyValues();
            if (primaryKeyValues.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5904\u7406\u7684\u6570\u636e", (String)"InvoiceQueryListEditOrgPlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject[] invoiceArr = BusinessDataServiceHelper.load((Object[])primaryKeyValues, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_vatinvoice"));
            HashSet orgSet = Sets.newHashSetWithExpectedSize((int)1);
            for (DynamicObject invoice : invoiceArr) {
                if (!this.editTypeSet.contains(invoice.getString("buyertype"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u6570\u636e\u6765\u6e90\u4e3a\"\u6570\u636e\u540c\u6b65\",\"\u8fdb\u9879\u4e0b\u8f7d\"\u8fdb\u884c\u4fee\u6539", (String)"InvoiceQueryListEditOrgPlugin_1", (String)"imc-sim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                    return;
                }
                orgSet.add(DynamicObjectUtil.getDynamicObjectLongValue((Object)invoice.get("orgid")));
            }
            if (orgSet.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u76f8\u540c\u4e1a\u52a1\u5355\u5143\u6570\u636e\u8fdb\u884c\u64cd\u4f5c", (String)"InvoiceQueryListEditOrgPlugin_2", (String)"imc-sim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return;
            }
            PermissionHelper.checkPermission((String)"sim", (String)"sim_vatinvoice", (long)orgSet.toArray(new Long[0])[0], (ImcPermItemEnum)ImcPermItemEnum.IMC_SIM_RED_INFO_EDIT_ORG);
            new EditOrgController().openEditOrgView((AbstractFormPlugin)this, DynamicObjectUtil.getDynamicObjectLongValue((Object)invoiceArr[0].get("orgid")), "\u7ec4\u7ec7");
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        BillList list = (BillList)this.getControl("billlistap");
        if (closedCallBackEvent.getReturnData() != null) {
            Object[] primaryKeyValues = ((IListView)this.getView()).getSelectedRows().getPrimaryKeyValues();
            DynamicObject[] invoices = BusinessDataServiceHelper.load((Object[])primaryKeyValues, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_vatinvoice"));
            long org = DynamicObjectUtil.getDynamicObjectLongValue((Object)invoices[0].get("orgid"));
            PermissionHelper.checkPermission((String)"sim", (String)"sim_vatinvoice", (long)org, (ImcPermItemEnum)ImcPermItemEnum.IMC_SIM_RED_INFO_EDIT_ORG);
            Object orgId = closedCallBackEvent.getReturnData();
            for (DynamicObject invoice : invoices) {
                invoice.set("orgid", orgId);
            }
            SaveServiceHelper.update((DynamicObject[])invoices);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u4fee\u6539\u6210\u529f", (String)"InvoiceQueryListEditOrgPlugin_4", (String)"imc-sim-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
        }
        list.clearSelection();
        list.refresh();
    }
}

