/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.issuing;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.ImcPermItemEnum;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.IssueType;
import kd.imc.bdm.common.dto.InvoicePushTaskDTO;
import kd.imc.bdm.common.helper.DownLoadCenterHelper;
import kd.imc.bdm.common.helper.HiddenButtonHelper;
import kd.imc.bdm.common.helper.PermissionHelper;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.EquipmentUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.UUID;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.common.helper.CheckCurrentOrgHelper;
import kd.imc.sim.formplugin.invoicebatch.TaxInvoiceImportUtil;
import kd.imc.sim.formplugin.issuing.AbstractVatInvoiceListPlugin;
import kd.imc.sim.formplugin.issuing.control.InvoiceQueryControl;
import kd.imc.sim.formplugin.issuing.task.PushInvoiceTask;
import org.apache.commons.io.FilenameUtils;

public class InvoiceQueryListPlugin
extends AbstractVatInvoiceListPlugin
implements UploadListener {
    private static final Log LOGGER = LogFactory.getLog(InvoiceQueryListPlugin.class);
    private static final String KEY_RE_SEND = "btn_re_send";
    private static final String KEY_EXPORT = "export";
    private static final String KEY_IMPORT = "invoiceimport";
    private static final String KEY_REFRESH = "refresh";
    private static final String KEY_SYNC = "invoicesync";
    private static final String KEY_DOWNLOAD_OFD = "btn_download";
    private static final String KEY_SIM_CHOOSE_INVOICE_TYPE = "sim_choose_invoice_type";
    private static final String PRINT_INVOICE = "printinvoice";
    private static final String PRINT_LIST = "print_list";
    private static final String ELEC_PRINT = "elec_print";
    private static final String SELECT_PRINT = "selectprint";
    private static final String SELECT_PRINT_LIST = "selectprint_list";
    private static final String KEY_COPY_ISSUE = "copyissue";
    private static final String KEY_CALLBACK = "callback";

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        Object issueTime = args.getSearchClickEvent().getFilterValue("issuetime");
        if (issueTime instanceof ArrayList) {
            ArrayList list = (ArrayList)issueTime;
            if (list.size() == 1) {
                String issueTimeStr = (String)list.get(0);
                this.getPageCache().put("search_date", issueTimeStr);
            } else {
                this.getPageCache().put("search_date", list.toString());
            }
        } else {
            this.getPageCache().put("search_date", null);
        }
    }

    public void afterCreateNewData(EventObject e) {
        HiddenButtonHelper.hideClose((AbstractFormPlugin)this, (String[])new String[]{"exit"});
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        if ("invoiceno".equals(args.getFieldName())) {
            args.setCancel(true);
            InvoiceQueryControl.handleHyperLinkClick((AbstractFormPlugin)this);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Toolbar toolbar = (Toolbar)this.getControl("toolbarap");
        toolbar.addUploadListener((UploadListener)this);
    }

    public void afterUpload(UploadEvent evt) {
        String key = evt.getCallbackKey();
        if ("import_tax".equals(key)) {
            TaxInvoiceImportUtil util = new TaxInvoiceImportUtil();
            Object[] urls = evt.getUrls();
            Object[] names = evt.getNames();
            if (urls.length > 0) {
                String excelUrl = urls[0].toString();
                String excelName = null;
                excelName = names != null && names.length > 0 ? names[0].toString() : FilenameUtils.getName((String)excelUrl);
                int success = util.parseTaxFile((AbstractFormPlugin)this, excelUrl, excelName);
                if (success > 0) {
                    this.refreshList();
                }
            }
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "btn_re_send": {
                InvoiceQueryControl.reSend((AbstractListPlugin)this);
                break;
            }
            case "export": {
                InvoiceQueryControl.export((AbstractListPlugin)this);
                break;
            }
            case "invoiceimport": {
                PermissionHelper.checkPermission((AbstractFormPlugin)this, (ImcPermItemEnum)ImcPermItemEnum.SIM_BDM_DERIVE);
                InvoiceQueryControl.invoiceImport((AbstractListPlugin)this);
                break;
            }
            case "printinvoice": {
                InvoiceQueryControl.invPrint((AbstractListPlugin)this, (String)"0");
                break;
            }
            case "selectprint": {
                InvoiceQueryControl.invPrint((AbstractListPlugin)this, (String)"1");
                break;
            }
            case "elec_print": {
                InvoiceQueryControl.elecPrint((AbstractListPlugin)this);
                break;
            }
            case "print_list": {
                InvoiceQueryControl.listPrint((AbstractListPlugin)this, (String)"0");
                break;
            }
            case "selectprint_list": {
                InvoiceQueryControl.listPrint((AbstractListPlugin)this, (String)"1");
                break;
            }
            case "btn_download": {
                BillList billList = (BillList)this.getView().getControl("billlistap");
                ListSelectedRowCollection selectedRows = billList.getSelectedRows();
                if (selectedRows == null || selectedRows.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u8981\u4e0b\u8f7d\u7684\u6570\u636e", (String)"InvoiceQueryListPlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]), Integer.valueOf(2500));
                    return;
                }
                this.downLoadCheck(selectedRows);
                break;
            }
            case "refresh": {
                this.refreshList();
                break;
            }
            case "invoicesync": {
                InvoiceQueryControl.invoicesync((AbstractListPlugin)this);
                break;
            }
            case "copyissue": {
                this.copyIssue();
                break;
            }
            case "callback": {
                InvoiceQueryControl.callback((AbstractListPlugin)this);
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        List qFilters = e.getQFilters();
        ArrayList<String> cacheFilters = new ArrayList<String>(qFilters.size());
        for (QFilter filter : qFilters) {
            cacheFilters.add(filter.toSerializedString());
        }
        e.getQFilters().stream().filter(qFilter -> qFilter.getProperty().equals("buyertelno")).findFirst().ifPresent(qFilter -> {
            e.getQFilters().remove(qFilter);
            qFilter.__setProperty("equipmentname");
            List nests = qFilter.getNests(false);
            for (QFilter.QFilterNest nest : nests) {
                nest.getFilter().__setProperty("equipmentname");
            }
            qFilter.and("authstatus", "=", (Object)"1");
            DynamicObject[] equipments = BusinessDataServiceHelper.load((String)"bdm_tax_equipment", (String)"equipmentno", (QFilter[])qFilter.toArray());
            e.getQFilters().add(new QFilter("jqbh", "in", (Object)Arrays.stream(equipments).map(equipment -> equipment.getString("equipmentno")).toArray()));
        });
        this.getPageCache().put("exportFilters", SerializationUtils.toJsonString(cacheFilters));
    }

    private void copyIssue() {
        try {
            BillList billList = (BillList)this.getView().getControl("billlistap");
            ListSelectedRowCollection rows = billList.getSelectedRows();
            if (rows.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u6761\u6570\u636e", (String)"InvoiceQueryListPlugin_1", (String)"imc-sim-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                return;
            }
            Object[] primaryKeyValues = rows.getPrimaryKeyValues();
            if (primaryKeyValues.length > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e00\u6b21\u4ec5\u80fd\u9009\u62e9\u4e00\u6761\u6570\u636e\u8fdb\u884c\u590d\u5236\u5f00\u7968", (String)"InvoiceQueryListPlugin_2", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                return;
            }
            ListSelectedRow listSelectedRow = rows.get(0);
            Object primaryKeyValue = listSelectedRow.getPrimaryKeyValue();
            this.checkCopyIssue(primaryKeyValue);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("copyissueid", primaryKeyValue);
            ViewUtil.openMainNewTabPage((AbstractFormPlugin)this, (String)(KEY_COPY_ISSUE + primaryKeyValue), params, (String)"sim_create_invoice", (String)KEY_COPY_ISSUE, (String)ResManager.loadKDString((String)"\u590d\u5236\u5f00\u7968", (String)"InvoiceQueryListPlugin_27", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        catch (KDBizException e) {
            LOGGER.error("\u590d\u5236\u5f00\u7968" + e.getMessage(), (Throwable)e);
            this.getView().showTipNotification(e.getMessage(), Integer.valueOf(3000));
        }
        catch (Exception e) {
            LOGGER.error("\u590d\u5236\u5f00\u7968" + e.getMessage(), (Throwable)e);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u5904\u7406\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"InvoiceQueryListPlugin_4", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
    }

    private void checkCopyIssue(Object copyIssueId) {
        DynamicObject invoice = BusinessDataServiceHelper.loadSingle((Object)copyIssueId, (String)"sim_vatinvoice");
        PermissionHelper.checkPermission((String)"sim", (String)"sim_vatinvoice", (long)DynamicObjectUtil.getDynamicObjectLongValue((Object)invoice.get("orgid")), (ImcPermItemEnum)ImcPermItemEnum.IMC_COPY_ISSUE);
        if (IssueType.RED_INVOICE.getTypeCode().equals(invoice.getString("issuetype"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u590d\u5236\u7ea2\u7968\u7ee7\u7eed\u5f00\u7968", (String)"InvoiceQueryListPlugin_5", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
    }

    private void downLoadCheck(ListSelectedRowCollection selectedRows) {
        Set typeSet;
        DynamicObject[] objects = BusinessDataServiceHelper.load((Object[])selectedRows.getPrimaryKeyValues(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_vatinvoice"));
        CheckCurrentOrgHelper.checkSelectRowsCurrentAuthor((AbstractFormPlugin)this, (ImcPermItemEnum)ImcPermItemEnum.BTN_DOWNLOAD, (DynamicObject[])objects);
        try {
            typeSet = InvoiceQueryControl.checkDownLoadData((DynamicObject[])objects, (String)"\u4e0b\u8f7d");
        }
        catch (KDBizException e) {
            this.getView().showTipNotification(e.getMessage());
            return;
        }
        DownLoadCenterHelper.checkLimitDownload((int)selectedRows.size(), (String)"zip");
        DownLoadCenterHelper.checkDownloadSize((DynamicObject[])objects);
        String noPdfNo = Stream.of(objects).filter(dObject -> "0".equals(dObject.getString("ofdstatus"))).filter(dObject -> !InvoiceType.ALL_E_NORMAL.getTypeCode().equalsIgnoreCase(dObject.getString("invoicetype")) && !InvoiceType.ALL_E_SPECIAL.getTypeCode().equalsIgnoreCase(dObject.getString("invoicetype"))).map(dObject -> dObject.getString("invoiceno")).collect(Collectors.joining("\u3001"));
        if (StringUtils.isNotBlank((CharSequence)noPdfNo)) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u4ee5\u4e0b\u53d1\u7968\u672a\u751f\u6210\u7248\u5f0f\u6587\u4ef6\uff0c\u70b9\u51fb\u53d1\u7968\u53f7\u7801\u53ef\u4ee5\u751f\u6210\u5bf9\u5e94\u7248\u5f0f\u6587\u4ef6", (String)"InvoiceQueryListPlugin_7", (String)"imc-sim-formplugin", (Object[])new Object[0]), noPdfNo, MessageBoxOptions.OK, ConfirmTypes.Default, null);
            return;
        }
        if ("0".equals(typeSet.iterator().next())) {
            ViewUtil.openNormalConfirm((AbstractFormPlugin)this, (String)ResManager.loadKDString((String)"\u662f\u5426\u786e\u5b9a\u4e0b\u8f7d\u7535\u5b50\u53d1\u7968\u7248\u5f0f\u6587\u4ef6\uff1f", (String)"InvoiceQueryListPlugin_8", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)KEY_DOWNLOAD_OFD);
        } else {
            ViewUtil.openNormalConfirm((AbstractFormPlugin)this, (String)ResManager.loadKDString((String)"\u662f\u5426\u786e\u5b9a\u4e0b\u8f7d\u7eb8\u8d28\u53d1\u7968\u7248\u5f0f\u6587\u4ef6\uff1f", (String)"InvoiceQueryListPlugin_9", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)KEY_DOWNLOAD_OFD);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        if (MessageBoxResult.Yes != event.getResult()) {
            return;
        }
        switch (event.getCallBackId()) {
            case "bdm_download_center": {
                ViewUtil.openListPageByMainPage((AbstractFormPlugin)this, null, (String)"bdm_download_center", null, (ShowType)ShowType.MainNewTabPage);
                break;
            }
            case "btn_download": {
                boolean isRefresh = InvoiceQueryControl.download((AbstractListPlugin)this);
                if (!isRefresh) break;
                this.refreshList();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Object returnData = event.getReturnData();
        switch (event.getActionId()) {
            case "msg_resend": {
                if (returnData == null) break;
                String respData = returnData.toString();
                if (respData.equals("0")) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u91cd\u65b0\u63a8\u9001\u6210\u529f", (String)"InvoiceQueryListPlugin_10", (String)"imc-sim-formplugin", (Object[])new Object[0]), Integer.valueOf(2500));
                    this.refreshList();
                    break;
                }
                if (respData.equals("4")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u5f00\u542f\u77ed\u4fe1\u63a8\u9001\u6743\u9650\uff0c\u4e0d\u63a8\u9001", (String)"InvoiceQueryListPlugin_11", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                    break;
                }
                if (respData.equals("6")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u90e8\u5206\u63a8\u9001\u6210\u529f", (String)"InvoiceQueryListPlugin_12", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                    break;
                }
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u91cd\u65b0\u63a8\u9001\u5931\u8d25", (String)"InvoiceQueryListPlugin_13", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                break;
            }
            case "msg_resend_email": {
                if (returnData == null) break;
                JSONObject returnMap = (JSONObject)returnData;
                if (returnMap.containsKey((Object)"sendResult")) {
                    this.showSendResult(returnData, returnMap);
                    break;
                }
                if (!returnMap.containsKey((Object)"continueSendArray")) break;
                JSONArray continueSendArray = (JSONArray)returnMap.get((Object)"continueSendArray");
                String email = (String)returnMap.get((Object)"email");
                this.checkFileUrl(continueSendArray, email, returnMap);
                break;
            }
            case "sim_labelape_print": {
                if (returnData == null) break;
                this.refreshList();
                break;
            }
            case "invoice_import": {
                if (returnData != null && returnData.equals("success")) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"excel\u53d1\u7968\u5bfc\u5165\u6210\u529f", (String)"InvoiceQueryListPlugin_14", (String)"imc-sim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                }
                this.refreshList();
                break;
            }
            case "sync_invoice_dialog": {
                this.refreshList();
                if (returnData == null) break;
                HashMap returnMap = (HashMap)returnData;
                this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u540c\u6b65\u6210\u529f\uff0c\u672c\u6b21\u65b0\u589e\u53d1\u7968\u6570\u91cf\uff1a%1$s\uff0c\u66f4\u65b0\u53d1\u7968\u6570\u91cf\uff1a%2$s", (String)"InvoiceQueryListPlugin_25", (String)"imc-sim-formplugin", (Object[])new Object[0]), returnMap.get("addSize"), returnMap.get("updateSize")), Integer.valueOf(3000));
                break;
            }
            case "sim_labelape_print_select": {
                this.refreshList();
                break;
            }
            case "sim_choose_invoice_type": {
                if (!StringUtils.isNotBlank((Object)returnData)) break;
                String fileTypeStr = (String)returnData;
                InvoiceQueryControl.downloadAllEleFile((AbstractListPlugin)this, (String)fileTypeStr);
                break;
            }
            case "bdm_tax_login": {
                if (null == returnData) break;
                String fileType = this.getPageCache().get("fileType");
                InvoiceQueryControl.downloadAllEleFile((AbstractListPlugin)this, (String)fileType);
                break;
            }
            case "dispatchTask": {
                try {
                    this.dispatchTaskCloseCallback(this, event.getReturnData());
                }
                catch (Exception e) {
                    LOGGER.error("dispatchTask" + e.getMessage(), (Throwable)e);
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u91cd\u53d1\u5931\u8d25\uff1a%s", (String)"InvoiceQueryListPlugin_26", (String)"imc-sim-formplugin", (Object[])new Object[0]), e.getMessage()));
                }
                break;
            }
            case "sim_url_check_tip": {
                if (null == returnData) break;
                JSONObject returnMap = (JSONObject)returnData;
                this.continueSend(returnMap);
                break;
            }
        }
    }

    private void checkFileUrl(JSONArray pkArray, String email, JSONObject returnMap) {
        QFilter filter = new QFilter("id", "in", (Object)pkArray.toArray());
        String fields = String.join((CharSequence)",", "fileurl", "xmlfileurl", "pdffileurl", "invoicetype", "invoiceno");
        DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)fields, (QFilter[])filter.toArray());
        JSONObject json = new JSONObject();
        JSONArray successInvoice = new JSONArray();
        JSONArray allInvoice = new JSONArray();
        JSONArray canSendInvoice = new JSONArray();
        StringBuilder noFileBuilder = new StringBuilder();
        StringBuilder noPdfBuilder = new StringBuilder();
        StringBuilder noXmlBuilder = new StringBuilder();
        boolean needLogin = false;
        for (DynamicObject invoice : invoices) {
            String invoiceType = invoice.getString("invoicetype");
            String invoiceNo = invoice.getString("invoiceno");
            String concat = "";
            if (InvoiceUtils.isAllEInvoice((Object)invoiceType)) {
                if (StringUtils.isBlank((CharSequence)invoice.getString("fileurl"))) {
                    noFileBuilder.append(invoiceNo).append('\u3001');
                    concat = concat + "file,";
                } else {
                    canSendInvoice.add(invoice.getPkValue());
                }
                if (StringUtils.isBlank((CharSequence)invoice.getString("pdffileurl"))) {
                    noPdfBuilder.append(invoiceNo).append('\u3001');
                    concat = concat + "pdf,";
                }
                if (StringUtils.isBlank((CharSequence)invoice.getString("xmlfileurl"))) {
                    noXmlBuilder.append(invoiceNo).append('\u3001');
                    concat = concat + "xml";
                }
                if (StringUtils.isNotBlank((CharSequence)concat)) {
                    needLogin = true;
                }
            } else {
                canSendInvoice.add(invoice.getPkValue());
            }
            if (StringUtils.isNotBlank((CharSequence)concat)) {
                json.put(String.valueOf(invoice.getPkValue()), (Object)concat);
            } else {
                successInvoice.add(invoice.getPkValue());
            }
            allInvoice.add(invoice.getPkValue());
        }
        if (json.size() > 0) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            String noFileStr = noFileBuilder.toString();
            String noPdfStr = noPdfBuilder.toString();
            String noXmlStr = noXmlBuilder.toString();
            if (noFileStr.contains("\u3001")) {
                noFileStr = noFileStr.substring(0, noFileStr.length() - 1);
            }
            if (noPdfStr.contains("\u3001")) {
                noPdfStr = noPdfStr.substring(0, noPdfStr.length() - 1);
            }
            if (noXmlStr.contains("\u3001")) {
                noXmlStr = noXmlStr.substring(0, noXmlStr.length() - 1);
            }
            params.put("noFile", noFileStr);
            params.put("noPdf", noPdfStr);
            params.put("noXml", noXmlStr);
            params.put("successInvoice", successInvoice);
            params.put("needDownloadMap", json);
            params.put("allInvoice", allInvoice);
            params.put("needLogin", needLogin);
            params.put("email", email);
            params.put("canSendInvoice", canSendInvoice);
            if (returnMap.containsKey((Object)"oneInvoiceSend")) {
                params.put("oneInvoiceSend", "oneInvoiceSend");
            }
            ViewUtil.openDialog((AbstractFormPlugin)this, (String)ResManager.loadKDString((String)"\u63d0\u793a", (String)"InvoiceQueryListPlugin_17", (String)"imc-sim-formplugin", (Object[])new Object[0]), params, (String)"sim_url_check_tip", (String)"sim_url_check_tip");
        } else {
            this.downloadAndSend(email, successInvoice, returnMap.containsKey((Object)"oneInvoiceSend"));
        }
    }

    private void dispatchTaskCloseCallback(InvoiceQueryListPlugin listPlugin, Object returnData) {
        TaskInfo taskInfo;
        Map result = (Map)returnData;
        if (result == null) {
            return;
        }
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        boolean isOneInvoiceSend = StringUtils.isNotBlank(customParams.get("oneInvoiceSend"));
        String taskInfoStr = (String)result.get("taskinfo");
        if (StringUtils.isNotBlank((CharSequence)taskInfoStr) && (taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class)).isTaskEnd() && StringUtils.isNotBlank((CharSequence)taskInfo.getData())) {
            Map data = (Map)SerializationUtils.fromJsonString((String)taskInfo.getData(), Map.class);
            Object errMsg = data.get("errMsg");
            Boolean success = (Boolean)data.get("success");
            if (success.booleanValue()) {
                if (isOneInvoiceSend) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u91cd\u53d1\u6210\u529f", (String)"InvoiceQueryListPlugin_18", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                } else {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u91cd\u53d1\u6210\u529f\uff0c\u8bf7\u57283\u4e2a\u6708\u5185\u4e0b\u8f7d\u53d1\u7968\u6587\u4ef6", (String)"InvoiceQueryListPlugin_19", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                }
            } else {
                String errMessasg = ResManager.loadKDString((String)"\u91cd\u53d1\u5931\u8d25", (String)"InvoiceQueryListPlugin_20", (String)"imc-sim-formplugin", (Object[])new Object[0]);
                if (StringUtils.isNotBlank(errMsg)) {
                    errMessasg = (String)errMsg;
                }
                listPlugin.getView().showErrorNotification(errMessasg);
            }
        }
    }

    private void continueSend(JSONObject params) {
        Object way = params.get((Object)"way");
        boolean isOneInvoiceSend = StringUtils.isNotBlank((Object)params.get((Object)"oneInvoiceSend"));
        if ("downloadandpush".equals(way)) {
            JSONArray allInvoice = (JSONArray)params.get((Object)"allInvoice");
            ArrayList<InvoicePushTaskDTO> totalTask = new ArrayList<InvoicePushTaskDTO>();
            String orderNo = UUID.getBatchNumber();
            this.addQueryUrlTask(totalTask, orderNo, params);
            String email = (String)params.get((Object)"email");
            this.addDownloadTask(totalTask, (List<Object>)allInvoice, email, isOneInvoiceSend);
            PushInvoiceTask.dispatchTask(this, totalTask);
        } else if ("continuepush".equals(way)) {
            JSONArray allInvoice = (JSONArray)params.get((Object)"successInvoice");
            String email = (String)params.get((Object)"email");
            if (allInvoice.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u53d1\u7968\u90fd\u5b58\u5728\u6587\u4ef6\u7f3a\u5931\uff0c\u8bf7\u4e0b\u8f7d\u540e\u63a8\u9001", (String)"InvoiceQueryListPlugin_21", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                return;
            }
            this.downloadAndSend(email, allInvoice, isOneInvoiceSend);
        }
    }

    private void downloadAndSend(String email, JSONArray allInvoice, boolean isOneInvoiceSend) {
        ArrayList<InvoicePushTaskDTO> totalTask = new ArrayList<InvoicePushTaskDTO>();
        this.addDownloadTask(totalTask, (List<Object>)allInvoice, email, isOneInvoiceSend);
        PushInvoiceTask.dispatchTask(this, totalTask);
    }

    private void showSendResult(Object returnData, JSONObject returnMap) {
        JSONArray msgArr = (JSONArray)returnMap.get((Object)"sendResult");
        if (null != msgArr && msgArr.size() > 0) {
            this.showErrConfirm("msg_resend_email", msgArr, ResManager.loadKDString((String)"\u4ee5\u4e0b\u53d1\u7968\u53f7\u7801\u91cd\u63a8\u5931\u8d25", (String)"InvoiceQueryListPlugin_22", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6279\u91cf\u91cd\u65b0\u63a8\u9001\u6210\u529f", (String)"InvoiceQueryListPlugin_23", (String)"imc-sim-formplugin", (Object[])new Object[0]), Integer.valueOf(2500));
            this.refreshList();
        }
    }

    private void showErrConfirm(String formId, JSONArray respData, String errMsg) {
        ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(formId, (IFormPlugin)this);
        IFormView view = this.getView();
        if (respData != null) {
            StringBuilder builder = new StringBuilder();
            for (Object info : respData) {
                builder.append("\u53d1\u7968\u53f7\u7801\uff1a");
                builder.append(info);
                builder.append('\n');
            }
            view.showConfirm(errMsg, builder.toString(), MessageBoxOptions.OK, ConfirmTypes.Fail, confirmCallBackListener);
        } else {
            this.refreshList();
        }
    }

    public void refreshList() {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        billList.clearSelection();
        billList.getFilterParameter().setOrderBy("createtime desc");
        this.getView().invokeOperation(KEY_REFRESH);
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new InitDataProvider());
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        List listCommonFilterColumns;
        Object isFromGoodsReport = this.getView().getFormShowParameter().getCustomParam("isFromGoodsReport");
        if ("isFromGoodsReport".equals(isFromGoodsReport) && !CollectionUtils.isEmpty((Collection)(listCommonFilterColumns = args.getCommonFilterColumns()))) {
            for (FilterColumn filterColumn : listCommonFilterColumns) {
                CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
                commonFilterColumn.setDefaultValue(null);
            }
        }
    }

    private void addDownloadTask(List<InvoicePushTaskDTO> totalTask, List<Object> allInvoices, String email, boolean isOneInvoiceSend) {
        if (isOneInvoiceSend) {
            for (int i = 0; i < allInvoices.size(); ++i) {
                Object invoicePk = allInvoices.get(i);
                InvoicePushTaskDTO sendTask = new InvoicePushTaskDTO("4", null, invoicePk, null);
                sendTask.setEmail(email);
                totalTask.add(sendTask);
            }
            return;
        }
        int size = allInvoices.size();
        HashMap orderNoInvoicePkMap = new HashMap();
        for (int i = 0; i < size; ++i) {
            Object needDownloadInvoicePk = allInvoices.get(i);
            InvoicePushTaskDTO task = new InvoicePushTaskDTO("2", null, needDownloadInvoicePk, null);
            totalTask.add(task);
        }
        InvoicePushTaskDTO sendTask = new InvoicePushTaskDTO("3", null, null, null);
        sendTask.setEmail(email);
        sendTask.setOrderNoInovicePkListMap(orderNoInvoicePkMap);
        totalTask.add(sendTask);
    }

    private void addQueryUrlTask(List<InvoicePushTaskDTO> totalTask, String orderNo, JSONObject params) {
        JSONObject map = (JSONObject)params.get((Object)"needDownloadMap");
        for (Map.Entry entry : map.entrySet()) {
            Object invoicePk = entry.getKey();
            invoicePk = Long.parseLong((String)invoicePk);
            String fileTypeStr = (String)entry.getValue();
            InvoicePushTaskDTO task = new InvoicePushTaskDTO("1", fileTypeStr, invoicePk, orderNo);
            totalTask.add(task);
        }
    }

    class InitDataProvider
    extends ListDataProvider {
        InitDataProvider() {
        }

        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection rows = super.getData(start, limit);
            if (rows.isEmpty()) {
                return rows;
            }
            if (!((DynamicObject)rows.get(0)).getDataEntityType().getProperties().containsKey((Object)"jqbh")) {
                return rows;
            }
            for (DynamicObject row : rows) {
                boolean isExistJqbh = row.getDataEntityType().getProperties().containsKey((Object)"jqbh");
                boolean isExistTerminalNo = row.getDataEntityType().getProperties().containsKey((Object)"terminalno");
                String terminalNo = "";
                if (isExistTerminalNo) {
                    terminalNo = row.getString("terminalno");
                }
                if (!isExistJqbh) continue;
                String jqbh = row.getString("jqbh");
                String deviceName = InvoiceQueryListPlugin.this.getPageCache().get(jqbh + terminalNo);
                if (StringUtils.isBlank((CharSequence)deviceName)) {
                    DynamicObject device;
                    if (StringUtils.isNotBlank((CharSequence)jqbh) && (device = EquipmentUtil.getCommonEquipment((String)jqbh, (String)row.getString("salertaxno"), (String)terminalNo)) != null) {
                        deviceName = device.getString("equipmentname");
                    }
                    InvoiceQueryListPlugin.this.getPageCache().put(jqbh + terminalNo, StringUtils.isBlank((CharSequence)deviceName) ? "\u25cf\u25c6\u25a0" : deviceName);
                }
                row.set("buyertelno", (Object)("\u25cf\u25c6\u25a0".equals(deviceName) ? "" : deviceName));
            }
            return rows;
        }
    }
}

