/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.issuing.paperprint;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryData;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.SelectRowsEventListener;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.imc.bdm.common.constant.BillStatusEnum;
import kd.imc.bdm.common.constant.ImcPermItemEnum;
import kd.imc.bdm.common.constant.InvoiceStatus;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.AllEleServiceHelper;
import kd.imc.bdm.common.helper.BotpHelper;
import kd.imc.bdm.common.helper.ComponentServiceHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.PermissionHelper;
import kd.imc.bdm.common.helper.UnitTestHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.message.model.MsgResponse;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.sim.common.helper.BwServerInvoiceHelper;
import kd.imc.sim.common.helper.HostModeInvoiceHelper;
import kd.imc.sim.common.helper.InvoiceCancelHelper;
import kd.imc.sim.common.helper.LyServerInvoiceHelper;
import kd.imc.sim.common.helper.PaperPrintHelper;
import kd.imc.sim.formplugin.issuing.paperprint.control.PrintInvoiceControl;
import kd.imc.sim.untrans.SimFormPluginConstellationUntrans;
import org.apache.commons.lang3.StringUtils;

public class InvoiceAbolishPlugin
extends AbstractFormPlugin
implements SelectRowsEventListener,
SimFormPluginConstellationUntrans {
    private static final Log LOGGER = LogFactory.getLog(InvoiceAbolishPlugin.class);
    private static final String ENTRYENTITY = "entryentity";
    private static final String DO_ABOLISH = "doabolish";
    private static final String COMPONENTFLEX = "epnamequery";
    private static final String IMC_SIM_ABOLISH_CACHE = "imc_sim_abolish_cache_";
    private static final String IMC_SIM_ABOLISH_ERRMSG_CACHE = "imc_sim_abolish_errmsg_cache_";
    private static final String ITEM_REASON = "reason";
    private static final String ITEM_OTHER_REASON = "otherreason";
    private static final String PARENT_FORM = "PARENT_FORM";
    private static final String INVOICE_NUM = "invoice_num";

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{COMPONENTFLEX});
        this.getView().setVisible(Boolean.FALSE, new String[]{"abolishself"});
        this.setComponentDiv("0", "************", "************", "1", "\u53d1\u7968\u4f5c\u5e9f");
        FormShowParameter parameter = this.getView().getFormShowParameter();
        DynamicObject[] load = this.getDynamicObjectByKeys(parameter);
        Map customParams = parameter.getCustomParams();
        boolean isFromOriginalBill = "sim_original_bill".equals(customParams.get("ParentForm"));
        DynamicObject originalBill = null;
        if (isFromOriginalBill) {
            Long billId = (Long)parameter.getCustomParam("billId");
            originalBill = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"sim_original_bill");
            this.getView().setVisible(Boolean.FALSE, new String[]{DO_ABOLISH, "buyername", "buyertaxno"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"cancel", "close"});
        }
        if (load.length > 0) {
            IDataModel modelDetail = this.getControl(ENTRYENTITY).getModel();
            BigDecimal totaltax = BigDecimal.ZERO;
            BigDecimal totalamount = BigDecimal.ZERO;
            for (DynamicObject object : load) {
                int index = this.getModel().createNewEntryRow(ENTRYENTITY);
                modelDetail.setValue("id", object.getPkValue(), index);
                modelDetail.setValue("invoicecode", object.get("invoicecode"), index);
                modelDetail.setValue("invoiceno", object.get("invoiceno"), index);
                modelDetail.setValue("buyername", object.get("buyername"), index);
                modelDetail.setValue("totaltax", object.get("totaltax"), index);
                modelDetail.setValue("buyertaxno", object.get("buyertaxno"), index);
                modelDetail.setValue("invoiceamount", object.get("invoiceamount"), index);
                modelDetail.setValue("totaltax", object.get("totaltax"), index);
                modelDetail.setValue("totalamount", object.get("totalamount"), index);
                modelDetail.setValue("invoicetype", object.get("invoicetype"), index);
                modelDetail.setValue("issuetime", object.get("issuetime"), index);
                modelDetail.setValue("invoicestatus", object.get("invoicestatus"), index);
                if (isFromOriginalBill) {
                    modelDetail.setValue("billstatus", object.get("billstatus"), index);
                    if (originalBill != null) {
                        String abolishReason = originalBill.getString("abolishreason");
                        if (StringUtils.isNotBlank((CharSequence)abolishReason) && !InvoiceAbolishPlugin_1.contains((Object)abolishReason)) {
                            modelDetail.setValue(ITEM_REASON, (Object)"\u5176\u4ed6", index);
                            modelDetail.setValue(ITEM_OTHER_REASON, (Object)abolishReason, index);
                        } else {
                            modelDetail.setValue(ITEM_REASON, (Object)abolishReason, index);
                        }
                    }
                }
                totaltax = totaltax.add(object.getBigDecimal("totaltax"));
                totalamount = totalamount.add(object.getBigDecimal("totalamount"));
            }
            if (load.length == 1 && !"6".equals(load[0].getString("invoicestatus"))) {
                this.getPageCache().put(INVOICE_NUM, INVOICE_NUM);
            }
            Label title = (Label)this.getControl("allaccount");
            if (!isFromOriginalBill || load.length == 1) {
                title.setText(String.format(ResManager.loadKDString((String)"\u603b\u8ba1\uff1a \u4f5c\u5e9f\u4efd\u6570%1$s\u4efd\uff0c\u5408\u8ba1\u7a0e\u989d%2$s\u5143\uff0c\u4ef7\u7a0e\u5408\u8ba1%3$s\u5143", (String)"InvoiceAbolishPlugin_24", (String)"imc-sim-formplugin", (Object[])new Object[0]), load.length, totaltax.setScale(2, 0), totalamount.setScale(2, 0)));
            } else {
                title.setText(String.format(ResManager.loadKDString((String)"\u603b\u8ba1\uff1a \u4f5c\u5e9f\u4efd\u6570%1$s\u4efd\uff0c\u5408\u8ba1\u7a0e\u989d%2$s\u5143\uff0c\u4ef7\u7a0e\u5408\u8ba1%3$s\u5143", (String)"InvoiceAbolishPlugin_24", (String)"imc-sim-formplugin", (Object[])new Object[0]), 0, 0, 0));
            }
        }
    }

    public void afterBindData(EventObject e) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        String num = this.getPageCache().get(INVOICE_NUM);
        if (StringUtils.isNotEmpty((CharSequence)num)) {
            entryGrid.selectRows(0);
        }
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{DO_ABOLISH, "cancel", "batchfill"});
        String cache = this.getPageCache().get(PARENT_FORM);
        if (StringUtils.isNotEmpty((CharSequence)cache)) {
            int[] rows = ((EntryGrid)this.getView().getControl(ENTRYENTITY)).getSelectRows();
            BigDecimal totalTax = BigDecimal.ZERO;
            BigDecimal totaAmount = BigDecimal.ZERO;
            for (int row : rows) {
                totalTax = totalTax.add((BigDecimal)this.getModel().getValue("totaltax", row));
                totaAmount = totaAmount.add((BigDecimal)this.getModel().getValue("totalamount", row));
            }
            Label title = (Label)this.getControl("allaccount");
            title.setText(String.format(ResManager.loadKDString((String)"\u603b\u8ba1\uff1a \u4f5c\u5e9f\u4efd\u6570%1$s\u4efd\uff0c\u5408\u8ba1\u7a0e\u989d%2$s\u5143\uff0c\u4ef7\u7a0e\u5408\u8ba1%3$s\u5143", (String)"InvoiceAbolishPlugin_24", (String)"imc-sim-formplugin", (Object[])new Object[0]), rows.length, totalTax, totaAmount));
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (DO_ABOLISH.equals(key) || "cancel".equals(key)) {
            this.doInvoiceAbolish();
        } else if ("batchfill".equals(key)) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRYENTITY);
            EntryData entryData = entryGrid.getEntryData();
            DynamicObject[] dataEntitys = entryData.getDataEntitys();
            if (dataEntitys[0].get(ITEM_REASON) == null) {
                return;
            }
            IDataModel modelDetail = this.getControl(ENTRYENTITY).getModel();
            for (int i = 1; i < dataEntitys.length; ++i) {
                modelDetail.setValue(ITEM_REASON, dataEntitys[0].get(ITEM_REASON), i);
                if (!"\u5176\u4ed6".equals(dataEntitys[0].get(ITEM_REASON))) {
                    modelDetail.setValue(ITEM_OTHER_REASON, null, i);
                    continue;
                }
                modelDetail.setValue(ITEM_OTHER_REASON, dataEntitys[0].get(ITEM_OTHER_REASON), i);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRYENTITY);
        int[] rows = entryGrid.getSelectRows();
        int editIndex = 0;
        if (rows.length > 0) {
            editIndex = rows[0];
        }
        if (property.getName().equals(ITEM_REASON) && !"\u5176\u4ed6".equals(newValue)) {
            IDataModel modelDetail = this.getControl(ENTRYENTITY).getModel();
            modelDetail.setValue(ITEM_OTHER_REASON, null, editIndex);
        }
    }

    private void setComponentDiv(String printseq, String invoicecode, String invoiceno, String timeflag, String printtype) {
        HashMap<String, Object> showMap = new HashMap<String, Object>(8);
        showMap.put("eventKey", "updatePrint");
        showMap.put("printseq", "0".equals(printseq) ? ResManager.loadKDString((String)"\u5f00\u59cb\u51c6\u5907\u53d1\u7968\u4f5c\u5e9f", (String)"InvoiceAbolishPlugin_9", (String)"imc-sim-formplugin", (Object[])new Object[0]) : String.format(ResManager.loadKDString((String)"\u6b63\u5728\u4f5c\u5e9f\u7b2c%s\u5f20\u53d1\u7968...", (String)"InvoiceAbolishPlugin_10", (String)"imc-sim-formplugin", (Object[])new Object[0]), printseq));
        showMap.put("invoicecode", invoicecode);
        showMap.put("invoiceno", invoiceno);
        showMap.put("timeflag", timeflag);
        showMap.put("printtype", printtype);
        showMap.put("time", System.currentTimeMillis());
        CustomControl printControl = (CustomControl)this.getControl(COMPONENTFLEX);
        printControl.setData(showMap);
        if ("0".equals(timeflag)) {
            CacheHelper.remove((String)(IMC_SIM_ABOLISH_CACHE + this.getView().getPageId()));
        }
    }

    private DynamicObject[] getDynamicObjectByKeys(FormShowParameter formShowParameter) {
        Map customParams = formShowParameter.getCustomParams();
        JSONArray arr = (JSONArray)customParams.get("keys");
        if ("sim_original_bill".equals(customParams.get("ParentForm"))) {
            this.getPageCache().put(PARENT_FORM, PARENT_FORM);
        }
        Object[] arrs = arr.toArray();
        String formId = PrintInvoiceControl.getFormId((String)((String)customParams.get("type")));
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)formId);
        return BusinessDataServiceHelper.load((Object[])arrs, (DynamicObjectType)dataEntityType);
    }

    private void doInvoiceAbolish() {
        this.getView().setVisible(Boolean.TRUE, new String[]{COMPONENTFLEX});
        Map customParams = PaperPrintHelper.getCustomParams((AbstractFormPlugin)this);
        String pageType = (String)customParams.get("type");
        IDataModel model = this.getModel();
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRYENTITY);
        JSONArray keys = new JSONArray();
        HashMap<String, String> reasonMap = new HashMap<String, String>();
        HashMap<String, String> reasonOtherMap = new HashMap<String, String>();
        boolean isReasonBlank = false;
        if (!StringUtils.isEmpty((CharSequence)this.getPageCache().get(PARENT_FORM))) {
            List<String> statusList = Arrays.asList(BillStatusEnum.NO_APPROVAL_REQUIRED.getCode(), BillStatusEnum.AUDIT_SUCCESS.getCode());
            int[] nArray = entryGrid.getSelectRows();
            if (nArray.length == 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u4f5c\u5e9f\u7684\u53d1\u7968", (String)"InvoiceAbolishPlugin_11", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            }
            for (int rowIndex : nArray) {
                this.checkInvalidData((String)model.getValue("invoicetype", rowIndex), (Date)model.getValue("issuetime", rowIndex), (String)model.getValue("invoicestatus", rowIndex));
                if (!StringUtils.isEmpty((CharSequence)this.getPageCache().get(PARENT_FORM))) {
                    String billStatus = (String)model.getValue("billstatus", rowIndex);
                    String reason = (String)this.getModel().getValue(ITEM_REASON, rowIndex);
                    if (!"\u6253\u5370\u9519\u8bef".equals(reason) && !statusList.contains(billStatus)) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u4ec5\u53ef\u5bf9\u201c\u65e0\u9700\u5ba1\u6279\u201d\u3001\u201c\u5df2\u5ba1\u6838\u201d\u72b6\u6001\u7684\u53d1\u7968\u8fdb\u884c\u4f5c\u5e9f\u64cd\u4f5c", (String)"InvoiceAbolishPlugin_12", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                    }
                }
                keys.add(this.getModel().getValue("id", rowIndex));
                if (this.getModel().getValue(ITEM_REASON) != null) {
                    reasonMap.put(this.getModel().getValue("id", rowIndex) + "", this.getModel().getValue(ITEM_REASON, rowIndex) + "");
                }
                if (this.getModel().getValue(ITEM_OTHER_REASON) == null) continue;
                reasonOtherMap.put(this.getModel().getValue("id", rowIndex) + "", this.getModel().getValue(ITEM_OTHER_REASON, rowIndex) + "");
            }
        } else {
            DynamicObject[] dataEntitys;
            for (DynamicObject dataEntity : dataEntitys = entryGrid.getEntryData().getDataEntitys()) {
                this.checkInvalidData(dataEntity.getString("invoicetype"), dataEntity.getDate("issuetime"), dataEntity.getString("invoicestatus"));
                keys.add(dataEntity.get("id"));
                if (this.getModel().getValue(ITEM_REASON) != null) {
                    reasonMap.put(dataEntity.get("id") + "", dataEntity.get(ITEM_REASON) + "");
                } else {
                    isReasonBlank = true;
                }
                if (this.getModel().getValue(ITEM_OTHER_REASON) == null) continue;
                reasonOtherMap.put(dataEntity.get("id") + "", dataEntity.get(ITEM_OTHER_REASON) + "");
            }
        }
        String formId = PrintInvoiceControl.getFormId((String)pageType);
        DynamicObject[] dynamicObjectArray = BusinessDataServiceHelper.load((Object[])keys.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)formId));
        if ("sim_vatinvoice_vehicles".equals(formId)) {
            PermissionHelper.checkPermission((String)"sim", (String)"sim_vatinvoice_vehicles", (long)DynamicObjectUtil.getDynamicObjectLongValue((Object)dynamicObjectArray[0].get("orgid")), (ImcPermItemEnum)ImcPermItemEnum.IMC_SIM_CANCEL_INVOICE);
        } else {
            PermissionHelper.checkPermission((String)"sim", (String)"sim_invoice_valid_list", (long)DynamicObjectUtil.getDynamicObjectLongValue((Object)dynamicObjectArray[0].get("orgid")), (ImcPermItemEnum)ImcPermItemEnum.INV_ABOLISH);
        }
        boolean bl = "sim_vatinvoice".equals(dynamicObjectArray[0].getDataEntityType().getName());
        if ("sim_vatinvoice".equals(dynamicObjectArray[0].getDataEntityType().getName()) && AllEleAuthHelper.isElePaper((Object)dynamicObjectArray[0].getString("iselepaper")) && isReasonBlank) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u7535\u7eb8\u7968\u4f5c\u5e9f\u539f\u56e0\u5fc5\u586b", (String)"InvoiceAbolishPlugin_13", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        if (bl && BotpHelper.needCancelShowArTip((DynamicObject[])dynamicObjectArray)) {
            this.getView().showTipNotification(BotpHelper.getArFiTip(), Integer.valueOf(8000));
        }
        String catchKey = IMC_SIM_ABOLISH_CACHE + this.getView().getPageId();
        String errCatchKey = IMC_SIM_ABOLISH_ERRMSG_CACHE + this.getView().getPageId();
        CacheHelper.remove((String)catchKey);
        CacheHelper.remove((String)errCatchKey);
        String invoiceType = dynamicObjectArray[0].getString("invoicetype");
        if (bl && AllEleAuthHelper.isElePaper((Object)dynamicObjectArray[0].getString("iselepaper")) || InvoiceUtils.isAllEVehicleInv((String)invoiceType)) {
            HashMap param = Maps.newHashMap();
            param.put("salertaxno", dynamicObjectArray[0].getString("salertaxno"));
            boolean isNeedlogin = AllEleServiceHelper.isNeedLogin((AbstractFormPlugin)this, (Map)param);
            LOGGER.info("\u662f\u5426\u8fdb\u884c\u4e86\u767b\u5f55" + isNeedlogin);
            if (isNeedlogin) {
                return;
            }
        }
        RequestContext context = RequestContext.get();
        ThreadPools.executeOnce((String)"for:paper-abolish", () -> {
            RequestContext.copyAndSet((RequestContext)context);
            int successFlag = 0;
            this.setComponentDiv("1", invoiceList[0].getString("invoicecode"), invoiceList[0].getString("invoiceno"), "1", "\u53d1\u7968\u4f5c\u5e9f");
            JSONObject jObject = JSONObject.parseObject((String)"{}");
            JSONArray errMsgArray = JSONArray.parseArray((String)"[]");
            boolean success = true;
            for (DynamicObject invoice : invoiceList) {
                try (DLock lock = DLock.create((String)("imc_invalid_" + invoice.getString("orderno")));){
                    String other;
                    boolean isGetLock = lock.tryLock(5000L);
                    if (!isGetLock) {
                        throw new MsgException(ResManager.loadKDString((String)"\u8be5\u53d1\u7968\u6b63\u5728\u4f5c\u5e9f\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"InvoiceAbolishPlugin_15", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                    }
                    jObject.put("printseq", (Object)(++successFlag));
                    jObject.put("invoicecode", (Object)invoice.getString("invoicecode"));
                    jObject.put("invoiceno", (Object)invoice.getString("invoiceno"));
                    jObject.put("timeflag", (Object)"1");
                    jObject.put("printtype", (Object)"\u53d1\u7968\u4f5c\u5e9f");
                    CacheHelper.put((String)catchKey, (String)jObject.toJSONString(), (int)600);
                    String invalidReason = (String)reasonMap.get(invoice.getPkValue() + "");
                    if ("\u5176\u4ed6".equals(invalidReason) && !StringUtils.isEmpty((CharSequence)(other = (String)reasonOtherMap.get(invoice.getPkValue() + "")))) {
                        invalidReason = other;
                    }
                    this.setNormal2Cancling(invoice);
                    MsgResponse msgResponse = new MsgResponse();
                    if (isVatInvoice && AllEleAuthHelper.isElePaper((Object)invoice.getString("iselepaper")) || InvoiceUtils.isAllEVehicleInv((String)invoiceType)) {
                        msgResponse = AllEleServiceHelper.elePaperInvoiceAbolish((DynamicObject)invoice, (String)invalidReason);
                    } else {
                        switch (invoice.getString("issuesource")) {
                            case "4": 
                            case "6": 
                            case "7": {
                                HostModeInvoiceHelper.invoiceAbolish((DynamicObject)invoice, (MsgResponse)msgResponse);
                                break;
                            }
                            case "8": {
                                BwServerInvoiceHelper.invoiceAbolish((DynamicObject)invoice, (MsgResponse)msgResponse);
                                break;
                            }
                            case "9": 
                            case "10": 
                            case "11": {
                                LyServerInvoiceHelper.invoiceAbolish((DynamicObject)invoice, (String)RequestContext.get().getUserName(), (MsgResponse)msgResponse);
                                break;
                            }
                            case "3": {
                                msgResponse.setErrorCode(ErrorType.SUCCESS.getCode());
                                break;
                            }
                            default: {
                                JSONObject jsonObject;
                                String reqParam = this.makeInvAbolishComponentParams(invoice).toJSONString();
                                String componentUrl = ComponentServiceHelper.getComponentRequestUrl((String)invoice.getString("jqbh"));
                                LOGGER.info("\u53d1\u7968\u4f5c\u5e9f\u8c03\u7528http\u8bf7\u6c42\u6570\u636e\uff1a" + reqParam);
                                if (UnitTestHelper.isUnitTest()) {
                                    jsonObject = new JSONObject();
                                    jsonObject.put("errcode", (Object)"6011");
                                } else {
                                    jsonObject = ComponentServiceHelper.doPost((String)componentUrl, (String)reqParam);
                                }
                                LOGGER.info("\u53d1\u7968\u4f5c\u5e9f\u8c03\u7528http\u8bf7\u6c42\u7684\u8fd4\u56de\u6570\u636e\uff1a" + jsonObject);
                                if (!"6011".equals(jsonObject.getString("errcode"))) {
                                    msgResponse.setErrorMsg(jsonObject.getString("description"));
                                    break;
                                }
                                msgResponse.setErrorCode(ErrorType.SUCCESS.getCode());
                            }
                        }
                    }
                    if (ErrorType.SUCCESS.getCode().equals(msgResponse.getErrorCode())) {
                        InvoiceCancelHelper.updateInvoiceAbolishStatus((DynamicObject)invoice, (String)RequestContext.get().getUserName(), (Object)invalidReason, (String)formId);
                        continue;
                    }
                    errMsgArray.add((Object)String.format(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801\uff1a%1$s:%2$s", (String)"InvoiceAbolishPlugin_25", (String)"imc-sim-formplugin", (Object[])new Object[0]), invoice.getString("invoiceno"), msgResponse.getErrorMsg()));
                }
                catch (Exception e) {
                    success = false;
                    jObject.put("timeflag", (Object)"0");
                    CacheHelper.put((String)catchKey, (String)jObject.toJSONString(), (int)600);
                    LOGGER.error("componentInvoiceAbolishFailed ", (Throwable)e);
                    this.getPageCache().put("errorMsg", e instanceof MsgException ? ((MsgException)((Object)((Object)((Object)e)))).getErrorMsg() : e.getMessage());
                    break;
                }
            }
            if (success) {
                JSONObject objMsg = JSONObject.parseObject((String)"{}");
                objMsg.put("success", (Object)invoiceList.length);
                objMsg.put("defeat", (Object)errMsgArray.size());
                objMsg.put("errmsg", (Object)errMsgArray);
                CacheHelper.put((String)errCatchKey, (String)objMsg.toJSONString(), (int)600);
                jObject.put("timeflag", (Object)"0");
                CacheHelper.put((String)catchKey, (String)jObject.toJSONString(), (int)600);
            }
        });
    }

    private void checkInvalidData(String invoiceType, Date issueTime, String invoiceStatus) {
        if (InvoiceUtils.isEtcInvoice((String)invoiceType)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u7eb8\u8d28\u53d1\u7968\u8fdb\u884c\u4f5c\u5e9f\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"InvoiceAbolishPlugin_19", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        if (!DateUtils.format((Date)new Date(), (String)"yyyyMM").equals(DateUtils.format((Date)issueTime, (String)"yyyyMM"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u6709\u5f53\u6708\u7684\u53d1\u7968\u624d\u5141\u8bb8\u4f5c\u5e9f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"InvoiceAbolishPlugin_20", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        HashSet invoiceStatusSet = Sets.newHashSet((Object[])new String[]{"0", "7"});
        if (!invoiceStatusSet.contains(invoiceStatus)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u6709\u53d1\u7968\u72b6\u6001\u4e3a'\u6b63\u5e38'\u6216\u8005'\u4f5c\u5e9f\u4e2d'\u7684\u53d1\u7968\u624d\u5141\u8bb8\u4f5c\u5e9f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"InvoiceAbolishPlugin_21", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
    }

    private void setNormal2Cancling(DynamicObject invoice) {
        if (!InvoiceStatus.isAbsoluteNormal((String)invoice.getString("invoicestatus"))) {
            return;
        }
        invoice.set("invoicestatus", (Object)"7");
        ImcSaveServiceHelper.update((DynamicObject)invoice);
    }

    private JSONObject makeInvAbolishComponentParams(DynamicObject dObject) {
        JSONObject result = JSONObject.parseObject((String)"{}");
        JSONObject param = JSONObject.parseObject((String)"{}");
        result.put("czlx", (Object)"6");
        if ("sim_vatinvoice".equals(dObject.getDynamicObjectType().getName())) {
            result.put("hxbzdh", (Object)(StringUtils.isEmpty((CharSequence)dObject.getString("terminalno")) ? "" : dObject.getString("terminalno")));
        }
        param.put("kpzl", (Object)InvoiceType.getTypeCodeHx((String)dObject.getString("invoicetype")));
        param.put("fpdm", (Object)dObject.getString("invoicecode"));
        param.put("fphm", (Object)dObject.getString("invoiceno"));
        param.put("zfr", (Object)RequestContext.get().getUserName());
        result.put("sjd", (Object)param);
        return result;
    }

    public void customEvent(CustomEventArgs e) {
        String eventName = e.getEventName();
        String args = e.getEventArgs();
        String catchKey = IMC_SIM_ABOLISH_CACHE + this.getView().getPageId();
        switch (eventName) {
            case "foreachData": {
                String data = CacheHelper.get((String)catchKey);
                if (StringUtils.isNotBlank((CharSequence)data)) {
                    JSONObject dObject = JSONObject.parseObject((String)data);
                    if (!StringUtils.isNotBlank((CharSequence)args)) break;
                    this.setComponentDiv(dObject.getString("printseq"), dObject.getString("invoicecode"), dObject.getString("invoiceno"), dObject.getString("timeflag"), dObject.getString("printtype"));
                    break;
                }
                this.closeByErr();
                break;
            }
            case "closePrint": {
                if (StringUtils.isNotBlank((CharSequence)CacheHelper.get((String)catchKey))) {
                    if (this.getModel().getValue("abolishflag").toString().equals("1")) {
                        JSONObject dObject = JSONObject.parseObject((String)CacheHelper.get((String)catchKey));
                        this.setComponentDiv(dObject.getString("printseq"), dObject.getString("invoicecode"), dObject.getString("invoiceno"), dObject.getString("timeflag"), dObject.getString("printtype"));
                        this.getModel().setValue("abolishflag", (Object)"0");
                        break;
                    }
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d1\u7968\u4f5c\u5e9f\u6267\u884c\u4e2d\uff0c\u8bf7\u52ff\u5f3a\u884c\u5173\u95ed", (String)"InvoiceAbolishPlugin_22", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                    break;
                }
                if (args.equals("finish")) {
                    this.closeByErr();
                    break;
                }
                if (!args.equals("close")) break;
                this.getView().setVisible(Boolean.FALSE, new String[]{COMPONENTFLEX});
            }
        }
    }

    private void closeByErr() {
        this.getView().setVisible(Boolean.FALSE, new String[]{COMPONENTFLEX});
        String errCatchKey = IMC_SIM_ABOLISH_ERRMSG_CACHE + this.getView().getPageId();
        if (CacheHelper.get((String)errCatchKey) != null) {
            JSONObject result = JSONObject.parseObject((String)CacheHelper.get((String)errCatchKey));
            result.put("success", (Object)result.getString("success"));
            result.put("defeat", (Object)result.getString("defeat"));
            result.put("errmsg", (Object)result.getString("errmsg"));
            CacheHelper.remove((String)errCatchKey);
            this.getView().returnDataToParent((Object)result);
            this.getView().close();
        } else {
            this.getModel().setValue("abolishflag", (Object)"1");
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u4f5c\u5e9f\u6267\u884c\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5 %s", (String)"InvoiceAbolishPlugin_26", (String)"imc-sim-formplugin", (Object[])new Object[0]), this.getPageCache().get("errorMsg")));
        }
    }
}

