/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.issuing.paperprint;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.EventObject;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.imc.bdm.common.constant.ImcPermItemEnum;
import kd.imc.bdm.common.constant.PrintTypeEnum;
import kd.imc.bdm.common.helper.ComponentServiceHelper;
import kd.imc.bdm.common.helper.PermissionHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.sim.common.helper.PaperPrintHelper;
import kd.imc.sim.formplugin.issuing.paperprint.control.PrintInvoiceControl;
import org.apache.commons.lang3.StringUtils;

public class InvoicePrintListPlugin
extends AbstractFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(InvoicePrintListPlugin.class);
    private static final String COMPONENTFLEX = "epnamequery";
    private static final String PRINT_SETUP = "printsetup";
    private static final String PRINT = "print";
    private static final String IMC_SIM_PRINT_CACHE = "imc_sim_print_cache_";
    private static final String IMC_SIM_PRINT_DEFEAT_CACHE = "imc_sim_print_defeat_cache_";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{PRINT_SETUP, PRINT});
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (PRINT.equals(key)) {
            Map customParams = PaperPrintHelper.getCustomParams((AbstractFormPlugin)this);
            JSONArray arr = (JSONArray)customParams.get("keys");
            Object[] ids = arr.toArray();
            String tableFormId = PrintInvoiceControl.getFormId((String)this.getPageCache().get("printType"));
            DynamicObject[] vatInvoiceList = BusinessDataServiceHelper.load((String)tableFormId, (String)PropertieUtil.getAllPropertiesSplitByComma((String)tableFormId), (QFilter[])new QFilter("id", "in", (Object)ids).toArray(), (String)MessageFormat.format("{0} asc", "invoiceno"));
            PermissionHelper.checkPermission((String)"sim", (String)"sim_vatinvoice", (long)DynamicObjectUtil.getDynamicObjectLongValue((Object)vatInvoiceList[0].get("orgid")), (ImcPermItemEnum)ImcPermItemEnum.INVOICE_PRINT);
            this.getView().setEnable(Boolean.FALSE, new String[]{PRINT});
            this.startPrint(customParams);
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setEnable(Boolean.FALSE, new String[]{"entryentity"});
        String printType = (String)this.getView().getFormShowParameter().getCustomParam("type");
        if (!PrintTypeEnum.QD_PRINT.getType().equals(printType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"printnumflex"});
        } else {
            String printNum = CacheHelper.get((String)("detail_print_num" + RequestContext.get().getOrgId() + RequestContext.get().getUserId()));
            if (StringUtils.isNotBlank((CharSequence)printNum)) {
                this.getModel().setValue("printnum", (Object)Integer.parseInt(printNum));
            }
        }
        this.getPageCache().put("printType", printType);
        Map customParams = PaperPrintHelper.getCustomParams((AbstractFormPlugin)this);
        JSONArray arr = (JSONArray)customParams.get("keys");
        Object[] ids = arr.toArray();
        String tableFormId = PrintInvoiceControl.getFormId((String)printType);
        DynamicObject[] vatInvoiceList = BusinessDataServiceHelper.load((String)tableFormId, (String)PropertieUtil.getAllPropertiesSplitByComma((String)tableFormId), (QFilter[])new QFilter("id", "in", (Object)ids).toArray(), (String)MessageFormat.format("{0} asc", "invoiceno"));
        if ("sim_vatinvoice_vehicles".equals(tableFormId)) {
            PermissionHelper.checkPermission((String)"sim", (String)"sim_vatinvoice_vehicles", (long)DynamicObjectUtil.getDynamicObjectLongValue((Object)vatInvoiceList[0].get("orgid")), (ImcPermItemEnum)ImcPermItemEnum.INVOICE_PRINT);
        }
        if (vatInvoiceList.length > 0) {
            JSONObject printMachineResponseJson;
            this.getView().setVisible(Boolean.FALSE, new String[]{COMPONENTFLEX});
            this.sendData2CustomView("0", "************", "************", "1", ResManager.loadKDString((String)"\u5f00\u59cb\u6253\u5370", (String)"InvoicePrintListPlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            PrintInvoiceControl.initListViewAndShowSummation((AbstractFormPlugin)this, (String)printType, (DynamicObject[])vatInvoiceList);
            String printName = PrintInvoiceControl.getPrinterNameCacheKey((String)printType, (String)vatInvoiceList[0].getString("jqbh"));
            try {
                printMachineResponseJson = PrintInvoiceControl.sendGetPrintMachineRequest((String)vatInvoiceList[0].getString("jqbh"), (long)DynamicObjectUtil.getDynamicObjectLongValue((Object)vatInvoiceList[0].get("orgid")));
            }
            catch (MsgException msgException) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u6253\u5370\u673a\u5217\u8868\u5931\u8d25\uff1a%s", (String)"InvoicePrintListPlugin_1", (String)"imc-sim-formplugin", (Object[])new Object[0]), msgException.getErrorMsg()));
                return;
            }
            LOGGER.info("getMachineInfo:" + printMachineResponseJson);
            if (ErrorType.SUCCESS.getCode().equals(printMachineResponseJson.getString("errcode"))) {
                PrintInvoiceControl.handleGetPrinterMachineResponse((AbstractFormPlugin)this, (JSONObject)printMachineResponseJson, (String)printName);
                return;
            }
            this.getView().setEnable(Boolean.FALSE, new String[]{PRINT});
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u6253\u5370\u673a\u5217\u8868\u5931\u8d25:%1$s errMsg:%2$s", (String)"InvoicePrintListPlugin_10", (String)"imc-sim-formplugin", (Object[])new Object[0]), vatInvoiceList[0].getString("jqbh"), printMachineResponseJson.getString("description")));
        }
    }

    private void sendData2CustomView(String printSeq, String invoiceCode, String invoiceNo, String timeFlag, String printType) {
        Map map = PrintInvoiceControl.getSendCustomViewData((String)printSeq, (String)invoiceCode, (String)invoiceNo, (String)timeFlag, (String)printType);
        CustomControl printControl = (CustomControl)this.getView().getControl(COMPONENTFLEX);
        printControl.setData((Object)map);
    }

    private void startPrint(Map<String, Object> customParams) {
        this.getView().setVisible(Boolean.TRUE, new String[]{COMPONENTFLEX});
        JSONArray keys = JSONArray.parseArray((String)customParams.get("keys").toString());
        String printType = this.getPageCache().get("printType");
        LOGGER.info("startPrint printType: " + printType);
        String printTypeStr = printType.equals(PrintTypeEnum.QD_PRINT.getType()) ? "\u6253\u5370\u6e05\u5355" : "\u6253\u5370\u53d1\u7968";
        String printmerName = this.getView().getControl("printmer").getModel().getValue("printmer").toString();
        LOGGER.info("startPrint \u5728\u6267\u884c\u6253\u5370\u7684\u6253\u5370\u673aprintmerName\uff1a" + printmerName);
        String printCache = IMC_SIM_PRINT_CACHE + this.getView().getPageId();
        String printErrCache = IMC_SIM_PRINT_DEFEAT_CACHE + this.getView().getPageId();
        String formId = PrintInvoiceControl.getFormId((String)printType);
        DynamicObject[] invoiceList = BusinessDataServiceHelper.load((String)formId, (String)PropertieUtil.getAllPropertiesSplitByComma((String)formId), (QFilter[])new QFilter("id", "in", (Object)keys.toArray()).toArray(), (String)MessageFormat.format("{0} asc", "invoiceno"));
        String printNameCacheKey = PrintInvoiceControl.getPrinterNameCacheKey((String)printType, (String)invoiceList[0].getString("jqbh"));
        LOGGER.info("startPrint cachePrintNameKey: " + printNameCacheKey);
        CacheHelper.put((String)printNameCacheKey, (String)printmerName, (int)2592000);
        ThreadPools.executeOnce((String)"for:paper-print", () -> {
            int successFlag = 0;
            JSONObject jObject = JSONObject.parseObject((String)"{}");
            jObject.put("printseq", (Object)(successFlag + 1));
            jObject.put("invoicecode", (Object)invoiceList[0].getString("invoicecode"));
            jObject.put("invoiceno", (Object)invoiceList[0].getString("invoiceno"));
            jObject.put("timeflag", (Object)"1");
            jObject.put("printtype", (Object)printTypeStr);
            this.getPageCache().put(printCache, jObject.toJSONString());
            this.sendData2CustomView("1", invoiceList[0].getString("invoicecode"), invoiceList[0].getString("invoiceno"), "1", printTypeStr);
            String requestUrl = ComponentServiceHelper.getComponentRequestUrl((String)invoiceList[0].getString("jqbh"));
            int printCount = ((BigDecimal)this.getModel().getValue("printnum")).intValue();
            CacheHelper.put((String)("detail_print_num" + RequestContext.get().getOrgId() + RequestContext.get().getUserId()), (String)String.valueOf(printCount), (int)604800);
            for (DynamicObject obj : invoiceList) {
                jObject.put("printseq", (Object)(++successFlag));
                jObject.put("invoicecode", (Object)obj.getString("invoicecode"));
                jObject.put("invoiceno", (Object)obj.getString("invoiceno"));
                jObject.put("timeflag", (Object)"1");
                jObject.put("printtype", (Object)printTypeStr);
                this.getPageCache().put(printCache, jObject.toJSONString());
                LOGGER.info(String.format("startPrint \u6279\u91cf\u6253\u5370\u7684\u53d1\u7968\u4ee3\u7801\uff1a%s \u53f7\u7801\uff1a%s", obj.getString("invoicecode"), obj.getString("invoiceno")));
                boolean printRequest = true;
                for (int i = 0; i < printCount; ++i) {
                    try {
                        String requestData = PrintInvoiceControl.makeComponentReqJSON((DynamicObject)obj, (String)printType, (String)printmerName).toJSONString();
                        String errorMsg = PrintInvoiceControl.sendPrintInvoiceRequest((String)requestData, (String)requestUrl, (DynamicObject)obj);
                        if (StringUtils.isEmpty((CharSequence)errorMsg)) continue;
                        this.getPageCache().put("printErrorMsg", errorMsg);
                        printRequest = false;
                        continue;
                    }
                    catch (Exception e) {
                        printRequest = false;
                        LOGGER.error(String.format("startPrint \u53d1\u7968\u53f7\u7801%s\u6253\u5370\u5931\u8d25", obj.getString("invoiceno")), (Throwable)e);
                        break;
                    }
                }
                if (!printRequest) {
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("batchPrintDefault:" + this.getPageCache().get(printCache));
                    }
                    jObject.put("timeflag", (Object)"0");
                    this.getPageCache().put(printErrCache, jObject.toJSONString());
                    this.getPageCache().remove(printCache);
                    this.sendData2CustomView(jObject.getString("printseq"), jObject.getString("invoicecode"), jObject.getString("invoiceno"), "0", printTypeStr);
                    break;
                }
                if (successFlag != invoiceList.length) continue;
                jObject.put("timeflag", (Object)"0");
                this.getPageCache().put(printCache, jObject.toJSONString());
                this.sendData2CustomView(jObject.getString("printseq"), jObject.getString("invoicecode"), jObject.getString("invoiceno"), "0", printTypeStr);
            }
        });
    }

    public void customEvent(CustomEventArgs e) {
        String eventName = e.getEventName();
        String args = e.getEventArgs();
        String printCache = IMC_SIM_PRINT_CACHE + this.getView().getPageId();
        String printErrCache = IMC_SIM_PRINT_DEFEAT_CACHE + this.getView().getPageId();
        switch (eventName) {
            case "foreachData": {
                String data = this.getPageCache().get(printCache);
                if (StringUtils.isNotBlank((CharSequence)data)) {
                    JSONObject dObject = JSONObject.parseObject((String)data);
                    if (!StringUtils.isNotBlank((CharSequence)args)) break;
                    this.sendData2CustomView(dObject.getString("printseq"), dObject.getString("invoicecode"), dObject.getString("invoiceno"), dObject.getString("timeflag"), dObject.getString("printtype"));
                    break;
                }
                this.getView().setVisible(Boolean.FALSE, new String[]{COMPONENTFLEX});
                if (this.getPageCache().get(printErrCache) != null) {
                    PrintInvoiceControl.jumpShowPrintSuccessOrErrorPage((AbstractFormPlugin)this, (String)printErrCache, (boolean)false);
                    break;
                }
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6253\u5370\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6216\u91cd\u8bd5", (String)"InvoicePrintListPlugin_8", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                break;
            }
            case "closePrint": {
                if (args.equals("finish")) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{COMPONENTFLEX});
                    if (this.getPageCache().get(printErrCache) != null) {
                        PrintInvoiceControl.jumpShowPrintSuccessOrErrorPage((AbstractFormPlugin)this, (String)printErrCache, (boolean)false);
                        break;
                    }
                    PrintInvoiceControl.jumpShowPrintSuccessOrErrorPage((AbstractFormPlugin)this, null, (boolean)true);
                    break;
                }
                if (args.equals("close") && this.getPageCache().get(printCache) != null && this.getPageCache().get(printErrCache) == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d1\u7968\u6253\u5370\u4e2d\uff0c\u8bf7\u52ff\u5f3a\u884c\u5173\u95ed", (String)"InvoicePrintListPlugin_9", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                    break;
                }
                if (!args.equals("close") || this.getPageCache().get(printCache) != null) break;
                this.getView().setVisible(Boolean.FALSE, new String[]{COMPONENTFLEX});
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if ("sim_print_success".equals(actionId)) {
            this.getView().returnDataToParent((Object)"colse");
            this.getView().close();
        }
    }
}

