/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.issuing.paperprint;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.EquipmentConstant;
import kd.imc.bdm.common.constant.ImcPermItemEnum;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.PrintTypeEnum;
import kd.imc.bdm.common.helper.EquipmentHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.PermissionHelper;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.common.dto.SelectPrintDto;
import kd.imc.sim.common.helper.PaperPrintHelper;
import kd.imc.sim.common.utils.InvoiceQFilterUtil;
import kd.imc.sim.untrans.SimFormPluginConstellationUntrans;

public class InvoicePwtPrintListPlugin
extends AbstractFormPlugin
implements SimFormPluginConstellationUntrans {
    private static final Log LOGGER = LogFactory.getLog(InvoicePwtPrintListPlugin.class);
    private static final String COMPONENTFLEX = "epnamequery";
    private static final String PRINT_SETUP = "printsetup";
    private static final String PRINT = "print";
    private static final String IMC_SIM_PRINT_CACHE = "imc_sim_print_cache_";
    private static final String IMC_SIM_PRINT_DEFEAT_CACHE = "imc_sim_print_defeat_cache_";
    private static final String PRINT_SEQ_NO = "seqno_";
    private static final String WAIT_TO_PRINT_LIST = "wait_to_print_list_";
    private static final String SIM_INVOICE_PRINT_TYPE = "sim_invoice_local_print";
    private static final String SIM_INVOICE_PRINT_ADDRESS = "address";

    public void afterCreateNewData(EventObject e) {
        this.getView().setEnable(Boolean.FALSE, new String[]{"entryentity"});
        String printType = (String)this.getView().getFormShowParameter().getCustomParam("type");
        if (!PrintTypeEnum.QD_PRINT.getType().equals(printType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"printnumflex"});
        } else {
            String printnum = CacheHelper.get((String)("detail_print_num" + RequestContext.get().getOrgId() + RequestContext.get().getUserId()));
            if (StringUtils.isNotBlank((CharSequence)printnum)) {
                this.getModel().setValue("printnum", (Object)Integer.parseInt(printnum));
            }
        }
        DynamicObject[] invoices = this.queryPrintInvoiceList();
        if (invoices.length > 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{COMPONENTFLEX});
            this.setComponentDiv("0", "************", "************", "1", ResManager.loadKDString((String)"\u5f00\u59cb\u6253\u5370", (String)"InvoicePwtPrintListPlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            IDataModel modelDetail = this.getControl("entryentity").getModel();
            String str = ResManager.loadKDString((String)"\u603b\u8ba1\uff1a \u5f00\u7968\u4efd\u6570%1$s\u4efd\uff0c\u5408\u8ba1\u7a0e\u989d%2$s\u5143\uff0c\u4ef7\u7a0e\u5408\u8ba1%3$s\u5143", (String)"InvoicePwtPrintListPlugin_26", (String)"imc-sim-formplugin", (Object[])new Object[0]);
            BigDecimal totaltax = BigDecimal.ZERO;
            BigDecimal totalamount = BigDecimal.ZERO;
            for (DynamicObject invoice : invoices) {
                int index = this.getModel().createNewEntryRow("entryentity");
                modelDetail.setValue("invoicecode", invoice.get("invoicecode"), index);
                modelDetail.setValue("invoiceno", invoice.get("invoiceno"), index);
                modelDetail.setValue("invoiceamount", invoice.get("invoiceamount"), index);
                modelDetail.setValue("totaltax", invoice.get("totaltax"), index);
                modelDetail.setValue("totalamount", invoice.get("totalamount"), index);
                modelDetail.setValue("invoicetype", invoice.get("invoicetype"), index);
                modelDetail.setValue("inventorymark", invoice.get("inventorymark"), index);
                totaltax = totaltax.add(invoice.getBigDecimal("totaltax"));
                totalamount = totalamount.add(invoice.getBigDecimal("totalamount"));
            }
            Label title = (Label)this.getControl("allaccount");
            title.setText(String.format(str, invoices.length, totaltax.setScale(2, 0), totalamount.setScale(2, 0)));
        }
    }

    private DynamicObject[] queryPrintInvoiceList() {
        Map customParams = PaperPrintHelper.getCustomParams((AbstractFormPlugin)this);
        JSONArray arr = (JSONArray)customParams.get("keys");
        Object[] objects = arr.toArray();
        return BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)"invoicecode,invoiceno,invoiceamount,totaltax,totalamount,invoicetype,inventorymark,orgid,jqbh", (QFilter[])new QFilter("id", "in", (Object)objects).toArray(), (String)MessageFormat.format("{0} asc", "invoiceno"));
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{PRINT_SETUP, PRINT});
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (PRINT.equals(key)) {
            DynamicObject[] dynamicObjects = this.queryPrintInvoiceList();
            PermissionHelper.checkPermission((String)"sim", (String)"sim_vatinvoice", (long)DynamicObjectUtil.getDynamicObjectLongValue((Object)dynamicObjects[0].get("orgid")), (ImcPermItemEnum)ImcPermItemEnum.INVOICE_PRINT);
            String pageId = this.getView().getPageId();
            String printLockKey = pageId + "printInovice";
            if (StringUtils.isNotBlank((CharSequence)CacheHelper.get((String)printLockKey))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u77ed\u65f6\u95f4\u5185\uff0810s\uff09\u8bf7\u52ff\u91cd\u590d\u6253\u5370", (String)"InvoicePwtPrintListPlugin_2", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                return;
            }
            try (DLock lock = DLock.create((String)printLockKey);){
                if (lock.tryLock(50L)) {
                    if (StringUtils.isNotBlank((CharSequence)CacheHelper.get((String)printLockKey))) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u77ed\u65f6\u95f4\u5185\uff0810s\uff09\u8bf7\u52ff\u91cd\u590d\u6253\u5370", (String)"InvoicePwtPrintListPlugin_2", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    CacheHelper.put((String)printLockKey, (String)"id", (int)10);
                    this.getComponentPrint();
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6253\u5370\u4efb\u52a1\u5728\u5904\u7406\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"InvoicePwtPrintListPlugin_3", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                }
            }
        }
    }

    private void getComponentPrint() {
        this.getView().setVisible(Boolean.TRUE, new String[]{COMPONENTFLEX});
        Map customParams = PaperPrintHelper.getCustomParams((AbstractFormPlugin)this);
        JSONArray keys = JSONArray.parseArray((String)customParams.get("keys").toString());
        String typeFlag = customParams.get("type").toString();
        String printtype = typeFlag.equals(PrintTypeEnum.INVOICE_PRINT.getType()) ? "\u5957\u6253\u53d1\u7968" : "\u5957\u6253\u6e05\u5355";
        String printCache = IMC_SIM_PRINT_CACHE + this.getView().getPageId();
        String printErrCache = IMC_SIM_PRINT_DEFEAT_CACHE + this.getView().getPageId();
        CacheHelper.remove((String)printCache);
        CacheHelper.remove((String)printErrCache);
        DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice", (boolean)true), (QFilter[])new QFilter("id", "in", (Object)keys.toArray()).toArray(), (String)MessageFormat.format("{0} asc", "invoiceno"));
        int printnum = ((BigDecimal)this.getModel().getValue("printnum")).intValue();
        CacheHelper.put((String)("detail_print_num" + RequestContext.get().getOrgId() + RequestContext.get().getUserId()), (String)String.valueOf(printnum), (int)604800);
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        for (int invoiceIndex = 0; invoiceIndex < invoices.length; ++invoiceIndex) {
            DynamicObject invoice = invoices[invoiceIndex];
            JSONObject jObject = JSONObject.parseObject((String)"{}");
            jObject.put("printseq", (Object)(invoiceIndex + 1));
            jObject.put("invoicecode", (Object)invoice.getString("invoicecode"));
            jObject.put("invoiceno", (Object)invoice.getString("invoiceno"));
            jObject.put("timeflag", (Object)"1");
            jObject.put("printtype", (Object)printtype);
            jObject.put("totalsize", (Object)invoices.length);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(String.format("pageId:[%s]\uff0c\u6279\u91cf\u6253\u5370\u7684\u53d1\u7968\u4ee3\u7801\uff1a[%s]\u53f7\u7801\uff1a[%s]", this.getView().getPageId(), invoice.getString("invoicecode"), invoice.getString("invoiceno")));
            }
            for (int printNumIndex = 0; printNumIndex < printnum; ++printNumIndex) {
                JSONObject requestData = this.makeComponentReqJSON(invoice, typeFlag);
                SelectPrintDto selectPrintDto = new SelectPrintDto();
                selectPrintDto.setInvoiceNumber(invoiceIndex + 1);
                selectPrintDto.setPrintCache(jObject.toJSONString());
                selectPrintDto.setInvoiceCode(invoice.getString("invoicecode"));
                selectPrintDto.setInvoiceNo(invoice.getString("invoiceno"));
                selectPrintDto.setPrintType(printtype);
                selectPrintDto.setPrintData(requestData.toJSONString());
                int keyNo = invoiceIndex * printnum + printNumIndex + 1;
                map.put(String.valueOf(keyNo), selectPrintDto);
            }
        }
        int totalSize = invoices.length * printnum;
        map.put("size", totalSize);
        CacheHelper.put((String)(WAIT_TO_PRINT_LIST + this.getView().getPageId()), (String)JSONObject.toJSONString(map));
        this.startInvoiceOrList((SelectPrintDto)map.get("1"), 1, "0");
    }

    private void startInvoiceOrList(SelectPrintDto selectPrintDto, int seq, String timeFlag) {
        String printCache = IMC_SIM_PRINT_CACHE + this.getView().getPageId();
        String printCacheValue = selectPrintDto.getPrintCache();
        String printData = selectPrintDto.getPrintData();
        int invoiceNumber = selectPrintDto.getInvoiceNumber();
        CacheHelper.put((String)printCache, (String)printCacheValue, (int)900);
        CacheHelper.put((String)(PRINT_SEQ_NO + this.getView().getPageId()), (String)String.valueOf(seq), (int)900);
        this.setComponentDiv(invoiceNumber + "", selectPrintDto.getInvoiceCode(), selectPrintDto.getInvoiceNo(), timeFlag, selectPrintDto.getPrintType());
        JSONObject reqDataJson = JSONObject.parseObject((String)printData);
        LOGGER.info(String.format("pageId:[%s],\u8bf7\u6c42\u7ec4\u4ef6\u6253\u5370\u8bf7\u6c42\u53c2\u6570:[%s]", this.getView().getPageId(), printData));
        this.callPrintInvoice(reqDataJson);
    }

    private void callPrintInvoice(JSONObject requestData) {
        HashMap<String, String> showDataMap = new HashMap<String, String>(4);
        showDataMap.put("eventKey", "crossHttp");
        showDataMap.put("data", (String)this.getJsonData(requestData, "post"));
        ViewUtil.bindDataToHtml((AbstractFormPlugin)this, showDataMap, (String)"crosshttp");
    }

    public JSONObject getJsonData(JSONObject requestData, String method) {
        JSONObject dataJson = new JSONObject();
        dataJson.put("data", (Object)requestData);
        dataJson.put("url", (Object)this.getRequestUrl());
        dataJson.put("method", (Object)method);
        dataJson.put("timeout", (Object)900000);
        return dataJson;
    }

    public String getRequestUrl() {
        String requestUrl = ImcConfigUtil.getValue((String)SIM_INVOICE_PRINT_TYPE, (String)SIM_INVOICE_PRINT_TYPE.concat("_").concat(SIM_INVOICE_PRINT_ADDRESS));
        if (StringUtils.isBlank((CharSequence)requestUrl)) {
            requestUrl = "http://127.0.0.1:61623";
        }
        if (!requestUrl.startsWith("http://")) {
            requestUrl = "http://".concat(requestUrl);
        }
        return requestUrl;
    }

    private void setComponentDiv(String printseq, String invoicecode, String invoiceno, String timeflag, String printtype) {
        HashMap<String, Object> showMap = new HashMap<String, Object>(8);
        showMap.put("eventKey", "updatePrint");
        showMap.put("printseq", "0".equals(printseq) ? ResManager.loadKDString((String)"\u5f00\u59cb\u51c6\u5907\u6253\u5370", (String)"InvoicePwtPrintListPlugin_8", (String)"imc-sim-formplugin", (Object[])new Object[0]) : String.format(ResManager.loadKDString((String)"\u6b63\u5728\u6253\u5370\u7b2c%s\u5f20\u53d1\u7968...", (String)"InvoicePwtPrintListPlugin_9", (String)"imc-sim-formplugin", (Object[])new Object[0]), printseq));
        showMap.put("invoicecode", invoicecode);
        showMap.put("invoiceno", invoiceno);
        showMap.put("timeflag", timeflag);
        showMap.put("printtype", printtype);
        showMap.put("time", System.currentTimeMillis());
        CustomControl printControl = (CustomControl)this.getControl(COMPONENTFLEX);
        printControl.setData(showMap);
    }

    public void customEvent(CustomEventArgs e) {
        String eventName = e.getEventName();
        String args = e.getEventArgs();
        String printCache = IMC_SIM_PRINT_CACHE + this.getView().getPageId();
        String printErrCache = IMC_SIM_PRINT_DEFEAT_CACHE + this.getView().getPageId();
        String printMapCache = WAIT_TO_PRINT_LIST + this.getView().getPageId();
        switch (eventName) {
            case "crossHttp": {
                String printData = CacheHelper.get((String)printCache);
                String waitPrintMapStr = CacheHelper.get((String)printMapCache);
                int printSeqNo = Integer.parseInt(CacheHelper.get((String)(PRINT_SEQ_NO + this.getView().getPageId())));
                LOGGER.info(String.format("pageId:[%s],\u5f53\u524d\u6253\u5370\u56de\u8c03\u7f16\u53f7:[%s]", this.getView().getPageId(), printSeqNo));
                if (StringUtils.isNotBlank((CharSequence)printData)) {
                    if (StringUtils.isNotBlank((CharSequence)args)) {
                        JSONObject retJson = JSONObject.parseObject((String)args);
                        LOGGER.info(String.format("pageId:[%s],select_print_ret:[%s]", this.getView().getPageId(), retJson));
                        LOGGER.info(String.format("pageId:[%s],select_print_printData:[%s]", this.getView().getPageId(), printData));
                        JSONObject dObject = JSONObject.parseObject((String)printData);
                        Map waitPrintMap = (Map)JSONObject.parseObject((String)waitPrintMapStr, Map.class);
                        SelectPrintDto selectPrintDto = (SelectPrintDto)JSONObject.parseObject((String)JSONObject.toJSONString(waitPrintMap.get(printSeqNo + "")), SelectPrintDto.class);
                        int MaxSize = (Integer)waitPrintMap.get("size");
                        LOGGER.info(String.format("pageId:[%s],\u6253\u5370\u8bf7\u6c42\u603b\u5e8f\u53f7:[%s]", this.getView().getPageId(), MaxSize));
                        String errCode = retJson.getString("errcode");
                        String description = retJson.getString("description");
                        if ("err".equals(errCode)) {
                            this.getView().setVisible(Boolean.FALSE, new String[]{COMPONENTFLEX});
                            if (CacheHelper.get((String)printErrCache) != null) {
                                this.jumpErrPage(printErrCache);
                                break;
                            }
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d1\u7968\u6253\u5370\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u6253\u5f00\u4e86\u53d1\u7968\u4e91\u6253\u5370\u7ec4\u4ef6", (String)"InvoicePwtPrintListPlugin_12", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                            break;
                        }
                        if ("0000".equals(errCode)) {
                            this.updatePrintFlag(dObject, "1");
                            if (printSeqNo != 0 && printSeqNo < MaxSize) {
                                LOGGER.info(String.format("pageId:[%s],\u53d1\u8d77\u6253\u5370\u8bf7\u6c42\u7f16\u53f7\u7f16\u53f7:[%s]", this.getView().getPageId(), printSeqNo + 1));
                                SelectPrintDto nextSelectPrintDto = (SelectPrintDto)JSONObject.parseObject((String)JSONObject.toJSONString(waitPrintMap.get(printSeqNo + 1 + "")), SelectPrintDto.class);
                                this.startInvoiceOrList(nextSelectPrintDto, printSeqNo + 1, "0");
                                break;
                            }
                            dObject.put("timeflag", (Object)"0");
                            CacheHelper.remove((String)(WAIT_TO_PRINT_LIST + this.getView().getPageId()));
                            Map customParams = PaperPrintHelper.getCustomParams((AbstractFormPlugin)this);
                            String typeFlag = customParams.get("type").toString();
                            customParams.put("state", Boolean.TRUE);
                            String caption = typeFlag.equals(PrintTypeEnum.INVOICE_PRINT.getType()) ? ResManager.loadKDString((String)"\u53d1\u7968\u6253\u5370\u6210\u529f", (String)"InvoicePwtPrintListPlugin_14", (String)"imc-sim-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6e05\u5355\u6253\u5370\u6210\u529f", (String)"InvoicePwtPrintListPlugin_15", (String)"imc-sim-formplugin", (Object[])new Object[0]);
                            ViewUtil.openDialog((AbstractFormPlugin)this, (String)caption, (Map)customParams, (String)"sim_print_success", (String)"sim_print_success");
                            break;
                        }
                        this.updatePrintFlag(dObject, "2");
                        this.getView().showTipNotification(description);
                        CacheHelper.put((String)printErrCache, (String)selectPrintDto.getPrintCache(), (int)600);
                        this.jumpErrPage(printErrCache);
                        break;
                    }
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6c42\u5f02\u5e38\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u6253\u5f00\u4e86\u53d1\u7968\u4e91\u6253\u5370\u7ec4\u4ef6", (String)"InvoicePwtPrintListPlugin_16", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                    break;
                }
                this.getView().setVisible(Boolean.FALSE, new String[]{COMPONENTFLEX});
                if (CacheHelper.get((String)printErrCache) != null) {
                    this.jumpErrPage(printErrCache);
                    break;
                }
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6253\u5370\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6216\u91cd\u8bd5", (String)"InvoicePwtPrintListPlugin_17", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                break;
            }
            case "closePrint": {
                if (args.equals("close") && CacheHelper.get((String)printCache) != null && CacheHelper.get((String)printErrCache) == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d1\u7968\u6253\u5370\u4e2d\uff0c\u8bf7\u52ff\u5f3a\u884c\u5173\u95ed", (String)"InvoicePwtPrintListPlugin_18", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                    break;
                }
                if (!args.equals("close") || CacheHelper.get((String)printCache) != null) break;
                this.getView().setVisible(Boolean.FALSE, new String[]{COMPONENTFLEX});
            }
        }
    }

    public void updatePrintFlag(JSONObject object, String printFlag) {
        String invoiceCode = object.getString("invoicecode");
        String invoiceNo = object.getString("invoiceno");
        QFilter qFilter = InvoiceQFilterUtil.getInvoiceByCodeAndNo((String)invoiceCode, (String)invoiceNo);
        DynamicObject invoiceObj = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice", (boolean)false), (QFilter[])qFilter.toArray());
        if (invoiceObj != null) {
            invoiceObj.set("printflag", (Object)printFlag);
            ImcSaveServiceHelper.update((DynamicObject)invoiceObj);
        }
    }

    private void jumpErrPage(String printErrCache) {
        JSONObject errMsg = JSONObject.parseObject((String)CacheHelper.get((String)printErrCache));
        Map customParams = PaperPrintHelper.getCustomParams((AbstractFormPlugin)this);
        customParams.put("defeatNum", errMsg.getString("printseq"));
        customParams.put("invoicecode", errMsg.getString("invoicecode"));
        customParams.put("invoiceno", errMsg.getString("invoiceno"));
        customParams.put("state", Boolean.FALSE);
        String typeFlag = customParams.get("type").toString();
        String caption = typeFlag.equals(PrintTypeEnum.INVOICE_PRINT.getType()) ? ResManager.loadKDString((String)"\u5957\u6253\u53d1\u7968\u5931\u8d25", (String)"InvoicePwtPrintListPlugin_19", (String)"imc-sim-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5957\u6253\u6e05\u5355\u5931\u8d25", (String)"InvoicePwtPrintListPlugin_20", (String)"imc-sim-formplugin", (Object[])new Object[0]);
        ViewUtil.openDialog((AbstractFormPlugin)this, (String)caption, (Map)customParams, (String)"sim_print_success", (String)"sim_print_success");
    }

    private String getTaxPlatType(DynamicObject object) {
        String equipmenttype = EquipmentHelper.getEquipmentTypeByNo((String)object.getString("jqbh"));
        String taxPlatType = "0";
        if (EquipmentConstant.isOfdDevice((String)equipmenttype)) {
            taxPlatType = "2";
        } else if (EquipmentConstant.isSkpDevice((String)equipmenttype) || "8".equals(equipmenttype)) {
            taxPlatType = "1";
        } else if (EquipmentConstant.isJspDevice((String)equipmenttype)) {
            taxPlatType = "0";
        }
        return taxPlatType;
    }

    private String getInvoiceType(DynamicObject object) {
        String invoiceType = object.getString("invoicetype");
        String retInvoiceType = InvoiceType.PAPER_SPECIAL_INVOICE.getTypeCode().equals(invoiceType) ? "0" : (InvoiceType.PAPER_NOMAL_INVOICE.getTypeCode().equals(invoiceType) ? "2" : (InvoiceType.PAPER_VEHICLE_INVOICE.getTypeCode().equals(invoiceType) ? "12" : invoiceType));
        return retInvoiceType;
    }

    private JSONObject makeComponentReqJSON(DynamicObject invoiceDO, String typeFlag) {
        JSONObject reqData = new JSONObject();
        reqData.put("czlx", (Object)"1");
        JSONObject sjd = new JSONObject();
        sjd.put("dylx", (Object)(PrintTypeEnum.QD_PRINT.getType().equals(typeFlag) ? "2" : "1"));
        sjd.put("splx", (Object)this.getTaxPlatType(invoiceDO));
        sjd.put("fplx", (Object)this.getInvoiceType(invoiceDO));
        sjd.put("qdbz", (Object)invoiceDO.getString("inventorymark"));
        String remark = invoiceDO.getString("remark");
        String redRemark = "\u5bf9\u5e94\u6b63\u6570\u53d1\u7968\u4ee3\u7801:" + invoiceDO.getString("originalinvoicecode") + " \u53f7\u7801:" + invoiceDO.getString("originalinvoiceno") + "\u3002";
        if (InvoiceType.PAPER_SPECIAL_INVOICE.getTypeCode().equals(invoiceDO.getString("invoicetype"))) {
            if ("1".equals(invoiceDO.getString("issuetype"))) {
                String tempRemark = "";
                if (StringUtils.isNotBlank((CharSequence)invoiceDO.getString("originalinvoicecode")) && !remark.contains("\u6b63\u6570\u53d1\u7968\u4ee3\u7801")) {
                    tempRemark = redRemark;
                }
                if (!remark.contains("\u4e13\u7528\u53d1\u7968\u4fe1\u606f\u8868\u7f16\u53f7")) {
                    QFilter qFilter;
                    DynamicObject vatRedObj;
                    String infocode = invoiceDO.getString("infocode");
                    String infocodeRemark = "";
                    if (StringUtils.isBlank((CharSequence)infocode) && (vatRedObj = BusinessDataServiceHelper.loadSingle((String)"sim_red_info", (String)"infocode", (QFilter[])(qFilter = InvoiceQFilterUtil.getInvoiceByCodeAndNo((String)invoiceDO.getString("invoicecode"), (String)invoiceDO.getString("invoiceno"))).toArray())) != null) {
                        infocode = vatRedObj.getString("infocode");
                    }
                    if (StringUtils.isNotEmpty((CharSequence)infocode)) {
                        infocodeRemark = String.format(ResManager.loadKDString((String)"\u5f00\u5177\u7ea2\u5b57\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\u4fe1\u606f\u8868\u7f16\u53f7:%s", (String)"InvoicePwtPrintListPlugin_28", (String)"imc-sim-formplugin", (Object[])new Object[0]), infocode);
                    }
                    remark = tempRemark.concat(infocodeRemark).concat(remark);
                }
            }
        } else if ("1".equals(invoiceDO.getString("issuetype")) && StringUtils.isNotBlank((CharSequence)invoiceDO.getString("originalinvoicecode")) && !remark.contains("\u6b63\u6570\u53d1\u7968\u4ee3\u7801")) {
            remark = redRemark.concat(remark);
        }
        sjd.put("bz", (Object)remark);
        sjd.put("fpdm", (Object)invoiceDO.getString("invoicecode"));
        sjd.put("fphm", (Object)invoiceDO.getString("invoiceno"));
        sjd.put("yfpdm", (Object)invoiceDO.getString("originalinvoicecode"));
        sjd.put("yfphm", (Object)invoiceDO.getString("originalinvoiceno"));
        sjd.put("mmq", (Object)invoiceDO.getString("skm"));
        sjd.put("kprq", (Object)DateUtils.format((Date)invoiceDO.getDate("issuetime"), (String)"yyyyMMdd"));
        sjd.put("jqbh", (Object)invoiceDO.getString("jqbh"));
        sjd.put("kplx", (Object)invoiceDO.getString("issuetype"));
        sjd.put("bmbb", (Object)"");
        sjd.put("zfbz", (Object)this.dealWithZFBZ(invoiceDO.getString("invoicestatus")));
        sjd.put("tspz", (Object)invoiceDO.getString("specialtype"));
        sjd.put("zhsl", (Object)"");
        sjd.put("jym", (Object)invoiceDO.getString("checkcode"));
        sjd.put("hsbz", (Object)"0");
        sjd.put("xhf_nsrsbh", (Object)invoiceDO.getString("salertaxno"));
        sjd.put("xhf_mc", (Object)invoiceDO.getString("salername"));
        sjd.put("xhf_dzdh", (Object)invoiceDO.getString("saleraddr"));
        sjd.put("xhf_yhzh", (Object)invoiceDO.getString("salerbank"));
        sjd.put("ghf_nsrsbh", (Object)invoiceDO.getString("buyertaxno"));
        sjd.put("ghf_mc", (Object)invoiceDO.getString("buyername"));
        sjd.put("ghf_dzdh", (Object)invoiceDO.getString("buyeraddr"));
        sjd.put("ghf_yhzh", (Object)invoiceDO.getString("buyerbank"));
        sjd.put("kpy", (Object)invoiceDO.getString("drawer"));
        sjd.put("sky", (Object)invoiceDO.getString("payee"));
        sjd.put("fhr", (Object)invoiceDO.getString("reviewer"));
        sjd.put("hjje", (Object)this.dealWithZeroBigDecial(invoiceDO.getBigDecimal("invoiceamount")));
        sjd.put("hjse", (Object)this.dealWithZeroBigDecial(invoiceDO.getBigDecimal("totaltax")));
        sjd.put("jshj", (Object)this.dealWithZeroBigDecial(invoiceDO.getBigDecimal("totalamount")));
        JSONArray items2 = new JSONArray();
        DynamicObjectCollection itemsCollection = invoiceDO.getDynamicObjectCollection("items");
        for (DynamicObject item : itemsCollection) {
            JSONObject itemJson = new JSONObject();
            itemJson.put("xmlx", (Object)(StringUtils.isBlank((CharSequence)item.getString("rowtype")) ? "0" : item.getString("rowtype")));
            itemJson.put("xmdw", (Object)item.getString("unit"));
            itemJson.put("xmmc", (Object)item.getString("goodsname"));
            BigDecimal numBig = item.getBigDecimal("num");
            if (BigDecimalUtil.compareZero((BigDecimal)numBig)) {
                itemJson.put("xmsl", (Object)"");
            } else {
                itemJson.put("xmsl", (Object)item.getString("num"));
            }
            itemJson.put("xmje", (Object)this.dealWithZeroBigDecial(item.getBigDecimal("amount")));
            itemJson.put("ggxh", (Object)item.getString("specification"));
            itemJson.put("se", (Object)this.dealWithZeroBigDecial(item.getBigDecimal("tax")));
            itemJson.put("sl", (Object)item.getString("taxrate"));
            BigDecimal unitPriceBig = item.getBigDecimal("unitprice");
            if (BigDecimalUtil.compareZero((BigDecimal)unitPriceBig)) {
                itemJson.put("xmdj", (Object)"");
            } else {
                itemJson.put("xmdj", (Object)item.getString("unitprice"));
            }
            JSONObject taxcode = new JSONObject();
            taxcode.put("kce", (Object)this.dealWithZeroBigDecial(invoiceDO.getBigDecimal("deduction")));
            taxcode.put("lslvbs", (Object)this.getPrintZeroMark(item.getString("zerotaxmark")));
            taxcode.put("ssflbm", (Object)item.getString("goodscode"));
            taxcode.put("yhzc", (Object)item.getString("taxpremark"));
            taxcode.put("yhzcnr", (Object)"");
            itemJson.put("taxcode", (Object)taxcode);
            items2.add((Object)itemJson);
        }
        sjd.put("items", (Object)items2);
        reqData.put("sjd", (Object)sjd);
        return reqData;
    }

    public String dealWithZFBZ(String invoiceStatus) {
        if ("6".equals(invoiceStatus)) {
            return "1";
        }
        return "";
    }

    public String dealWithZeroBigDecial(BigDecimal bigDecimal) {
        if (BigDecimalUtil.compareZero((BigDecimal)bigDecimal)) {
            return "0";
        }
        return bigDecimal.toString();
    }

    public String getPrintZeroMark(String taxZeroMark) {
        String retTaxZeroMark;
        switch (taxZeroMark) {
            case "1": {
                retTaxZeroMark = "1";
                break;
            }
            case "2": {
                retTaxZeroMark = "2";
                break;
            }
            case "3": {
                retTaxZeroMark = "3";
                break;
            }
            case "0": {
                retTaxZeroMark = "0";
                break;
            }
            default: {
                retTaxZeroMark = "";
            }
        }
        return retTaxZeroMark;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if ("sim_print_success".equals(actionId)) {
            this.getView().returnDataToParent((Object)"colse");
            this.getView().close();
        }
    }
}

