/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.issuing.task;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.imc.bdm.common.dto.BillMatch.BillMatchDetailVo;
import kd.imc.bdm.common.dto.BillMatch.BillMatchInvoiceDetailVo;
import kd.imc.bdm.common.dto.BillMatch.BillMatchResultResponseVo;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.sim.common.dto.minusbill.MatchInvoiceDTO;
import kd.imc.sim.common.dto.minusbill.MinusBillDTO;
import kd.imc.sim.common.dto.minusbill.MinusBillItemDTO;
import kd.imc.sim.formplugin.match.MinusBillMatchHelper;

public class MatchBillAsyncTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(MatchBillAsyncTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        try (DLock lock = DLock.create((String)MatchBillAsyncTask.class.getName());){
            if (!lock.tryLock(1000L)) {
                return;
            }
            DeleteServiceHelper.delete((String)"sim_billmatch_data", (QFilter[])new QFilter("createdatefield", "<=", (Object)DateUtils.addDay((Date)new Date(), (int)-31)).toArray());
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"sim_billmatch_data", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_billmatch_data"), (QFilter[])new QFilter("matchStatus", "=", (Object)"0").toArray());
            MinusBillMatchHelper minusBillMatchHelper = new MinusBillMatchHelper();
            for (DynamicObject dynamicObject : dynamicObjects) {
                MinusBillDTO minusBillDTO = (MinusBillDTO)JSON.parseObject((String)dynamicObject.getString("requestdata_tag"), MinusBillDTO.class);
                BillMatchResultResponseVo billMatchResponseVo = new BillMatchResultResponseVo();
                billMatchResponseVo.setBillNo(dynamicObject.getString("billno"));
                billMatchResponseVo.setMatchRule(dynamicObject.getString("matchRule"));
                billMatchResponseVo.setMatchName(dynamicObject.getString("matchName"));
                try {
                    billMatchResponseVo.setMatchTime(DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
                    minusBillMatchHelper.match(minusBillDTO);
                }
                catch (Exception e) {
                    logger.info(String.format("\u5339\u914d\u5355\u636e\u4efb\u52a1\u53f7:[%s],\u5931\u8d25\u539f\u56e0:[%s]", dynamicObject.getString("batchno"), e.getMessage()));
                    billMatchResponseVo.setMatchStatus("3");
                    billMatchResponseVo.setMatchResult("0");
                    dynamicObject.set("matchstatus", (Object)"3");
                    dynamicObject.set("responsedata_tag", (Object)SerializationUtils.toJsonString((Object)billMatchResponseVo));
                    dynamicObject.set("matchtime", (Object)DateUtils.stringToDate((String)billMatchResponseVo.getMatchTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                    ImcSaveServiceHelper.save((DynamicObject)dynamicObject);
                    continue;
                }
                boolean amountStandard = minusBillDTO.getConfig().getAmountStandard();
                boolean isMatch = false;
                boolean isAllMatch = true;
                ArrayList billMatchDetailVoList = Lists.newArrayListWithCapacity((int)0);
                for (MinusBillItemDTO minusBillDTOItem : minusBillDTO.getItems()) {
                    BillMatchDetailVo billMatchDetailVo = new BillMatchDetailVo();
                    billMatchDetailVo.setDetailId(minusBillDTOItem.getMatchOrMergeItemId().toString());
                    if ("5".equals(minusBillDTOItem.getMatchStatus())) {
                        isMatch = true;
                        isAllMatch = false;
                        billMatchDetailVo.setMatchResult("2");
                        this.formatBillDetail(minusBillDTOItem, billMatchDetailVo, amountStandard);
                    } else if ("1".equals(minusBillDTOItem.getMatchStatus())) {
                        isMatch = true;
                        billMatchDetailVo.setMatchResult("1");
                        this.formatBillDetail(minusBillDTOItem, billMatchDetailVo, amountStandard);
                    } else {
                        isAllMatch = false;
                        billMatchDetailVo.setMatchResult("0");
                    }
                    billMatchDetailVoList.add(billMatchDetailVo);
                }
                if (isMatch) {
                    if (isAllMatch) {
                        billMatchResponseVo.setMatchStatus("2");
                        billMatchResponseVo.setMatchResult("1");
                    } else {
                        billMatchResponseVo.setMatchStatus("2");
                        billMatchResponseVo.setMatchResult("2");
                    }
                } else {
                    billMatchResponseVo.setMatchStatus("2");
                    billMatchResponseVo.setMatchResult("0");
                }
                billMatchResponseVo.setBillDetail((List)billMatchDetailVoList);
                dynamicObject.set("responsedata_tag", (Object)SerializationUtils.toJsonString((Object)billMatchResponseVo));
                dynamicObject.set("matchstatus", (Object)billMatchResponseVo.getMatchStatus());
                dynamicObject.set("matchresult", (Object)billMatchResponseVo.getMatchResult());
                dynamicObject.set("matchtime", (Object)DateUtils.stringToDate((String)billMatchResponseVo.getMatchTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                ImcSaveServiceHelper.save((DynamicObject)dynamicObject);
            }
        }
    }

    private void formatBillDetail(MinusBillItemDTO minusBillDTOItem, BillMatchDetailVo billMatchDetailVo, boolean amountStandard) {
        BigDecimal matchAmountOrNum = minusBillDTOItem.getMatchAmountOrNum();
        BigDecimal matchTaxAmount = BigDecimal.ZERO;
        BigDecimal matchTotalAmount = BigDecimal.ZERO;
        if (amountStandard) {
            matchTaxAmount = matchAmountOrNum.multiply(BigDecimal.valueOf(Double.parseDouble(minusBillDTOItem.getTaxRate()))).setScale(2, RoundingMode.HALF_UP);
            matchTotalAmount = matchAmountOrNum.add(matchTaxAmount).setScale(2, RoundingMode.HALF_UP);
            billMatchDetailVo.setMatchAmount(matchAmountOrNum.toPlainString());
            billMatchDetailVo.setMatchTaxAmount(matchTaxAmount.toPlainString());
            billMatchDetailVo.setMatchTotalAmount(matchTotalAmount.toPlainString());
        } else {
            matchAmountOrNum = BigDecimal.ZERO;
        }
        ArrayList billMatchList = Lists.newArrayListWithCapacity((int)0);
        for (MatchInvoiceDTO matchInvoiceDTO : minusBillDTOItem.getInvoiceList()) {
            BillMatchInvoiceDetailVo billMatch = new BillMatchInvoiceDetailVo();
            billMatch.setInvoiceCode(matchInvoiceDTO.getInvoicecode());
            billMatch.setInvoiceNo(matchInvoiceDTO.getInvoiceno());
            billMatch.setOriginalSeq(matchInvoiceDTO.getItemseq().toString());
            billMatch.setRedQuantity(matchInvoiceDTO.getItemNum().stripTrailingZeros().toPlainString());
            billMatch.setMatchAmount(matchInvoiceDTO.getItemAmount().toPlainString());
            billMatch.setMatchTaxAmount(matchInvoiceDTO.getItemTax().stripTrailingZeros().toPlainString());
            billMatch.setMatchTotalAmount(matchInvoiceDTO.getItemAmount().add(matchInvoiceDTO.getItemTax()).setScale(2, RoundingMode.HALF_UP).toPlainString());
            if (!amountStandard) {
                matchAmountOrNum = matchAmountOrNum.add(matchInvoiceDTO.getItemAmount());
                matchTaxAmount = matchTaxAmount.add(matchInvoiceDTO.getItemTax());
            }
            long invoiceId = matchInvoiceDTO.getInvoiceid();
            DynamicObject invoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice", (boolean)true), (QFilter[])new QFilter("id", "=", (Object)invoiceId).toArray());
            if (invoice != null) {
                billMatch.setInvoiceDate(DateUtils.format((Date)invoice.getDate("issuetime"), (String)"yyyy-MM-dd HH:mm:ss"));
                billMatch.setInvoiceType(invoice.getString("invoicetype"));
                DynamicObjectCollection items2 = invoice.getDynamicObjectCollection("items");
                if (items2.size() != 0) {
                    for (DynamicObject item : items2) {
                        if (!item.getPkValue().toString().equals(matchInvoiceDTO.getItemid().toString())) continue;
                        billMatch.setRemainAmount(item.getBigDecimal("itemremainredamount").setScale(2, RoundingMode.HALF_UP).toPlainString());
                        billMatch.setRemainQuantity(BigDecimalUtil.formatNumOrUnitPrice((BigDecimal)item.getBigDecimal("itemremainrednum"), (int)16).stripTrailingZeros().toPlainString());
                        billMatch.setRemainTaxAmount(item.getBigDecimal("itemremainredtax").setScale(2, RoundingMode.HALF_UP).toPlainString());
                        billMatch.setPrice(item.getBigDecimal("unitprice").stripTrailingZeros().toPlainString());
                        billMatch.setRedPrice(matchInvoiceDTO.getItemUnitprice().stripTrailingZeros().toPlainString());
                    }
                }
            }
            billMatchList.add(billMatch);
        }
        if (!amountStandard) {
            matchTotalAmount = matchAmountOrNum.add(matchTaxAmount);
            billMatchDetailVo.setMatchAmount(matchAmountOrNum.toPlainString());
            billMatchDetailVo.setMatchTaxAmount(matchTaxAmount.toPlainString());
            billMatchDetailVo.setMatchTotalAmount(matchTotalAmount.toPlainString());
        }
        billMatchDetailVo.setInvoiceDetail((List)billMatchList);
    }
}

