/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.issuing.task;

import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dlock.DLock;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.sim.formplugin.redconfirm.op.RedConfirmBillUploadOp;

public class RedComfirmBillSubmitTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(RedComfirmBillSubmitTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        try (DLock lock = DLock.create((String)RedComfirmBillSubmitTask.class.getName());){
            DynamicObject[] redConfirmBills;
            if (!lock.tryLock(1000L)) {
                return;
            }
            QFilter dateFilter = new QFilter("createdate", ">=", (Object)DateUtils.addDay((Date)new Date(), (int)-7)).and("operate", "=", (Object)"0");
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"sim_red_comfirm_bill_temp", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_red_comfirm_bill_temp"), (QFilter[])dateFilter.toArray());
            ArrayList<Long> idList = new ArrayList<Long>(dynamicObjects.length);
            for (DynamicObject dynamicObject : dynamicObjects) {
                idList.add(Long.parseLong(dynamicObject.getString("redid")));
                DeleteServiceHelper.delete((String)"sim_red_comfirm_bill_temp", (QFilter[])new QFilter("orderno", "=", dynamicObject.get("orderno")).toArray());
            }
            if (idList.size() > 0 && (redConfirmBills = BusinessDataServiceHelper.load((String)"sim_red_confirm_bill", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_red_confirm_bill", (boolean)true), (QFilter[])new QFilter("id", "in", idList).toArray())).length != 0) {
                BeginOperationTransactionArgs e = new BeginOperationTransactionArgs("repair", redConfirmBills);
                RedConfirmBillUploadOp redConfirmBillUploadOp = new RedConfirmBillUploadOp();
                redConfirmBillUploadOp.beginOperationTransaction(e);
                AfterOperationArgs afterOperationArgs = new AfterOperationArgs("repair", new ArrayList());
                afterOperationArgs.setDataEntities(e.getDataEntities());
                redConfirmBillUploadOp.afterExecuteOperationTransaction(afterOperationArgs);
            }
        }
    }
}

