/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.issuing.task;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.sim.billcenter.BillCenterOrgMappingService;
import kd.imc.sim.billcenter.sys.OperaCommonLogicService;
import org.apache.commons.lang3.StringUtils;

public class SyncOperaDataTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(SyncOperaDataTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> paramsMap) throws KDException {
        logger.info("SyncOperaDataTask\uff0c\u5f00\u542f\u540c\u6b65Opera\u6570\u636e\u7684\u529f\u80fd\uff01");
        try (DLock lock = DLock.create((String)SyncOperaDataTask.class.getName());){
            String endDate;
            if (!lock.tryLock(1000L)) {
                logger.error("SyncOperaDataTask-\u5f53\u524d\u5b9a\u65f6\u4efb\u52a1\u7684\u7ebf\u7a0b\u672a\u83b7\u53d6\u5230\u76f8\u5173\u7684\u9501\u673a\u5236\uff01");
                return;
            }
            logger.info("SyncOperaDataTask,\u89e6\u53d1\u540c\u6b65Opera\u8ba2\u5355\u6570\u636e\u5f00\u59cb\u3002\u3002\u3002");
            String billNo2 = (String)paramsMap.get("billNo");
            String phoneNumber = (String)paramsMap.get("phoneNumber");
            String blockCode = (String)paramsMap.get("blockCode");
            String startDate = (String)paramsMap.get("startDate");
            if (StringUtils.isEmpty((CharSequence)startDate)) {
                startDate = DateUtils.format((Date)DateUtils.getDayStart((Date)new Date()));
            }
            if (StringUtils.isEmpty((CharSequence)(endDate = (String)paramsMap.get("endDate")))) {
                endDate = DateUtils.format((Date)DateUtils.getDayEnd((Date)new Date()));
            }
            logger.info("SyncOperaDataTask, billNo:{}, phoneNumber:{}, blockCode:{}, startDate:{}, endDate:{}", new Object[]{billNo2, phoneNumber, blockCode, startDate, endDate});
            BillCenterOrgMappingService orgMappingService = new BillCenterOrgMappingService();
            List systemCodeList = orgMappingService.getSystemCodeListMethod();
            QFilter qFilter = new QFilter("number", "in", (Object)systemCodeList);
            DynamicObjectCollection dynamicObjectCollection = orgMappingService.loadSystemCfgDataByCondition(qFilter);
            logger.info("\u8bfb\u53d6\u7684Opera\u6570\u636e\u6e90\u5171\u6709\uff1a{}", (Object)dynamicObjectCollection.size());
            String[] paramArray = new String[]{billNo2, phoneNumber, blockCode, startDate, endDate};
            ArrayList successMsgList = new ArrayList(16);
            ArrayList errorMsgList = new ArrayList(16);
            OperaCommonLogicService operaCommonLogicService = new OperaCommonLogicService();
            for (DynamicObject frontSystemObject : dynamicObjectCollection) {
                HashSet billNoSet = new HashSet(16);
                operaCommonLogicService.dealGetOperaBillNoMethod(frontSystemObject, paramArray, billNoSet);
                logger.info("\u5b9a\u65f6\u4efb\u52a1\u62c9\u53d6\u8ba2\u5355\u53f7\u5217\u8868\u6570\u91cf\u662f:{}", (Object)billNoSet.size());
                for (String billNo2 : billNoSet) {
                    String[] conditionArray = new String[]{billNo2, null, null, null, null};
                    operaCommonLogicService.dealCreateDBConnMethod(frontSystemObject, conditionArray, successMsgList, errorMsgList);
                }
            }
            logger.info("\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u6210\u529f\u7684\u6570\u91cf\u662f\uff1a{}\uff0c\u5931\u8d25\u7684\u6570\u91cf\u662f:{}", (Object)successMsgList.size(), (Object)errorMsgList.size());
            operaCommonLogicService.dealSaveInterfaceLogMethod(null, paramArray, "\u5b9a\u65f6\u4efb\u52a1\u540c\u6b65\u8d26\u5355\u6570\u636e", successMsgList.size(), errorMsgList.size());
        }
        logger.info("SyncOperaDataTask\uff0c\u7ed3\u675f\u540c\u6b65Opera\u6570\u636e\u7684\u529f\u80fd\uff01");
    }
}

