/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.lqpt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.imc.bdm.common.constant.ImcPermItemEnum;
import kd.imc.bdm.common.constant.OperationConstant;
import kd.imc.bdm.common.constant.table.EnterPriseBaseInfoConstant;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.OrgHelper;
import kd.imc.bdm.common.helper.PermissionHelper;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.bdm.lqpt.model.request.LqptRequest;
import kd.imc.bdm.lqpt.model.request.base.summary.SummaryQueryRequest;
import kd.imc.bdm.lqpt.model.response.LqptResponse;
import kd.imc.bdm.lqpt.model.response.base.summary.SummaryQueryDetailResponse;
import kd.imc.bdm.lqpt.model.response.base.summary.SummaryQueryResponse;
import kd.imc.bdm.lqpt.service.LqptService;
import kd.imc.sim.common.helper.CheckCurrentOrgHelper;
import org.apache.commons.collections.CollectionUtils;

public class SimLqptSummaryPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
HyperLinkClickListener {
    public void registerListener(EventObject e) {
        BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl("orgfilter");
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        beforeF7SelectEvent.setCustomQFilters(this.getOrgFilter(ImcPermItemEnum.ITEM_VIEW));
    }

    public List<QFilter> getOrgFilter(ImcPermItemEnum permItem) {
        DynamicObjectCollection epInfos;
        ArrayList<QFilter> list = new ArrayList<QFilter>(4);
        HasPermOrgResult userHasPermOrgs = PermissionServiceHelper.getAllPermOrgs((Long)Long.parseLong(RequestContext.get().getUserId()), (String)"sim", (String)"sim_lqpt_summary", (String)permItem.getPermId());
        if (!userHasPermOrgs.hasAllOrgPerm()) {
            list.add(new QFilter("id", "in", (Object)userHasPermOrgs.getHasPermOrgs()));
        }
        if (CollectionUtils.isEmpty((Collection)(epInfos = QueryServiceHelper.query((String)"bdm_enterprise_baseinfo", (String)"id", (QFilter[])new QFilter("issuechannel", "in", (Object)EnterPriseBaseInfoConstant.LQPT_CHANNEL).toArray())))) {
            list.add(new QFilter("1", "=", (Object)"-1"));
        } else {
            DynamicObjectCollection orgs = QueryServiceHelper.query((String)"bdm_org", (String)"id", (QFilter[])new QFilter("epinfo", "in", (Object)epInfos.stream().map(epInfo -> epInfo.get("id")).toArray()).toArray());
            list.add(new QFilter("id", "in", (Object)orgs.stream().map(org -> org.get("id")).toArray()));
        }
        return list;
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("summarymonthfilter", (Object)DateUtils.addMonth((Date)new Date(), (int)-1));
        this.getModel().setValue("orgfilter", (Object)new Object[]{RequestContext.get().getOrgId()});
        this.setListFilter();
    }

    protected void setListFilter() {
        QFilter qFilter = new QFilter("1", "=", (Object)1);
        Date summaryMonth = (Date)this.getModel().getValue("summarymonthfilter");
        if (summaryMonth != null) {
            qFilter.and("summarymonth", ">=", (Object)DateUtils.getFirstDateOfMonth((Date)summaryMonth)).and("summarymonth", "<=", (Object)DateUtils.getLastDateOfMonth((Date)summaryMonth));
        }
        MulBasedataDynamicObjectCollection orgs = (MulBasedataDynamicObjectCollection)this.getModel().getValue("orgfilter");
        HasPermOrgResult userHasPermOrgs = PermissionServiceHelper.getAllPermOrgs((Long)Long.parseLong(RequestContext.get().getUserId()), (String)"sim", (String)"sim_lqpt_summary", (String)ImcPermItemEnum.ITEM_VIEW.getPermId());
        if (CollectionUtils.isNotEmpty((Collection)orgs)) {
            if (!userHasPermOrgs.hasAllOrgPerm()) {
                Set orgIds = orgs.stream().map(org -> DynamicObjectUtil.getDynamicObjectLongValue((Object)org.get("fbasedataid_id"))).filter(orgId -> userHasPermOrgs.getHasPermOrgs().contains(orgId)).collect(Collectors.toSet());
                if (CollectionUtils.isNotEmpty(orgIds)) {
                    qFilter.and(OrgHelper.getIdFilter(orgIds, (String)"org"));
                } else {
                    qFilter.and("1", "=", (Object)-1);
                }
            } else {
                qFilter.and(OrgHelper.getIdFilter((Collection)orgs.stream().map(org -> DynamicObjectUtil.getDynamicObjectLongValue((Object)org.get("fbasedataid_id"))).collect(Collectors.toSet()), (String)"org"));
            }
        } else if (!userHasPermOrgs.hasAllOrgPerm()) {
            qFilter.and(OrgHelper.getIdFilter((Collection)userHasPermOrgs.getHasPermOrgs(), (String)"org"));
        }
        FilterParameter fp = new FilterParameter();
        fp.setFilter(qFilter);
        BillList billList = (BillList)this.getControl("billlistap");
        billList.setFilterParameter(fp);
        billList.clearSelection();
        billList.refreshData();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if ("summarymonthfilter".equals(e.getProperty().getName()) || "orgfilter".equals(e.getProperty().getName())) {
            this.setListFilter();
        }
    }

    public void itemClick(ItemClickEvent evt) {
        if ("summary_confirm".equals(evt.getItemKey()) || "summary_cancel".equals(evt.getItemKey())) {
            OperationResult operationResult;
            BillList billList = (BillList)this.getControl("billlistap");
            Object[] summaryIds = billList.getSelectedRows().getPrimaryKeyValues();
            if (summaryIds.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"SimLqptSummaryPlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject[] summaryArr = BusinessDataServiceHelper.load((String)"sim_lqpt_summary", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_lqpt_summary"), (QFilter[])OrgHelper.getIdFilter((Collection)Arrays.stream(summaryIds).collect(Collectors.toSet())).toArray());
            if ("summary_confirm".equals(evt.getItemKey())) {
                CheckCurrentOrgHelper.checkSelectRowsCurrentAuthor((AbstractFormPlugin)this, (ImcPermItemEnum)ImcPermItemEnum.SUMMARY_CONFIRM, (String)"sim_lqpt_summary", (DynamicObject[])summaryArr);
                operationResult = OperationServiceHelper.executeOperate((String)"summary_confirm", (String)"sim_lqpt_summary", (DynamicObject[])summaryArr, null);
            } else {
                CheckCurrentOrgHelper.checkSelectRowsCurrentAuthor((AbstractFormPlugin)this, (ImcPermItemEnum)ImcPermItemEnum.SUMMARY_CANCEL, (String)"sim_lqpt_summary", (DynamicObject[])summaryArr);
                operationResult = OperationServiceHelper.executeOperate((String)"summary_cancel", (String)"sim_lqpt_summary", (DynamicObject[])summaryArr, null);
            }
            if (!operationResult.isSuccess()) {
                this.getView().showErrorNotification(OperationConstant.getErrorMsg((OperationResult)operationResult));
            } else {
                this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"%s\u6210\u529f\u3002", (String)"SimLqptSummaryPlugin_4", (String)"imc-sim-formplugin", (Object[])new Object[0]), "summary_confirm".equals(evt.getItemKey()) ? ResManager.loadKDString((String)"\u6c47\u603b\u786e\u8ba4", (String)"SimLqptSummaryPlugin_5", (String)"imc-sim-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u53d6\u6d88\u786e\u8ba4", (String)"SimLqptSummaryPlugin_6", (String)"imc-sim-formplugin", (Object[])new Object[0])));
            }
        } else if ("summary_query".equals(evt.getItemKey())) {
            Date summaryMonth = (Date)this.getModel().getValue("summarymonthfilter");
            if (summaryMonth == null || summaryMonth.after(DateUtils.getFirstDateOfMonth((Date)new Date()))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u975e\u672c\u6708\u7684\u6c47\u603b\u6708\u4efd", (String)"SimLqptSummaryPlugin_1", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                return;
            }
            MulBasedataDynamicObjectCollection orgs = (MulBasedataDynamicObjectCollection)this.getModel().getValue("orgfilter");
            if (CollectionUtils.isEmpty((Collection)orgs)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ec4\u7ec7", (String)"SimLqptSummaryPlugin_2", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                return;
            }
            Set<Long> orgIds = orgs.stream().map(org -> DynamicObjectUtil.getDynamicObjectLongValue((Object)org.get("fbasedataid_id"))).collect(Collectors.toSet());
            for (Long orgId : orgIds) {
                if (PermissionHelper.checkOrgPermission((AbstractFormPlugin)this, (ImcPermItemEnum)ImcPermItemEnum.SUMMARY_QUERY, (String)"sim_lqpt_summary", (Long)orgId)) continue;
                DynamicObject org2 = BusinessDataServiceHelper.loadSingle((Object)orgId, (String)"bos_org");
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709%1$s\u7ec4\u7ec7\u7684%2$s\u6743\u9650\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e", (String)"SimLqptSummaryPlugin_3", (String)"imc-sim-formplugin", (Object[])new Object[0]), org2.getString("name"), ImcPermItemEnum.SUMMARY_QUERY.getDescription()));
                return;
            }
            this.querySummaryInfo(orgIds, summaryMonth);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5386\u53f2\u6c47\u603b\u67e5\u8be2\u6210\u529f", (String)"SimLqptSummaryPlugin_7", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        } else if ("new".equals(evt.getItemKey())) {
            BillShowParameter listParam = new BillShowParameter();
            listParam.setStatus(OperationStatus.ADDNEW);
            listParam.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            listParam.setFormId("sim_lqpt_summary");
            listParam.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "sim_lqpt_summary"));
            this.getView().showForm((FormShowParameter)listParam);
        }
        if ("summary_confirm".equals(evt.getItemKey()) || "summary_cancel".equals(evt.getItemKey()) || "summary_query".equals(evt.getItemKey()) || "btn_refresh".equals(evt.getItemKey())) {
            this.setListFilter();
        }
    }

    private void querySummaryInfo(Set<Long> orgIds, Date summaryMonth) {
        DynamicObject[] orgs = BusinessDataServiceHelper.load((String)"bdm_org", (String)"epinfo", (QFilter[])OrgHelper.getIdFilter(orgIds).toArray());
        Set epInfoIds = Arrays.stream(orgs).map(org -> DynamicObjectUtil.getDynamicObjectLongValue((Object)org.get("epinfo"))).collect(Collectors.toSet());
        DynamicObject[] epInfos = BusinessDataServiceHelper.load((String)"bdm_enterprise_baseinfo", (String)String.join((CharSequence)",", "issuechannel", "number", "enterpriserole", "leqiid"), (QFilter[])OrgHelper.getIdFilter(epInfoIds).and("issuechannel", "in", (Object)EnterPriseBaseInfoConstant.LQPT_CHANNEL).toArray());
        ArrayList<DynamicObject> summaryList = new ArrayList<DynamicObject>(epInfos.length);
        LqptService lqptService = new LqptService();
        for (DynamicObject epInfo : epInfos) {
            SummaryQueryRequest queryRequest = new SummaryQueryRequest();
            queryRequest.setNsrsbh(epInfo.getString("number"));
            queryRequest.setXsfnsrsbh(epInfo.getString("number"));
            DynamicObject ep = BusinessDataServiceHelper.loadSingle((String)"bdm_enterprise_info", (String)"zgswskfjdm", (QFilter[])new QFilter("epinfo", "=", epInfo.getPkValue()).toArray());
            if (ep == null) {
                return;
            }
            queryRequest.setXsfsjswjgdm(ep.getString("zgswskfjdm"));
            queryRequest.setPtbh(epInfo.getString("leqiid"));
            queryRequest.setYf(DateUtils.format((Date)summaryMonth, (String)"yyyy-MM"));
            LqptResponse send = lqptService.send((LqptRequest)queryRequest);
            if (!send.success()) {
                throw new KDBizException(send.getDescription());
            }
            SummaryQueryResponse response = (SummaryQueryResponse)send.getData();
            List list = response.getFphzqrxxList();
            if (CollectionUtils.isEmpty((Collection)list)) continue;
            DynamicObject summary2 = DynamicObjectUtil.bean2DynamicObject(list.get(0), (DynamicObject)BusinessDataServiceHelper.newDynamicObject((String)"sim_lqpt_summary"));
            summary2.set("summarystatus", (Object)"1");
            summary2.set("epinfo", epInfo.getPkValue());
            summary2.set("org", (Object)TaxUtils.getOrgDynamicObjectByTaxNo((String)epInfo.getString("number")));
            summary2.set("enterpriserole", (Object)epInfo.getString("enterpriserole"));
            summary2.set("summarymonth", (Object)DateUtils.handleDate((String)((SummaryQueryDetailResponse)list.get(0)).getYf()));
            summaryList.add(summary2);
        }
        if (CollectionUtils.isNotEmpty(summaryList)) {
            Date firstDateOfMonth = DateUtils.getFirstDateOfMonth((Date)summaryMonth);
            QFilter qFilter = new QFilter("summarymonth", ">=", (Object)firstDateOfMonth).and("summarymonth", "<", (Object)DateUtils.getFirstDateOfMonth((Date)DateUtils.addMonth((Date)summaryMonth, (int)1))).and("epinfo", "in", (Object)summaryList.stream().map(summary -> DynamicObjectUtil.getDynamicObjectLongValue((Object)summary.get("epinfo"))).toArray());
            DeleteServiceHelper.delete((String)"sim_lqpt_summary", (QFilter[])qFilter.toArray());
            ImcSaveServiceHelper.save(summaryList);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent args) {
        String fieldName = args.getFieldName();
        if ("org_name".equals(fieldName)) {
            BillList billList = (BillList)this.getView().getControl("billlistap");
            ListSelectedRow row = billList.getCurrentSelectedRowInfo();
            DynamicObject summary = BusinessDataServiceHelper.loadSingle((Object)row.getPrimaryKeyValue(), (String)"sim_lqpt_summary");
            BillShowParameter listParam = new BillShowParameter();
            listParam.setPkId(row.getPrimaryKeyValue());
            String summaryStatus = summary.getString("summarystatus");
            boolean hasAuth = PermissionHelper.checkOrgPermission((AbstractFormPlugin)this, (ImcPermItemEnum)ImcPermItemEnum.ITEM_EDIT, (String)"sim_lqpt_summary", (Long)DynamicObjectUtil.getDynamicObjectLongValue((Object)summary.get("org")));
            if ("1".equals(summaryStatus) || !hasAuth) {
                listParam.setStatus(OperationStatus.VIEW);
            } else {
                listParam.setStatus(OperationStatus.EDIT);
            }
            listParam.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            listParam.setFormId("sim_lqpt_summary");
            this.getView().showForm((FormShowParameter)listParam);
        }
    }
}

