/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.openapi.callback;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.OpenApiCallbackInterfaceCodeEnum;
import kd.imc.bdm.common.dto.CallbackLogVo;
import kd.imc.bdm.common.enums.CallBackLogTypeEnum;
import kd.imc.bdm.common.helper.callback.SendCallBackHelper;
import kd.imc.bdm.common.util.CallbackHelperUtil;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.PropertieUtil;

public class CallbackTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(CallbackTask.class);
    private static final String[] businessTypes = new String[]{OpenApiCallbackInterfaceCodeEnum.INVOICE_OPEN.getCode(), OpenApiCallbackInterfaceCodeEnum.INVOICE_CANCEL.getCode(), OpenApiCallbackInterfaceCodeEnum.INVOICE_RED.getCode(), OpenApiCallbackInterfaceCodeEnum.ALLE_INVOICE_OPEN.getCode()};

    public void execute(RequestContext arg0, Map<String, Object> arg1) throws KDException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("CallbackTask \u5b9a\u65f6\u4efb\u52a1start");
        }
        Date today = new Date();
        Date timeStart = DateUtils.addDay((Date)DateUtils.trunc((Date)today), (int)-2);
        Date timeEnd = DateUtils.addMinute((Date)today, (int)-2);
        QFilter timeFilter = new QFilter("create_time", "<", (Object)timeEnd).and("create_time", ">=", (Object)timeStart).and("callback_status", "!=", (Object)"0").and("business_type", "in", (Object)businessTypes).and("targetsystem", "!=", (Object)"originalbill").and("retry_times", "<", (Object)10);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"invsm_callback_log", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"invsm_callback_log"), (QFilter[])timeFilter.toArray(), (String)"create_time desc", (int)0, (int)100);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("CallbackTask_List_size:" + dynamicObjects.length);
        }
        if (dynamicObjects.length == 0) {
            return;
        }
        ArrayList<CallbackLogVo> callbackLogList = new ArrayList<CallbackLogVo>(dynamicObjects.length);
        for (DynamicObject callBackLogDynamicObject : dynamicObjects) {
            if (CallBackLogTypeEnum.invoiceError.getValue().equals(callBackLogDynamicObject.getString("callbacktype")) || CallBackLogTypeEnum.billError.getValue().equals(callBackLogDynamicObject.getString("callbacktype"))) {
                SendCallBackHelper.handlerErrorCallBackTask((DynamicObject)callBackLogDynamicObject);
                continue;
            }
            CallbackLogVo callbackVo = (CallbackLogVo)DynamicObjectUtil.dynamicObject2Bean(CallbackLogVo.class, (DynamicObject)callBackLogDynamicObject);
            callbackLogList.add(callbackVo);
        }
        for (CallbackLogVo callbackLog : callbackLogList) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(String.format("CallbackTask_\u53d1\u7968\u4ee3\u7801\uff1a%s\uff0c\u53f7\u7801%s\uff0c\u56de\u8c03\u7c7b\u578b%s\uff0c\u8fdb\u884c\u91cd\u8bd5\u56de\u8c03\u7b2c%s\u6b21", callbackLog.getInvoiceCode(), callbackLog.getInvoiceNo(), callbackLog.getBusinessType(), callbackLog.getRetryTimes()));
            }
            CallbackHelperUtil.callbackHandler((String)JSON.toJSONString((Object)callbackLog), (int)1);
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("CallbackTask \u53d1\u7968\u56de\u8c03\u5b9a\u65f6\u4efb\u52a1end");
        }
    }
}

