/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.redconfirm;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.OperationConstant;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.AllEleServiceHelper;
import kd.imc.bdm.common.helper.EnterpriseHelper;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.bdm.file.util.Handle;
import kd.imc.bdm.lqpt.model.response.collect.InvoiceStatusQueryResponse;
import kd.imc.sim.common.constant.RedConfirmBillRedReasonEnum;
import kd.imc.sim.common.constant.RiskControlRecordConstant;
import kd.imc.sim.common.helper.RimLqptQueryHelper;
import kd.imc.sim.common.utils.MathUtils;
import kd.imc.sim.formplugin.bill.helper.RimInvoiceHelper;
import kd.imc.sim.formplugin.bill.originalbill.control.AllESpecialTypeControl;
import kd.imc.sim.formplugin.bill.originalbill.control.InvoiceOriginalFormControl;
import kd.imc.sim.formplugin.redconfirm.control.RedConfirmBillAddControl;
import kd.imc.sim.formplugin.redconfirm.control.RedConfirmBillIssueControl;
import kd.imc.sim.formplugin.redconfirm.helper.RedConfirmBillHelper;
import kd.imc.sim.formplugin.risk.control.BillRiskControlService;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class RedConfirmBillAddPlugin
extends AbstractFormPlugin
implements AfterF7SelectListener,
BeforeF7SelectListener {
    private static final String BILL_KEY = "billKey";
    private static final String BTN_ADDROW = "addrow";
    private static final String EDIT_TAX = "edittax";
    private static final String BTN_SUBMIT = "btn_submit";
    private static final String[] ITEM_DISABLE_KEY = new String[]{"num", "taxamount"};
    private static final Log LOGGER = LogFactory.getLog(RedConfirmBillAddPlugin.class);

    public void afterCreateNewData(EventObject e) {
        String orgId;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        this.getModel().setValue("applicant", customParams.get("applicant"));
        this.getModel().setValue("redreason", customParams.get("redreason"));
        String invoiceIdStr = (String)customParams.get("id");
        if (StringUtils.isBlank((CharSequence)invoiceIdStr)) {
            return;
        }
        long invoiceId = Long.parseLong(invoiceIdStr);
        if (0L == invoiceId) {
            return;
        }
        String billKey = customParams.getOrDefault(BILL_KEY, "sim_vatinvoice");
        DynamicObject invoice = BusinessDataServiceHelper.loadSingle((Object)invoiceId, (String)billKey);
        if (!"sim_vatinvoice".equals(billKey)) {
            invoice = RimInvoiceHelper.createInvoiceByRim((DynamicObject)invoice);
        }
        RedConfirmBillHelper.initRedConfirmBillFromInvoice((AbstractFormPlugin)this, (DynamicObject)invoice, (String)billKey);
        if (!"sim_vatinvoice".equals(billKey)) {
            this.setItemTaxEnable(false);
        }
        if (StringUtils.isNotBlank((CharSequence)(orgId = (String)customParams.get("org")))) {
            this.getPageCache().put("org", orgId);
        }
        this.queryLqOriginalInvoiceIssueTime();
    }

    private void queryLqOriginalInvoiceIssueTime() {
        try {
            String accountingQuery = ImcConfigUtil.getValue((String)"bdm_lqpt", (String)"open_rim_invoice_account_query");
            if (!"1".equals(accountingQuery)) {
                return;
            }
            String originalInvoiceType = (String)this.getModel().getValue("originalinvoicetype");
            if (StringUtils.isBlank((CharSequence)originalInvoiceType)) {
                return;
            }
            if (InvoiceUtils.isAllEInvoice((Object)originalInvoiceType)) {
                return;
            }
            Date originalIssueTime = (Date)this.getModel().getValue("originalissuetime");
            if (originalIssueTime == null) {
                return;
            }
            String hhmmss = DateUtils.format((Date)originalIssueTime, (String)"HHmmss");
            if (!"000000".equals(hhmmss)) {
                return;
            }
            String taxNo = (String)this.getModel().getValue("salertaxno");
            if ("1".equals(this.getModel().getValue("enteridentity"))) {
                taxNo = (String)this.getModel().getValue("buyertaxno");
            }
            if (!EnterpriseHelper.isLqptChannel((String)taxNo)) {
                return;
            }
            InvoiceStatusQueryResponse statusQueryResponse = new RimLqptQueryHelper().invoiceAccountingQuery(taxNo, originalInvoiceType, (String)this.getModel().getValue("originalinvoicecode"), (String)this.getModel().getValue("originalinvoiceno"), originalIssueTime);
            if (statusQueryResponse.getKprq() != null) {
                this.getModel().setValue("originalissuetime", (Object)statusQueryResponse.getKprq());
            }
        }
        catch (Exception e) {
            LOGGER.info("\u7a0e\u63a7\u7968\u8bbe\u7f6e\u539f\u84dd\u7968\u65e5\u671f\u5931\u8d25" + e.getMessage());
        }
    }

    public void afterBindData(EventObject e) {
        Object applicant;
        long invoiceId;
        String orgStr = this.getPageCache().get("org");
        if (StringUtils.isNotBlank((CharSequence)orgStr)) {
            long orgId = Long.parseLong(orgStr);
            this.getModel().setValue("org", (Object)orgId);
            this.getModel().setValue("useorg", (Object)orgId);
            this.getModel().setValue("createorg", (Object)orgId);
        }
        AllESpecialTypeControl.showOrHideFields((AbstractFormPlugin)this, (boolean)true);
        AllESpecialTypeControl.dealShowOrHideSpecailAreaMethod((AbstractFormPlugin)this);
        this.getModel().setDataChanged(false);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String invoiceIdStr = (String)formShowParameter.getCustomParam("id");
        if (StringUtils.isNotEmpty((CharSequence)invoiceIdStr) && 0L != (invoiceId = Long.parseLong(invoiceIdStr))) {
            Object redReason = this.getModel().getValue("redreason");
            String[] disableKey = ITEM_DISABLE_KEY;
            if (RedConfirmBillRedReasonEnum.SALES_RETURN.getCode().equals(redReason)) {
                disableKey = new String[]{"taxamount"};
            } else if (RedConfirmBillRedReasonEnum.SERVICE_CUT.getCode().equals(redReason)) {
                disableKey = null;
            } else if (RedConfirmBillRedReasonEnum.SALES_DISCOUNTS.getCode().equals(redReason)) {
                disableKey = new String[]{"num"};
            }
            this.setItemValueAndDisable(disableKey);
        }
        if ("1".equals((applicant = this.getModel().getValue("applicant")) + "")) {
            this.setItemZZSTSGKEnable();
        }
        Object uploadStatus = this.getModel().getValue("uploadstatus");
        boolean uploadFlag = "1".equals(uploadStatus);
        this.getView().setVisible(Boolean.valueOf(!uploadFlag), new String[]{BTN_SUBMIT});
        String taxNo = (String)this.getModel().getValue("salertaxno");
        if (!uploadFlag && "1".equals(this.getModel().getValue("enteridentity"))) {
            taxNo = (String)this.getModel().getValue("buyertaxno");
        }
        if (EnterpriseHelper.isLqptChannel((String)taxNo)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"account"});
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"account"});
        DynamicObject accountObj = AllEleAuthHelper.getAccountByTaxNo((String)taxNo);
        Pair accountList = AllEleAuthHelper.getAccountList((DynamicObject)accountObj, (boolean)true);
        ViewUtil.setDropDownViewData((AbstractFormPlugin)this, (String)"account", (Map)((Map)accountList.getValue()));
        String account = (String)this.getView().getFormShowParameter().getCustomParam("account");
        if (StringUtils.isNotBlank((CharSequence)account)) {
            this.getModel().setValue("account", (Object)account);
        }
    }

    private void setItemValueAndDisable(String[] disableKey) {
        boolean emptyFlag = false;
        Object redReason = this.getModel().getValue("redreason");
        if (RedConfirmBillRedReasonEnum.SALES_DISCOUNTS.getCode().equals(redReason)) {
            emptyFlag = true;
        }
        DynamicObjectCollection itemList = this.getModel().getEntryEntity("items");
        for (int i = 0; i < itemList.size(); ++i) {
            DynamicObject itemObject = (DynamicObject)itemList.get(i);
            if (emptyFlag) {
                itemObject.set("num", (Object)"");
                itemObject.set("unitprice", (Object)"");
                itemObject.set("taxunitprice", (Object)"");
            }
            if (MathUtils.isNullOrZero((BigDecimal)itemObject.getBigDecimal("num"))) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"num"});
            }
            if (null == disableKey) continue;
            this.getView().setEnable(Boolean.FALSE, i, disableKey);
        }
        this.getModel().setValue("items", (Object)itemList);
        this.getView().updateView("items");
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"tbmain", "advcontoolbarap"});
        this.addClickListeners(new String[]{"goodscode", "goodsname"});
        this.addF7SelectListener("goodsid", "taxratecodeid");
    }

    private void addF7SelectListener(String ... keys) {
        for (String key : keys) {
            BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl(key);
            if (basedataEdit == null) continue;
            basedataEdit.addAfterF7SelectListener((AfterF7SelectListener)this);
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (EDIT_TAX.equals(itemKey)) {
            this.setItemTaxEnable(true);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (BTN_SUBMIT.equals(itemKey) || "btn_confirm".equals(itemKey) || "btn_red".equals(itemKey)) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            List<DynamicObject> list = Collections.singletonList(dataEntity);
            String callbackKey = "risk_control_check_" + itemKey;
            RiskControlRecordConstant.ExecuteActionEnum executeAction = RiskControlRecordConstant.ExecuteActionEnum.getExecuteActionEnumByButtonKey((String)itemKey);
            boolean antiReplayControlFlag = BillRiskControlService.riskControl(list, (String)"sim_red_confirm_bill", (RiskControlRecordConstant.ExecuteActionEnum)executeAction, (AbstractFormPlugin)this, (String)callbackKey);
            if (antiReplayControlFlag) {
                evt.setCancel(true);
                return;
            }
        }
        if (!BTN_SUBMIT.equals(evt.getItemKey())) {
            return;
        }
        switch (itemKey) {
            case "addrow": {
                break;
            }
            case "edittax": {
                this.setItemTaxEnable(true);
                break;
            }
            case "btn_submit": {
                this.submitRedConfirm(evt);
            }
        }
    }

    private void setItemTaxEnable(boolean editAble) {
        DynamicObjectCollection itemList = this.getModel().getEntryEntity("items");
        for (int i = 0; i < itemList.size(); ++i) {
            this.getView().setEnable(Boolean.valueOf(editAble), i, new String[]{"tax"});
        }
    }

    private void setItemZZSTSGKEnable() {
        DynamicObjectCollection itemList = this.getModel().getEntryEntity("items");
        for (int i = 0; i < itemList.size(); ++i) {
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"zzstsgl"});
            if (Handle.isEmpty((Object)((DynamicObject)itemList.get(i)).getString("rowtype")) || "1".equals(((DynamicObject)itemList.get(i)).getString("rowtype")) || Handle.isNotEmpty((Object)((DynamicObject)itemList.get(i)).getString("zzstsgl")) || Handle.isEmpty((Object)((DynamicObject)itemList.get(i)).getString("taxpremark")) || !"1".equals(((DynamicObject)itemList.get(i)).getString("taxpremark"))) continue;
            this.getView().setEnable(Boolean.TRUE, i, new String[]{"zzstsgl"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("items");
        int[] rows = entryGrid.getSelectRows();
        int editIndex = 0;
        if (rows.length > 0) {
            editIndex = rows[0];
        }
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        Object oldValue = changeData.getOldValue();
        switch (name) {
            case "num": {
                RedConfirmBillAddControl.editNum((AbstractFormPlugin)this, (int)editIndex, (BigDecimal)((BigDecimal)newValue), (BigDecimal)((BigDecimal)oldValue));
                break;
            }
            case "amount": {
                RedConfirmBillAddControl.editAmount((AbstractFormPlugin)this, (int)editIndex, (BigDecimal)((BigDecimal)newValue), (BigDecimal)((BigDecimal)oldValue));
                break;
            }
            case "unitprice": {
                RedConfirmBillAddControl.editUnitPrice((AbstractFormPlugin)this, (int)editIndex, (BigDecimal)((BigDecimal)newValue), (BigDecimal)((BigDecimal)oldValue));
                break;
            }
            case "taxunitprice": {
                RedConfirmBillAddControl.editTaxUnitPrice((AbstractFormPlugin)this, (int)editIndex, (BigDecimal)((BigDecimal)newValue), (BigDecimal)((BigDecimal)oldValue));
                break;
            }
            case "taxamount": {
                RedConfirmBillAddControl.editTaxAmount((AbstractFormPlugin)this, (int)editIndex, (BigDecimal)((BigDecimal)newValue), (BigDecimal)((BigDecimal)oldValue));
                break;
            }
            case "tax": {
                this.editTax(editIndex, (BigDecimal)newValue, (BigDecimal)oldValue);
                break;
            }
            case "taxrate": {
                RedConfirmBillAddControl.editTaxRate((AbstractFormPlugin)this, (int)editIndex, (String)((String)newValue));
                break;
            }
            case "invoicetype": {
                this.getModel().setValue("originalinvoicetype", newValue);
                if (InvoiceUtils.isPaperInvoice((String)((String)newValue))) {
                    this.getModel().setValue("iselepaper", (Object)"1");
                    break;
                }
                this.getModel().setValue("iselepaper", (Object)"0");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void editTax(int editIndex, BigDecimal newTax, BigDecimal oldTax) {
        this.getModel().beginInit();
        try {
            if (BigDecimalUtil.greaterZero((BigDecimal)newTax)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u660e\u7ec6\u7a0e\u989d\u4e0d\u80fd\u5927\u4e8e0", (String)"RedConfirmBillAddPlugin_2", (String)"imc-sim-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                this.getModel().setValue("tax", (Object)oldTax, editIndex);
                return;
            }
            BigDecimal itemTaxAmount = (BigDecimal)this.getModel().getValue("taxamount", editIndex);
            if (itemTaxAmount.abs().compareTo(newTax.abs()) < 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u660e\u7ec6\u7a0e\u989d\u7edd\u5bf9\u503c\u4e0d\u80fd\u5927\u4e8e\u542b\u7a0e\u91d1\u989d\u7edd\u5bf9\u503c", (String)"RedConfirmBillAddPlugin_3", (String)"imc-sim-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                this.getModel().setValue("tax", (Object)oldTax, editIndex);
                return;
            }
            BigDecimal itemAmount = itemTaxAmount.subtract(newTax);
            this.getModel().setValue("amount", (Object)itemAmount, editIndex);
        }
        finally {
            this.getModel().endInit();
        }
        RedConfirmBillAddControl.updateField((AbstractFormPlugin)this, (int)editIndex, null);
        RedConfirmBillAddControl.countHeadAmount((AbstractFormPlugin)this);
    }

    private void submitRedConfirm(BeforeItemClickEvent evt) {
        this.getPageCache().put("save", "save");
        OperationResult operationResult = this.getView().invokeOperation("save", OperateOption.create());
        this.getPageCache().remove("save");
        if (!operationResult.isSuccess()) {
            this.getView().showErrorNotification(OperationConstant.getErrorMsg((OperationResult)operationResult));
            evt.setCancel(true);
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        String taxNo = "2".equals(this.getModel().getValue("applicant")) ? (String)this.getModel().getValue("salertaxno") : (String)this.getModel().getValue("buyertaxno");
        params.put("salertaxno", taxNo);
        params.put("account", this.getModel().getValue("account"));
        if (AllEleServiceHelper.isNeedLogin((AbstractFormPlugin)this, params)) {
            evt.setCancel(true);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("save".equals(operateKey)) {
            DynamicObject dynamicObject = this.getModel().getDataEntity();
            String billNo = dynamicObject.getString("orderno");
            DynamicObjectCollection itemObjectCollection = dynamicObject.getDynamicObjectCollection("items");
            DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("travelers");
            try {
                InvoiceOriginalFormControl.dealCheckTravelerItemMethod((String)billNo, (DynamicObjectCollection)itemObjectCollection, (DynamicObjectCollection)dynamicObjectCollection);
                InvoiceOriginalFormControl.dealCheckTransportTypeMethod((DynamicObjectCollection)dynamicObjectCollection);
            }
            catch (Exception e) {
                throw new KDBizException(e.getMessage());
            }
        } else if ("btn_red".equals(operateKey)) {
            operate.getOption().setVariableValue("org", String.valueOf(DynamicObjectUtil.getDynamicObjectLongValue((Object)this.getModel().getValue("createorg"))));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        switch (args.getOperateKey()) {
            case "btn_submit": {
                this.getView().invokeOperation("refresh");
                if (!args.getOperationResult().isSuccess()) break;
                this.setItemTaxEnable(false);
                break;
            }
            case "save": {
                if (StringUtils.isNotBlank((CharSequence)this.getPageCache().get("save"))) {
                    args.getOperationResult().setShowMessage(false);
                } else {
                    this.getView().invokeOperation("refresh");
                }
                if (!args.getOperationResult().isSuccess()) break;
                this.setItemTaxEnable(false);
                break;
            }
            case "btn_red": {
                OperationResult operationResult = args.getOperationResult();
                operationResult.setShowMessage(false);
                if (!operationResult.isSuccess()) {
                    this.getView().showTipNotification(OperationConstant.getErrorMsg((OperationResult)operationResult));
                    return;
                }
                String message = operationResult.getMessage();
                JSONObject json = JSONObject.parseObject((String)message);
                json.put("operateKey", (Object)args.getOperateKey());
                json.put("pkIds", (Object)operationResult.getSuccessPkIds());
                if (json.containsKey((Object)"cancelOrRedArInvoiceBillPks")) {
                    this.getPageCache().put("cancelOrRedArInvoiceBillPks", json.toJSONString());
                    ViewUtil.openNormalConfirm((AbstractFormPlugin)this, (String)ResManager.loadKDString((String)"\u5f00\u7968\u7533\u8bf7\u5355\u5df2\u786e\u8ba4\u5e94\u6536\uff0c\u7ea2\u51b2\u53d1\u7968\u5c06\u51b2\u9500\u5f00\u7968\u7533\u8bf7\u5355\u6240\u5173\u8054\u7684\u8d22\u52a1\u5e94\u6536\u5355\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"RedConfirmBillListPlugin_55", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)"cancelOrRedArInvoice");
                    return;
                }
                new RedConfirmBillIssueControl().handlerRedConfirmIssue(this, json);
                break;
            }
            case "deleteentry": {
                RedConfirmBillAddControl.countHeadAmount((AbstractFormPlugin)this);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if ("bdm_tax_login".equals(closedCallBackEvent.getActionId()) && closedCallBackEvent.getReturnData() != null) {
            this.getView().invokeOperation(BTN_SUBMIT);
        }
        if (closedCallBackEvent.getReturnData() == null) {
            return;
        }
        if ("sim_red_coinfirm_account".equals(closedCallBackEvent.getActionId())) {
            JSONObject json = (JSONObject)closedCallBackEvent.getReturnData();
            new RedConfirmBillIssueControl().executeBatchRed(this, json);
        }
    }

    public void afterF7Select(AfterF7SelectEvent event) {
        String key = ((Control)event.getSource()).getKey();
        EntryGrid grid = (EntryGrid)this.getControl("items");
        int[] rows = grid.getSelectRows();
        if (rows.length < 1) {
            return;
        }
        int selectRow = grid.getSelectRows()[0];
        switch (key) {
            case "goodsid": {
                RedConfirmBillAddControl.editGoodsId((AbstractFormPlugin)this, (AfterF7SelectEvent)event, (int)selectRow);
                break;
            }
            case "taxratecodeid": {
                DynamicObject taxCode = (DynamicObject)this.getModel().getValue("taxratecodeid", selectRow);
                this.getModel().setValue("goodscode", taxCode.get("mergecode"), selectRow);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = ((Control)e.getSource()).getKey();
        if ("goodsid".equals(key) && StringUtils.isBlank((CharSequence)((String)this.getModel().getValue("hsbz")))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u542b\u7a0e\u6807\u5fd7", (String)"RedConfirmBillAddPlugin_4", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (MessageBoxResult.Cancel.equals((Object)messageBoxClosedEvent.getResult())) {
            return;
        }
        String callBackId = StringUtils.defaultString((String)messageBoxClosedEvent.getCallBackId());
        if (callBackId.startsWith("risk_control_check_")) {
            String key = callBackId.substring(callBackId.indexOf("risk_control_check_") + "risk_control_check_".length());
            BillRiskControlService.unlockRiskRecord((AbstractFormPlugin)this);
            BeforeItemClickEvent evt = new BeforeItemClickEvent(new Object(), key, key);
            this.beforeItemClick(evt);
            if (!evt.isCancel()) {
                this.getView().invokeOperation(key);
            }
        } else if ("cancelOrRedArInvoice".equals(callBackId)) {
            new RedConfirmBillIssueControl().handlerRedConfirmIssue(this, JSONObject.parseObject((String)this.getPageCache().get("cancelOrRedArInvoiceBillPks")));
        }
    }
}

