/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.redconfirm.op;

import com.alibaba.fastjson.JSONObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.imc.bdm.common.model.SaleInfo;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.sim.formplugin.redconfirm.helper.RedConfirmBillHelper;

public class AbstractRedConfirmBillBatchOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("confirmstatus");
        fieldKeys.add("number");
        fieldKeys.add("originalinvoicecode");
        fieldKeys.add("salertaxno");
        fieldKeys.add("buyertaxno");
        fieldKeys.add("enteridentity");
        fieldKeys.add("batchstatus");
        fieldKeys.add("applicant");
        fieldKeys.add("account");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities;
                OperateOption option = this.getOption();
                SaleInfo saleInfo = TaxUtils.getSaleInfoByOrg((Long)Long.parseLong(option.getVariableValue("org")));
                String taxNo = saleInfo.getSaleTaxNo();
                this.getOption().setVariableValue("salertaxno", taxNo);
                HashSet<String> accountSet = new HashSet<String>(4);
                for (ExtendedDataEntity dataEntity : dataEntities = this.dataEntities) {
                    String applyTaxNo;
                    DynamicObject redConfirm = dataEntity.getDataEntity();
                    String batchStatus = redConfirm.getString("batchstatus");
                    if (batchStatus.contains("\u4e2d") && StringUtils.isNotBlank((CharSequence)CacheHelper.get((String)((applyTaxNo = RedConfirmBillHelper.getApplyTaxNo((DynamicObject)redConfirm)) + "batchSyncOperate")))) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u786e\u8ba4\u5355\u3010%1$s\u3011\u7684\u72b6\u6001\u4e3a[%2$s]\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"AbstractRedConfirmBillBatchOp_0", (String)"imc-sim-formplugin", (Object[])new Object[0]), redConfirm.getString("number"), batchStatus));
                    }
                    accountSet.add(redConfirm.getString("account"));
                }
                this.getOption().setVariableValue("account", accountSet.size() == 1 ? (String)accountSet.toArray()[0] : "");
            }
        });
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        String statusDescription = this.operateOption.getVariableValue("statusDescription");
        String taxNo = this.operateOption.getVariableValue("salertaxno");
        JSONObject json = new JSONObject();
        json.put("statusDescription", (Object)statusDescription);
        json.put("taxNo", (Object)taxNo);
        json.put("account", (Object)this.operateOption.getVariableValue("account"));
        this.operationResult.setMessage(json.toJSONString());
    }
}

