/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.redconfirm.op;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.model.MsgResponse;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.sim.common.service.IssueInvoiceService;
import kd.imc.sim.formplugin.redconfirm.helper.RedConfirmBillHelper;

public class RedConfirmBillIssueOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().addAll(PropertieUtil.addFieldKey((String)"sim_red_confirm_bill", (boolean)true));
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList<DynamicObject> successObj = new ArrayList<DynamicObject>(dataEntities.length);
        OperateOption option = this.getOption();
        String sellerOrgPk = option.getVariableValue("sellerOrgPk");
        Long sellerOrg = null;
        if (StringUtils.isNotBlank((CharSequence)sellerOrgPk)) {
            sellerOrg = Long.parseLong(sellerOrgPk);
        }
        String account = this.getOption().containsVariable("account") ? this.getOption().getVariableValue("account") : "";
        for (DynamicObject redConfirmBill : dataEntities) {
            DynamicObject invoiceObj = RedConfirmBillHelper.createWaitInvoice((DynamicObject)redConfirmBill);
            if (StringUtils.isNotBlank((CharSequence)account)) {
                invoiceObj.set("account", (Object)account);
            }
            String applicant = redConfirmBill.getString("applicant");
            if (null != sellerOrg && "1".equals(applicant)) {
                invoiceObj.set("orgid", (Object)sellerOrg);
            }
            MsgResponse response = IssueInvoiceService.doIssueInvoice((DynamicObject)invoiceObj, (boolean)false);
            if (ErrorType.SUCCESS.getCode().equals(response.getErrorCode()) || ErrorType.SUBMITED.getCode().equals(response.getErrorCode())) {
                if (StringUtils.isNotBlank((CharSequence)response.getRespData())) {
                    JSONObject json = JSONObject.parseObject((String)response.getRespData());
                    redConfirmBill.set("invoiceno", json.get((Object)"invoiceno"));
                }
                if (ErrorType.SUBMITED.getCode().equals(response.getErrorCode())) {
                    this.operationResult.addErrorInfo((OperateErrorInfo)new ValidationErrorInfo("", redConfirmBill.getPkValue(), 0, 0, ErrorType.FAIL.getCode(), "imc", ErrorType.SUBMITED.getName(), ErrorLevel.Error));
                    redConfirmBill.set("issuestatus", (Object)IssueStatusEnum.underway.getCode());
                    SaveServiceHelper.update((DynamicObject)redConfirmBill);
                } else {
                    redConfirmBill.set("issuestatus", (Object)IssueStatusEnum.ok.getCode());
                }
            } else {
                throw new KDBizException(response.getErrorMsg());
            }
            successObj.add(redConfirmBill);
        }
        e.setDataEntities(successObj.toArray(new DynamicObject[0]));
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        try {
            for (DynamicObject redConfirm : dataEntities) {
                if (!IssueStatusEnum.underway.getCode().equals(redConfirm.getString("issuestatus"))) continue;
                DispatchServiceHelper.invokeBizService((String)"imc", (String)"sim", (String)"AsyncIssueInvoiceQueryImpl", (String)"queryAsyncIssueResult", (Object[])new Object[]{redConfirm.getString("orderno")});
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

