/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.redconfirm.op;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.OrgHelper;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.sim.common.helper.NegativeBillMatchHelper;
import org.apache.commons.collections.CollectionUtils;

public class RedConfirmBillRollbackOp
extends AbstractOperationServicePlugIn {
    private static final Set<String> canRollbackStatus = new ImmutableSet.Builder().add((Object[])new String[]{"05", "06", "07", "08", "09", "10"}).build();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("uploadstatus");
        e.getFieldKeys().add("confirmstatus");
        e.getFieldKeys().add("number");
        e.getFieldKeys().add("originalinvoicecode");
        e.getFieldKeys().add("originalinvoiceno");
        e.getFieldKeys().add("source");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] redConfirms = e.getDataEntities();
        ArrayList<Object> deleteIds = new ArrayList<Object>(redConfirms.length);
        ArrayList<Object> deleteRelationIds = new ArrayList<Object>(redConfirms.length);
        ArrayList<Object> deleteRelationNumbers = new ArrayList<Object>(redConfirms.length);
        HashSet<String> invoiceCodeNoSet = new HashSet<String>(redConfirms.length);
        Set redConfirmPkSet = Arrays.stream(redConfirms).map(o -> o.getLong("id")).collect(Collectors.toSet());
        DynamicObject[] relations = BusinessDataServiceHelper.load((String)"sim_bill_inv_relation", (String)"sbillid,tbillid", (QFilter[])new QFilter("tbillid", "in", redConfirmPkSet).toArray());
        Map<Long, Long> sBillIdTBillIdMap = Arrays.stream(relations).collect(Collectors.toMap(o -> o.getLong("sbillid"), o -> o.getLong("tbillid")));
        Set matchBillIdSet = Arrays.stream(relations).map(o -> o.getLong("sbillid")).collect(Collectors.toSet());
        DynamicObject[] rollBackMatchBills = BusinessDataServiceHelper.load((String)"sim_match_bill", (String)"matchtarget", (QFilter[])new QFilter("id", "in", matchBillIdSet).toArray());
        Set matchRedConfirmMatchBillPks = Arrays.stream(rollBackMatchBills).filter(o -> "1".equals(o.getString("matchtarget")) || "2".equals(o.getString("matchtarget"))).map(o -> o.getLong("id")).collect(Collectors.toSet());
        Set fromMatchRedConfirmPks = matchRedConfirmMatchBillPks.stream().map(o -> (Long)sBillIdTBillIdMap.get(o)).collect(Collectors.toSet());
        ArrayList<DynamicObject> matchBillMatchRedConfirms = new ArrayList<DynamicObject>();
        for (DynamicObject redConfirm : redConfirms) {
            if (!"10".equals(redConfirm.getString("source"))) continue;
            if (fromMatchRedConfirmPks.contains(redConfirm.getLong("id"))) {
                matchBillMatchRedConfirms.add(redConfirm);
                continue;
            }
            this.revokeRedConfirmFromMatchInv(deleteIds, deleteRelationIds, deleteRelationNumbers, invoiceCodeNoSet, redConfirm);
        }
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"rollbackdelete", (String)"sim_red_confirm_bill", (Object[])deleteIds.toArray(), null);
        if (CollectionUtils.isNotEmpty((Collection)operationResult.getSuccessPkIds())) {
            deleteRelationIds.addAll(operationResult.getSuccessPkIds());
        }
        if (CollectionUtils.isNotEmpty(deleteRelationIds)) {
            DynamicObject[] matchBills;
            for (DynamicObject matchBill : matchBills = new NegativeBillMatchHelper().getMatchBillByTBillId(deleteRelationIds)) {
                DynamicObjectCollection items2 = matchBill.getDynamicObjectCollection("sim_original_bill_item");
                for (DynamicObject item : items2) {
                    DynamicObjectCollection oriItems = item.getDynamicObjectCollection("subentryentity");
                    for (DynamicObject oriItem : oriItems) {
                        String invoiceCodeNo;
                        if (deleteRelationNumbers.contains(oriItem.getString("infocode"))) {
                            oriItem.set("infocode", (Object)"");
                        }
                        if (!invoiceCodeNoSet.contains(invoiceCodeNo = oriItem.getString("oriinvoicecode") + "\u25cf\u25c6\u25a0" + oriItem.getString("oriinvoiceno") + "\u25cf\u25c6\u25a0" + oriItem.getString("oriitemseq"))) continue;
                        oriItem.set("pushstatus", (Object)"-1");
                    }
                }
                NegativeBillMatchHelper.changePushStatus((DynamicObject)matchBill);
            }
            ImcSaveServiceHelper.save((DynamicObject[])matchBills);
            DeleteServiceHelper.delete((String)"sim_match_inv_relation", (QFilter[])OrgHelper.getIdFilter(deleteRelationIds, (String)"tbillid").toArray());
        }
        if (CollectionUtils.isNotEmpty(matchBillMatchRedConfirms)) {
            for (DynamicObject redConfirm : matchBillMatchRedConfirms) {
                redConfirm.set("occupystatus", (Object)"0");
                if ("1".equals(redConfirm.getString("applicant"))) {
                    redConfirm.set("source", (Object)"2");
                    continue;
                }
                redConfirm.set("source", (Object)"1");
            }
            DeleteServiceHelper.delete((String)"sim_match_inv_relation", (QFilter[])OrgHelper.getIdFilter(deleteRelationIds, (String)"tbillid").toArray());
        }
    }

    private void revokeRedConfirmFromMatchInv(List<Object> deleteIds, List<Object> deleteRelationIds, List<Object> deleteRelationNumbers, Set<String> invoiceCodeNoSet, DynamicObject redConfirm) {
        if (DynamicObjectUtil.checkDynamicObjectHasField((DynamicObject)redConfirm, (String)"items") && CollectionUtils.isNotEmpty((Collection)redConfirm.getDynamicObjectCollection("items"))) {
            DynamicObjectCollection redItems = redConfirm.getDynamicObjectCollection("items");
        } else {
            DynamicObject redConfirmBill = BusinessDataServiceHelper.loadSingle((String)"sim_red_confirm_bill", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_red_confirm_bill", (boolean)true), (QFilter[])new QFilter("id", "=", (Object)redConfirm.getLong("id")).toArray());
            DynamicObjectCollection redItems = redConfirmBill.getDynamicObjectCollection("items");
            for (DynamicObject redItem : redItems) {
                invoiceCodeNoSet.add(redConfirm.getString("originalinvoicecode") + "\u25cf\u25c6\u25a0" + redConfirm.getString("originalinvoiceno") + "\u25cf\u25c6\u25a0" + redItem.getString("originseq"));
            }
        }
        String uploadStatus = redConfirm.getString("uploadstatus");
        if ("0".equals(uploadStatus) || "2".equals(uploadStatus)) {
            deleteIds.add(redConfirm.getPkValue());
            return;
        }
        if (canRollbackStatus.contains(redConfirm.getString("confirmstatus"))) {
            deleteIds.add(redConfirm.getPkValue());
            deleteRelationIds.add(redConfirm.getPkValue());
            deleteRelationNumbers.add(redConfirm.getString("number"));
        }
    }
}

