/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.redconfirm.op.validator;

import com.google.common.collect.ImmutableSet;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.constant.BillStatusEnum;
import kd.imc.bdm.common.helper.InvoiceValidHelper;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.GBKUtils;
import kd.imc.sim.common.constant.InvoiceConstant;
import kd.imc.sim.common.constant.RedConfirmBillRedReasonEnum;
import kd.imc.sim.common.constant.RedConfirmStatusEnum;
import kd.imc.sim.common.helper.issueinvoice.PriceHelper;
import kd.imc.sim.common.utils.MathUtils;
import org.apache.commons.lang3.StringUtils;

public class RedConfirmBillSaveValidator
extends AbstractValidator {
    private static final Set<String> normalConfirmStatus = new ImmutableSet.Builder().add((Object)RedConfirmStatusEnum.NO_CONFIRM.getBillCode()).add((Object)RedConfirmStatusEnum.BUYER_CONFIRM.getBillCode()).add((Object)RedConfirmStatusEnum.SELLER_CONFIRM.getBillCode()).add((Object)RedConfirmStatusEnum.ALL_CONFIRM.getBillCode()).build();

    public Set<String> preparePropertys() {
        Set props = super.preparePropertys();
        Collections.addAll(props, "remark", "buyeremail", "buyerphone");
        return props;
    }

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.dataEntities;
        QFilter vatInvoiceFilter = null;
        QFilter rimEleFilter = null;
        HashMap<String, DynamicObject> blueInvoiceNoMap = new HashMap<String, DynamicObject>();
        HashMap<String, ExtendedDataEntity> redConfirmEntityNoMap = new HashMap<String, ExtendedDataEntity>();
        HashMap<Long, DynamicObject> redItemMap = new HashMap<Long, DynamicObject>();
        HashMap<Long, Integer> redItemIndexMap = new HashMap<Long, Integer>();
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject redConfirm = dataEntity.getDataEntity();
            String status = redConfirm.getString("status");
            String remark = redConfirm.getString("remark");
            if (String.valueOf(remark).length() > 200) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5907\u6ce8\u8d85\u957f", (String)"RedConfirmBillSaveValidator_26", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            }
            String operateKey = this.getOperateKey();
            String errorMsg = this.checkBuyerEmail(redConfirm.getString("buyeremail"));
            if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
                this.addErrorMessage(dataEntity, errorMsg);
            }
            if (GBKUtils.getGBKLength((String)redConfirm.getString("buyerphone")) > 80) {
                this.addErrorMessage(dataEntity, ApiErrCodeEnum.BILL_PUSH_BUYERRPHONE_ERROR_LEN.getMsg());
            }
            if (!"save".equals(operateKey) ? "submit".equals(operateKey) && !BillStatusEnum.TEMP_SAVE.getCode().equals(status) : !BillStatusEnum.TEMP_SAVE.getCode().equals(status) && !BillStatusEnum.NO_APPROVAL_REQUIRED.getCode().equals(status)) continue;
            if (!DynamicObjectUtil.checkDynamicObjectHasField((DynamicObject)redConfirm, (String)"redreason")) {
                redConfirm = BusinessDataServiceHelper.loadSingle((Object)redConfirm.getPkValue(), (String)"sim_red_confirm_bill");
            }
            if ("1".equals(redConfirm.getString("uploadstatus")) && !normalConfirmStatus.contains(redConfirm.getString("confirmstatus"))) continue;
            String redReason = redConfirm.getString("redreason");
            DynamicObjectCollection items2 = redConfirm.getDynamicObjectCollection("items");
            String applicant = redConfirm.getString("applicant");
            if (items2.stream().allMatch(this::notServiceCut) && RedConfirmBillRedReasonEnum.SERVICE_CUT.getCode().equals(redReason)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u660e\u7ec6\u7684\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u4ee51\u30012\u5f00\u5934\uff0c\u51b2\u7ea2\u539f\u56e0\u4e0d\u5141\u8bb8\u9009\u62e9\u201c\u670d\u52a1\u7ec8\u6b62\u201d\uff01", (String)"RedConfirmBillSaveValidator_0", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            }
            if (StringUtils.isBlank((CharSequence)redConfirm.getString("originalinvoiceno"))) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u4e3a:%s\u7684\u7ea2\u5b57\u786e\u8ba4\u5355\u539f\u53d1\u7968\u53f7\u7801\u5fc5\u586b\uff01", (String)"RedConfirmBillSaveValidator_1", (String)"imc-sim-formplugin", (Object[])new Object[0]), redConfirm.getString("billno")));
            } else if ("2".equals(applicant)) {
                vatInvoiceFilter = null == vatInvoiceFilter ? new QFilter("invoicecode", "=", (Object)redConfirm.getString("originalinvoicecode")).and("invoiceno", "=", (Object)redConfirm.getString("originalinvoiceno")) : vatInvoiceFilter.or(new QFilter("invoicecode", "=", (Object)redConfirm.getString("originalinvoicecode")).and("invoiceno", "=", (Object)redConfirm.getString("originalinvoiceno")));
                String buyerTaxNo = redConfirm.getString("buyertaxno");
                if (StringUtils.isNotBlank((CharSequence)buyerTaxNo) && buyerTaxNo.length() > 20) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u4e3a:%s\u7684\u7ea2\u5b57\u786e\u8ba4\u5355\u8d2d\u65b9\u7a0e\u53f7\u4e0d\u80fd\u8d85\u8fc720\u4f4d", (String)"RedConfirmBillSaveValidator_25", (String)"imc-sim-formplugin", (Object[])new Object[]{redConfirm.getString("billno")}));
                }
                for (int i = 0; i < items2.size(); ++i) {
                    DynamicObject item = (DynamicObject)items2.get(i);
                    redItemMap.put(item.getLong("originalinvoiceitemid"), item);
                    redItemIndexMap.put(item.getLong("originalinvoiceitemid"), i + 1);
                }
            } else {
                rimEleFilter = null == rimEleFilter ? new QFilter("invoice_no", "=", (Object)redConfirm.getString("originalinvoiceno")) : rimEleFilter.or("invoice_no", "=", (Object)redConfirm.getString("originalinvoiceno"));
            }
            this.checkItemsAmount(dataEntity, redConfirm, items2);
            blueInvoiceNoMap.put(redConfirm.getString("originalinvoiceno"), redConfirm);
            redConfirmEntityNoMap.put(redConfirm.getString("originalinvoiceno"), dataEntity);
        }
        if (null != vatInvoiceFilter) {
            String fields = String.join((CharSequence)",", "invoicecode", "invoiceno", "totaltax", "totalamount", "invoiceamount", "remainredamount", "canredtaxamount", "itemremainredamount", "itemremainrednum");
            DynamicObject[] oriInvoices = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)fields, (QFilter[])vatInvoiceFilter.toArray());
            this.checkOriAmount(blueInvoiceNoMap, redConfirmEntityNoMap, oriInvoices, redItemMap, redItemIndexMap);
        }
        if (null != rimEleFilter) {
            String rimEleFields = "total_amount,total_tax_amount,invoice_amount,invoice_no";
            DynamicObject[] rimInvs = BusinessDataServiceHelper.load((String)"rim_inv_electric", (String)rimEleFields, (QFilter[])rimEleFilter.toArray());
            this.checkOriAmount(blueInvoiceNoMap, redConfirmEntityNoMap, rimInvs, redItemMap, redItemIndexMap);
        }
    }

    private String checkBuyerEmail(String buyerEmail) {
        try {
            InvoiceValidHelper.checkMultiEmail((String)buyerEmail);
        }
        catch (MsgException e) {
            return e.getErrorMsg().replace("\u8d2d\u4e70\u65b9", "\u4ea4\u4ed8");
        }
        return null;
    }

    private void checkOriAmount(HashMap<String, DynamicObject> blueInvoiceNoMap, HashMap<String, ExtendedDataEntity> redConfirmEntityNoMap, DynamicObject[] oriInvoices, Map<Long, DynamicObject> redItemMap, Map<Long, Integer> redItemIndexMap) {
        for (DynamicObject oriInvoice : oriInvoices) {
            ExtendedDataEntity dataEntity;
            String billKey = oriInvoice.getDataEntityType().getName();
            BigDecimal blueTotalTax = BigDecimal.ZERO;
            BigDecimal blueInvoiceAmount = BigDecimal.ZERO;
            String invoiceNo = null;
            if ("sim_vatinvoice".equals(billKey)) {
                BigDecimal totalRedConfirmAmount;
                DynamicObject[] queryRedConfirms;
                invoiceNo = oriInvoice.getString("invoiceno");
                blueTotalTax = oriInvoice.getBigDecimal("totaltax");
                blueInvoiceAmount = oriInvoice.getBigDecimal("invoiceamount");
                ExtendedDataEntity dataEntity2 = redConfirmEntityNoMap.get(invoiceNo);
                DynamicObject redConfirm = blueInvoiceNoMap.get(invoiceNo);
                QFilter redConfirmFilter = new QFilter("originalinvoicecode", "=", (Object)redConfirm.getString("originalinvoicecode")).and("originalinvoiceno", "=", (Object)redConfirm.getString("originalinvoiceno"));
                QFilter uploadFilter = new QFilter("confirmstatus", "in", normalConfirmStatus).or(new QFilter("uploadstatus", "!=", (Object)"1"));
                redConfirmFilter.and(uploadFilter);
                if (redConfirm.getPkValue() != null) {
                    redConfirmFilter.and("id", "!=", redConfirm.getPkValue());
                }
                if ((queryRedConfirms = BusinessDataServiceHelper.load((String)"sim_red_confirm_bill", (String)String.join((CharSequence)",", "invoiceamount", "billno"), (QFilter[])redConfirmFilter.toArray())) != null && queryRedConfirms.length != 0 && (totalRedConfirmAmount = Arrays.stream(queryRedConfirms).map(confirm -> confirm.getBigDecimal("invoiceamount")).reduce(BigDecimal.ZERO, BigDecimal::add)).add(redConfirm.getBigDecimal("invoiceamount")).abs().compareTo(blueInvoiceAmount) > 0) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u4e3a:", (String)"RedConfirmBillSaveValidator_21", (String)"imc-sim-formplugin", (Object[])new Object[0])).append(redConfirm.getString("billno")).append('\uff0c');
                    if (StringUtils.isNotBlank((CharSequence)redConfirm.getString("originalinvoicecode"))) {
                        sb.append(ResManager.loadKDString((String)"\u539f\u84dd\u7968\u4ee3\u7801", (String)"RedConfirmBillSaveValidator_22", (String)"imc-sim-formplugin", (Object[])new Object[0])).append(redConfirm.getString("originalinvoicecode")).append('\uff0c');
                    }
                    if (StringUtils.isNotBlank((CharSequence)redConfirm.getString("originalinvoiceno"))) {
                        sb.append(ResManager.loadKDString((String)"\u539f\u84dd\u7968\u53f7\u7801", (String)"RedConfirmBillSaveValidator_23", (String)"imc-sim-formplugin", (Object[])new Object[0])).append(redConfirm.getString("originalinvoiceno")).append('\uff0c');
                    }
                    sb.append(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5df2\u7533\u8bf7\u7ea2\u5b57\u786e\u8ba4\u603b\u989d\u4e3a:%1$s,\u5269\u4f59\u53ef\u7533\u8bf7\u7ea2\u5b57\u786e\u8ba4\u5355\u91d1\u989d\u4e3a:%2$s", (String)"RedConfirmBillSaveValidator_24", (String)"imc-sim-formplugin", (Object[])new Object[0]), totalRedConfirmAmount.setScale(2, 4), totalRedConfirmAmount.add(blueInvoiceAmount).negate().setScale(2, 4)));
                    this.addErrorMessage(dataEntity2, sb.toString());
                }
                DynamicObjectCollection oriItems = oriInvoice.getDynamicObjectCollection("items");
                for (DynamicObject oriItem : oriItems) {
                    DynamicObject redItem = redItemMap.get(oriItem.getLong("id"));
                    if (redItem == null) continue;
                    BigDecimal redNum = redItem.getBigDecimal("num");
                    BigDecimal redAmount = redItem.getBigDecimal("amount");
                    BigDecimal remainNum = oriItem.getBigDecimal("itemremainrednum");
                    BigDecimal remainAmount = oriItem.getBigDecimal("itemremainredamount");
                    int redIndex = redItemIndexMap.get(oriItem.getLong("id"));
                    if (redAmount.abs().compareTo(remainAmount) > 0) {
                        this.addErrorMessage(dataEntity2, String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u4e3a:%1$s\u7684\u7ea2\u5b57\u786e\u8ba4\u5355\uff0c\u539f\u84dd\u7968\u4ee3\u7801%2$s\uff0c\u539f\u84dd\u7968\u53f7\u7801%3$s\uff0c\u7b2c%4$s\u884c\u660e\u7ec6\u7684\u4e0d\u542b\u7a0e\u91d1\u989d%5$s\u8d85\u8fc7\u539f\u84dd\u7968\u7684\u4e0d\u542b\u7a0e\u91d1\u989d%6$s", (String)"RedConfirmBillSaveValidator_19", (String)"imc-sim-formplugin", (Object[])new Object[0]), redConfirm.getString("billno"), redConfirm.getString("originalinvoicecode"), redConfirm.getString("originalinvoiceno"), redIndex, redAmount.abs().setScale(2, 4), remainAmount.setScale(2, 4)));
                    }
                    if (redNum == null || remainNum == null || redNum.abs().compareTo(remainNum) <= 0) continue;
                    this.addErrorMessage(dataEntity2, String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u4e3a:%1$s\u7684\u7ea2\u5b57\u786e\u8ba4\u5355\uff0c\u539f\u84dd\u7968\u4ee3\u7801%2$s\uff0c\u539f\u84dd\u7968\u53f7\u7801%3$s\uff0c\u7b2c%4$s\u884c\u660e\u7ec6\u7684\u6570\u91cf%5$s\u8d85\u8fc7\u539f\u84dd\u7968\u7684\u6570\u91cf%6$s", (String)"RedConfirmBillSaveValidator_20", (String)"imc-sim-formplugin", (Object[])new Object[0]), redConfirm.getString("billno"), redConfirm.getString("originalinvoicecode"), redConfirm.getString("originalinvoiceno"), redIndex, redNum.stripTrailingZeros().toPlainString(), remainNum.stripTrailingZeros().toPlainString()));
                }
            } else if ("rim_inv_electric".equals(billKey)) {
                invoiceNo = oriInvoice.getString("invoice_no");
                blueTotalTax = oriInvoice.getBigDecimal("total_tax_amount");
                blueInvoiceAmount = oriInvoice.getBigDecimal("total_amount");
            }
            DynamicObject redConfirm = blueInvoiceNoMap.get(invoiceNo);
            BigDecimal redConfirmInvoiceAmount = redConfirm.getBigDecimal("invoiceamount");
            BigDecimal redConfirmTotalTax = redConfirm.getBigDecimal("totaltax");
            if (redConfirmInvoiceAmount.abs().compareTo(blueInvoiceAmount.abs()) > 0) {
                dataEntity = redConfirmEntityNoMap.get(invoiceNo);
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u4e3a:%s\u7684\u7ea2\u5b57\u786e\u8ba4\u5355\uff0c\u4e0d\u542b\u7a0e\u91d1\u989d\u8d85\u8fc7\u539f\u84dd\u7968\u7684\u4e0d\u542b\u7a0e\u91d1\u989d", (String)"RedConfirmBillSaveValidator_6", (String)"imc-sim-formplugin", (Object[])new Object[0]), redConfirm.getString("billno")));
            }
            if (redConfirmTotalTax.abs().compareTo(blueTotalTax.abs()) <= 0) continue;
            dataEntity = redConfirmEntityNoMap.get(invoiceNo);
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u4e3a:%s\u7684\u7ea2\u5b57\u786e\u8ba4\u5355\uff0c\u7a0e\u989d\u8d85\u8fc7\u539f\u84dd\u7968\u7684\u7a0e\u989d", (String)"RedConfirmBillSaveValidator_7", (String)"imc-sim-formplugin", (Object[])new Object[0]), redConfirm.getString("billno")));
        }
    }

    private void checkItemsAmount(ExtendedDataEntity dataEntity, DynamicObject redConfirm, DynamicObjectCollection items2) {
        if (items2.size() == 0) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a", (String)"RedConfirmBillSaveValidator_8", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            return;
        }
        BigDecimal calTotalTax = BigDecimal.ZERO;
        BigDecimal calTotalAmount = BigDecimal.ZERO;
        BigDecimal calInvoiceAmount = BigDecimal.ZERO;
        for (int i = 0; i < items2.size(); ++i) {
            String goodsName;
            DynamicObject item = (DynamicObject)items2.get(i);
            String goodsCode = item.getString("goodscode");
            if (StringUtils.isBlank((CharSequence)goodsCode) && StringUtils.isNotBlank((CharSequence)(goodsName = item.getString("goodsname"))) && !goodsName.contains("\u8be6\u89c1\u9500\u8d27\u6e05\u5355")) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (String)"RedConfirmBillSaveValidator_9", (String)"imc-sim-formplugin", (Object[])new Object[0]), i + 1));
            }
            if (StringUtils.isBlank((CharSequence)item.getString("taxrate"))) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u660e\u7ec6\u7a0e\u7387\u4e3a\u7a7a", (String)"RedConfirmBillSaveValidator_10", (String)"imc-sim-formplugin", (Object[])new Object[0]), i + 1));
                return;
            }
            BigDecimal taxAmount = (BigDecimal)item.get("taxamount");
            BigDecimal itemAmount = (BigDecimal)item.get("amount");
            BigDecimal tax = (BigDecimal)item.get("tax");
            if (!MathUtils.isNullOrZero((BigDecimal)taxAmount)) {
                if (tax.add(itemAmount).compareTo(taxAmount) != 0) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u660e\u7ec6\u91d1\u989d+\u7a0e\u989d\u4e0d\u7b49\u4e8e\u542b\u7a0e\u91d1\u989d", (String)"RedConfirmBillSaveValidator_11", (String)"imc-sim-formplugin", (Object[])new Object[0]), i + 1));
                }
            } else {
                taxAmount = itemAmount.add(tax);
                item.set("taxamount", (Object)taxAmount);
            }
            BigDecimal unitPrice = item.getBigDecimal("unitprice");
            BigDecimal num = item.getBigDecimal("num");
            if (!BigDecimalUtil.compareZero((BigDecimal)num) && !BigDecimalUtil.compareZero((BigDecimal)unitPrice)) {
                BigDecimal calAmount = num.multiply(unitPrice).setScale(2, RoundingMode.HALF_UP);
                BigDecimal amountDiffer = calAmount.subtract(itemAmount).abs();
                if (amountDiffer.compareTo(InvoiceConstant.DIFF_01) > 0) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u660e\u7ec6\u5355\u4ef7\u4e58\u4ee5\u6570\u91cf\u4e0e\u91d1\u989d\u7684\u5dee\u503c\u5927\u4e8e0.01", (String)"RedConfirmBillSaveValidator_12", (String)"imc-sim-formplugin", (Object[])new Object[0]), i + 1));
                }
                if (MathUtils.isNullOrZero((BigDecimal)item.getBigDecimal("taxunitprice"))) {
                    item.set("taxunitprice", (Object)PriceHelper.calcPriceOrNum((BigDecimal)item.getBigDecimal("taxamount"), (BigDecimal)num, (boolean)Boolean.TRUE));
                }
            }
            calTotalTax = calTotalTax.add(tax);
            calTotalAmount = calTotalAmount.add(taxAmount);
            calInvoiceAmount = calInvoiceAmount.add(itemAmount);
        }
        if (calTotalTax.compareTo(redConfirm.getBigDecimal("totaltax")) != 0) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u660e\u7ec6\u7a0e\u989d\u4e4b\u548c\u4e0e\u5355\u636e\u5934\u7a0e\u989d\u4e0d\u4e00\u81f4", (String)"RedConfirmBillSaveValidator_14", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        if (calInvoiceAmount.compareTo(redConfirm.getBigDecimal("invoiceamount")) != 0) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u660e\u7ec6\u91d1\u989d\u4e4b\u548c\u4e0e\u5355\u636e\u5934\u4e0d\u542b\u7a0e\u91d1\u989d\u4e0d\u4e00\u81f4", (String)"RedConfirmBillSaveValidator_15", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        if (calTotalAmount.compareTo(redConfirm.getBigDecimal("totalamount")) != 0) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u660e\u7ec6\u542b\u7a0e\u91d1\u989d\u4e4b\u548c\u4e0e\u5355\u636e\u5934\u542b\u7a0e\u91d1\u989d\u4e0d\u4e00\u81f4", (String)"RedConfirmBillSaveValidator_16", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
    }

    private boolean notServiceCut(DynamicObject item) {
        String goodsCode = item.getString("goodscode");
        if (StringUtils.isBlank((CharSequence)goodsCode)) {
            return true;
        }
        return goodsCode.startsWith("1") || goodsCode.startsWith("2");
    }
}

