/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.redconfirm.task;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.constant.OperationConstant;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.sim.common.dto.RedConfirmBillHandleRequest;
import kd.imc.sim.formplugin.redconfirm.RedConfirmBillListPlugin;
import kd.imc.sim.formplugin.redconfirm.helper.RedConfirmBillHelper;
import kd.imc.sim.untrans.SimFormPluginConstellationUntrans;

public class RedConfirmBillHandleTask
extends AbstractTask
implements SimFormPluginConstellationUntrans {
    private static Log LOGGER = LogFactory.getLog(RedConfirmBillHandleTask.class);

    public static void dispatchTask(RedConfirmBillListPlugin listPlugin, RedConfirmBillHandleRequest request) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId(listPlugin.getView().getFormShowParameter().getAppId());
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setName(ResManager.loadKDString((String)"\u7ea2\u5b57\u786e\u8ba4\u5355\u6279\u91cf\u5f02\u6b65\u5904\u7406", (String)"RedConfirmBillHandleTask_0", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setTaskClassname(RedConfirmBillHandleTask.class.getName());
        jobInfo.setRunByUserId(Long.parseLong(RequestContext.get().getUserId()));
        HashMap<String, RedConfirmBillHandleRequest> params = new HashMap<String, RedConfirmBillHandleRequest>();
        params.put("request", request);
        jobInfo.setParams(params);
        JobFormInfo formInfo = new JobFormInfo(jobInfo);
        formInfo.setCloseCallBack(new CloseCallBack((IFormPlugin)listPlugin, "dispatchTaskRedConfirm"));
        formInfo.setCanBackground(true);
        formInfo.setTimeout(600);
        JobForm.dispatch((JobFormInfo)formInfo, (IFormView)listPlugin.getView());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOGGER.info("RedConfirmBillHandleTaskStart");
        RedConfirmBillHandleRequest request = (RedConfirmBillHandleRequest)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)map.get("request")), RedConfirmBillHandleRequest.class);
        Object[] pks = request.getPks();
        String description = request.getOpDescription();
        String operate = description.replace("\u4e2d", "");
        try {
            String opKey = request.getOpKey();
            this.feedbackProgress(0, String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u786e\u8ba4\u5355%s", (String)"RedConfirmBillHandleTask_1", (String)"imc-sim-formplugin", (Object[])new Object[0]), description), null);
            int totalNum = pks.length;
            int successNum = 0;
            StringBuilder failReasonBuilder = new StringBuilder();
            OperateOption option = OperateOption.create();
            option.setVariableValue("account", request.getAccount());
            for (int i = 0; i < pks.length; ++i) {
                Object pk = pks[i];
                OperationResult operationResult = OperationServiceHelper.executeOperate((String)opKey, (String)"sim_red_confirm_bill", (Object[])new Object[]{pk}, (OperateOption)option);
                if (null != operationResult && operationResult.isSuccess()) {
                    ++successNum;
                } else if (null != operationResult) {
                    LOGGER.info(String.format("\u5904\u7406\u5931\u8d25\uff1a%s", OperationConstant.getErrorMsg((OperationResult)operationResult)));
                    failReasonBuilder.append(OperationConstant.getErrorMsg((OperationResult)operationResult)).append(";");
                }
                int progress = (i + 1) * 100 / totalNum;
                String desc = String.format(ResManager.loadKDString((String)"\u6b63\u5728\u5904\u7406\u7b2c%1$s\u4e2a\u7ea2\u5b57\u786e\u8ba4\u5355\uff0c\u5171%2$s\u4e2a\u7ea2\u5b57\u786e\u8ba4\u5355", (String)"RedConfirmBillHandleTask_2", (String)"imc-sim-formplugin", (Object[])new Object[0]), i + 1, totalNum);
                this.feedbackProgress(progress, desc, new HashMap());
            }
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("success", Boolean.TRUE);
            result.put("succesNum", successNum);
            if (totalNum - successNum != 0) {
                result.put("errMsg", String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u786e\u8ba4\u5355%1$s\u6210\u529f:%2$s\u6761\uff0c\u5931\u8d25:%3$s\u6761,\u5931\u8d25\u539f\u56e0\uff1a%4$s", (String)"RedConfirmBillHandleTask_3", (String)"imc-sim-formplugin", (Object[])new Object[0]), operate, successNum, totalNum - successNum, failReasonBuilder.toString()));
            } else {
                result.put("errMsg", String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u786e\u8ba4\u5355%1$s\u6210\u529f:%2$s\u6761\uff0c\u5931\u8d25:%3$s\u6761", (String)"RedConfirmBillHandleTask_4", (String)"imc-sim-formplugin", (Object[])new Object[0]), operate, successNum, totalNum - successNum));
            }
            result.put("failNum", totalNum - successNum);
            this.feedbackCustomdata(result);
        }
        catch (Exception e) {
            try {
                LOGGER.error(e.getMessage(), (Throwable)e);
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put("success", Boolean.FALSE);
                result.put("errMsg", String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u786e\u8ba4\u5355%1$s\u5931\u8d25:%2$s", (String)"RedConfirmBillHandleTask_5", (String)"imc-sim-formplugin", (Object[])new Object[0]), operate, e.getMessage()));
                this.feedbackCustomdata(result);
            }
            catch (Throwable throwable) {
                String fields = String.join((CharSequence)",", "batchstatus", "salertaxno", "buyertaxno", "applicant");
                DynamicObject[] redConfirms = BusinessDataServiceHelper.load((String)"sim_red_confirm_bill", (String)fields, (QFilter[])new QFilter("id", "in", (Object)pks).toArray());
                String applyTaxNo = RedConfirmBillHelper.getApplyTaxNo((DynamicObject)redConfirms[0]);
                for (DynamicObject redConfirm : redConfirms) {
                    redConfirm.set("batchstatus", null);
                }
                SaveServiceHelper.update((DynamicObject[])redConfirms);
                CacheHelper.remove((String)(applyTaxNo + "batchSyncOperate"));
                throw throwable;
            }
            String fields = String.join((CharSequence)",", "batchstatus", "salertaxno", "buyertaxno", "applicant");
            DynamicObject[] redConfirms = BusinessDataServiceHelper.load((String)"sim_red_confirm_bill", (String)fields, (QFilter[])new QFilter("id", "in", (Object)pks).toArray());
            String applyTaxNo = RedConfirmBillHelper.getApplyTaxNo((DynamicObject)redConfirms[0]);
            for (DynamicObject redConfirm : redConfirms) {
                redConfirm.set("batchstatus", null);
            }
            SaveServiceHelper.update((DynamicObject[])redConfirms);
            CacheHelper.remove((String)(applyTaxNo + "batchSyncOperate"));
        }
        String fields = String.join((CharSequence)",", "batchstatus", "salertaxno", "buyertaxno", "applicant");
        DynamicObject[] redConfirms = BusinessDataServiceHelper.load((String)"sim_red_confirm_bill", (String)fields, (QFilter[])new QFilter("id", "in", (Object)pks).toArray());
        String applyTaxNo = RedConfirmBillHelper.getApplyTaxNo((DynamicObject)redConfirms[0]);
        for (DynamicObject redConfirm : redConfirms) {
            redConfirm.set("batchstatus", null);
        }
        SaveServiceHelper.update((DynamicObject[])redConfirms);
        CacheHelper.remove((String)(applyTaxNo + "batchSyncOperate"));
    }
}

