/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.redinfo;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.bdm.common.constant.ImcPermItemEnum;
import kd.imc.bdm.common.constant.InvoiceStatus;
import kd.imc.bdm.common.constant.table.RedInfoConstant;
import kd.imc.bdm.common.helper.PermissionHelper;
import kd.imc.bdm.common.model.SaleInfo;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.sim.common.helper.SimCallBackHelper;
import kd.imc.sim.common.plugin.AbstractCheckInvoicePlugin;
import kd.imc.sim.common.utils.InvoiceQFilterUtil;
import kd.imc.sim.formplugin.redconfirm.helper.RedConfirmBillHelper;

public class RedInfoDialogPlugin
extends AbstractCheckInvoicePlugin {
    public void afterCreateNewData(EventObject e) {
        JSONObject jsonObject = (JSONObject)this.getView().getFormShowParameter().getCustomParam("data");
        if (null != jsonObject) {
            this.getModel().setValue("originalinvoicecode", (Object)jsonObject.getString("invoicecode"));
            this.getModel().setValue("originalinvoiceno", (Object)jsonObject.getString("invoiceno"));
            this.getModel().setValue("originalissuetime", jsonObject.get((Object)"issuetime"));
            this.getView().setEnable(Boolean.FALSE, new String[]{"originalinvoicecode", "originalinvoiceno", "originalissuetime", "applicant", "org"});
            JSONObject org = (JSONObject)jsonObject.get((Object)"orgid");
            if (Objects.nonNull(org)) {
                this.getModel().setValue("org", org.get((Object)"id"));
            }
        } else {
            this.getModel().setValue("org", (Object)RequestContext.get().getOrgId());
            this.changeApplicant(RedInfoConstant.ApplicantEnum.SALER.getCode());
        }
        this.getModel().setValue("applicant", (Object)RedInfoConstant.ApplicantEnum.SALER.getCode());
    }

    private void changeApplicant(String applicant) {
        this.getModel().setValue("originalinvoicecode", null);
        this.getModel().setValue("originalinvoiceno", null);
        this.getModel().setValue("originalissuetime", null);
        TextEdit codeEdit = (TextEdit)this.getControl("originalinvoicecode");
        TextEdit noEdit = (TextEdit)this.getControl("originalinvoiceno");
        DateEdit dateEdit = (DateEdit)this.getControl("originalissuetime");
        if (applicant.equals(RedInfoConstant.ApplicantEnum.BUYERDEDUCTED.getCode())) {
            codeEdit.setMustInput(false);
            noEdit.setMustInput(false);
            dateEdit.setMustInput(false);
            codeEdit.setEnable(null, false, 0);
            dateEdit.setEnable(null, false, 0);
        } else {
            codeEdit.setMustInput(true);
            noEdit.setMustInput(true);
            dateEdit.setMustInput(true);
            codeEdit.setEnable(null, true, 0);
            dateEdit.setEnable(null, true, 0);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if ("applicant".equals(e.getProperty().getName())) {
            this.changeApplicant((String)e.getChangeSet()[0].getNewValue());
        }
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btn_ok"});
        TextEdit invoiceNoEdit = (TextEdit)this.getView().getControl("originalinvoiceno");
        invoiceNoEdit.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        switch (source.getKey()) {
            case "originalinvoiceno": {
                this.openVatInvoiceListView();
                break;
            }
            case "btn_ok": {
                this.editRedInfo();
                break;
            }
        }
    }

    private void openVatInvoiceListView() {
        Object org = this.getModel().getValue("org");
        if (org == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ec4\u7ec7", (String)"RedInfoDialogPlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        String applicant = (String)this.getModel().getValue("applicant");
        if (RedInfoConstant.ApplicantEnum.SALER.getCode().equals(applicant)) {
            QFilter qFilter = new QFilter("invoicetype", "in", (Object)InvoiceUtils.getSpecialInvoiceType()).and("invoicestatus", "in", (Object)InvoiceStatus.NormalStatusArray).and("orgid", "=", (Object)DynamicObjectUtil.getDynamicObjectLongValue((Object)this.getModel().getValue("org"))).and("totalamount", ">", (Object)BigDecimal.ZERO).and("iselepaper", "!=", (Object)"1");
            RedConfirmBillHelper.openListPage((AbstractFormPlugin)this, (QFilter)qFilter, (String)"sim_choose_vatinvoice", (String)"originalinvoiceno", null, (String)ResManager.loadKDString((String)"\u9500\u9879\u5f00\u7968\u5217\u8868", (String)"RedInfoDialogPlugin_1", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        } else {
            try {
                QFilter qFilter = this.getRimCommonFilter(applicant);
                QueryServiceHelper.exists((String)"rim_inv_special", (QFilter[])qFilter.toArray());
                HashMap customParams = new HashMap(4);
                RedConfirmBillHelper.openListPage((AbstractFormPlugin)this, (QFilter)qFilter, (String)"rim_inv_special", (String)"rim_inv_special", customParams, (String)ResManager.loadKDString((String)"\u8fdb\u9879\u53d1\u7968\u6c60", (String)"RedInfoDialogPlugin_2", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            }
            catch (Exception e) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e\u9009\u62e9", (String)"RedInfoDialogPlugin_3", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private QFilter getRimCommonFilter(String applicant) {
        Object org = this.getModel().getValue("org");
        if (org == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ec4\u7ec7", (String)"RedInfoDialogPlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        long orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)this.getModel().getValue("org"));
        SaleInfo saleInfo = TaxUtils.getSaleInfoByOrg((Long)orgId);
        QFilter qFilter = new QFilter("type", "=", (Object)"0").and("invoice_status", "=", (Object)"0").and("buyer_tax_no", "=", (Object)saleInfo.getSaleTaxNo()).and("org", "=", (Object)orgId);
        if (RedInfoConstant.ApplicantEnum.BUYERDEDUCTED.getCode().equals(applicant)) {
            qFilter.and("authenticate_flag", "in", (Object)new String[]{"2", "3"});
        } else {
            qFilter.and("authenticate_flag", "in", (Object)new String[]{"0", "1", "4"});
        }
        return qFilter;
    }

    private void editRedInfo() {
        DynamicObject obj;
        QFilter qFilter;
        Object org = this.getModel().getValue("org");
        if (org == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a", (String)"RedInfoDialogPlugin_4", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        long orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)org);
        PermissionHelper.checkPermission((String)"sim", (String)"sim_red_info", (long)orgId, (ImcPermItemEnum)ImcPermItemEnum.ITEM_NEW);
        TaxUtils.getSaleInfoByOrg((Long)orgId);
        String applicant = (String)this.getModel().getValue("applicant");
        String originalInvoiceCode = (String)this.getModel().getValue("originalinvoicecode");
        String originalInvoiceNo = (String)this.getModel().getValue("originalinvoiceno");
        String infoType = (String)this.getModel().getValue("infotype");
        if (StringUtils.isBlank((CharSequence)infoType)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4fe1\u606f\u8868\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (String)"RedInfoDialogPlugin_5", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        if (!RedInfoConstant.ApplicantEnum.BUYERDEDUCTED.getCode().equals(applicant)) {
            this.checkRedInvoice();
            Date originalIssueTime = (Date)this.getModel().getValue("originalissuetime");
            if (originalIssueTime == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u84dd\u7968\u5f00\u7968\u65e5\u671f", (String)"RedInfoDialogPlugin_6", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            }
            if (originalIssueTime.after(new Date())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u84dd\u7968\u5f00\u7968\u65e5\u671f\u4e0d\u80fd\u8d85\u8fc7\u4eca\u5929", (String)"RedInfoDialogPlugin_7", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            }
        }
        if (RedInfoConstant.ApplicantEnum.SALER.getCode().equals(applicant)) {
            qFilter = InvoiceQFilterUtil.getInvoiceByCodeAndNo((String)originalInvoiceCode, (String)originalInvoiceNo).and("invoicetype", "in", (Object)InvoiceUtils.getSpecialInvoiceType()).and("orgid", "=", (Object)orgId);
            obj = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)String.join((CharSequence)",", "id", "remainredamount", "canredtaxamount", "issuetime", "buyertype", "billno", "systemsource", "specialtype"), (QFilter[])qFilter.toArray());
        } else {
            if (StringUtils.isNotBlank((CharSequence)originalInvoiceNo) && StringUtils.isBlank((CharSequence)originalInvoiceCode)) {
                this.getModel().setValue("originalinvoiceno", null);
            }
            if (StringUtils.isNotBlank((CharSequence)originalInvoiceCode)) {
                qFilter = this.getRimCommonFilter(applicant).and("invoice_code", "=", (Object)originalInvoiceCode).and("invoice_no", "=", (Object)originalInvoiceNo);
                obj = BusinessDataServiceHelper.loadSingle((String)"rim_inv_special", (String)"id", (QFilter[])qFilter.toArray());
            } else {
                obj = null;
            }
        }
        HashMap map = Maps.newHashMapWithExpectedSize((int)6);
        map.put("applicant", this.getModel().getValue("applicant"));
        map.put("originalinvoicecode", this.getModel().getValue("originalinvoicecode"));
        map.put("originalinvoiceno", this.getModel().getValue("originalinvoiceno"));
        map.put("originalissuetime", this.getModel().getValue("originalissuetime"));
        map.put("org", orgId);
        map.put("infotype", "0");
        map.put("pageId", this.getView().getPageId());
        if (obj != null) {
            map.put("id", obj.get("id"));
            if (RedInfoConstant.ApplicantEnum.SALER.getCode().equals(applicant)) {
                Date originalIssueTime;
                String issueTime;
                if (!"9".equals(obj.getString("buyertype"))) {
                    BigDecimal remainRedAmount = obj.getBigDecimal("remainredamount");
                    if (remainRedAmount.compareTo(BigDecimal.ZERO) <= 0) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u5df2\u8fbe\u5230\u6700\u5927\u53ef\u7ea2\u51b2\u91d1\u989d", (String)"RedInfoDialogPlugin_8", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                    }
                    BigDecimal canRedTaxAmount = obj.getBigDecimal("canredtaxamount");
                    if (canRedTaxAmount.compareTo(BigDecimal.ZERO) <= 0) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u5df2\u8fbe\u5230\u6700\u5927\u53ef\u7ea2\u51b2\u7a0e\u989d", (String)"RedInfoDialogPlugin_9", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                    }
                }
                if (!(issueTime = DateUtils.format((Date)obj.getDate("issuetime"))).equals(DateUtils.format((Date)(originalIssueTime = (Date)this.getModel().getValue("originalissuetime"))))) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u84dd\u7968\u5f00\u7968\u65e5\u671f\u9519\u8bef\uff0c\u6b63\u786e\u65e5\u671f\u5e94\u4e3a%s", (String)"RedInfoDialogPlugin_13", (String)"imc-sim-formplugin", (Object[])new Object[0]), issueTime));
                }
                if ("4".equals(obj.get("buyertype"))) {
                    map.put("billno", obj.get("billno"));
                }
                map.put("systemsource", obj.get("systemsource"));
                String specialType = obj.getString("specialtype");
                if ("18".equals(specialType) && "0".equals(infoType)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u673a\u52a8\u8f66\u53d1\u7968\u7684\u4fe1\u606f\u8868\u7c7b\u578b\u6709\u8bef\uff0c\u8bf7\u4fee\u6539\u3002", (String)"RedInfoDialogPlugin_11", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                }
                if (!"18".equals(specialType) && ("2".equals(infoType) || "3".equals(infoType))) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u975e\u7279\u6b8a\u7968\u79cd\u53d1\u7968\u7684\u4fe1\u606f\u8868\u7c7b\u578b\u8bf7\u9009\u62e9\u975e\u7279\u6b8a\u7968\u79cd\uff0c\u8bf7\u4fee\u6539\u3002", (String)"RedInfoDialogPlugin_12", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                }
                map.put("infotype", infoType);
            }
        }
        this.getView().returnDataToParent((Object)map);
        this.getView().close();
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        SimCallBackHelper.callBack((AbstractFormPlugin)this, (Object)closedCallBackEvent);
    }
}

