/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.report;

import java.util.Date;
import java.util.HashSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.bdm.common.constant.InvoiceStatus;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.util.DateUtils;

public abstract class AbstractReportDataPlugin
extends AbstractReportListDataPlugin {
    public static final String KEY_SEARCH_CRITERIA_START_DATE = "startdate";
    public static final String KEY_SEARCH_CRITERIA_END_DATE = "enddate";
    protected static final String KEY_SEARCH_CRITERIA_ORG = "org";
    protected static final String KEY_SEARCH_CRITERIA_INVOICE_KIND = "invoicekind";
    protected static final String KEY_SEARCH_CRITERIA_ISSUE_DEVICE = "issuedevice";
    protected static final String KEY_SEARCH_CRITERIA_INVOICE_NATURE = "invoicenature";
    protected HashSet<Object> orgIdsSet = null;
    protected String KEY_SEARCH_CRITERIA_ORG_NAME = "org_name";
    protected String KEY_SEARCH_CRITERIA_GOODS = "goods";
    protected String KEY_SEARCH_CRITERIA_GOODS_CODE = "goodscode";
    protected String KEY_SEARCH_CRITERIA_BUYER_NAME = "buyer_name";
    protected String KEY_SEARCH_CRITERIA_BUYER_TAX_NO = "buyer_taxno";
    protected String KEY_SEARCH_CRITERIA_SELLER_TAX_NO = "seller_taxno";
    protected String KEY_SEARCH_CRITERIA_SELLER_NAME = "seller_name";

    protected QFilter initTimePeriodFilter(FilterInfo filterInfo) {
        Date startDate = filterInfo.getDate(KEY_SEARCH_CRITERIA_START_DATE);
        Date endDate = filterInfo.getDate(KEY_SEARCH_CRITERIA_END_DATE);
        return this.getDateFilter(startDate, endDate);
    }

    private QFilter getDateFilter(Date startDate, Date endDate) {
        if (null == startDate || null == endDate) {
            Date now = new Date();
            startDate = DateUtils.getFirstDateOfMonth((Date)now);
            endDate = DateUtils.getDayEnd((Date)now);
        } else {
            endDate = DateUtils.getDayEnd((Date)endDate);
        }
        QFilter startFilter = new QFilter("issuetime", ">=", (Object)startDate);
        QFilter endFilter = new QFilter("issuetime", "<", (Object)endDate);
        return startFilter.and(endFilter);
    }

    protected QFilter initOrgFilter(FilterInfo filterInfo) {
        DynamicObjectCollection collection = filterInfo.getDynamicObjectCollection(KEY_SEARCH_CRITERIA_ORG);
        String orgName = filterInfo.getString(this.KEY_SEARCH_CRITERIA_ORG_NAME);
        return this.getOrgFilter(collection, orgName);
    }

    public QFilter getOrgFilter(DynamicObjectCollection collection, String orgName) {
        int size;
        if (null == collection || (size = collection.size()) == 0) {
            if (StringUtils.isNotBlank((CharSequence)orgName)) {
                return null;
            }
            this.orgIdsSet = new HashSet();
            Long orgId = RequestContext.get().getOrgId();
            this.orgIdsSet.add(orgId);
            return new QFilter("orgid", "=", (Object)orgId);
        }
        this.orgIdsSet = new HashSet();
        Object[] ids = new Object[size];
        for (int i = 0; i < collection.size(); ++i) {
            Object id = ((DynamicObject)collection.get(i)).get("id");
            this.orgIdsSet.add(id);
            ids[i] = id;
        }
        return new QFilter("orgid", "in", (Object)ids);
    }

    protected QFilter initInvoiceKindFilter(FilterInfo filterInfo) {
        String invoiceKind = filterInfo.getString(KEY_SEARCH_CRITERIA_INVOICE_KIND);
        if (StringUtils.isNotBlank((CharSequence)invoiceKind)) {
            return new QFilter("invoicetype", "=", (Object)invoiceKind);
        }
        return null;
    }

    protected QFilter initIssueDeviceFilter(FilterInfo filterInfo) {
        String issueDevice = filterInfo.getString(KEY_SEARCH_CRITERIA_ISSUE_DEVICE);
        if (StringUtils.isNotBlank((CharSequence)issueDevice)) {
            if (issueDevice.startsWith(",")) {
                issueDevice = issueDevice.substring(1, issueDevice.length());
            }
            if (issueDevice.endsWith(",")) {
                issueDevice = issueDevice.substring(0, issueDevice.length() - 1);
            }
            String[] array = issueDevice.split(",");
            return new QFilter("jqbh", "in", (Object)array);
        }
        return null;
    }

    protected QFilter initInvoiceNatureFilter(FilterInfo filterInfo) {
        String invoiceNature = filterInfo.getString(KEY_SEARCH_CRITERIA_INVOICE_NATURE);
        if (StringUtils.isNotBlank((CharSequence)invoiceNature)) {
            return new QFilter("invoicestatus", "=", (Object)invoiceNature);
        }
        return this.initExcludeCancelInvoiceFilter();
    }

    protected QFilter initExcludeCancelInvoiceFilter() {
        return new QFilter("invoicestatus", "in", (Object)InvoiceStatus.NotInvalidArray).and("issuestatus", "=", (Object)IssueStatusEnum.ok.getCode());
    }

    protected QFilter initBlueOrRedFilter(FilterInfo filterInfo) {
        String issueType = filterInfo.getString(KEY_SEARCH_CRITERIA_INVOICE_NATURE);
        if (StringUtils.isNotBlank((CharSequence)issueType)) {
            return new QFilter("issuetype", "=", (Object)issueType);
        }
        return null;
    }

    protected QFilter initGoodsNameFilter(FilterInfo filterInfo) {
        String goodsName = filterInfo.getString(this.KEY_SEARCH_CRITERIA_GOODS);
        if (StringUtils.isNotBlank((CharSequence)goodsName)) {
            return new QFilter("items.goodsname", "like", (Object)("%" + goodsName + "%"));
        }
        return null;
    }

    protected QFilter initGoodsCodeFilter(FilterInfo filterInfo) {
        String goodsCode = filterInfo.getString(this.KEY_SEARCH_CRITERIA_GOODS_CODE);
        if (StringUtils.isNotBlank((CharSequence)goodsCode)) {
            return new QFilter("items.goodsname", "like", (Object)("%" + goodsCode + "%"));
        }
        return null;
    }

    protected QFilter initOrgNameFilter(FilterInfo filterInfo) {
        String orgName = filterInfo.getString(this.KEY_SEARCH_CRITERIA_ORG_NAME);
        return this.getOrgNameFilter(orgName);
    }

    private QFilter getOrgNameFilter(String orgName) {
        if (StringUtils.isNotBlank((CharSequence)orgName)) {
            HashSet<Object> setCommon = new HashSet<Object>();
            QFilter nameFilter = new QFilter("name", "like", (Object)("%" + orgName + "%"));
            DynamicObject[] objs = BusinessDataServiceHelper.load((String)"bdm_org", (String)"id", (QFilter[])nameFilter.toArray());
            if (null == objs || 0 == objs.length) {
                return null;
            }
            Object[] ids = new Object[objs.length];
            for (int i = 0; i < objs.length; ++i) {
                ids[i] = objs[i].get("id");
            }
            for (Object id : ids) {
                if (null == this.orgIdsSet) {
                    setCommon.add(id);
                    continue;
                }
                if (!this.orgIdsSet.contains(id)) continue;
                setCommon.add(id);
            }
            this.orgIdsSet = setCommon;
            return new QFilter("orgid", "in", (Object)ids);
        }
        return null;
    }

    protected QFilter initBuyerNameFilter(FilterInfo filterInfo) {
        String buyerName = filterInfo.getString(this.KEY_SEARCH_CRITERIA_BUYER_NAME);
        if (StringUtils.isNotBlank((CharSequence)buyerName)) {
            return new QFilter("buyername", "like", (Object)("%" + buyerName + "%"));
        }
        return null;
    }

    protected QFilter initBuyerTaxNoFilter(FilterInfo filterInfo) {
        String buyerTaxNoFilter = filterInfo.getString(this.KEY_SEARCH_CRITERIA_BUYER_TAX_NO);
        if (StringUtils.isNotBlank((CharSequence)buyerTaxNoFilter)) {
            return new QFilter("buyertaxno", "like", (Object)("%" + buyerTaxNoFilter + "%"));
        }
        return null;
    }

    protected QFilter initSellerNameFilter(FilterInfo filterInfo) {
        String sellerName = filterInfo.getString(this.KEY_SEARCH_CRITERIA_SELLER_NAME);
        if (StringUtils.isNotBlank((CharSequence)sellerName)) {
            return new QFilter("salername", "like", (Object)("%" + sellerName + "%"));
        }
        return null;
    }

    protected QFilter initSellerTaxNoFilter(FilterInfo filterInfo) {
        String sellerTaxNoFilter = filterInfo.getString(this.KEY_SEARCH_CRITERIA_SELLER_TAX_NO);
        if (StringUtils.isNotBlank((CharSequence)sellerTaxNoFilter)) {
            return new QFilter("salertaxno", "like", (Object)("%" + sellerTaxNoFilter + "%"));
        }
        return null;
    }

    public HashSet<String> queryEnterpriseName(FilterInfo filterInfo) {
        String orgName = filterInfo.getString(this.KEY_SEARCH_CRITERIA_ORG_NAME);
        QFilter filter = null;
        if (StringUtils.isNotBlank((CharSequence)orgName)) {
            filter = new QFilter("name", "like", (Object)("%" + orgName + "%"));
            return this.initSet(filter);
        }
        String sellerName = filterInfo.getString(this.KEY_SEARCH_CRITERIA_SELLER_NAME);
        if (StringUtils.isNotBlank((CharSequence)sellerName)) {
            QFilter epNameFilter = new QFilter("epinfo.name", "like", (Object)("%" + sellerName + "%"));
            return this.initSet(epNameFilter);
        }
        String sellerTaxNo = filterInfo.getString(this.KEY_SEARCH_CRITERIA_SELLER_TAX_NO);
        if (StringUtils.isNotBlank((CharSequence)sellerTaxNo)) {
            QFilter taxNoFilter = new QFilter("epinfo.number", "like", (Object)("%" + sellerName + "%"));
            return this.initSet(taxNoFilter);
        }
        DynamicObjectCollection collection = filterInfo.getDynamicObjectCollection(KEY_SEARCH_CRITERIA_ORG);
        if (null != collection && collection.size() > 0) {
            Object[] orgIds = new Object[collection.size()];
            for (int i = 0; i < collection.size(); ++i) {
                Object id;
                orgIds[i] = id = ((DynamicObject)collection.get(i)).get("id");
            }
            QFilter orgIdsFilter = new QFilter("id", "in", (Object)orgIds);
            return this.initSet(orgIdsFilter);
        }
        Long orgId = RequestContext.get().getOrgId();
        QFilter orgIdFilter = new QFilter("id", "=", (Object)orgId);
        return this.initSet(orgIdFilter);
    }

    private HashSet<String> initSet(QFilter filter) {
        HashSet<String> nameSet = new HashSet<String>();
        DynamicObjectCollection orgs = QueryServiceHelper.query((String)"bdm_org", (String)"epinfo.name", (QFilter[])filter.toArray());
        for (DynamicObject org : orgs) {
            String epinfoName = org.getString("epinfo.name");
            if (StringUtils.isBlank((CharSequence)epinfoName)) continue;
            nameSet.add(epinfoName);
        }
        return nameSet;
    }
}

