/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.report;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.EquipmentUtil;

public abstract class AbstractReportPlugin
extends AbstractReportFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(AbstractReportPlugin.class);
    private static final String ISSUE_DEVICE = "issuedevice";
    private static final String ORG = "org";
    public static String[] invoiceTypeArray = new String[]{"026", "028", "004", "007", "025", "006", "005", "08xdp", "10xdp"};

    protected void initDeviceList() {
        long orgId = RequestContext.get().getOrgId();
        QFilter orgFilter = new QFilter("id", "=", (Object)orgId);
        this.filterAndSetComboItem(orgFilter);
    }

    private void filterAndSetComboItem(QFilter orgFilter) {
        DynamicObject[] array = BusinessDataServiceHelper.load((String)"bdm_org", (String)"devlist_tag", (QFilter[])orgFilter.toArray());
        ComboEdit comboEdit = (ComboEdit)this.getControl(ISSUE_DEVICE);
        if (null == comboEdit) {
            return;
        }
        if (array.length == 0) {
            ArrayList items2 = new ArrayList();
            comboEdit.setComboItems(items2);
            return;
        }
        HashSet devNoSet = new HashSet();
        for (DynamicObject object : array) {
            DynamicObject[] devList = object.getString("devlist_tag");
            if (StringUtils.isBlank((CharSequence)devList)) continue;
            if (devList.startsWith(",")) {
                devList = devList.substring(1, devList.length() - 1);
            }
            if (devList.endsWith(",")) {
                devList = devList.substring(0, devList.length() - 2);
            }
            String[] split = devList.split(",");
            Collections.addAll(devNoSet, split);
        }
        if (devNoSet.size() == 0) {
            return;
        }
        LOGGER.error(String.format("\u8bbe\u5907\u5217\u8868:%s", devNoSet));
        long[] devIds = devNoSet.stream().mapToLong(Long::parseLong).toArray();
        QFilter equipmentNoFilter = new QFilter("id", "in", (Object)devIds);
        DynamicObject[] equips = BusinessDataServiceHelper.load((String)"bdm_tax_equipment", (String)"equipmentname,equipmentno", (QFilter[])equipmentNoFilter.toArray());
        HashMap<String, String> map = new HashMap<String, String>();
        for (DynamicObject equipment : equips) {
            String name = equipment.getString("equipmentname");
            String deviceNo = equipment.getString("equipmentno");
            map.put(deviceNo, name);
        }
        ArrayList items3 = Lists.newArrayListWithCapacity((int)array.length);
        for (Map.Entry entry : map.entrySet()) {
            items3.add(new ComboItem(new LocaleString((String)entry.getValue()), (String)entry.getKey()));
        }
        comboEdit.setComboItems((List)items3);
        DynamicObject defaultDev = EquipmentUtil.getDefaultDev((Long)RequestContext.get().getOrgId());
        if (defaultDev != null) {
            this.getView().getControl(ISSUE_DEVICE).getModel().setValue(ISSUE_DEVICE, (Object)defaultDev.getString("equipmentno"));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().toString();
        if (ORG.equals(propertyName)) {
            ChangeData[] set = e.getChangeSet();
            HashSet<Object> idSet = new HashSet<Object>();
            for (ChangeData changeData : set) {
                DynamicObjectCollection collection = (DynamicObjectCollection)changeData.getNewValue();
                if (collection.size() <= 0) continue;
                for (int i = 0; i < collection.size(); ++i) {
                    idSet.add(((DynamicObject)((DynamicObject)collection.get(i)).get("fbasedataid")).getPkValue());
                }
            }
            if (idSet.size() > 0) {
                Object[] idSetArr = idSet.toArray();
                QFilter idsFilter = new QFilter("id", "in", (Object)idSetArr);
                this.filterAndSetComboItem(idsFilter);
                if (this.getPluginName().contains("SimGoldenTaxReportFormPlugin")) {
                    this.initSellTaxNoAndNameFilter(Long.parseLong(idSetArr[0].toString()));
                }
            }
        }
    }

    protected boolean timeVerify(ReportQueryParam queryParam) {
        FilterInfo filter = queryParam.getFilter();
        Date startDate = filter.getDate("startdate");
        Date endDate = filter.getDate("enddate");
        if (null == startDate && null == endDate) {
            return true;
        }
        if (null == startDate || null == endDate) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u65f6\u95f4\u6bb5\u9700\u540c\u65f6\u9009\u62e9\u6216\u5219\u540c\u65f6\u4e0d\u9009", (String)"AbstractReportPlugin_1", (String)"imc-sim-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return false;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(endDate);
        calendar.add(1, -1);
        Date oneYearAgo = calendar.getTime();
        if (oneYearAgo.after(startDate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u65f6\u95f4\u6bb5\u4e0d\u80fd\u8d85\u8fc7\u4e00\u5e74", (String)"AbstractReportPlugin_2", (String)"imc-sim-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return false;
        }
        if (startDate.after(endDate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u9700\u5c0f\u4e8e\u7ed3\u675f\u65e5\u671f", (String)"AbstractReportPlugin_3", (String)"imc-sim-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return false;
        }
        if (startDate.after(new Date())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u9700\u5c0f\u4e8e\u5f53\u524d\u65f6\u95f4", (String)"AbstractReportPlugin_4", (String)"imc-sim-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return false;
        }
        return true;
    }

    protected void initSellTaxNoAndNameFilter(long orgid) {
        if (orgid == 0L) {
            orgid = RequestContext.get().getOrgId();
        }
        DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)orgid, (String)"bdm_org");
        this.getModel().setValue("seller_taxno", (Object)object.getString("epinfo.number"));
        this.getModel().setValue("seller_name", (Object)object.getString("epinfo.name"));
    }

    protected void initStartDayFilter() {
        Date firstDateOfMonth = DateUtils.getFirstDateOfMonth((Date)new Date());
        this.getModel().setValue("startdate", (Object)firstDateOfMonth);
    }

    protected void initEndDayFilter() {
        this.getModel().setValue("enddate", (Object)new Date());
    }

    protected void initBaseOrgParamFilter() {
        QFilter idFilter = new QFilter("id", "=", (Object)RequestContext.get().getOrgId());
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"bos_org", (String)"id,name", (QFilter[])idFilter.toArray());
        if (null != load && load.length > 0) {
            this.getModel().setValue(ORG, (Object)new Object[]{load[0].getPkValue()});
        }
    }

    protected void repairOrgData() {
        String fields = "id,parentid,basename,parent,name,level,isleaf,status,enable";
        QFilter levelFilter = new QFilter("level", "=", (Object)0L).or(new QFilter("status", "!=", (Object)"C"));
        DynamicObject[] ids = BusinessDataServiceHelper.load((String)"bdm_org_tree_list", (String)fields, (QFilter[])levelFilter.toArray());
        if (null != ids && ids.length > 0) {
            for (DynamicObject org : ids) {
                DynamicObject orgParent = BusinessDataServiceHelper.newDynamicObject((String)"bdm_org_tree_list");
                String parentId = org.getString("parentid");
                if (StringUtils.isEmpty((CharSequence)parentId)) {
                    parentId = "-1";
                }
                orgParent.set("id", (Object)Long.parseLong(parentId));
                org.set("parent", (Object)orgParent);
                org.set("name", (Object)org.getString("basename"));
                org.set("level", (Object)1);
                org.set("isleaf", (Object)0);
                org.set("status", (Object)"C");
                org.set("enable", (Object)"1");
            }
        }
        SaveServiceHelper.save((DynamicObject[])ids);
    }

    protected QFilter getOrgNameFilter(String orgName) {
        QFilter nameFilter = new QFilter("name", "=", (Object)orgName);
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)"bdm_org", (String)"id", (QFilter[])nameFilter.toArray());
        if (null == objs || 0 == objs.length) {
            return null;
        }
        Object[] ids = new Object[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            ids[i] = objs[i].get("id");
        }
        return new QFilter("orgid", "in", (Object)ids);
    }

    protected QFilter getDateFilter(Date startDate, Date endDate) {
        if (null == startDate || null == endDate) {
            Date now = new Date();
            startDate = DateUtils.getFirstDateOfMonth((Date)now);
            endDate = DateUtils.getDayEnd((Date)now);
        } else {
            endDate = DateUtils.getDayEnd((Date)endDate);
        }
        QFilter startFilter = new QFilter("issuetime", ">=", (Object)startDate);
        QFilter endFilter = new QFilter("issuetime", "<", (Object)endDate);
        return startFilter.and(endFilter);
    }
}

