/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.report.plugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.bdm.common.constant.TaxRate;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.util.DBUtils;
import kd.imc.sim.formplugin.report.AbstractReportDataPlugin;

public class SimTaxRateReportDataPlugin
extends AbstractReportDataPlugin {
    private static final Log LOGGER = LogFactory.getLog(SimTaxRateReportDataPlugin.class);
    private static final String[] taxRateArray = new String[]{"0.17", "0.16", "0.13", "0.11", "0.10", "0.09", "0.05", "0.06", "0.04", "0.03", "0.015", "0.01", "0"};
    private static final String[] moneyType = new String[]{"amount", "tax", "taxamount"};

    public DataSet query(ReportQueryParam param, Object o) {
        try {
            QFilter baseFilter = this.initFilters(param);
            HashSet<String> enterpriseNames = this.queryEnterpriseName(param.getFilter());
            String fields = DBUtils.getQueryFields((String[])new String[]{"salername", "invoicetype", "salertaxno", "orgid", "totalamount", "totaltax", "items.taxrate,items.amount,items.tax,items.taxamount"});
            DataSet set = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"sim_vatinvoice", (String)fields, (QFilter[])baseFilter.toArray(), null);
            TaxRate[] taxRates = new TaxRate[]{TaxRate.SEVENTEEN_PERCENT, TaxRate.SIXTEEN_PERCENT, TaxRate.THIRTEEN_PERCENT, TaxRate.ELEVEN_PERCENT, TaxRate.TEN_PERCENT, TaxRate.NINE_PERCENT, TaxRate.FIVE_PERCENT, TaxRate.FOUR_PERCENT, TaxRate.SIX_PERCENT, TaxRate.THREE_PERCENT, TaxRate.ONE_POINT_FIVE_PERCENT, TaxRate.ONE_PERCENT, TaxRate.ZERO_PERCENT};
            this.addOrgHistoryEpName(param, enterpriseNames, set);
            DataSet result = null;
            if (enterpriseNames.isEmpty()) {
                QFilter filter = new QFilter("orgid", "=", (Object)-12344261L);
                return set.filter(filter.toString());
            }
            for (String eName : enterpriseNames) {
                for (String s : moneyType) {
                    DataSet eSet = this.getDetailDataSet(set, taxRates, eName, s);
                    DataSet smallSet = this.getTotalDetailDataSet(eSet);
                    result = this.combineSet(result, eSet, smallSet);
                }
            }
            if (null != result) {
                return result.orderBy(new String[]{"salername", "invoicetype", "sim_taxrate_bill_item.countdimension"});
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private void addOrgHistoryEpName(ReportQueryParam param, HashSet<String> enterpriseNames, DataSet set) {
        FilterInfo filterInfo = param.getFilter();
        String likeSellerName = filterInfo.getString(this.KEY_SEARCH_CRITERIA_SELLER_NAME);
        HashSet<String> epNameSet = new HashSet<String>();
        DataSet sellerNameSet = set.copy().select(new String[]{"salername"}).distinct();
        for (Row row : sellerNameSet) {
            String sellerName = row.getString("salername");
            if ("null".equalsIgnoreCase(sellerName) || !StringUtils.isNotBlank((CharSequence)sellerName)) continue;
            if (StringUtils.isNotBlank((CharSequence)likeSellerName)) {
                if (!sellerName.contains(likeSellerName)) continue;
                epNameSet.add(sellerName);
                continue;
            }
            epNameSet.add(sellerName);
        }
        enterpriseNames.addAll(epNameSet);
    }

    private DataSet combineSet(DataSet result, DataSet eSet, DataSet smallSet) {
        DataSet smallCombine = eSet.union(smallSet);
        result = null == result ? smallCombine : result.union(smallCombine);
        return result;
    }

    private DataSet getTotalDetailDataSet(DataSet eSet) {
        DataSet smallCountSet = eSet.copy().groupBy(new String[]{"salername", "sim_taxrate_bill_item.countdimension"}).sum("sim_taxrate_bill_item.total").sum("sim_taxrate_bill_item.seventeenpercent").sum("sim_taxrate_bill_item.sixteenpercent").sum("sim_taxrate_bill_item.thirteenpercent").sum("sim_taxrate_bill_item.elevenpercent").sum("sim_taxrate_bill_item.tenpercent").sum("sim_taxrate_bill_item.ninepercent").sum("sim_taxrate_bill_item.sixpercent").sum("sim_taxrate_bill_item.fivepercent").sum("sim_taxrate_bill_item.fourpercent").sum("sim_taxrate_bill_item.threepercent").sum("sim_taxrate_bill_item.onepointfivepercent").sum("sim_taxrate_bill_item.onepercent").sum("sim_taxrate_bill_item.zeropercent").sum("sim_taxrate_bill_item.otherpercent").finish();
        return smallCountSet.select(new String[]{"salername", "'' as salertaxno", "'\u5c0f\u8ba1' as invoicetype", "sim_taxrate_bill_item.countdimension", "sim_taxrate_bill_item.total", "sim_taxrate_bill_item.seventeenpercent", "sim_taxrate_bill_item.sixteenpercent", "sim_taxrate_bill_item.thirteenpercent", "sim_taxrate_bill_item.elevenpercent", "sim_taxrate_bill_item.tenpercent", "sim_taxrate_bill_item.ninepercent", "sim_taxrate_bill_item.sixpercent", "sim_taxrate_bill_item.fivepercent", "sim_taxrate_bill_item.fourpercent", "sim_taxrate_bill_item.threepercent", "sim_taxrate_bill_item.onepointfivepercent", "sim_taxrate_bill_item.onepercent", "sim_taxrate_bill_item.zeropercent", "sim_taxrate_bill_item.otherpercent"});
    }

    private DataSet getDetailDataSet(DataSet set, TaxRate[] taxRates, String eName, String s) {
        DataSet eSet = null;
        for (TaxRate taxRate : taxRates) {
            DataSet dataSet = this.queryOneEnterpriseOneKindRate(taxRate, s, set.copy(), eName);
            eSet = null == eSet ? dataSet.copy() : eSet.union(dataSet.copy());
        }
        if (null != eSet) {
            DataSet moneyOtherSet = this.queryOneEnterpriseOtherKindRate(s, set.copy(), eName);
            eSet = eSet.union(moneyOtherSet);
            eSet = eSet.groupBy(new String[]{"salername", "salertaxno", "invoicetype", "sim_taxrate_bill_item.countdimension"}).sum("sim_taxrate_bill_item.total").sum("sim_taxrate_bill_item.seventeenpercent").sum("sim_taxrate_bill_item.sixteenpercent").sum("sim_taxrate_bill_item.thirteenpercent").sum("sim_taxrate_bill_item.elevenpercent").sum("sim_taxrate_bill_item.tenpercent").sum("sim_taxrate_bill_item.ninepercent").sum("sim_taxrate_bill_item.sixpercent").sum("sim_taxrate_bill_item.fivepercent").sum("sim_taxrate_bill_item.fourpercent").sum("sim_taxrate_bill_item.threepercent").sum("sim_taxrate_bill_item.onepointfivepercent").sum("sim_taxrate_bill_item.onepercent").sum("sim_taxrate_bill_item.zeropercent").sum("sim_taxrate_bill_item.otherpercent").finish();
        }
        return eSet;
    }

    private DataSet queryOneEnterpriseOtherKindRate(String moneyType, DataSet copy, String eName) {
        String rateFilter = new QFilter("items.taxrate", "not in", (Object)taxRateArray).toString();
        String eNameFilter = new QFilter("salername", "=", (Object)eName).toString();
        DataSet oneEnterpriseOneRateSet = copy.filter(rateFilter).filter(eNameFilter);
        DataSet sumSet = oneEnterpriseOneRateSet.groupBy(new String[]{"salername", "invoicetype", "salertaxno"}).sum("items.amount").sum("items.tax").sum("items.taxamount").finish();
        String[] array = this.queryOtherStringArray(moneyType);
        DataSet otherSet = sumSet.select(array);
        return otherSet;
    }

    private String[] queryOtherStringArray(String moneyType) {
        if ("amount".equals(moneyType)) {
            return new String[]{"0 as sim_taxrate_bill_item.seventeenpercent", "0 as sim_taxrate_bill_item.sixteenpercent", "0 as sim_taxrate_bill_item.thirteenpercent", "0 as sim_taxrate_bill_item.elevenpercent", "0 as sim_taxrate_bill_item.tenpercent", "0 as sim_taxrate_bill_item.ninepercent", "0 as sim_taxrate_bill_item.sixpercent", "0 as sim_taxrate_bill_item.fivepercent", "0 as sim_taxrate_bill_item.fourpercent", "0 as sim_taxrate_bill_item.threepercent", "0 as sim_taxrate_bill_item.onepointfivepercent", "0 as sim_taxrate_bill_item.onepercent", "0 as sim_taxrate_bill_item.zeropercent", "items.amount as sim_taxrate_bill_item.otherpercent", "items.amount as sim_taxrate_bill_item.total", "'amount' as sim_taxrate_bill_item.countdimension", "salername", "salertaxno", "invoicetype"};
        }
        if ("taxamount".equals(moneyType)) {
            return new String[]{"0 as sim_taxrate_bill_item.seventeenpercent", "0 as sim_taxrate_bill_item.sixteenpercent", "0 as sim_taxrate_bill_item.thirteenpercent", "0 as sim_taxrate_bill_item.elevenpercent", "0 as sim_taxrate_bill_item.tenpercent", "0 as sim_taxrate_bill_item.ninepercent", "0 as sim_taxrate_bill_item.sixpercent", "0 as sim_taxrate_bill_item.fivepercent", "0 as sim_taxrate_bill_item.fourpercent", "0 as sim_taxrate_bill_item.threepercent", "0 as sim_taxrate_bill_item.onepointfivepercent", "0 as sim_taxrate_bill_item.onepercent", "0 as sim_taxrate_bill_item.zeropercent", "items.taxamount as sim_taxrate_bill_item.otherpercent", "items.taxamount as sim_taxrate_bill_item.total", "'taxamount' as sim_taxrate_bill_item.countdimension", "salername", "salertaxno", "invoicetype"};
        }
        return new String[]{"0 as sim_taxrate_bill_item.seventeenpercent", "0 as sim_taxrate_bill_item.sixteenpercent", "0 as sim_taxrate_bill_item.thirteenpercent", "0 as sim_taxrate_bill_item.elevenpercent", "0 as sim_taxrate_bill_item.tenpercent", "0 as sim_taxrate_bill_item.ninepercent", "0 as sim_taxrate_bill_item.sixpercent", "0 as sim_taxrate_bill_item.fivepercent", "0 as sim_taxrate_bill_item.fourpercent", "0 as sim_taxrate_bill_item.threepercent", "0 as sim_taxrate_bill_item.onepointfivepercent", "0 as sim_taxrate_bill_item.onepercent", "0 as sim_taxrate_bill_item.zeropercent", "items.tax as sim_taxrate_bill_item.otherpercent", "items.tax as sim_taxrate_bill_item.total", "'tax' as sim_taxrate_bill_item.countdimension", "salername", "salertaxno", "invoicetype"};
    }

    private DataSet queryOneEnterpriseOneKindRate(TaxRate taxRate, String moneyType, DataSet copy, String eName) {
        String rateFilter = new QFilter("items.taxrate", "=", (Object)taxRate.getRateValue()).toString();
        String eNameFilter = new QFilter("salername", "=", (Object)eName).toString();
        DataSet oneEnterpriseOneRateSet = copy.filter(rateFilter).filter(eNameFilter);
        DataSet sumSet = oneEnterpriseOneRateSet.groupBy(new String[]{"salername", "invoicetype", "salertaxno"}).sum("items.amount").sum("items.tax").sum("items.taxamount").finish();
        String[] array = this.queryStringArray(taxRate, moneyType);
        return sumSet.select(array);
    }

    private String[] queryStringArray(TaxRate taxRate, String moneyType) {
        Set<String> set = this.initParamSet();
        ArrayList<String> list = new ArrayList<String>();
        for (String s : set) {
            if (s.equals(taxRate.getDescription()) && "amount".equals(moneyType)) {
                list.add("items.amount as sim_taxrate_bill_item." + taxRate.getDescription());
                continue;
            }
            if (s.equals(taxRate.getDescription()) && "tax".equals(moneyType)) {
                list.add("items.tax as sim_taxrate_bill_item." + taxRate.getDescription());
                continue;
            }
            if (s.equals(taxRate.getDescription()) && "taxamount".equals(moneyType)) {
                list.add("items.amount+items.tax as sim_taxrate_bill_item." + taxRate.getDescription());
                continue;
            }
            String queryType = "0 as sim_taxrate_bill_item." + s;
            list.add(queryType);
        }
        if ("amount".equals(moneyType)) {
            list.add("items.amount as sim_taxrate_bill_item.total");
            list.add("'amount' as sim_taxrate_bill_item.countdimension");
        }
        if ("tax".equals(moneyType)) {
            list.add("items.tax as sim_taxrate_bill_item.total");
            list.add("'tax' as sim_taxrate_bill_item.countdimension");
        }
        if ("taxamount".equals(moneyType)) {
            list.add("items.amount+items.tax as sim_taxrate_bill_item.total");
            list.add("'taxamount' as sim_taxrate_bill_item.countdimension");
        }
        Collections.addAll(list, "salername", "salertaxno", "invoicetype");
        String[] strings = new String[list.size()];
        return list.toArray(strings);
    }

    public Set<String> initParamSet() {
        HashSet<String> set = new HashSet<String>(20);
        Collections.addAll(set, TaxRate.SEVENTEEN_PERCENT.getDescription(), TaxRate.SIXTEEN_PERCENT.getDescription(), TaxRate.THIRTEEN_PERCENT.getDescription(), TaxRate.ELEVEN_PERCENT.getDescription(), TaxRate.TEN_PERCENT.getDescription(), TaxRate.NINE_PERCENT.getDescription(), TaxRate.SIX_PERCENT.getDescription(), TaxRate.FIVE_PERCENT.getDescription(), TaxRate.FOUR_PERCENT.getDescription(), TaxRate.THREE_PERCENT.getDescription(), TaxRate.ONE_POINT_FIVE_PERCENT.getDescription(), TaxRate.ONE_PERCENT.getDescription(), TaxRate.ZERO_PERCENT.getDescription(), "otherpercent");
        return set;
    }

    private QFilter initFilters(ReportQueryParam param) {
        QFilter sellerTaxNoFilter;
        QFilter sellerNameFilter;
        QFilter orgNameFilter;
        QFilter invoiceKindFilter;
        FilterInfo filterInfo = param.getFilter();
        QFilter resultFilter = this.initTimePeriodFilter(filterInfo);
        QFilter orgFilter = this.initOrgFilter(filterInfo);
        if (null != orgFilter) {
            resultFilter = resultFilter.and(orgFilter);
        }
        if (null != (invoiceKindFilter = this.initInvoiceKindFilter(filterInfo))) {
            resultFilter = resultFilter.and(invoiceKindFilter);
        }
        QFilter filter = this.initExcludeCancelInvoiceFilter();
        resultFilter = resultFilter.and(filter);
        QFilter blueOrRedFilter = this.initBlueOrRedFilter(filterInfo);
        if (null != blueOrRedFilter) {
            resultFilter = resultFilter.and(blueOrRedFilter);
        }
        if (null != (orgNameFilter = this.initOrgNameFilter(filterInfo))) {
            resultFilter = resultFilter.and(orgNameFilter);
        }
        if (null != (sellerNameFilter = this.initSellerNameFilter(filterInfo))) {
            resultFilter = resultFilter.and(sellerNameFilter);
        }
        if (null != (sellerTaxNoFilter = this.initSellerTaxNoFilter(filterInfo))) {
            resultFilter = resultFilter.and(sellerTaxNoFilter);
        }
        QFilter issuedFilter = new QFilter("issuestatus", "=", (Object)IssueStatusEnum.ok.getCode());
        resultFilter = resultFilter.and(issuedFilter);
        return resultFilter;
    }
}

