/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.vehicle;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.ImcPermItemEnum;
import kd.imc.bdm.common.helper.PermissionHelper;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.sim.common.service.IssueInvoiceService;
import kd.imc.sim.formplugin.vehicle.control.VehicleInvoiceBatchRedController;

public class VehicleInvoiceBatchRedPlugin
extends AbstractListPlugin {
    private static Log LOGGER = LogFactory.getLog(VehicleInvoiceBatchRedPlugin.class);
    private String str = ResManager.loadKDString((String)"\u603b\u8ba1\uff1a \u5f00\u7968\u4efd\u6570%1$s\u4efd\uff0c\u5408\u8ba1\u7a0e\u989d%2$s\u5143\uff0c\u4ef7\u7a0e\u5408\u8ba1%3$s\u5143", (String)"VehicleInvoiceBatchRedPlugin_3", (String)"imc-sim-formplugin", (Object[])new Object[0]);

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject[] invoices;
        BillList billList = (BillList)this.getView().getControl("billlistap");
        List ids = (List)this.getView().getFormShowParameter().getCustomParam("keys");
        QFilter qFilter = new QFilter("id", "in", (Object)ids);
        FilterParameter fp = new FilterParameter();
        fp.setFilter(qFilter);
        billList.setFilterParameter(fp);
        billList.refreshData();
        BigDecimal totalTax = BigDecimal.ZERO;
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (DynamicObject invoice : invoices = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_vatinvoice_vehicles"))) {
            totalTax = totalTax.add(invoice.getBigDecimal("totaltax"));
            totalAmount = totalAmount.add(invoice.getBigDecimal("totalamount"));
        }
        Label titleLabel = (Label)this.getView().getControl("allaccount");
        titleLabel.setText(String.format(this.str, invoices.length, totalTax.setScale(2, 0), totalAmount.setScale(2, 0)));
    }

    public void beforeBindData(EventObject e) {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        billList.selectAllRows();
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        if (source.getKey().equals("btnok")) {
            this.confirmRed();
            this.getView().close();
        }
    }

    private void confirmRed() {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection rows = billList.getSelectedRows();
        DynamicObject[] vehicles = BusinessDataServiceHelper.load((Object[])rows.getPrimaryKeyValues(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_vatinvoice_vehicles"));
        PermissionHelper.checkPermission((String)"sim", (String)"sim_vatinvoice_vehicles", (long)DynamicObjectUtil.getDynamicObjectLongValue((Object)vehicles[0].get("orgid")), (ImcPermItemEnum)ImcPermItemEnum.SIM_RED);
        ArrayList errorMsg = Lists.newArrayListWithCapacity((int)vehicles.length);
        for (int i = 0; i < vehicles.length; ++i) {
            JSONObject response;
            DynamicObject vehicle = vehicles[i];
            try {
                response = IssueInvoiceService.doRedVehicleInvoice((DynamicObject)vehicle);
            }
            catch (Exception e) {
                LOGGER.info(String.format("\u7ec4\u4ef6\u5f02\u5e38\u8fd4\u56de\u6d4b\u8bd5\u6570\u636eTestData:%s", e.getMessage()));
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u5f02\u5e38:%s", (String)"VehicleInvoiceBatchRedPlugin_2", (String)"imc-sim-formplugin", (Object[])new Object[0]), e.getMessage()));
            }
            LOGGER.info(String.format("VehicleInvoiceBatchRedPlugin confirmRed response:%s", SerializationUtils.toJsonString((Object)response)));
            VehicleInvoiceBatchRedController.handleRespData((List)errorMsg, (DynamicObject)vehicle, (JSONObject)response);
        }
        if (!CollectionUtils.isEmpty((Collection)errorMsg)) {
            this.getView().returnDataToParent((Object)errorMsg);
        }
    }
}

