/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.vehicle.validator;

import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.sim.formplugin.issuing.control.BatchInvoiceControl;

public class VehicleInvoiceBatchValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.dataEntities;
        long orgIdCount = Stream.of(dataEntities).map(o -> DynamicObjectUtil.getDynamicObjectLongValue((Object)o.getDataEntity().get("orgid"))).distinct().count();
        if (orgIdCount != 1L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u64cd\u4f5c\u6570\u636e\u6765\u6e90\u4e8e\u591a\u4e2a\u4e0d\u540c\u6838\u7b97\u7ec4\u7ec7\uff0c\u8bf7\u9009\u62e9\u540c\u4e00\u6838\u7b97\u7ec4\u7ec7\u7684\u6570\u636e\u64cd\u4f5c", (String)"VehicleInvoiceBatchValidator_2", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject vehicle = dataEntity.getDataEntity();
            String issueStatus = vehicle.getString("issuestatus");
            String billNo = vehicle.getString("billno");
            if (BatchInvoiceControl.getInvoiceStatusSet().contains(issueStatus)) continue;
            this.addErrorMessage(dataEntity, String.format("%1$s%2$sVehicleInvoiceBatchValidator_1%3$simc-sim-formplugin", ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7 ", (String)"VehicleInvoiceBatchValidator_1", (String)"imc-sim-formplugin", (Object[])new Object[0]), billNo, IssueStatusEnum.getName((String)issueStatus)));
        }
    }
}

