/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.schedule.bill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.BillStatusEnum;
import kd.imc.bdm.common.dto.merge.MergeRequestDTO;
import kd.imc.bdm.common.dto.merge.MergeResponseDTO;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.OrgHelper;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.sim.common.constant.table.MatchBillConstant;
import kd.imc.sim.common.dto.matchconfirm.MatchRedConfirmBillDTO;
import kd.imc.sim.common.dto.matchconfirm.MatchRedConfirmBillItemDTO;
import kd.imc.sim.common.dto.matchconfirm.MatchRedConfirmResponse;
import kd.imc.sim.common.dto.matchconfirm.MatchRedConfirmResultDTO;
import kd.imc.sim.common.dto.minusbill.MatchBillRequest;
import kd.imc.sim.common.dto.minusbill.MatchInvoiceDTO;
import kd.imc.sim.common.dto.minusbill.MinusBillDTO;
import kd.imc.sim.common.dto.minusbill.MinusBillItemDTO;
import kd.imc.sim.common.dto.minusbill.MinusBillMatchConfig;
import kd.imc.sim.common.utils.BillOperationLockUtil;
import kd.imc.sim.common.utils.SimpleGoodsNameUtil;
import kd.imc.sim.formplugin.bill.matchbill.BillMatchDetailPlugin;
import kd.imc.sim.formplugin.bill.originalbill.workbench.task.AutoBillMatchTask;
import kd.imc.sim.formplugin.bill.splitMerge.helper.BillMergeHelper;
import kd.imc.sim.formplugin.match.MinusBillMatchHelper;
import kd.imc.sim.formplugin.match.RedConfirmMatchHelper;
import kd.imc.sim.schedule.AbstractJobTask;
import org.apache.commons.lang3.StringUtils;

public class NegativeBillMatchTask
extends AbstractJobTask {
    private static Log LOGGER = LogFactory.getLog(NegativeBillMatchTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        this.feedbackProgress(0, ResManager.loadKDString((String)"\u5f00\u59cb\u5339\u914d\u539f\u84dd\u7968", (String)"NegativeBillMatchTask_0", (String)"imc-sim-formplugin", (Object[])new Object[0]), null);
        Map request = (Map)map.get("request");
        try (DLock lock = DLock.create((String)(request.get("orgid") + NegativeBillMatchTask.class.getName()), (String)ResManager.loadKDString((String)"\u5339\u914d\u84dd\u7968\u9501", (String)"NegativeBillMatchTask_1", (String)"imc-sim-formplugin", (Object[])new Object[0]));){
            if (!lock.tryLock(1000L)) {
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put("success", Boolean.FALSE);
                result.put("errMsg", String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7%s\u6b63\u5728\u5339\u914d\u84dd\u7968\uff0c\u8bf7\u5339\u914d\u5b8c\u6210\u540e\u518d\u8fdb\u884c\u64cd\u4f5c", (String)"NegativeBillMatchTask_2", (String)"imc-sim-formplugin", (Object[])new Object[0]), request.get("orgid")));
                this.feedbackCustomdata(result);
                return;
            }
            this.billMatchInvoice(request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void billMatchInvoice(Map<String, Object> request) {
        List jsonArray = (List)request.get("pks");
        HashMap<String, Object> result = new HashMap<String, Object>(4);
        DynamicObject[] bills = BusinessDataServiceHelper.load((Object[])jsonArray.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_original_bill"));
        List billNos = Arrays.stream(bills).map(bill -> bill.getString("billno")).collect(Collectors.toList());
        long orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)bills[0].get("orgid"));
        BillOperationLockUtil.getBillsLock(billNos, (boolean)true, (long)orgId);
        TXHandle tx = TX.requiresNew();
        try {
            MatchBillRequest matchBillRequest = this.buildMatchBillsOrMergeBills(request, bills);
            List matchBillsOrMergeBills = matchBillRequest.getMatchBillsOrMergeBills();
            MinusBillMatchConfig matchConfig = this.buildMatchConfig(request.get("matchrule"));
            DynamicObject matchRedConfirmConfig = this.getMatchRedConfirmConfig(request.get("matchconfig"));
            if (!matchConfig.getAmountStandard().booleanValue()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u6309\u6570\u91cf\u57fa\u51c6\u8fdb\u884c\u5339\u914d\u3002", (String)"NegativeBillMatchTask_9", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            }
            if (!matchConfig.getHeadField().contains("invoicetype")) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f00\u7968\u7533\u8bf7\u5355\u6570\u636e\uff0c\u4e0d\u652f\u6301\u4f7f\u7528\u4e0d\u6309\u7167\u53d1\u7968\u79cd\u7c7b\u5339\u914d\u7684\u5339\u914d\u89c4\u5219\uff0c\u8bf7\u66f4\u6362\u5339\u914d\u89c4\u5219\u3002", (String)"NegativeBillMatchTask_10", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            }
            MinusBillMatchHelper matchHelper = new MinusBillMatchHelper();
            int successSize = 0;
            int partSuccessSize = 0;
            ArrayList<DynamicObject> createMatchBills = new ArrayList<DynamicObject>(matchBillsOrMergeBills.size());
            ArrayList<DynamicObject> updateMatchBills = new ArrayList<DynamicObject>(matchBillsOrMergeBills.size());
            HashMap<Long, String> matchBillStatus = new HashMap<Long, String>(matchBillsOrMergeBills.size());
            HashSet matchInvoiceItems = new HashSet(matchBillsOrMergeBills.size());
            HashSet<Long> oriInvoiceIdSet = new HashSet<Long>(matchBillsOrMergeBills.size());
            HashSet<Long> redConfirmIdSet = new HashSet<Long>(matchBillsOrMergeBills.size());
            RedConfirmMatchHelper redConfirmMatchHelper = new RedConfirmMatchHelper();
            for (int i = 0; i < matchBillsOrMergeBills.size(); ++i) {
                String desc = String.format(ResManager.loadKDString((String)"\u5171%1$s\u4e2a\u5355\u636e\uff0c\u7b2c%2$s\u4e2a\u5355\u636e", (String)"NegativeBillMatchTask_3", (String)"imc-sim-formplugin", (Object[])new Object[0]), matchBillsOrMergeBills.size(), i + 1);
                int process = (i + 1) * 100 / matchBillsOrMergeBills.size();
                DynamicObject matchBillOrMergeBill = (DynamicObject)matchBillsOrMergeBills.get(i);
                MatchRedConfirmResponse response = null;
                try {
                    DynamicObject matchBill;
                    String matchStatus;
                    MinusBillDTO minusBill;
                    boolean isOriginalBill = "sim_original_bill".equals(matchBillOrMergeBill.getDynamicObjectType().getName());
                    if (isOriginalBill) {
                        minusBill = this.createMinusBill(matchConfig, matchBillOrMergeBill);
                        minusBill.setRedreason((String)request.get("redreason"));
                    } else {
                        minusBill = matchHelper.createMinusBillByMatchBill(matchConfig, matchBillOrMergeBill);
                    }
                    minusBill.setConfig(matchConfig);
                    minusBill.getMatchInvoiceItems().addAll(matchInvoiceItems);
                    minusBill.setMatchInvoiceIds(oriInvoiceIdSet);
                    boolean isMatchTargetRedConfirm = true;
                    if (isOriginalBill) {
                        if (null != matchRedConfirmConfig) {
                            response = redConfirmMatchHelper.matchRedConfirmBillFromOriginalBillOrMatchBill(matchBillOrMergeBill, matchRedConfirmConfig);
                            String matchStatusCode = response.getDto().getMatchStatusCode();
                            if (!MatchBillConstant.MatchStatusEnum.MATCH_PART_SUCCESS.getCode().equals(matchStatusCode) && !MatchBillConstant.MatchStatusEnum.MATCH_SUCCESS.getCode().equals(matchStatusCode)) {
                                isMatchTargetRedConfirm = false;
                                matchHelper.match(minusBill);
                            }
                        } else {
                            isMatchTargetRedConfirm = false;
                            matchHelper.match(minusBill);
                        }
                    } else {
                        String targetBill = matchBillOrMergeBill.getString("matchtarget");
                        matchStatus = matchBillOrMergeBill.getString("matchstatus");
                        if (MatchBillConstant.MatchStatusEnum.UN_PROCESS.getCode().equals(matchStatus) || MatchBillConstant.MatchStatusEnum.MATCH_FAIL.getCode().equals(matchStatus)) {
                            if (null != matchRedConfirmConfig) {
                                matchBillOrMergeBill.set("matchconfig", (Object)matchRedConfirmConfig);
                                response = redConfirmMatchHelper.matchRedConfirmBillFromOriginalBillOrMatchBill(matchBillOrMergeBill, matchRedConfirmConfig);
                                String matchStatusCode = response.getDto().getMatchStatusCode();
                                if (MatchBillConstant.MatchStatusEnum.UN_PROCESS.getCode().equals(matchStatusCode) || MatchBillConstant.MatchStatusEnum.MATCH_FAIL.getCode().equals(matchStatusCode)) {
                                    isMatchTargetRedConfirm = false;
                                    matchHelper.match(minusBill);
                                }
                            } else {
                                isMatchTargetRedConfirm = false;
                                matchHelper.match(minusBill);
                            }
                        } else if ("1".equals(targetBill)) {
                            response = redConfirmMatchHelper.matchRedConfirmBillFromOriginalBillOrMatchBill(matchBillOrMergeBill, matchRedConfirmConfig);
                        } else {
                            isMatchTargetRedConfirm = false;
                            matchHelper.match(minusBill);
                        }
                    }
                    this.addRedConfirmId(redConfirmIdSet, response);
                    if (isMatchTargetRedConfirm) {
                        if (isOriginalBill) {
                            matchBill = redConfirmMatchHelper.createMatchBillFromOriginalBill(matchBillOrMergeBill, response.getDto());
                            createMatchBills.add(matchBill);
                        } else {
                            matchBill = matchBillOrMergeBill;
                            redConfirmMatchHelper.updateMatchBillFromMatchDTO(matchBill, response.getDto());
                            updateMatchBills.add(matchBill);
                        }
                        matchBill.set("matchtarget", (Object)"1");
                        matchBill.set("matchconfig", (Object)matchRedConfirmConfig);
                    } else {
                        if (isOriginalBill) {
                            matchBill = this.createMatchBill(minusBill, matchBillOrMergeBill, oriInvoiceIdSet);
                            createMatchBills.add(matchBill);
                        } else {
                            matchBill = matchBillOrMergeBill;
                            matchHelper.updateMatchBill(minusBill, matchBillOrMergeBill, oriInvoiceIdSet);
                            updateMatchBills.add(matchBill);
                        }
                        matchBill.set("matchtarget", (Object)"0");
                        matchInvoiceItems.addAll(minusBill.getMatchInvoiceItems());
                    }
                    matchStatus = matchBill.getString("matchstatus");
                    if (MatchBillConstant.MatchStatusEnum.MATCH_SUCCESS.getCode().equals(matchStatus)) {
                        ++successSize;
                    } else if (MatchBillConstant.MatchStatusEnum.MATCH_PART_SUCCESS.getCode().equals(matchStatus)) {
                        ++partSuccessSize;
                    }
                    this.feedbackProgress(process, String.format(ResManager.loadKDString((String)"%1$s\u5339\u914d%2$s", (String)"NegativeBillMatchTask_4", (String)"imc-sim-formplugin", (Object[])new Object[0]), desc, MatchBillConstant.MatchStatusEnum.getDescByCode((String)matchBill.getString("matchstatus"))), null);
                    matchBillStatus.put(matchBill.getLong("id"), matchBill.getString("matchstatus"));
                    continue;
                }
                catch (Exception e) {
                    LOGGER.error(String.format("\u5355\u636e[%s]\u5339\u914d\u5931\u8d25", matchBillOrMergeBill.getString("billno")), (Throwable)e);
                    this.feedbackProgress(process, String.format(ResManager.loadKDString((String)"%1$s\u5339\u914d\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a:%2$s\uff0c\u5f00\u59cb\u5339\u914d\u4e0b\u4e00\u4e2a\u5355\u636e", (String)"NegativeBillMatchTask_7", (String)"imc-sim-formplugin", (Object[])new Object[0]), desc, e.getMessage()), null);
                }
            }
            if (!CollectionUtils.isEmpty(createMatchBills)) {
                matchHelper.saveCreateMatchBills(createMatchBills, matchBillRequest, matchBillStatus);
                ImcSaveServiceHelper.save((List)matchBillRequest.getNoMatchOriginalBills());
            }
            if (!CollectionUtils.isEmpty(updateMatchBills)) {
                this.updateCreateMatchBills(updateMatchBills, matchBillRequest, matchBillStatus);
            }
            if (!CollectionUtils.isEmpty(oriInvoiceIdSet)) {
                matchHelper.updateInvoiceOccupyStatus(oriInvoiceIdSet, "1", "sim_vatinvoice");
            }
            if (!CollectionUtils.isEmpty(redConfirmIdSet)) {
                matchHelper.updateInvoiceOccupyStatus(redConfirmIdSet, "1", "sim_red_confirm_bill");
            }
            result.put("success", Boolean.TRUE);
            result.put("errMsg", String.format(ResManager.loadKDString((String)"\u5171\u5339\u914d%1$s\u6761\uff0c\u5168\u90e8\u5339\u914d%2$s\u6761\uff0c\u90e8\u5206\u5339\u914d%3$s\u6761\uff0c\u96f6\u5339\u914d%4$s\u6761", (String)"NegativeBillMatchTask_8", (String)"imc-sim-formplugin", (Object[])new Object[0]), matchBillsOrMergeBills.size(), successSize, partSuccessSize, matchBillsOrMergeBills.size() - successSize - partSuccessSize));
        }
        catch (Exception e) {
            LOGGER.error(String.format("\u8d1f\u6570\u5339\u914d\u84dd\u7968\u5931\u8d25,\u5355\u636e\u7f16\u53f7[%s]", String.join((CharSequence)",", billNos)), (Throwable)e);
            tx.markRollback();
            result.put("success", Boolean.FALSE);
            result.put("errMsg", e instanceof MsgException ? ((MsgException)((Object)e)).getErrorMsg() : e.getMessage());
        }
        finally {
            tx.close();
            BillOperationLockUtil.unOperationLook((String)String.valueOf(orgId), billNos);
        }
        this.feedbackCustomdata(result);
    }

    private void addRedConfirmId(Set<Long> redConfirmIdSet, MatchRedConfirmResponse response) {
        if (null == response) {
            return;
        }
        MatchRedConfirmBillDTO dto = response.getDto();
        List items2 = dto.getItems();
        for (MatchRedConfirmBillItemDTO item : items2) {
            List matchResult = item.getMatchResult();
            if (null == matchResult) continue;
            for (MatchRedConfirmResultDTO matchItem : matchResult) {
                if (!matchItem.isNewMatchInfo()) continue;
                redConfirmIdSet.add(matchItem.getRedConfirmPk());
            }
        }
    }

    private DynamicObject getMatchRedConfirmConfig(Object o) {
        if (null == o) {
            return null;
        }
        return BusinessDataServiceHelper.loadSingle((Object)o, (String)"bdm_match_redconfirm");
    }

    private MatchBillRequest buildMatchBillsOrMergeBills(Map<String, Object> request, DynamicObject[] bills) {
        MatchBillRequest matchBillRequest = new MatchBillRequest();
        ArrayList<DynamicObject> noMatchOriginalBills = new ArrayList<DynamicObject>(bills.length);
        ArrayList<DynamicObject> matchOriginalBills = new ArrayList<DynamicObject>(bills.length);
        for (DynamicObject bill : bills) {
            String matchStatus = bill.getString("matchstatus");
            if (StringUtils.isBlank((CharSequence)matchStatus) || MatchBillConstant.MatchStatusEnum.UN_PROCESS.getCode().equals(matchStatus)) {
                noMatchOriginalBills.add(bill);
                continue;
            }
            matchOriginalBills.add(bill);
        }
        matchBillRequest.setNoMatchOriginalBills(noMatchOriginalBills);
        matchBillRequest.setMatchOriginalBills(matchOriginalBills);
        ArrayList matchBillsOrMergeBills = new ArrayList();
        MergeResponseDTO response = new MergeResponseDTO();
        if (!CollectionUtils.isEmpty(noMatchOriginalBills)) {
            MergeRequestDTO mergeRequest = new MergeRequestDTO.Builder().mergeBill(((Boolean)request.get("ismergebill")).booleanValue()).mergeBillDetail(((Boolean)request.get("ismergebilldetail")).booleanValue()).bills(noMatchOriginalBills.toArray(new DynamicObject[0])).build();
            response = new BillMergeHelper().mergeBill(mergeRequest);
            matchBillsOrMergeBills.addAll(response.getBills());
        }
        DynamicObject[] relations = new DynamicObject[]{};
        if (!CollectionUtils.isEmpty(matchOriginalBills)) {
            relations = BusinessDataServiceHelper.load((String)"sim_matchbill_relation", (String)String.join((CharSequence)",", "tbillid", "sbillid"), (QFilter[])OrgHelper.getIdFilter((Collection)matchOriginalBills.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList()), (String)"sbillid").toArray());
            DynamicObject[] matchBillArr = BusinessDataServiceHelper.load((Object[])Arrays.stream(relations).map(relation -> relation.get("tbillid")).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_match_bill"));
            matchBillsOrMergeBills.addAll(Arrays.stream(matchBillArr).collect(Collectors.toList()));
        }
        matchBillRequest.setMatchBillsOrMergeBills(matchBillsOrMergeBills);
        matchBillRequest.setRelations(response.getRelations());
        matchBillRequest.setBill2MatchBillRelation(relations);
        return matchBillRequest;
    }

    private void updateCreateMatchBills(List<DynamicObject> updateMatchBills, MatchBillRequest matchBillRequest, Map<Long, String> matchBillStatus) {
        Map<Long, Long> relationMap = Arrays.stream(matchBillRequest.getBill2MatchBillRelation()).collect(Collectors.toMap(k -> k.getLong("sbillid"), v -> v.getLong("tbillid"), (v1, v2) -> v1));
        matchBillRequest.getMatchOriginalBills().forEach(bill -> bill.set("matchstatus", matchBillStatus.get(relationMap.get(bill.getLong("id")))));
        ImcSaveServiceHelper.save((List)matchBillRequest.getMatchOriginalBills());
        ImcSaveServiceHelper.save(updateMatchBills);
    }

    private MinusBillDTO createMinusBill(MinusBillMatchConfig matchConfig, DynamicObject mergeBill) {
        MinusBillDTO minusBill = (MinusBillDTO)DynamicObjectUtil.dynamicObject2Bean(MinusBillDTO.class, (DynamicObject)mergeBill);
        List minusBillItems = minusBill.getItems();
        minusBill.setHeadExtJson(MinusBillMatchHelper.getExtJson((String)matchConfig.getHeadField(), (DynamicObject)mergeBill));
        DynamicObjectCollection items2 = mergeBill.getDynamicObjectCollection("sim_original_bill_item");
        for (int i = 0; i < minusBillItems.size(); ++i) {
            DynamicObject item = (DynamicObject)items2.get(i);
            SimpleGoodsNameUtil.handlerSimpleGoodsName((DynamicObject)item);
            MinusBillItemDTO minusBillItem = (MinusBillItemDTO)minusBillItems.get(i);
            minusBillItem.setGoodsname(item.getString("goodsname"));
            minusBillItem.setItemExtJson(MinusBillMatchHelper.getExtJson((String)matchConfig.getItemField(), (DynamicObject)item));
        }
        minusBill.setMatchInvoiceItems(new HashSet(16));
        return minusBill;
    }

    public DynamicObject createMatchBill(MinusBillDTO minusBill, DynamicObject mergeBill, Set<Long> oriInvoiceIdSet) {
        MinusBillMatchHelper minusBillMatchHelper = new MinusBillMatchHelper();
        DynamicObject matchBill = BusinessDataServiceHelper.newDynamicObject((String)"sim_match_bill");
        DynamicObjectUtil.copyDynamicObject((DynamicObject)mergeBill, (DynamicObject)matchBill, (boolean)false, (boolean)true, (boolean)true);
        matchBill.set("id", (Object)minusBill.getMergebillId());
        matchBill.set("billno", (Object)MinusBillMatchHelper.getMergeBillNoFirst((String)mergeBill.getString("billno")));
        matchBill.set("billstatus", (Object)BillStatusEnum.AUDIT_SUCCESS.getCode());
        matchBill.set("creator", (Object)Long.parseLong(RequestContext.get().getUserId()));
        matchBill.set("org", mergeBill.get("orgid"));
        matchBill.set("applyamount", mergeBill.get("invoiceamount"));
        matchBill.set("applytax", mergeBill.get("totaltax"));
        matchBill.set("applytotalamount", mergeBill.get("totalamount"));
        matchBill.set("matchrule", (Object)minusBill.getConfig().getId());
        matchBill.set("redreason", (Object)minusBill.getRedreason());
        matchBill.set("matchtype", (Object)"1");
        matchBill.set("remark", (Object)mergeBill.getString("invoiceremark"));
        matchBill.set("matchbatch", (Object)BillMatchDetailPlugin.createMatchBatch());
        matchBill.set("matchtime", (Object)new Date());
        List minusBillItems = minusBill.getItems();
        DynamicObjectCollection items2 = matchBill.getDynamicObjectCollection("sim_original_bill_item");
        items2.clear();
        HashSet<Long> invoiceSet = new HashSet<Long>(4);
        HashSet<String> matchFlagSet = new HashSet<String>(4);
        BigDecimal matchAmount = BigDecimal.ZERO;
        BigDecimal matchTax = BigDecimal.ZERO;
        int seq = 1;
        for (int i = 0; i < minusBillItems.size(); ++i) {
            MinusBillItemDTO minusBillItem = (MinusBillItemDTO)minusBillItems.get(i);
            DynamicObject item = items2.addNew();
            item.set("id", minusBillItem.getMatchOrMergeItemId());
            item.set("seq", (Object)(i + 1));
            item.set("goodsname", (Object)minusBillItem.getGoodsname());
            item.set("spbm", (Object)minusBillItem.getSpbm());
            item.set("goodscode", (Object)minusBillItem.getGoodscode());
            item.set("specification", (Object)minusBillItem.getSpecification());
            item.set("unit", (Object)minusBillItem.getUnit());
            item.set("num", (Object)minusBillItem.getNum());
            item.set("taxrate", (Object)minusBillItem.getTaxRate());
            item.set("unitprice", (Object)minusBillItem.getUnitprice());
            item.set("taxunitprice", (Object)minusBillItem.getTaxUnitPrice());
            item.set("amount", (Object)minusBillItem.getAmount());
            item.set("tax", (Object)minusBillItem.getTax());
            if (!MatchBillConstant.MatchStatusEnum.MATCH_SUCCESS.getCode().equals(minusBillItem.getMatchStatus())) {
                if (minusBillItem.getInvoiceList().size() > 0) {
                    minusBillItem.setMatchStatus(MatchBillConstant.MatchStatusEnum.MATCH_PART_SUCCESS.getCode());
                } else {
                    minusBillItem.setMatchStatus(MatchBillConstant.MatchStatusEnum.MATCH_FAIL.getCode());
                }
            }
            matchFlagSet.add(minusBillItem.getMatchStatus());
            item.set("itemmatchstatus", (Object)minusBillItem.getMatchStatus());
            List invoiceList = minusBillItem.getInvoiceList();
            DynamicObjectCollection oriInvoices = item.getDynamicObjectCollection("subentryentity");
            for (MatchInvoiceDTO matchInvoice : invoiceList) {
                oriInvoiceIdSet.add(matchInvoice.getInvoiceid());
                DynamicObject oriInvoice = minusBillMatchHelper.createOriInvoice(oriInvoices, matchInvoice, minusBillItem);
                oriInvoice.set("seq", (Object)seq++);
                if (matchInvoice.getInvoiceid() != null && matchInvoice.getInvoiceid() != 0L) {
                    invoiceSet.add(matchInvoice.getInvoiceid());
                }
                matchAmount = matchAmount.add(matchInvoice.getItemAmount());
                matchTax = matchTax.add(matchInvoice.getItemTax());
            }
        }
        matchBill.set("pushdownstatus", (Object)"0");
        matchBill.set("matchamount", (Object)matchAmount.negate());
        matchBill.set("matchtax", (Object)matchTax.negate());
        matchBill.set("matchtotalamount", (Object)matchAmount.add(matchTax).negate());
        matchBill.set("matchinvoicenum", (Object)invoiceSet.size());
        if (matchFlagSet.size() == 1) {
            matchBill.set("matchstatus", (Object)matchFlagSet.toArray(new String[0])[0]);
        } else {
            matchBill.set("matchstatus", (Object)MatchBillConstant.MatchStatusEnum.MATCH_PART_SUCCESS.getCode());
        }
        return matchBill;
    }

    private MinusBillMatchConfig buildMatchConfig(Object matchrule) {
        DynamicObject matchRule = BusinessDataServiceHelper.loadSingle((Object)matchrule, (String)"bdm_match_ori_inv_setting");
        return NegativeBillMatchTask.buildMatchConfigByDynamicObject(matchRule);
    }

    public static MinusBillMatchConfig buildMatchConfigByDynamicObject(DynamicObject dynamicObject) {
        return AutoBillMatchTask.buildMatchConfigByDynamicObject((DynamicObject)dynamicObject);
    }
}

