/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.schedule.issue;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.helper.OrgHelper;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.sim.common.helper.LyServerInvoiceHelper;
import kd.imc.sim.common.helper.issueinvoice.IssueInvoiceMqHelper;
import kd.imc.sim.formplugin.issuing.task.SyncTGInvoiceTask;

public class FailAutoIssueTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(LyServerInvoiceHelper.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOGGER.info("IssueFailAutoIssueTaskStart");
        try (DLock lock = DLock.create((String)FailAutoIssueTask.class.getName());){
            if (!lock.tryLock(1000L)) {
                return;
            }
            QFilter qFilter = new QFilter("createdate", ">=", (Object)DateUtils.addDay((Date)new Date(), (int)-7));
            DynamicObject[] autoInvoice = BusinessDataServiceHelper.load((String)"sim_fail_auto_issue", (String)"orderno", (QFilter[])qFilter.toArray(), (String)String.format("%s asc", "createdate"), (int)SyncTGInvoiceTask.getQueryCount());
            if (autoInvoice.length == 0) {
                return;
            }
            try {
                LOGGER.info(String.format("IssueFailAutoIssueTask issue size: %d", autoInvoice.length));
                DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)String.join((CharSequence)",", "issuestatus", "result", "id", "invoiceamount", "salertaxno", "jqbh", "orderno", "orgid", "invoicetype", "issuesource"), (QFilter[])OrgHelper.getIdFilter((Collection)Arrays.stream(autoInvoice).map(auto -> auto.getString("orderno")).collect(Collectors.toList()), (String)"orderno").toArray());
                Map<String, List<DynamicObject>> invoiceTypeGroup = Arrays.stream(invoices).collect(Collectors.groupingBy(k -> DynamicObjectUtil.getDynamicObjectLongValue((Object)k.get("orgid")) + "!!!!" + k.getString("invoicetype")));
                invoiceTypeGroup.forEach((k, list) -> IssueInvoiceMqHelper.submitInvoice2MQ((DynamicObject[])list.toArray(new DynamicObject[0])));
            }
            catch (Exception e) {
                LOGGER.error("IssueFailAutoIssueTask error ", (Throwable)e);
            }
        }
    }
}

